/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Pair;
import androidx.annotation.WorkerThread;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzdw;
import com.google.android.gms.measurement.internal.zzer;
import com.google.android.gms.measurement.internal.zzes;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzev;
import com.google.android.gms.measurement.internal.zzew;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzgm;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

final class zzex
extends zzgm {
    @VisibleForTesting
    static final Pair<String, Long> zza;
    private SharedPreferences zzt;
    public zzev zzb;
    public final zzet zzc;
    public final zzet zzd;
    public final zzew zze;
    private String zzu;
    private boolean zzv;
    private long zzw;
    public final zzet zzf;
    public final zzer zzg;
    public final zzew zzh;
    public final zzer zzi;
    public final zzet zzj;
    public boolean zzk;
    public final zzer zzl;
    public final zzer zzm;
    public final zzet zzn;
    public final zzew zzo;
    public final zzew zzp;
    public final zzet zzq;
    public final zzes zzr;

    @WorkerThread
    @VisibleForTesting
    protected final SharedPreferences zza() {
        this.zzg();
        this.zzu();
        Preconditions.checkNotNull((Object)this.zzt);
        return this.zzt;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    final Pair<String, Boolean> zzb(String string) {
        this.zzg();
        long l = this.zzs.zzav().elapsedRealtime();
        String string2 = this.zzu;
        if (string2 != null && l < this.zzw) {
            return new Pair((Object)string2, (Object)this.zzv);
        }
        this.zzw = l + this.zzs.zzf().zzi(string, zzdw.zza);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            string = this.zzs.zzau();
            string = AdvertisingIdClient.getAdvertisingIdInfo((Context)string);
            this.zzu = "";
            string2 = string.getId();
            if (string2 != null) {
                this.zzu = string2;
            }
            this.zzv = string.isLimitAdTrackingEnabled();
        }
        catch (Exception exception) {
            this.zzs.zzay().zzc().zzb("Unable to get advertising id", exception);
            this.zzu = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzu, (Object)this.zzv);
    }

    @WorkerThread
    final zzag zzc() {
        this.zzg();
        return zzag.zzb(this.zza().getString("consent_settings", "G1"));
    }

    @WorkerThread
    final Boolean zzd() {
        this.zzg();
        if (this.zza().contains("measurement_enabled")) {
            return this.zza().getBoolean("measurement_enabled", true);
        }
        return null;
    }

    static {
        Pair pair;
        zza = pair = new Pair((Object)"", (Object)0L);
    }

    zzex(zzfs object) {
        super((zzfs)object);
        this.zzf = object = new zzet(this, "session_timeout", 1800000L);
        this.zzg = object = new zzer(this, "start_new_session", true);
        this.zzj = object = new zzet(this, "last_pause_time", 0L);
        this.zzh = object = new zzew(this, "non_personalized_ads", null);
        this.zzi = object = new zzer(this, "allow_remote_dynamite", false);
        this.zzc = object = new zzet(this, "first_open_time", 0L);
        this.zzd = object = new zzet(this, "app_install_time", 0L);
        this.zze = object = new zzew(this, "app_instance_id", null);
        this.zzl = object = new zzer(this, "app_backgrounded", false);
        this.zzm = object = new zzer(this, "deep_link_retrieval_complete", false);
        this.zzn = object = new zzet(this, "deep_link_retrieval_attempts", 0L);
        this.zzo = object = new zzew(this, "firebase_feature_rollouts", null);
        this.zzp = object = new zzew(this, "deferred_attribution_cache", null);
        this.zzq = object = new zzet(this, "deferred_attribution_cache_timestamp", 0L);
        this.zzr = object = new zzes(this, "default_event_parameters", null);
    }

    @Override
    @EnsuresNonNull.List(value={@EnsuresNonNull(value={"this.preferences"}), @EnsuresNonNull(value={"this.monitoringSample"})})
    @WorkerThread
    protected final void zzaA() {
        zzev zzev2;
        boolean bl;
        this.zzt = this.zzs.zzau().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzk = bl = this.zzt.getBoolean("has_been_opened", false);
        if (!bl) {
            SharedPreferences.Editor editor = this.zzt.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzs.zzf();
        this.zzb = zzev2 = new zzev(this, "health_monitor", Math.max(0L, (Long)zzdw.zzb.zza(null)), null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzh(Boolean bl) {
        zzex2.zzg();
        zzex zzex2 = zzex2.zza().edit();
        if (bl != null) {
            zzex2.putBoolean("measurement_enabled", bl);
        } else {
            zzex2.remove("measurement_enabled");
        }
        zzex2.apply();
    }

    @WorkerThread
    final void zzi(boolean bl) {
        zzex2.zzg();
        zzex2.zzs.zzay().zzj().zzb("App measurement setting deferred collection", bl);
        zzex zzex2 = zzex2.zza().edit();
        zzex2.putBoolean("deferred_analytics_collection", bl);
        zzex2.apply();
    }

    @WorkerThread
    final boolean zzj() {
        zzex zzex2 = zzex2.zzt;
        if (zzex2 == null) {
            return false;
        }
        return zzex2.contains("deferred_analytics_collection");
    }

    final boolean zzk(long l) {
        return l - this.zzf.zza() > this.zzj.zza();
    }

    @Override
    protected final boolean zzf() {
        return true;
    }

    @WorkerThread
    final boolean zzl(int n) {
        return zzag.zzl(n, this.zza().getInt("consent_source", 100));
    }
}

