/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzeb;
import com.google.android.gms.measurement.internal.zzed;
import com.google.android.gms.measurement.internal.zzei;
import com.google.android.gms.measurement.internal.zzem;
import com.google.android.gms.measurement.internal.zzfr;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzje;
import com.google.android.gms.measurement.internal.zzjf;
import com.google.android.gms.measurement.internal.zzjg;
import com.google.android.gms.measurement.internal.zzjh;
import com.google.android.gms.measurement.internal.zzji;
import com.google.android.gms.measurement.internal.zzjk;

@VisibleForTesting
public final class zzjj
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile zzei zzc;
    final /* synthetic */ zzjk zza;

    protected zzjj(zzjk zzjk2) {
        this.zza = zzjk2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void zza(Intent object) {
        ((zzgn)this.zza).zzg();
        Context context = this.zza.zzs.zzax();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        synchronized (this) {
            boolean bl = this.zzb;
            if (bl) {
                object = this.zza;
                object = ((zzgn)object).zzs.zzau();
                ((zzem)object).zzk().zza("Connection attempt already in progress");
                return;
            }
            zzgn zzgn2 = this.zza;
            zzgn2 = zzgn2.zzs.zzau();
            ((zzem)zzgn2).zzk().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, (Intent)object, (ServiceConnection)zzjk.zzI(this.zza), 129);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @WorkerThread
    public final void zzb() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @MainThread
    public final void onServiceConnected(ComponentName object, IBinder object2) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        // MONITORENTER : this
        if (object2 == null) {
            this.zzb = false;
            object = this.zza;
            object = ((zzgn)object).zzs.zzau();
            ((zzem)object).zzb().zza("Service connected with null binder");
            // MONITOREXIT : this
            return;
        }
        try {
            object = object2.getInterfaceDescriptor();
            boolean bl = "com.google.android.gms.measurement.internal.IMeasurementService".equals(object);
            if (bl) {
                object = object2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService");
                bl = object instanceof zzed;
                object = bl ? (zzed)object : new zzeb((IBinder)object2);
                object2 = this.zza;
                object2 = ((zzgn)object2).zzs.zzau();
                ((zzem)object2).zzk().zza("Bound to IMeasurementService interface");
                object2 = object;
            } else {
                object2 = this.zza;
                object2 = ((zzgn)object2).zzs.zzau();
                ((zzem)object2).zzb().zzb("Got binder with a wrong descriptor", object);
                object2 = null;
            }
            object = object2;
        }
        catch (RemoteException remoteException) {
            block14: {
                object = null;
                break block14;
                catch (RemoteException remoteException2) {}
            }
            object2 = this.zza;
            object2 = ((zzgn)object2).zzs.zzau();
            ((zzem)object2).zzb().zza("Service connect failed to get IMeasurementService");
        }
        if (object != null) {
            object2 = this.zza;
            object2 = ((zzgn)object2).zzs.zzav();
            zzje zzje2 = new zzje(this, (zzed)object);
            ((zzfr)object2).zzh(zzje2);
            return;
        }
        this.zzb = false;
        try {
            object = ConnectionTracker.getInstance();
            object2 = this.zza;
            object2 = ((zzgn)object2).zzs.zzax();
            object.unbindService((Context)object2, (ServiceConnection)zzjk.zzI(this.zza));
            // MONITOREXIT : this
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        this.zza.zzs.zzau().zzj().zza("Service disconnected");
        zzgp zzgp2 = this.zza;
        zzgp2 = ((zzgn)zzgp2).zzs;
        zzgp2 = ((zzfu)zzgp2).zzav();
        zzjf zzjf2 = new zzjf(this, componentName);
        ((zzfr)zzgp2).zzh(zzjf2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void zzc() {
        ((zzgn)this.zza).zzg();
        Object object = this.zza.zzs.zzax();
        synchronized (this) {
            zzei zzei2;
            boolean bl;
            boolean bl2 = this.zzb;
            if (bl2) {
                object = this.zza;
                object = ((zzgn)object).zzs.zzau();
                ((zzem)object).zzk().zza("Connection attempt already in progress");
                return;
            }
            zzei zzei3 = this.zzc;
            if (zzei3 != null && ((bl = this.zzc.isConnecting()) || (bl = this.zzc.isConnected()))) {
                object = this.zza;
                object = ((zzgn)object).zzs.zzau();
                ((zzem)object).zzk().zza("Already awaiting connection attempt");
                return;
            }
            this.zzc = zzei2 = new zzei((Context)object, Looper.getMainLooper(), this, this);
            object = this.zza;
            object = ((zzgn)object).zzs.zzau();
            ((zzem)object).zzk().zza("Connecting to remote service");
            this.zzb = true;
            Preconditions.checkNotNull((Object)((Object)this.zzc));
            this.zzc.checkAvailabilityAndConnect();
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @MainThread
    public final void onConnected(Bundle object) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        // MONITORENTER : this
        try {
            Preconditions.checkNotNull((Object)((Object)this.zzc));
            object = (zzed)this.zzc.getService();
            zzgn zzgn2 = this.zza;
            zzgn2 = zzgn2.zzs.zzav();
            zzjg zzjg2 = new zzjg(this, (zzed)object);
            ((zzfr)zzgn2).zzh(zzjg2);
            // MONITOREXIT : this
            return;
        }
        catch (DeadObjectException | IllegalStateException throwable) {
            this.zzc = null;
            this.zzb = false;
            return;
            {
                catch (Throwable throwable2) {}
                {
                    // MONITOREXIT : this
                    throw throwable2;
                }
            }
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        this.zza.zzs.zzau().zzj().zza("Service connection suspended");
        zzgp zzgp2 = this.zza;
        zzgp2 = ((zzgn)zzgp2).zzs;
        zzgp2 = ((zzfu)zzgp2).zzav();
        zzjh zzjh2 = new zzjh(this);
        ((zzfr)zzgp2).zzh(zzjh2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult object) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        Object object2 = this.zza.zzs.zzf();
        if (object2 != null) {
            ((zzem)object2).zze().zzb("Service connection failed", object);
        }
        synchronized (this) {
            this.zzb = false;
            this.zzc = null;
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl9 : MonitorExitStatement: MONITOREXIT : this
            object = this.zza;
            object = ((zzgn)object).zzs;
            object = ((zzfu)object).zzav();
            object2 = new zzji(this);
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
        ((zzfr)object).zzh((Runnable)object2);
    }

    static /* synthetic */ boolean zzd(zzjj zzjj2, boolean bl) {
        zzjj2.zzb = false;
        return false;
    }
}

