/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.GuardedBy;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzc;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzdz;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzea;
import com.google.android.gms.measurement.internal.zzek;
import com.google.android.gms.measurement.internal.zzem;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfr;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzhw;
import com.google.android.gms.measurement.internal.zzid;
import com.google.android.gms.measurement.internal.zzie;
import com.google.android.gms.measurement.internal.zzif;
import com.google.android.gms.measurement.internal.zzig;
import com.google.android.gms.measurement.internal.zzih;
import com.google.android.gms.measurement.internal.zzii;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zzjx;
import com.google.android.gms.measurement.internal.zzku;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class zzik
extends zzf {
    private volatile zzid zzb;
    private zzid zzc;
    @VisibleForTesting
    protected zzid zza;
    private final Map<Activity, zzid> zzd;
    @GuardedBy(value="activityLock")
    private Activity zze;
    @GuardedBy(value="activityLock")
    private volatile boolean zzf;
    private volatile zzid zzg;
    private zzid zzh;
    @GuardedBy(value="activityLock")
    private boolean zzi;
    private final Object zzj;
    @GuardedBy(value="this")
    private zzid zzk;
    @GuardedBy(value="this")
    private String zzl;

    public zzik(zzfu concurrentHashMap) {
        super((zzfu)((Object)concurrentHashMap));
        concurrentHashMap = new ConcurrentHashMap<Activity, zzid>();
        this.zzj = concurrentHashMap;
        concurrentHashMap = new ConcurrentHashMap<Activity, zzid>();
        this.zzd = concurrentHashMap;
    }

    @Override
    protected final boolean zze() {
        return false;
    }

    @WorkerThread
    public final zzid zzh(boolean bl) {
        this.zzb();
        ((zzgn)this).zzg();
        if (!this.zzs.zzc().zzn(null, zzea.zzar) || !bl) {
            return this.zza;
        }
        zzid zzid2 = this.zza;
        if (zzid2 != null) {
            return zzid2;
        }
        return this.zzh;
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    final String zzi(Class<?> object, String string) {
        if ((object = ((Class)object).getCanonicalName()) == null) {
            return "Activity";
        }
        int n = ((Object)(object = ((String)object).split("\\."))).length;
        object = n > 0 ? object[n + -1] : "";
        n = ((String)object).length();
        this.zzs.zzc();
        if (n > 100) {
            this.zzs.zzc();
            return ((String)object).substring(0, 100);
        }
        return object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void zzj(Bundle bundle, long l) {
        Object object;
        Object object2;
        zzgn zzgn2;
        Object object3;
        block18: {
            block19: {
                block16: {
                    block17: {
                        if (!zzgn2.zzs.zzc().zzn(null, zzea.zzar)) {
                            zzgn2.zzs.zzau().zzh().zza("Manual screen reporting is disabled.");
                            return;
                        }
                        object3 = ((zzik)zzgn2).zzj;
                        // MONITORENTER : object3
                        int n = ((zzik)zzgn2).zzi;
                        if (n == 0) {
                            zzgn2 = zzgn2.zzs.zzau();
                            ((zzem)zzgn2).zzh().zza("Cannot log screen view event when the app is in the background.");
                            // MONITOREXIT : object3
                            return;
                        }
                        object2 = bundle.getString("screen_name");
                        if (object2 == null) break block16;
                        n = ((String)object2).length();
                        if (n <= 0) break block17;
                        n = ((String)object2).length();
                        zzgn2.zzs.zzc();
                        if (n <= 100) break block16;
                    }
                    zzgn2 = zzgn2.zzs.zzau();
                    ((zzem)zzgn2).zzh().zzb("Invalid screen name length for screen view. Length", ((String)object2).length());
                    // MONITOREXIT : object3
                    return;
                }
                if ((object = bundle.getString("screen_class")) == null) break block18;
                int n = ((String)object).length();
                if (n <= 0) break block19;
                n = ((String)object).length();
                zzgn2.zzs.zzc();
                if (n <= 100) break block18;
            }
            zzgn2 = zzgn2.zzs.zzau();
            ((zzem)zzgn2).zzh().zzb("Invalid screen class length for screen view. Length", ((String)object).length());
            // MONITOREXIT : object3
            return;
        }
        if (object == null) {
            object = ((zzik)zzgn2).zze;
            object = object != null ? ((zzik)zzgn2).zzi(object.getClass(), "Activity") : "Activity";
        }
        zzid zzid2 = ((zzik)zzgn2).zzb;
        boolean bl = ((zzik)zzgn2).zzf;
        if (bl && zzid2 != null) {
            ((zzik)zzgn2).zzf = false;
            bl = zzku.zzS(zzid2.zzb, (String)object);
            boolean bl2 = zzku.zzS(zzid2.zza, (String)object2);
            if (bl && bl2) {
                zzgn2 = zzgn2.zzs.zzau();
                ((zzem)zzgn2).zzh().zza("Ignoring call to log screen view event with duplicate parameters.");
                // MONITOREXIT : object3
                return;
            }
        }
        // MONITOREXIT : object3
        zzek zzek2 = zzgn2.zzs.zzau().zzk();
        object3 = object2 == null ? "null" : object2;
        {
            catch (Throwable throwable) {}
            {
                // MONITOREXIT : object3
                throw throwable;
            }
        }
        Object object4 = object == null ? "null" : object;
        zzek2.zzc("Logging screen view with name, class", object3, object4);
        object3 = ((zzik)zzgn2).zzb == null ? ((zzik)zzgn2).zzc : ((zzik)zzgn2).zzb;
        ((zzik)zzgn2).zzb = object4 = new zzid((String)object2, (String)object, zzgn2.zzs.zzl().zzd(), true, l);
        ((zzik)zzgn2).zzc = object3;
        ((zzik)zzgn2).zzg = object4;
        object = zzgn2.zzs;
        object = ((zzfu)object).zzay();
        l = object.elapsedRealtime();
        object = zzgn2.zzs;
        object = ((zzfu)object).zzav();
        object2 = new zzie((zzik)zzgn2, bundle, (zzid)object4, (zzid)object3, l);
        ((zzfr)object).zzh((Runnable)object2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Deprecated
    @MainThread
    public final void zzk(@NonNull Activity activity, @Size(min=1L, max=36L) String string, @Size(min=1L, max=36L) String string2) {
        block9: {
            block11: {
                block10: {
                    int n;
                    block8: {
                        if (!this.zzs.zzc().zzt()) {
                            this.zzs.zzau().zzh().zza("setCurrentScreen cannot be called while screen reporting is disabled.");
                            return;
                        }
                        zzid zzid2 = this.zzb;
                        if (zzid2 == null) {
                            this.zzs.zzau().zzh().zza("setCurrentScreen cannot be called while no activity active");
                            return;
                        }
                        if (this.zzd.get(activity) == null) {
                            this.zzs.zzau().zzh().zza("setCurrentScreen must be called with an activity in the activity lifecycle");
                            return;
                        }
                        if (string2 == null) {
                            string2 = this.zzi(activity.getClass(), "Activity");
                        }
                        String string3 = zzid2.zzb;
                        boolean bl = zzku.zzS(string3, string2);
                        n = zzku.zzS(zzid2.zza, string);
                        if (bl && n != 0) {
                            this.zzs.zzau().zzh().zza("setCurrentScreen cannot be called with the same class and name");
                            return;
                        }
                        if (string == null) break block8;
                        if (string.length() <= 0) break block9;
                        n = string.length();
                        this.zzs.zzc();
                        if (n > 100) break block9;
                    }
                    if (string2 == null) break block10;
                    if (string2.length() <= 0) break block11;
                    n = string2.length();
                    this.zzs.zzc();
                    if (n > 100) break block11;
                }
                zzek zzek2 = this.zzs.zzau().zzk();
                Object object = string == null ? "null" : string;
                zzek2.zzc("Setting current screen to name, class", object, string2);
                object = new zzid(string, string2, this.zzs.zzl().zzd());
                this.zzd.put(activity, (zzid)object);
                this.zzA(activity, (zzid)object, true);
                return;
            }
            this.zzs.zzau().zzh().zzb("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        this.zzs.zzau().zzh().zzb("Invalid screen name length in setCurrentScreen. Length", string.length());
    }

    public final zzid zzl() {
        return this.zzb;
    }

    /*
     * Enabled aggressive block sorting
     */
    @MainThread
    private final void zzA(Activity object, zzid object2, boolean bl) {
        Object object3;
        zzid zzid2 = this.zzb == null ? this.zzc : this.zzb;
        if (((zzid)object2).zzb == null) {
            object = object != null ? this.zzi(object.getClass(), "Activity") : null;
            object = object3 = new zzid(((zzid)object2).zza, (String)object, ((zzid)object2).zzc, ((zzid)object2).zze, ((zzid)object2).zzf);
        } else {
            object = object2;
        }
        this.zzc = this.zzb;
        this.zzb = object;
        object2 = this.zzs;
        object2 = ((zzfu)object2).zzay();
        long l = object2.elapsedRealtime();
        object2 = this.zzs;
        object2 = ((zzfu)object2).zzav();
        object3 = new zzif(this, (zzid)object, zzid2, l, bl);
        ((zzfr)object2).zzh((Runnable)object3);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zzB(zzid zzid2, zzid object, long l, boolean bl, Bundle bundle) {
        ((zzgn)this).zzg();
        bl = bl ? this.zza != null : false;
        if (bl) {
            this.zzC(this.zza, true, l);
        }
        if (object == null || ((zzid)object).zzc != zzid2.zzc || !zzku.zzS(((zzid)object).zzb, zzid2.zzb) || !zzku.zzS(((zzid)object).zza, zzid2.zza)) {
            Bundle bundle2;
            Bundle bundle3 = new Bundle();
            bundle = this.zzs.zzc().zzn(null, zzea.zzar) ? (bundle != null ? (bundle2 = new Bundle(bundle)) : new Bundle()) : bundle3;
            zzik.zzm(zzid2, bundle, true);
            if (object != null) {
                String string;
                String string2 = ((zzid)object).zza;
                if (string2 != null) {
                    bundle.putString("_pn", string2);
                }
                if ((string = ((zzid)object).zzb) != null) {
                    bundle.putString("_pc", string);
                }
                bundle.putLong("_pi", ((zzid)object).zzc);
            }
            if (bl) {
                object = this.zzs.zzh().zzb;
                long l2 = l - ((zzjx)object).zzb;
                ((zzjx)object).zzb = l;
                if (l2 > 0L) {
                    this.zzs.zzl().zzac(bundle, l2);
                }
            }
            if (this.zzs.zzc().zzn(null, zzea.zzar)) {
                if (!this.zzs.zzc().zzt()) {
                    bundle.putLong("_mst", 1L);
                }
                object = !zzid2.zze ? "auto" : "app";
            } else {
                object = "auto";
            }
            if (this.zzs.zzc().zzn(null, zzea.zzar)) {
                long l3;
                long l4 = this.zzs.zzay().currentTimeMillis();
                long l5 = zzid2.zze ? ((l3 = zzid2.zzf) != 0L ? l3 : l4) : l4;
                this.zzs.zzk().zzt((String)object, "_vs", l5, bundle);
            } else {
                zzhw zzhw2 = this.zzs.zzk();
                zzfu cfr_ignored_0 = zzhw2.zzs;
                ((zzgn)zzhw2).zzg();
                zzhw2.zzt((String)object, "_vs", zzhw2.zzs.zzay().currentTimeMillis(), bundle);
            }
        }
        this.zza = zzid2;
        if (this.zzs.zzc().zzn(null, zzea.zzar) && zzid2.zze) {
            this.zzh = zzid2;
        }
        this.zzs.zzy().zzz(zzid2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zzC(zzid zzid2, boolean bl, long l) {
        this.zzs.zzB().zzc(this.zzs.zzay().elapsedRealtime());
        boolean bl2 = zzid2 != null ? zzid2.zzd : false;
        if (this.zzs.zzh().zzb.zzd(bl2, bl, l) && zzid2 != null) {
            zzid2.zzd = false;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void zzm(zzid zzid2, Bundle bundle, boolean bl) {
        if (zzid2 != null) {
            if (!bundle.containsKey("_sc") || bl) {
                String string = zzid2.zza;
                if (string != null) {
                    bundle.putString("_sn", string);
                } else {
                    bundle.remove("_sn");
                }
                if ((string = zzid2.zzb) != null) {
                    bundle.putString("_sc", string);
                } else {
                    bundle.remove("_sc");
                }
                bundle.putLong("_si", zzid2.zzc);
                return;
            }
            bl = false;
        }
        if (zzid2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void zzn(String string, zzid zzid2) {
        ((zzgn)this).zzg();
        synchronized (this) {
            boolean bl;
            String string2 = this.zzl;
            if (string2 != null && !(bl = string2.equals(string))) {
                if (zzid2 == null) return;
            }
            this.zzl = string;
            this.zzk = zzid2;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @MainThread
    private final zzid zzD(@NonNull Activity object) {
        void var1_3;
        Preconditions.checkNotNull((Object)object);
        Object object2 = this.zzd.get(object);
        if (object2 == null) {
            object2 = object.getClass();
            object2 = this.zzi((Class<?>)object2, "Activity");
            zzid zzid2 = new zzid(null, (String)object2, this.zzs.zzl().zzd());
            this.zzd.put((Activity)object, zzid2);
            zzid zzid3 = zzid2;
        } else {
            zzid zzid4 = object2;
        }
        if (!this.zzs.zzc().zzn(null, zzea.zzar)) {
            return var1_3;
        }
        if (this.zzg != null) {
            return this.zzg;
        }
        return var1_3;
    }

    @MainThread
    public final void zzo(Activity activity, Bundle bundle) {
        if (!this.zzs.zzc().zzt()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        if ((bundle = bundle.getBundle("com.google.app_measurement.screen_service")) == null) {
            return;
        }
        zzid zzid2 = new zzid(bundle.getString("name"), bundle.getString("referrer_name"), bundle.getLong("id"));
        this.zzd.put(activity, zzid2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    public final void zzq(Activity object) {
        Object object2;
        block12: {
            if (zze2.zzs.zzc().zzn(null, zzea.zzar)) {
                object2 = zze2.zzj;
                synchronized (object2) {
                    zze2.zzi = true;
                    Object object3 = zze2.zze;
                    if (object != object3) {
                        zzgp zzgp2;
                        Object object4;
                        object3 = zze2.zzj;
                        synchronized (object3) {
                            zze2.zze = object;
                            zze2.zzf = false;
                            // MONITOREXIT @DISABLED, blocks:[2, 6, 7, 10, 11] lbl12 : MonitorExitStatement: MONITOREXIT : var3_4
                            object3 = zze2.zzs.zzc();
                            object4 = zzea.zzaq;
                            boolean bl = ((zzae)object3).zzn(null, (zzdz<Boolean>)object4);
                            if (!bl || !(bl = zze2.zzs.zzc().zzt())) break block12;
                            zze2.zzg = null;
                            zzgp2 = zze2.zzs;
                            zzgp2 = ((zzfu)zzgp2).zzav();
                            object4 = new zzij((zzik)zze2);
                        }
                        ((zzfr)zzgp2).zzh((Runnable)object4);
                    }
                }
            }
        }
        if (zze2.zzs.zzc().zzn(null, zzea.zzaq) && !zze2.zzs.zzc().zzt()) {
            zze2.zzb = zze2.zzg;
            object = zze2.zzs;
            object = ((zzfu)object).zzav();
            object2 = new zzig((zzik)zze2);
            ((zzfr)object).zzh((Runnable)object2);
            return;
        }
        zze2.zzA((Activity)object, zze2.zzD((Activity)object), false);
        zze zze2 = zze2.zzs.zzB();
        object = zze2.zzs;
        object = ((zzfu)object).zzay();
        long l = object.elapsedRealtime();
        object = zze2.zzs;
        object = ((zzfu)object).zzav();
        object2 = new zzc((zzd)zze2, l);
        ((zzfr)object).zzh((Runnable)object2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    public final void zzr(Activity object) {
        Object object2;
        if (this.zzs.zzc().zzn(null, zzea.zzar)) {
            object2 = this.zzj;
            synchronized (object2) {
                this.zzi = false;
                this.zzf = true;
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
            }
        }
        long l = this.zzs.zzay().elapsedRealtime();
        if (this.zzs.zzc().zzn(null, zzea.zzaq) && !this.zzs.zzc().zzt()) {
            this.zzb = null;
            object = this.zzs;
            object = ((zzfu)object).zzav();
            object2 = new zzih(this, l);
            ((zzfr)object).zzh((Runnable)object2);
            return;
        }
        object = this.zzD((Activity)object);
        this.zzc = this.zzb;
        this.zzb = null;
        object2 = this.zzs;
        object2 = ((zzfu)object2).zzav();
        zzii zzii2 = new zzii(this, (zzid)object, l);
        ((zzfr)object2).zzh(zzii2);
    }

    @MainThread
    public final void zzs(Activity activity, Bundle bundle) {
        if (!((zzgn)((Object)zzid2)).zzs.zzc().zzt()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        zzid zzid2 = ((zzik)((Object)zzid2)).zzd.get(activity);
        if (zzid2 == null) {
            return;
        }
        activity = new Bundle();
        activity.putLong("id", zzid2.zzc);
        activity.putString("name", zzid2.zza);
        activity.putString("referrer_name", zzid2.zzb);
        bundle.putBundle("com.google.app_measurement.screen_service", (Bundle)activity);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @MainThread
    public final void zzt(Activity activity) {
        Object object = this.zzj;
        // MONITORENTER : object
        Activity activity2 = this.zze;
        if (activity == activity2) {
            this.zze = null;
            // MONITOREXIT : object
        }
        if (!this.zzs.zzc().zzt()) {
            return;
        }
        this.zzd.remove(activity);
        {
            catch (Throwable throwable) {}
            {
                // MONITOREXIT : object
                throw throwable;
            }
        }
    }

    static /* synthetic */ void zzu(zzik zzik2, Bundle bundle, zzid zzid2, zzid zzid3, long l) {
        bundle.remove("screen_name");
        bundle.remove("screen_class");
        zzik2.zzB(zzid2, zzid3, l, true, zzik2.zzs.zzl().zzF(null, "screen_view", bundle, null, true));
    }

    static /* synthetic */ void zzv(zzik zzik2, zzid zzid2, zzid zzid3, long l, boolean bl, Bundle bundle) {
        zzik2.zzB(zzid2, zzid3, l, bl, null);
    }

    static /* synthetic */ zzid zzx(zzik zzik2) {
        return zzik2.zzh;
    }

    static /* synthetic */ void zzy(zzik zzik2, zzid zzid2, boolean bl, long l) {
        zzik2.zzC(zzid2, false, l);
    }

    static /* synthetic */ zzid zzz(zzik zzik2, zzid zzid2) {
        zzik2.zzh = null;
        return null;
    }
}

