/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.content.res.Resources;
import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.wrappers.InstantApps;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzov;
import com.google.android.gms.internal.measurement.zzqi;
import com.google.android.gms.measurement.internal.zzdz;
import com.google.android.gms.measurement.internal.zzea;
import com.google.android.gms.measurement.internal.zzem;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfb;
import com.google.android.gms.measurement.internal.zzfm;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzku;
import com.google.android.gms.measurement.internal.zzp;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.util.List;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class zzee
extends zzf {
    private String zza;
    private String zzb;
    private int zzc;
    private String zzd;
    private String zze;
    private long zzf;
    private final long zzg;
    private List<String> zzh;
    private int zzi;
    private String zzj;
    private String zzk;
    private String zzl;

    zzee(zzfu zzfu2, long l) {
        super(zzfu2);
        this.zzg = l;
    }

    @Override
    protected final boolean zze() {
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @EnsuresNonNull(value={"appId", "appStore", "appName", "gmpAppId", "gaAppId"})
    protected final void zzf() {
        block39: {
            block40: {
                var6_1 = this.zzs.zzax().getPackageName();
                var7_2 = this.zzs.zzax().getPackageManager();
                var1_3 = "unknown";
                var3_15 = "Unknown";
                var5_19 /* !! */  = "Unknown";
                if (var7_2 == null) {
                    this.zzs.zzau().zzb().zzb("PackageManager is null, app identity information might be inaccurate. appId", zzem.zzl(var6_1));
                    var2_21 = var3_15;
                    var3_16 = -2147483648;
                    var4_26 = var5_19 /* !! */ ;
                } else {
                    block37: {
                        block36: {
                            try {
                                var2_21 = var7_2.getInstallerPackageName(var6_1);
                                var1_3 = var2_21;
                            }
                            catch (IllegalArgumentException v0) {
                                this.zzs.zzau().zzb().zzb("Error retrieving app installer package name. appId", zzem.zzl(var6_1));
                            }
                            if (var1_3 == null) {
                                var1_3 = "manual_install";
                            } else if ("com.android.vending".equals(var1_3)) {
                                var1_3 = "";
                            }
                            var2_21 = this.zzs.zzax();
                            var4_26 = var7_2.getPackageInfo(var2_21.getPackageName(), 0);
                            if (var4_26 == null) break block36;
                            var2_21 = var7_2.getApplicationLabel(var4_26.applicationInfo);
                            var8_28 = TextUtils.isEmpty((CharSequence)var2_21);
                            var2_21 = var8_28 == false ? var2_21.toString() : var5_19 /* !! */ ;
                            var5_19 /* !! */  = var4_26.versionName;
                            var4_27 = var4_26.versionCode;
                            var3_15 = var5_19 /* !! */ ;
                            var5_19 /* !! */  = var2_21;
                            break block37;
                        }
                        var4_27 = -2147483648;
                    }
                    var2_21 = var3_15;
                    var3_16 = var4_27;
                    var4_26 = var5_19 /* !! */ ;
                }
                break block40;
                catch (PackageManager.NameNotFoundException v1) {
                    block38: {
                        var4_26 = var5_19 /* !! */ ;
                        break block38;
                        catch (PackageManager.NameNotFoundException v2) {
                            var4_26 = var2_21;
                            break block38;
                        }
                        catch (PackageManager.NameNotFoundException v3) {
                            var3_15 = var5_19 /* !! */ ;
                            var4_26 = var2_21;
                        }
                    }
                    this.zzs.zzau().zzb().zzc("Error retrieving package info. appId, appName", zzem.zzl(var6_1), var4_26);
                    var2_21 = var3_15;
                    var3_16 = -2147483648;
                }
            }
            this.zza = var6_1;
            this.zzd = var1_3;
            this.zzb = var2_21;
            this.zzc = var3_16;
            this.zze = var4_26;
            this.zzf = 0L;
            var1_4 = !TextUtils.isEmpty((CharSequence)this.zzs.zzr()) ? "am".equals(this.zzs.zzs()) : false;
            var3_16 = this.zzs.zzG();
            switch (var3_16) {
                default: {
                    this.zzs.zzau().zzi().zza("App measurement disabled due to denied storage consent");
                    break;
                }
                case 0: {
                    this.zzs.zzau().zzk().zza("App measurement collection enabled");
                    break;
                }
                case 1: {
                    this.zzs.zzau().zzi().zza("App measurement deactivated via the manifest");
                    break;
                }
                case 2: {
                    this.zzs.zzau().zzk().zza("App measurement deactivated via the init parameters");
                    break;
                }
                case 3: {
                    this.zzs.zzau().zzi().zza("App measurement disabled by setAnalyticsCollectionEnabled(false)");
                    break;
                }
                case 4: {
                    this.zzs.zzau().zzi().zza("App measurement disabled via the manifest");
                    break;
                }
                case 5: {
                    this.zzs.zzau().zzk().zza("App measurement disabled via the init parameters");
                    break;
                }
                case 6: {
                    this.zzs.zzau().zzh().zza("App measurement deactivated via resources. This method is being deprecated. Please refer to https://firebase.google.com/support/guides/disable-analytics");
                    break;
                }
                case 7: {
                    this.zzs.zzau().zzi().zza("App measurement disabled via the global data collection setting");
                }
            }
            this.zzj = "";
            this.zzk = "";
            this.zzl = "";
            this.zzs.zzat();
            if (var1_4) {
                this.zzk = this.zzs.zzr();
            }
            try {
                var1_5 = this.zzs.zzax();
                var2_21 = this.zzs.zzv();
                var4_26 = zzic.zza((Context)var1_5, (String)"google_app_id", (String)var2_21);
                var1_6 = TextUtils.isEmpty((CharSequence)var4_26);
                var1_7 = true != var1_6 ? var4_26 : "";
                this.zzj = var1_7;
                zzov.zzb();
                var1_7 = this.zzs.zzc();
                var2_21 = zzea.zzag;
                var1_8 = var1_7.zzn(null, (zzdz<Boolean>)var2_21);
                if (var1_8) {
                    var1_9 /* !! */  = this.zzs.zzax();
                    var2_21 = this.zzs.zzv();
                    Preconditions.checkNotNull((Object)var1_9 /* !! */ );
                    var5_19 /* !! */  = var1_9 /* !! */ .getResources();
                    var8_28 = TextUtils.isEmpty((CharSequence)var2_21);
                    var1_9 /* !! */  = var8_28 == false ? var2_21 : zzfm.zza((Context)var1_9 /* !! */ );
                    var8_29 = zzfm.zzb((String)"ga_app_id", (Resources)var5_19 /* !! */ , (String)var1_9 /* !! */ );
                    var2_22 = TextUtils.isEmpty((CharSequence)var8_29);
                    var2_23 = true != var2_22 ? var8_29 : "";
                    this.zzl = var2_23;
                    var2_24 = TextUtils.isEmpty((CharSequence)var4_26);
                    if (!var2_24 || !(var2_24 = TextUtils.isEmpty((CharSequence)var8_29))) {
                        this.zzk = zzfm.zzb((String)"admob_app_id", (Resources)var5_19 /* !! */ , (String)var1_9 /* !! */ );
                    }
                } else {
                    var1_8 = TextUtils.isEmpty((CharSequence)var4_26);
                    if (!var1_8) {
                        var1_13 /* !! */  = this.zzs.zzax();
                        var2_21 = this.zzs.zzv();
                        Preconditions.checkNotNull((Object)var1_13 /* !! */ );
                        var4_26 = var1_13 /* !! */ .getResources();
                        var5_20 = TextUtils.isEmpty((CharSequence)var2_21);
                        var1_13 /* !! */  = var5_20 == false ? var2_21 : zzfm.zza((Context)var1_13 /* !! */ );
                        this.zzk = zzfm.zzb((String)"admob_app_id", (Resources)var4_26, (String)var1_13 /* !! */ );
                    }
                }
                if (var3_16 == 0) {
                    var1_10 = this.zzs.zzau();
                    var2_21 = var1_10.zzk();
                    var3_17 = "App measurement enabled for app package, google app id";
                    var4_26 = this.zza;
                    var1_4 = TextUtils.isEmpty((CharSequence)this.zzj);
                    var1_11 = var1_4 != false ? this.zzk : this.zzj;
                    var2_21.zzc(var3_17, var4_26, var1_11);
                }
            }
            catch (IllegalStateException var1_14) {
                this.zzs.zzau().zzb().zzc("Fetching Google App Id failed with exception. appId", zzem.zzl(var6_1), var1_14);
            }
            this.zzh = null;
            this.zzs.zzat();
            var1_12 = this.zzs.zzc().zzq("analytics.safelisted_events");
            if (var1_12 == null) ** GOTO lbl160
            if (var1_12.size() == 0) {
                this.zzs.zzau().zzh().zza("Safelisted event list is empty. Ignoring");
            } else {
                for (String var3_18 : var1_12) {
                    if (this.zzs.zzl().zzk("safelisted event", var3_18)) continue;
                    break block39;
                }
lbl160:
                // 2 sources

                this.zzh = var1_12;
            }
        }
        if (var7_2 != null) {
            this.zzi = (int)InstantApps.isInstantApp((Context)this.zzs.zzax());
            return;
        }
        this.zzi = 0;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    final zzp zzh(String string) {
        Object object;
        boolean bl;
        boolean bl2;
        Object object2;
        Object object3;
        long l;
        String string2;
        long l2;
        String string3;
        String string4;
        String string5;
        block24: {
            PackageManager packageManager;
            Object[] objectArray;
            block22: {
                long l3;
                block23: {
                    ((zzgn)this).zzg();
                    string5 = this.zzi();
                    string4 = this.zzj();
                    this.zzb();
                    string3 = this.zzb;
                    this.zzb();
                    l2 = this.zzc;
                    this.zzb();
                    Preconditions.checkNotNull((Object)this.zzd);
                    string2 = this.zzd;
                    this.zzs.zzc().zzf();
                    this.zzb();
                    ((zzgn)this).zzg();
                    l = this.zzf;
                    if (l != 0L) break block22;
                    zzku zzku2 = this.zzs.zzl();
                    object3 = this.zzs.zzax();
                    objectArray = this.zzs.zzax().getPackageName();
                    zzku2.zzg();
                    Preconditions.checkNotNull((Object)object3);
                    Preconditions.checkNotEmpty((String)objectArray);
                    packageManager = object3.getPackageManager();
                    object2 = zzku.zzN();
                    if (object2 == null) {
                        zzku2.zzs.zzau().zzb().zza("Could not get MD5 instance");
                        l3 = -1L;
                    } else {
                        if (packageManager != null) {
                            long l4;
                            boolean bl3 = zzku2.zzW((Context)object3, (String)objectArray);
                            if (!bl3) {
                                int n;
                                object3 = Wrappers.packageManager((Context)object3);
                                Signature[] signatureArray = zzku2.zzs.zzax();
                                object3 = object3.getPackageInfo(signatureArray.getPackageName(), 64);
                                signatureArray = ((PackageInfo)object3).signatures;
                                if (signatureArray != null && (n = ((PackageInfo)object3).signatures.length) > 0) {
                                    long l5;
                                    l4 = l5 = zzku.zzO(((MessageDigest)object2).digest(((PackageInfo)object3).signatures[0].toByteArray()));
                                } else {
                                    object3 = zzku2.zzs.zzau();
                                    ((zzem)object3).zze().zza("Could not get signatures");
                                    l4 = -1L;
                                }
                            } else {
                                l4 = 0L;
                            }
                            l3 = l4;
                        }
                        l3 = 0L;
                    }
                    break block23;
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        zzku2.zzs.zzau().zzb().zzb("Package name not found", (Object)nameNotFoundException);
                        l3 = 0L;
                    }
                }
                this.zzf = l3;
                l = l3;
            }
            bl2 = this.zzs.zzF();
            bl = this.zzs.zzd().zzk ^ true;
            ((zzgn)this).zzg();
            if (!this.zzs.zzF()) {
                object = null;
            } else {
                zzqi.zzb();
                if (this.zzs.zzc().zzn(null, zzea.zzai)) {
                    this.zzs.zzau().zzk().zza("Disabled IID for tests.");
                    object = null;
                } else {
                    block21: {
                        block20: {
                            object = this.zzs.zzax();
                            object = object.getClassLoader().loadClass("com.google.firebase.analytics.FirebaseAnalytics");
                            if (object != null) break block20;
                            object = null;
                        }
                        object3 = new Class[]{Context.class};
                        object3 = ((Class)object).getDeclaredMethod("getInstance", (Class<?>)object3);
                        objectArray = new Object[1];
                        packageManager = this.zzs.zzax();
                        objectArray[0] = packageManager;
                        object3 = ((Method)object3).invoke(null, objectArray);
                        if (object3 != null) break block21;
                        object = null;
                    }
                    object = (String)((Class)object).getDeclaredMethod("getFirebaseInstanceId", new Class[0]).invoke(object3, new Object[0]);
                    catch (ClassNotFoundException classNotFoundException) {
                        object = null;
                    }
                }
            }
            break block24;
            catch (Exception exception) {
                this.zzs.zzau().zzf().zza("Failed to obtain Firebase Analytics instance");
                object = null;
            }
            break block24;
            catch (Exception exception) {
                this.zzs.zzau().zzh().zza("Failed to retrieve Firebase Instance Id");
                object = null;
            }
        }
        object3 = this.zzs;
        long l6 = ((zzfu)object3).zzd().zzc.zza();
        long l7 = l6 == 0L ? (l6 = ((zzfu)object3).zzc) : (l6 = Math.min(((zzfu)object3).zzc, l6));
        this.zzb();
        int n = this.zzi;
        boolean bl4 = this.zzs.zzc().zzs();
        object3 = this.zzs.zzd();
        ((zzgn)object3).zzg();
        boolean bl5 = ((zzfb)object3).zzd().getBoolean("deferred_analytics_collection", false);
        this.zzb();
        String string6 = this.zzk;
        object3 = this.zzs.zzc().zzp("google_analytics_default_allow_ad_personalization_signals");
        object3 = object3 == null ? null : Boolean.valueOf((Boolean)object3 ^ true);
        long l8 = this.zzg;
        List<String> list = this.zzh;
        zzov.zzb();
        object2 = this.zzs.zzc().zzn(null, zzea.zzag) ? this.zzl() : null;
        return new zzp(string5, string4, string3, l2, string2, 42004L, l, string, bl2, bl, (String)object, 0L, l7, n, bl4, bl5, string6, (Boolean)object3, l8, list, (String)object2, this.zzs.zzd().zzi().zzd());
    }

    final String zzi() {
        this.zzb();
        Preconditions.checkNotNull((Object)this.zza);
        return this.zza;
    }

    final String zzj() {
        this.zzb();
        Preconditions.checkNotNull((Object)this.zzj);
        return this.zzj;
    }

    final String zzk() {
        this.zzb();
        return this.zzk;
    }

    final String zzl() {
        this.zzb();
        Preconditions.checkNotNull((Object)this.zzl);
        return this.zzl;
    }

    final int zzm() {
        this.zzb();
        return this.zzc;
    }

    final int zzn() {
        this.zzb();
        return this.zzi;
    }

    final List<String> zzo() {
        return this.zzh;
    }
}

