/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.GuardedBy;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzlc;
import com.google.android.gms.internal.measurement.zzll;
import com.google.android.gms.internal.measurement.zzlr;
import com.google.android.gms.internal.measurement.zzlx;
import com.google.android.gms.internal.measurement.zznb;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzdv;
import com.google.android.gms.measurement.internal.zzdw;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzew;
import com.google.android.gms.measurement.internal.zzex;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfa;
import com.google.android.gms.measurement.internal.zzfi;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzgv;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzgx;
import com.google.android.gms.measurement.internal.zzgy;
import com.google.android.gms.measurement.internal.zzgz;
import com.google.android.gms.measurement.internal.zzha;
import com.google.android.gms.measurement.internal.zzhb;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzhe;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzhg;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzhi;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzhk;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzht;
import com.google.android.gms.measurement.internal.zzhu;
import com.google.android.gms.measurement.internal.zzib;
import com.google.android.gms.measurement.internal.zzjb;
import com.google.android.gms.measurement.internal.zzjo;
import com.google.android.gms.measurement.internal.zzjp;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzkg;
import com.google.android.gms.measurement.internal.zzkj;
import com.google.android.gms.measurement.internal.zzkk;
import com.google.android.gms.measurement.internal.zzr;
import com.google.android.gms.measurement.internal.zzz;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzhn
extends zzf {
    @VisibleForTesting
    protected zzhm zza;
    private zzgl zzd;
    private final Set<zzgm> zze;
    private boolean zzf;
    private final AtomicReference<String> zzg;
    private final Object zzh;
    @GuardedBy(value="consentLock")
    private zzaf zzi;
    @GuardedBy(value="consentLock")
    private int zzj;
    private final AtomicLong zzk;
    private long zzl;
    private int zzm;
    final zzr zzb;
    @VisibleForTesting
    protected boolean zzc;
    private final zzkj zzn;

    protected zzhn(zzfl zzfl2) {
        super(zzfl2);
        Object object = new CopyOnWriteArraySet();
        this.zze = object;
        this.zzh = object = new Object();
        this.zzc = true;
        this.zzn = object = new zzhc(this);
        object = new AtomicReference();
        this.zzg = object;
        this.zzi = object = new zzaf(null, null);
        this.zzj = 100;
        this.zzl = -1L;
        this.zzm = 100;
        this.zzk = object = new AtomicLong(0L);
        this.zzb = object = new zzr(zzfl2);
    }

    @Override
    protected final boolean zze() {
        return false;
    }

    public final void zzh() {
        if (this.zzx.zzaw().getApplicationContext() instanceof Application && this.zza != null) {
            ((Application)this.zzx.zzaw().getApplicationContext()).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zza);
            return;
        }
    }

    public final Boolean zzi() {
        AtomicReference atomicReference = new AtomicReference();
        zzgg zzgg2 = this.zzx;
        zzgg2 = ((zzfl)zzgg2).zzau();
        zzgz zzgz2 = new zzgz(this, atomicReference);
        return (Boolean)((zzfi)zzgg2).zzi(atomicReference, 15000L, "boolean test flag value", zzgz2);
    }

    public final String zzj() {
        AtomicReference atomicReference = new AtomicReference();
        zzgg zzgg2 = this.zzx;
        zzgg2 = ((zzfl)zzgg2).zzau();
        zzhd zzhd2 = new zzhd(this, atomicReference);
        return (String)((zzfi)zzgg2).zzi(atomicReference, 15000L, "String test flag value", zzhd2);
    }

    public final Long zzk() {
        AtomicReference atomicReference = new AtomicReference();
        zzgg zzgg2 = this.zzx;
        zzgg2 = ((zzfl)zzgg2).zzau();
        zzhe zzhe2 = new zzhe(this, atomicReference);
        return (Long)((zzfi)zzgg2).zzi(atomicReference, 15000L, "long test flag value", zzhe2);
    }

    public final Integer zzl() {
        AtomicReference atomicReference = new AtomicReference();
        zzgg zzgg2 = this.zzx;
        zzgg2 = ((zzfl)zzgg2).zzau();
        zzhf zzhf2 = new zzhf(this, atomicReference);
        return (Integer)((zzfi)zzgg2).zzi(atomicReference, 15000L, "int test flag value", zzhf2);
    }

    public final Double zzm() {
        AtomicReference atomicReference = new AtomicReference();
        zzgg zzgg2 = this.zzx;
        zzgg2 = ((zzfl)zzgg2).zzau();
        zzhg zzhg2 = new zzhg(this, atomicReference);
        return (Double)((zzfi)zzgg2).zzi(atomicReference, 15000L, "double test flag value", zzhg2);
    }

    public final void zzn(Boolean bl) {
        this.zzb();
        zzgg zzgg2 = this.zzx;
        zzgg2 = ((zzfl)zzgg2).zzau();
        zzhh zzhh2 = new zzhh(this, bl);
        ((zzfi)zzgg2).zzh(zzhh2);
    }

    public final void zzo(Bundle bundle, int n, long l) {
        zzlc.zzb();
        if (this.zzx.zzc().zzn(null, zzdw.zzaw)) {
            this.zzb();
            String string = zzaf.zza(bundle);
            if (string != null) {
                this.zzx.zzat().zzh().zzb("Ignoring invalid consent setting", string);
                this.zzx.zzat().zzh().zza("Valid consent values are 'granted', 'denied'");
            }
            this.zzq(zzaf.zzb(bundle), n, l);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void zzq(zzaf zzaf2, int n, long l) {
        long l2;
        boolean bl;
        block16: {
            block17: {
                boolean bl2;
                boolean bl3;
                block15: {
                    zzlc.zzb();
                    if (!this.zzx.zzc().zzn(null, zzdw.zzaw)) return;
                    this.zzb();
                    if (!this.zzx.zzc().zzn(null, zzdw.zzax) || n != 20) {
                        if (zzaf2.zze() == null && zzaf2.zzg() == null) {
                            this.zzx.zzat().zzh().zza("Discarding empty consent settings");
                            return;
                        }
                    } else {
                        n = 20;
                    }
                    Object object = this.zzh;
                    // MONITORENTER : object
                    boolean bl4 = this.zzj;
                    bl4 = zzaf.zzm(n, bl4 ? 1 : 0);
                    if (bl4) {
                        bl3 = zzaf2.zzi(this.zzi);
                        bl4 = zzaf2.zzh();
                        bl4 = bl4 ? !(bl4 = (boolean)this.zzi.zzh()) : false;
                        this.zzi = zzaf2 = zzaf2.zzl(this.zzi);
                        this.zzj = n;
                        bl = bl4;
                        bl2 = true;
                        // MONITOREXIT : object
                        break block15;
                    }
                    bl3 = false;
                    bl = false;
                    bl2 = false;
                    {
                        catch (Throwable throwable) {}
                        {
                            // MONITOREXIT : object
                            throw throwable;
                        }
                    }
                }
                if (!bl2) {
                    this.zzx.zzat().zzi().zzb("Ignoring lower-priority consent settings, proposed settings", zzaf2);
                    return;
                }
                l2 = this.zzk.getAndIncrement();
                if (bl3) {
                    this.zzg.set(null);
                    zzgg zzgg2 = this.zzx;
                    zzgg2 = ((zzfl)zzgg2).zzau();
                    zzhi zzhi2 = new zzhi(this, zzaf2, l, n, l2, bl);
                    ((zzfi)zzgg2).zzj(zzhi2);
                    return;
                }
                if (!this.zzx.zzc().zzn(null, zzdw.zzax)) break block16;
                if (n == 40) break block17;
                if (n != 20) break block16;
                n = 20;
            }
            zzgg zzgg3 = this.zzx;
            zzgg3 = ((zzfl)zzgg3).zzau();
            zzhj zzhj2 = new zzhj(this, zzaf2, n, l2, bl);
            ((zzfi)zzgg3).zzj(zzhj2);
            return;
        }
        zzgg zzgg4 = this.zzx;
        zzgg4 = ((zzfl)zzgg4).zzau();
        zzhk zzhk2 = new zzhk(this, zzaf2, n, l2, bl);
        ((zzfi)zzgg4).zzh(zzhk2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzr(zzaf zzaf2) {
        ((zzge)this).zzg();
        boolean bl = !zzaf2.zzh() || !zzaf2.zzf() ? this.zzx.zzy().zzH() : true;
        if (bl != this.zzx.zzI()) {
            this.zzx.zzH(bl);
            Object object = this.zzx.zzd();
            zzlc.zzb();
            if (((zzge)object).zzx.zzc().zzn(null, zzdw.zzaw)) {
                zzfl cfr_ignored_0 = ((zzge)object).zzx;
                ((zzge)object).zzg();
                object = ((zzex)object).zzd().contains("measurement_enabled_from_api") ? Boolean.valueOf(((zzex)object).zzd().getBoolean("measurement_enabled_from_api", true)) : null;
            } else {
                object = null;
            }
            if (!bl || object == null || ((Boolean)object).booleanValue()) {
                this.zzY(bl, false);
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zzY(Boolean bl, boolean bl2) {
        ((zzge)this).zzg();
        this.zzb();
        this.zzx.zzat().zzj().zzb("Setting app measurement enabled (FE)", bl);
        this.zzx.zzd().zze(bl);
        zzlc.zzb();
        if (this.zzx.zzc().zzn(null, zzdw.zzaw) && bl2) {
            zzex zzex2 = this.zzx.zzd();
            zzlc.zzb();
            if (zzex2.zzx.zzc().zzn(null, zzdw.zzaw)) {
                zzfl cfr_ignored_0 = zzex2.zzx;
                zzex2.zzg();
                zzex2 = zzex2.zzd().edit();
                if (bl != null) {
                    zzex2.putBoolean("measurement_enabled_from_api", bl);
                } else {
                    zzex2.remove("measurement_enabled_from_api");
                }
                zzex2.apply();
            }
        }
        zzlc.zzb();
        if (!this.zzx.zzc().zzn(null, zzdw.zzaw) || this.zzx.zzI() || bl != null && !bl.booleanValue()) {
            this.zzZ();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zzZ() {
        ((zzge)this).zzg();
        Object object = this.zzx.zzd().zzm.zza();
        if (object != null) {
            if ("unset".equals(object)) {
                this.zzB("app", "_npa", null, this.zzx.zzax().currentTimeMillis());
            } else {
                long l = true != "true".equals(object) ? 0L : 1L;
                this.zzB("app", "_npa", l, this.zzx.zzax().currentTimeMillis());
            }
        }
        if (this.zzx.zzF() && this.zzc) {
            this.zzx.zzat().zzj().zza("Recording app launch after enabling measurement for the first time (FE)");
            this.zzH();
            zzlx.zzb();
            if (this.zzx.zzc().zzn(null, zzdw.zzao)) {
                this.zzx.zzh().zza.zza();
            }
            zzlr.zzb();
            if (this.zzx.zzc().zzn(null, zzdw.zzar)) {
                object = this.zzx.zzi();
                Preconditions.checkNotNull((Object)object);
                if (((zzfa)object).zza.zzd().zzi.zza() <= 0L) {
                    ((zzfa)object).zza(((zzfa)object).zza.zzaw().getPackageName());
                }
            }
            object = this.zzx;
            object = ((zzfl)object).zzau();
            zzgr zzgr2 = new zzgr(this);
            ((zzfi)object).zzh(zzgr2);
            return;
        }
        this.zzx.zzat().zzj().zza("Updating Scion state (FE)");
        this.zzx.zzy().zzi();
    }

    public final void zzs(String string, String string2, Bundle bundle) {
        this.zzv(string, string2, bundle, true, true, this.zzx.zzax().currentTimeMillis());
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzt(String string, String string2, long l, Bundle bundle) {
        ((zzge)this).zzg();
        boolean bl = this.zzd != null ? zzkk.zzR(string2) : true;
        this.zzu(string, string2, l, bundle, true, bl, false, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    protected final void zzu(String object, String string, long l, Bundle object2, boolean n, boolean bl, boolean bl2, String string2) {
        int n2;
        long l2;
        int n3;
        Object object32;
        block51: {
            block52: {
                Object[] objectArray;
                Preconditions.checkNotEmpty((String)object);
                Preconditions.checkNotNull((Object)object2);
                ((zzge)zzgg2).zzg();
                ((zzf)zzgg2).zzb();
                if (!((zzhn)zzgg2).zzx.zzF()) {
                    ((zzge)zzgg2).zzx.zzat().zzj().zza("Event not sent since app measurement is disabled");
                    return;
                }
                Object object4 = ((zze)zzgg2).zzx.zzA().zzo();
                if (object4 != null && !object4.contains(string)) {
                    ((zzge)zzgg2).zzx.zzat().zzj().zzc("Dropping non-safelisted event. event name, origin", string, object);
                    return;
                }
                if (!((zzhn)zzgg2).zzf) {
                    GenericDeclaration genericDeclaration;
                    ((zzhn)zzgg2).zzf = true;
                    boolean bl3 = ((zzhn)zzgg2).zzx.zzu();
                    if (bl3) {
                        genericDeclaration = "com.google.android.gms.tagmanager.TagManagerService";
                        genericDeclaration = Class.forName((String)((Object)genericDeclaration));
                    }
                    genericDeclaration = "com.google.android.gms.tagmanager.TagManagerService";
                    objectArray = ((zzge)zzgg2).zzx.zzaw();
                    genericDeclaration = Class.forName((String)((Object)genericDeclaration), true, objectArray.getClassLoader());
                    try {
                        objectArray = new Class[]{Context.class};
                        genericDeclaration = ((Class)genericDeclaration).getDeclaredMethod("initialize", (Class<?>[])objectArray);
                        objectArray = new Object[1];
                        object32 = ((zzge)zzgg2).zzx.zzaw();
                        objectArray[0] = object32;
                        ((Method)genericDeclaration).invoke(null, objectArray);
                    }
                    catch (Exception exception) {
                        try {
                            ((zzge)zzgg2).zzx.zzat().zze().zzb("Failed to invoke Tag Manager's initialize() method", exception);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            ((zzge)zzgg2).zzx.zzat().zzi().zza("Tag Manager is not found and thus will not be used");
                        }
                    }
                }
                if (((zzge)zzgg2).zzx.zzc().zzn(null, zzdw.zzac) && "_cmp".equals(string) && object2.containsKey("gclid")) {
                    ((zzge)zzgg2).zzx.zzas();
                    ((zzhn)zzgg2).zzB("auto", "_lgclid", object2.getString("gclid"), ((zzge)zzgg2).zzx.zzax().currentTimeMillis());
                }
                ((zzge)zzgg2).zzx.zzas();
                if (n != 0 && zzkk.zzY(string)) {
                    ((zzge)zzgg2).zzx.zzl().zzH((Bundle)object2, ((zzge)zzgg2).zzx.zzd().zzw.zza());
                }
                if (bl2) {
                    ((zzge)zzgg2).zzx.zzas();
                    if (!"_iap".equals(string)) {
                        int n4;
                        object4 = ((zzhn)zzgg2).zzx.zzl();
                        if (!((zzkk)object4).zzj("event", string)) {
                            n4 = 2;
                        } else if (!((zzkk)object4).zzl("event", zzgi.zza, zzgi.zzb, string)) {
                            n4 = 13;
                        } else {
                            ((zzge)object4).zzx.zzc();
                            n4 = !((zzkk)object4).zzm("event", 40, string) ? 2 : 0;
                        }
                        if (n4 != 0) {
                            ((zzge)zzgg2).zzx.zzat().zzd().zzb("Invalid public event name. Event will not be logged (FE)", ((zzge)zzgg2).zzx.zzm().zzc(string));
                            object = ((zzhn)zzgg2).zzx;
                            object = ((zzfl)object).zzl();
                            ((zzhn)zzgg2).zzx.zzc();
                            object2 = ((zzkk)object).zzC(string, 40, true);
                            int n5 = string != null ? string.length() : 0;
                            ((zzhn)zzgg2).zzx.zzl().zzM(((zzhn)zzgg2).zzn, null, n4, "_ev", (String)object2, n5);
                            return;
                        }
                    }
                }
                ((zzge)zzgg2).zzx.zzas();
                objectArray = ((zze)zzgg2).zzx.zzx().zzh(false);
                if (objectArray != null && !object2.containsKey("_sc")) {
                    objectArray.zzd = true;
                }
                n3 = n != 0 ? (bl2 ? 1 : 0) : 0;
                zzib.zzm((zzhu)objectArray, (Bundle)object2, n3 != 0);
                n3 = "am".equals(object);
                boolean bl4 = zzkk.zzR(string);
                if (n == 0) break block52;
                if (((zzhn)zzgg2).zzd != null) {
                    if (!bl4) {
                        if (n3 == 0) {
                            ((zzge)zzgg2).zzx.zzat().zzj().zzc("Passing event to registered event handler (FE)", ((zzge)zzgg2).zzx.zzm().zzc(string), ((zzge)zzgg2).zzx.zzm().zzf((Bundle)object2));
                            Preconditions.checkNotNull((Object)((zzhn)zzgg2).zzd);
                            ((zzhn)zzgg2).zzd.interceptEvent((String)object, string, (Bundle)object2, l);
                            return;
                        }
                        n = 1;
                        break block51;
                    } else {
                        n = n3;
                    }
                    break block51;
                } else {
                    n = n3;
                }
                break block51;
            }
            n = n3;
        }
        if (!((zzhn)zzgg2).zzx.zzL()) {
            return;
        }
        n3 = ((zzge)zzgg2).zzx.zzl().zzn(string);
        if (n3 != 0) {
            ((zzge)zzgg2).zzx.zzat().zzd().zzb("Invalid event name. Event will not be logged (FE)", ((zzge)zzgg2).zzx.zzm().zzc(string));
            object = ((zzge)zzgg2).zzx;
            object = ((zzfl)object).zzl();
            ((zzge)zzgg2).zzx.zzc();
            object2 = ((zzkk)object).zzC(string, 40, true);
            int n6 = string != null ? string.length() : 0;
            ((zzhn)zzgg2).zzx.zzl().zzM(((zzhn)zzgg2).zzn, string2, n3, "_ev", (String)object2, n6);
            return;
        }
        String[] stringArray = new String[]{"_o", "_sn", "_sc", "_si"};
        stringArray = CollectionUtils.listOf((Object[])stringArray);
        stringArray = ((zzge)zzgg2).zzx.zzl().zzF(string2, string, (Bundle)object2, (List<String>)stringArray, bl2);
        Preconditions.checkNotNull((Object)stringArray);
        if (stringArray.containsKey("_sc") && stringArray.containsKey("_si")) {
            object2 = stringArray.getString("_sn");
            String string3 = stringArray.getString("_sc");
            l2 = stringArray.getLong("_si");
            Long l3 = l2;
            new zzhu((String)object2, string3, l3);
        }
        ((zzge)zzgg2).zzx.zzas();
        if (((zze)zzgg2).zzx.zzx().zzh(false) != null && "_ae".equals(string)) {
            object2 = ((zze)zzgg2).zzx.zzh().zzb;
            l2 = ((zzjo)object2).zzc.zzx.zzax().elapsedRealtime();
            long l4 = l2 - ((zzjo)object2).zzb;
            ((zzjo)object2).zzb = l2;
            if (l4 > 0L) {
                ((zzge)zzgg2).zzx.zzl().zzac((Bundle)stringArray, l4);
            }
        }
        zzll.zzb();
        if (((zzge)zzgg2).zzx.zzc().zzn(null, zzdw.zzan)) {
            if (!"auto".equals(object) && "_ssr".equals(string)) {
                zzkk zzkk2 = ((zzge)zzgg2).zzx.zzl();
                object2 = stringArray.getString("_ffr");
                if (Strings.isEmptyOrWhitespace((String)object2)) {
                    object2 = null;
                } else if (object2 != null) {
                    object2 = ((String)object2).trim();
                }
                if (zzkk.zzS((String)object2, zzkk2.zzx.zzd().zzt.zza())) {
                    zzkk2.zzx.zzat().zzj().zza("Not logging duplicate session_start_with_rollout event");
                    return;
                }
                zzkk2.zzx.zzd().zzt.zzb((String)object2);
            } else if ("_ae".equals(string) && !TextUtils.isEmpty((CharSequence)(object2 = ((zzge)zzgg2).zzx.zzl().zzx.zzd().zzt.zza()))) {
                stringArray.putString("_ffr", (String)object2);
            }
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        arrayList.add((Bundle)stringArray);
        ((zzge)zzgg2).zzx.zzl().zzf().nextLong();
        if (((zzge)zzgg2).zzx.zzd().zzo.zza() > 0L && ((zzge)zzgg2).zzx.zzd().zzl(l) && ((zzge)zzgg2).zzx.zzd().zzq.zza()) {
            ((zzge)zzgg2).zzx.zzat().zzk().zza("Current session is expired, remove the session number, ID, and engagement time");
            ((zzhn)zzgg2).zzB("auto", "_sid", null, ((zzge)zzgg2).zzx.zzax().currentTimeMillis());
            ((zzhn)zzgg2).zzB("auto", "_sno", null, ((zzge)zzgg2).zzx.zzax().currentTimeMillis());
            ((zzhn)zzgg2).zzB("auto", "_se", null, ((zzge)zzgg2).zzx.zzax().currentTimeMillis());
        }
        if (stringArray.getLong("extend_session", 0L) == 1L) {
            ((zzge)zzgg2).zzx.zzat().zzk().zza("EXTEND_SESSION param attached: initiate a new session or extend the current active session");
            ((zzhn)zzgg2).zzx.zzh().zza.zzb(l, true);
        }
        object32 = new ArrayList(stringArray.keySet());
        Collections.sort(object32);
        int n7 = object32.size();
        for (n2 = 0; n2 < n7; ++n2) {
            String string4 = (String)object32.get(n2);
            if (string4 == null) continue;
            ((zzge)zzgg2).zzx.zzl();
            Object object5 = stringArray.get(string4);
            if (object5 instanceof Bundle) {
                Bundle[] bundleArray = new Bundle[]{(Bundle)object5};
                object5 = bundleArray;
            } else if (object5 instanceof Parcelable[]) {
                object5 = (Parcelable[])object5;
                object5 = (Bundle[])Arrays.copyOf(object5, ((Parcelable[])object5).length, Bundle[].class);
            } else if (object5 instanceof ArrayList) {
                object5 = (ArrayList)object5;
                object5 = ((ArrayList)object5).toArray(new Bundle[((ArrayList)object5).size()]);
            } else {
                object5 = null;
            }
            if (object5 == null) continue;
            stringArray.putParcelableArray(string4, (Parcelable[])object5);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            stringArray = (Bundle)arrayList.get(n2);
            String string5 = n2 != 0 ? "_ep" : string;
            stringArray.putString("_o", (String)object);
            if (bl) {
                stringArray = ((zzge)zzgg2).zzx.zzl().zzU((Bundle)stringArray);
            }
            zzaq zzaq2 = new zzaq((Bundle)stringArray);
            object32 = new zzas(string5, zzaq2, (String)object, l);
            ((zze)zzgg2).zzx.zzy().zzl((zzas)((Object)object32), string2);
            if (n != 0) continue;
            for (Object object32 : ((zzhn)zzgg2).zze) {
                object32 = (zzgm)object32;
                zzaq2 = new Bundle((Bundle)stringArray);
                object32.onEvent((String)object, string, (Bundle)zzaq2, l);
            }
        }
        ((zzge)zzgg2).zzx.zzas();
        if (((zze)zzgg2).zzx.zzx().zzh(false) != null && "_ae".equals(string)) {
            object = ((zze)zzgg2).zzx;
            object = ((zzfl)object).zzh();
            zzgg zzgg2 = ((zzge)zzgg2).zzx;
            zzgg2 = ((zzfl)zzgg2).zzax();
            l = zzgg2.elapsedRealtime();
            ((zzjq)object).zzb.zzd(true, true, l);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzv(String string, String string2, Bundle bundle, boolean bl, boolean bl2, long l) {
        if (string == null) {
            string = "app";
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (this.zzx.zzc().zzn(null, zzdw.zzat) && zzkk.zzS(string2, "screen_view")) {
            this.zzx.zzx().zzj(bundle, l);
            return;
        }
        boolean bl3 = bl2 ? (this.zzd != null ? zzkk.zzR(string2) : true) : true;
        this.zzx(string, string2, l, bundle, bl2, bl3, bl ^ true, null);
    }

    protected final void zzx(String string, String string2, long l, Bundle object2, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle = new Bundle((Bundle)object2);
        for (Object object2 : bundle.keySet()) {
            Bundle bundle2;
            Object object3;
            Object object4 = bundle.get((String)object2);
            if (object4 instanceof Bundle) {
                object3 = new Bundle((Bundle)object4);
                bundle.putBundle((String)object2, object3);
                continue;
            }
            if (object4 instanceof Parcelable[]) {
                object4 = (Parcelable[])object4;
                for (int i = 0; i < ((Parcelable[])object4).length; ++i) {
                    object3 = object4[i];
                    if (!(object3 instanceof Bundle)) continue;
                    bundle2 = new Bundle(object3);
                    object4[i] = bundle2;
                }
                continue;
            }
            if (!(object4 instanceof List)) continue;
            object4 = (List)object4;
            for (int i = 0; i < object4.size(); ++i) {
                object3 = object4.get(i);
                if (!(object3 instanceof Bundle)) continue;
                bundle2 = new Bundle(object3);
                object4.set(i, bundle2);
            }
        }
        object2 = this.zzx;
        object2 = ((zzfl)object2).zzau();
        Object object5 = new zzgt(this, string, string2, l, bundle, bl, bl2, bl3, string3);
        ((zzfi)object2).zzh((Runnable)object5);
    }

    public final void zzy(String string, String string2, Object object, boolean bl) {
        this.zzz("auto", string2, object, true, this.zzx.zzax().currentTimeMillis());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final void zzz(String object, String string, Object object2, boolean bl, long l) {
        void var5_15;
        void var4_8;
        if (object == null) {
            object = "app";
        }
        if (bl) {
            int n = this.zzx.zzl().zzo(string);
        } else {
            zzkk zzkk2 = this.zzx.zzl();
            if (!zzkk2.zzj("user property", string)) {
                int n = 6;
            } else if (!zzkk2.zzl("user property", zzgk.zza, null, string)) {
                int n = 15;
            } else {
                zzkk2.zzx.zzc();
                if (!zzkk2.zzm("user property", 24, string)) {
                    int n = 6;
                } else {
                    boolean bl2 = false;
                }
            }
        }
        if (var4_8 != false) {
            object = this.zzx;
            object = ((zzfl)object).zzl();
            this.zzx.zzc();
            object2 = ((zzkk)object).zzC(string, 24, true);
            int n = string != null ? string.length() : 0;
            this.zzx.zzl().zzM(this.zzn, null, (int)var4_8, "_ev", (String)object2, n);
            return;
        }
        if (object2 == null) {
            this.zzA((String)object, string, (long)var5_15, null);
            return;
        }
        int n = this.zzx.zzl().zzJ(string, object2);
        if (n != 0) {
            object = this.zzx;
            object = ((zzfl)object).zzl();
            this.zzx.zzc();
            string = ((zzkk)object).zzC(string, 24, true);
            int n2 = object2 instanceof String || object2 instanceof CharSequence ? String.valueOf(object2).length() : 0;
            this.zzx.zzl().zzM(this.zzn, null, n, "_ev", string, n2);
            return;
        }
        object2 = this.zzx.zzl().zzK(string, object2);
        if (object2 != null) {
            this.zzA((String)object, string, (long)var5_15, object2);
            return;
        }
    }

    final void zzA(String string, String string2, long l, Object object) {
        zzgg zzgg2 = this.zzx;
        zzgg2 = ((zzfl)zzgg2).zzau();
        zzgu zzgu2 = new zzgu(this, string, string2, object, l);
        ((zzfi)zzgg2).zzh(zzgu2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzB(String string, String string2, Object object, long l) {
        Object object2;
        block6: {
            block7: {
                Preconditions.checkNotEmpty((String)string);
                Preconditions.checkNotEmpty((String)string2);
                ((zzge)this).zzg();
                this.zzb();
                if (!"allow_personalized_ads".equals(string2)) break block7;
                if (object instanceof String && !TextUtils.isEmpty((CharSequence)(object2 = (String)object))) {
                    long l2 = true != "false".equals(((String)object2).toLowerCase(Locale.ENGLISH)) ? 0L : 1L;
                    object2 = l2;
                    object = this.zzx.zzd().zzm;
                    string2 = (Long)object2 == 1L ? "true" : "false";
                    ((zzew)object).zzb(string2);
                    string2 = "_npa";
                    break block6;
                } else if (object == null) {
                    this.zzx.zzd().zzm.zzb("unset");
                    string2 = "_npa";
                    object2 = object;
                    break block6;
                } else {
                    object2 = object;
                }
                break block6;
            }
            object2 = object;
        }
        if (!this.zzx.zzF()) {
            this.zzx.zzat().zzk().zza("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzx.zzL()) {
            return;
        }
        object = new zzkg(string2, l, object2, string);
        this.zzx.zzy().zzs((zzkg)((Object)object));
    }

    public final List<zzkg> zzC(boolean bl) {
        this.zzb();
        this.zzx.zzat().zzk().zza("Getting user properties (FE)");
        if (!this.zzx.zzau().zzd()) {
            this.zzx.zzas();
            if (zzz.zza()) {
                this.zzx.zzat().zzb().zza("Cannot get all user properties from main thread");
                return Collections.emptyList();
            }
            Object object = new AtomicReference();
            zzgg zzgg2 = this.zzx;
            zzgg2 = ((zzfl)zzgg2).zzau();
            zzgv zzgv2 = new zzgv(this, (AtomicReference)object, bl);
            ((zzfi)zzgg2).zzi(object, 5000L, "get user properties", zzgv2);
            object = (List)((AtomicReference)object).get();
            if (object == null) {
                this.zzx.zzat().zzb().zzb("Timed out waiting for get user properties, includeInternal", bl);
                return Collections.emptyList();
            }
            return object;
        }
        this.zzx.zzat().zzb().zza("Cannot get all user properties from analytics worker thread");
        return Collections.emptyList();
    }

    public final String zzD() {
        return this.zzg.get();
    }

    final void zzE(String string) {
        this.zzg.set(string);
    }

    public final void zzF(long l) {
        this.zzg.set(null);
        zzgg zzgg2 = this.zzx;
        zzgg2 = ((zzfl)zzgg2).zzau();
        zzgw zzgw2 = new zzgw(this, l);
        ((zzfi)zzgg2).zzh(zzgw2);
    }

    final void zzG(long l, boolean bl) {
        ((zzge)this).zzg();
        this.zzb();
        this.zzx.zzat().zzj().zza("Resetting analytics data (FE)");
        zzjq zzjq2 = this.zzx.zzh();
        ((zzge)zzjq2).zzg();
        zzjp cfr_ignored_0 = zzjq2.zza;
        zzjq2.zzb.zzc();
        boolean bl2 = this.zzx.zzF();
        zzex zzex2 = this.zzx.zzd();
        zzex2.zzh.zzb(l);
        if (!TextUtils.isEmpty((CharSequence)zzex2.zzx.zzd().zzt.zza())) {
            zzex2.zzt.zzb(null);
        }
        zzlx.zzb();
        if (zzex2.zzx.zzc().zzn(null, zzdw.zzao)) {
            zzex2.zzo.zzb(0L);
        }
        if (!zzex2.zzx.zzc().zzr()) {
            zzex2.zzj(bl2 ^ true);
        }
        zzex2.zzu.zzb(null);
        zzex2.zzv.zzb(0L);
        zzex2.zzw.zzb(null);
        if (bl) {
            this.zzx.zzy().zzu();
        }
        zzlx.zzb();
        if (this.zzx.zzc().zzn(null, zzdw.zzao)) {
            this.zzx.zzh().zza.zza();
        }
        this.zzc = bl2 ^ true;
    }

    @WorkerThread
    public final void zzH() {
        ((zzge)this).zzg();
        this.zzb();
        if (this.zzx.zzL()) {
            Object object;
            Object object2;
            if (this.zzx.zzc().zzn(null, zzdw.zzab)) {
                object2 = this.zzx.zzc();
                ((zzge)object2).zzx.zzas();
                object2 = ((zzae)object2).zzp("google_analytics_deferred_deep_link_enabled");
                if (object2 != null && ((Boolean)object2).booleanValue()) {
                    this.zzx.zzat().zzj().zza("Deferred Deep Link feature enabled.");
                    object2 = this.zzx;
                    object2 = ((zzfl)object2).zzau();
                    object = new zzgp(this);
                    ((zzfi)object2).zzh((Runnable)object);
                }
            }
            this.zzx.zzy().zzy();
            this.zzc = false;
            object2 = this.zzx.zzd();
            ((zzge)object2).zzg();
            object = ((zzex)object2).zzd().getString("previous_os_version", null);
            ((zzge)object2).zzx.zzz().zzv();
            String string = Build.VERSION.RELEASE;
            if (!TextUtils.isEmpty((CharSequence)string) && !string.equals(object)) {
                object2 = ((zzex)object2).zzd().edit();
                object2.putString("previous_os_version", string);
                object2.apply();
            }
            if (!TextUtils.isEmpty((CharSequence)object)) {
                this.zzx.zzz().zzv();
                if (!((String)object).equals(Build.VERSION.RELEASE)) {
                    object2 = new Bundle();
                    object2.putString("_po", (String)object);
                    this.zzs("auto", "_ou", (Bundle)object2);
                    return;
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    public final void zzI(zzgl zzgl2) {
        zzgl zzgl3;
        ((zzge)this).zzg();
        this.zzb();
        if (zzgl2 != null && zzgl2 != (zzgl3 = this.zzd)) {
            boolean bl = zzgl3 == null;
            Preconditions.checkState((boolean)bl, (Object)"EventInterceptor already set.");
        }
        this.zzd = zzgl2;
    }

    public final void zzJ(zzgm zzgm2) {
        this.zzb();
        Preconditions.checkNotNull((Object)zzgm2);
        if (!this.zze.add(zzgm2)) {
            this.zzx.zzat().zze().zza("OnEventListener already registered");
            return;
        }
    }

    public final void zzK(zzgm zzgm2) {
        this.zzb();
        Preconditions.checkNotNull((Object)zzgm2);
        if (!this.zze.remove(zzgm2)) {
            this.zzx.zzat().zze().zza("OnEventListener had not been registered");
            return;
        }
    }

    public final int zzL(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzx.zzc();
        return 25;
    }

    public final void zzM(Bundle bundle) {
        this.zzN(bundle, this.zzx.zzax().currentTimeMillis());
    }

    public final void zzN(Bundle object, long l) {
        block6: {
            Object object2;
            block7: {
                long l2;
                block9: {
                    Bundle bundle;
                    block8: {
                        Preconditions.checkNotNull((Object)object);
                        bundle = new Bundle((Bundle)object);
                        if (!TextUtils.isEmpty((CharSequence)bundle.getString("app_id"))) {
                            this.zzx.zzat().zze().zza("Package name should be null when calling setConditionalUserProperty");
                        }
                        bundle.remove("app_id");
                        Preconditions.checkNotNull((Object)bundle);
                        zzgh.zzb((Bundle)bundle, (String)"app_id", String.class, null);
                        zzgh.zzb((Bundle)bundle, (String)"origin", String.class, null);
                        zzgh.zzb((Bundle)bundle, (String)"name", String.class, null);
                        zzgh.zzb((Bundle)bundle, (String)"value", Object.class, null);
                        zzgh.zzb((Bundle)bundle, (String)"trigger_event_name", String.class, null);
                        object = 0L;
                        zzgh.zzb((Bundle)bundle, (String)"trigger_timeout", Long.class, (Object)object);
                        zzgh.zzb((Bundle)bundle, (String)"timed_out_event_name", String.class, null);
                        zzgh.zzb((Bundle)bundle, (String)"timed_out_event_params", Bundle.class, null);
                        zzgh.zzb((Bundle)bundle, (String)"triggered_event_name", String.class, null);
                        zzgh.zzb((Bundle)bundle, (String)"triggered_event_params", Bundle.class, null);
                        zzgh.zzb((Bundle)bundle, (String)"time_to_live", Long.class, (Object)object);
                        zzgh.zzb((Bundle)bundle, (String)"expired_event_name", String.class, null);
                        zzgh.zzb((Bundle)bundle, (String)"expired_event_params", Bundle.class, null);
                        Preconditions.checkNotEmpty((String)bundle.getString("name"));
                        Preconditions.checkNotEmpty((String)bundle.getString("origin"));
                        Preconditions.checkNotNull((Object)bundle.get("value"));
                        bundle.putLong("creation_timestamp", l);
                        object = bundle.getString("name");
                        object2 = bundle.get("value");
                        if (this.zzx.zzl().zzo((String)object) != 0) break block6;
                        if (this.zzx.zzl().zzJ((String)object, object2) != 0) break block7;
                        Object object3 = this.zzx.zzl().zzK((String)object, object2);
                        if (object3 == null) {
                            this.zzx.zzat().zzb().zzc("Unable to normalize conditional user property value", this.zzx.zzm().zze((String)object), object2);
                            return;
                        }
                        zzgh.zza((Bundle)bundle, (Object)object3);
                        l2 = bundle.getLong("trigger_timeout");
                        if (TextUtils.isEmpty((CharSequence)bundle.getString("trigger_event_name"))) break block8;
                        this.zzx.zzc();
                        if (l2 > 15552000000L || l2 < 1L) break block9;
                    }
                    long l3 = bundle.getLong("time_to_live");
                    this.zzx.zzc();
                    if (l3 > 15552000000L || l3 < 1L) {
                        this.zzx.zzat().zzb().zzc("Invalid conditional user property time to live", this.zzx.zzm().zze((String)object), l3);
                        return;
                    }
                    object = this.zzx;
                    object = ((zzfl)object).zzau();
                    object2 = new zzgx(this, bundle);
                    ((zzfi)object).zzh((Runnable)object2);
                    return;
                }
                this.zzx.zzat().zzb().zzc("Invalid conditional user property timeout", this.zzx.zzm().zze((String)object), l2);
                return;
            }
            this.zzx.zzat().zzb().zzc("Invalid conditional user property value", this.zzx.zzm().zze((String)object), object2);
            return;
        }
        this.zzx.zzat().zzb().zzb("Invalid conditional user property name", this.zzx.zzm().zze((String)object));
    }

    public final void zzO(String object, String object2, Bundle bundle) {
        zzfl zzfl2 = this.zzx;
        zzfl2 = zzfl2.zzax();
        long l = zzfl2.currentTimeMillis();
        Preconditions.checkNotEmpty((String)object);
        zzfl2 = new Bundle();
        zzfl2.putString("name", (String)object);
        zzfl2.putLong("creation_timestamp", l);
        if (object2 != null) {
            zzfl2.putString("expired_event_name", (String)object2);
            zzfl2.putBundle("expired_event_params", bundle);
        }
        object = this.zzx;
        object = ((zzfl)object).zzau();
        object2 = new zzgy(this, (Bundle)zzfl2);
        ((zzfi)object).zzh((Runnable)object2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ArrayList<Bundle> zzP(String object, String string) {
        if (((zzge)((Object)this)).zzx.zzau().zzd()) {
            ((zzge)((Object)this)).zzx.zzat().zzb().zza("Cannot get conditional user properties from analytics worker thread");
            return new ArrayList(0);
        }
        ((zzge)((Object)this)).zzx.zzas();
        if (zzz.zza()) {
            ((zzge)((Object)this)).zzx.zzat().zzb().zza("Cannot get conditional user properties from main thread");
            return new ArrayList(0);
        }
        AtomicReference atomicReference = new AtomicReference();
        zzgg zzgg2 = ((zzhn)((Object)this)).zzx;
        zzgg2 = ((zzfl)zzgg2).zzau();
        zzha zzha2 = new zzha((zzhn)((Object)this), atomicReference, null, (String)object, string);
        ((zzfi)zzgg2).zzi(atomicReference, 5000L, "get conditional user properties", zzha2);
        object = (List)atomicReference.get();
        if (object != null) return zzkk.zzak((List<zzaa>)object);
        ((zzge)((Object)this)).zzx.zzat().zzb().zzb("Timed out waiting for get conditional user properties", null);
        return new ArrayList();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Map<String, Object> zzQ(String iterator, String object, boolean bl) {
        void var3_5;
        if (((zzge)object2).zzx.zzau().zzd()) {
            ((zzge)object2).zzx.zzat().zzb().zza("Cannot get user properties from analytics worker thread");
            return Collections.emptyMap();
        }
        ((zzge)object2).zzx.zzas();
        if (zzz.zza()) {
            ((zzge)object2).zzx.zzat().zzb().zza("Cannot get user properties from main thread");
            return Collections.emptyMap();
        }
        AtomicReference atomicReference = new AtomicReference();
        zzgg zzgg2 = ((zzhn)object2).zzx;
        zzgg2 = ((zzfl)zzgg2).zzau();
        zzhb zzhb2 = new zzhb((zzhn)object2, atomicReference, null, (String)((Object)iterator), (String)object, (boolean)var3_5);
        ((zzfi)zzgg2).zzi(atomicReference, 5000L, "get user properties", zzhb2);
        iterator = (List)atomicReference.get();
        if (iterator == null) {
            ((zzge)object2).zzx.zzat().zzb().zzb("Timed out waiting for handle get user properties, includeInternal", (boolean)var3_5);
            return Collections.emptyMap();
        }
        Object object2 = new ArrayMap(iterator.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            zzkg zzkg2 = (zzkg)((Object)iterator.next());
            Object object3 = zzkg2.zza();
            if (object3 == null) continue;
            object2.put(zzkg2.zzb, object3);
        }
        return object2;
    }

    public final String zzR() {
        zzhu zzhu2 = ((zzhn)((Object)zzhu2)).zzx.zzx().zzl();
        if (zzhu2 != null) {
            return zzhu2.zza;
        }
        return null;
    }

    public final String zzS() {
        zzhu zzhu2 = ((zzhn)((Object)zzhu2)).zzx.zzx().zzl();
        if (zzhu2 != null) {
            return zzhu2.zzb;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final String zzT() {
        block4: {
            Object object;
            if (this.zzx.zzr() != null) return this.zzx.zzr();
            try {
                zznb.zzb();
                zzae zzae2 = this.zzx.zzc();
                object = zzdw.zzaB;
                boolean bl = zzae2.zzn(null, (zzdv<Boolean>)object);
                if (!bl) break block4;
            }
            catch (IllegalStateException illegalStateException) {
                this.zzx.zzat().zzb().zzb("getGoogleAppId failed with exception", illegalStateException);
                return null;
            }
            Object object2 = this.zzx.zzaw();
            object = this.zzx.zzv();
            return zzht.zzb((Context)object2, (String)"google_app_id", (String)object);
        }
        Object object = this.zzx.zzaw();
        return zzht.zza((Context)object, (String)"google_app_id");
    }

    /*
     * Enabled aggressive block sorting
     */
    final /* synthetic */ void zzU(Bundle object) {
        Object object2;
        if (object == null) {
            Object object3 = ((zzge)object3).zzx;
            object3 = ((zzfl)object3).zzd();
            object3 = ((zzex)object3).zzw;
            object = new Bundle();
            ((zzet)object3).zzb((Bundle)object);
            return;
        }
        Bundle bundle = ((zzge)object3).zzx.zzd().zzw.zza();
        for (Object object4 : object.keySet()) {
            object2 = object.get((String)object4);
            if (!(object2 == null || object2 instanceof String || object2 instanceof Long || object2 instanceof Double)) {
                if (((zzge)object3).zzx.zzl().zzs(object2)) {
                    ((zzge)object3).zzx.zzl().zzM(((zzhn)object3).zzn, null, 27, null, null, 0);
                }
                ((zzge)object3).zzx.zzat().zzh().zzc("Invalid default event parameter type. Name, value", object4, object2);
                continue;
            }
            if (zzkk.zzR((String)object4)) {
                ((zzge)object3).zzx.zzat().zzh().zzb("Invalid default event parameter name. Name", object4);
                continue;
            }
            if (object2 == null) {
                bundle.remove((String)object4);
                continue;
            }
            zzgg zzgg2 = ((zzge)object3).zzx;
            zzgg2 = ((zzfl)zzgg2).zzl();
            ((zzge)object3).zzx.zzc();
            if (!((zzkk)zzgg2).zzt("param", (String)object4, 100, object2)) continue;
            ((zzge)object3).zzx.zzl().zzL(bundle, (String)object4, object2);
        }
        ((zzge)object3).zzx.zzl();
        int n = ((zzge)object3).zzx.zzc().zzc();
        if (bundle.size() > n) {
            Object object4;
            object = new TreeSet(bundle.keySet());
            object4 = object.iterator();
            int n2 = 0;
            while (object4.hasNext()) {
                object2 = (String)object4.next();
                if (++n2 <= n) continue;
                bundle.remove((String)object2);
            }
            ((zzge)object3).zzx.zzl().zzM(((zzhn)object3).zzn, null, 26, null, null, 0);
            ((zzge)object3).zzx.zzat().zzh().zza("Too many default event parameters set. Discarding beyond event parameter limit");
        }
        ((zzge)object3).zzx.zzd().zzw.zzb(bundle);
        ((zze)object3).zzx.zzy().zzA(bundle);
    }

    static /* synthetic */ void zzV(zzhn zzhn2, Boolean bl, boolean bl2) {
        zzhn2.zzY(bl, true);
    }

    static /* synthetic */ void zzW(zzhn zzgg2, zzaf atomicReference, int n, long l, boolean bl, boolean bl2) {
        ((zzge)zzgg2).zzg();
        ((zzf)zzgg2).zzb();
        if (l > ((zzhn)zzgg2).zzl || !zzaf.zzm(((zzhn)zzgg2).zzm, n)) {
            zzex zzex2 = ((zzge)zzgg2).zzx.zzd();
            zzlc.zzb();
            if (zzex2.zzx.zzc().zzn(null, zzdw.zzaw)) {
                zzfl cfr_ignored_0 = zzex2.zzx;
                zzex2.zzg();
                if (zzex2.zzh(n)) {
                    zzex2 = zzex2.zzd().edit();
                    zzex2.putString("consent_settings", ((zzaf)((Object)atomicReference)).zzd());
                    zzex2.putInt("consent_source", n);
                    zzex2.apply();
                    ((zzhn)zzgg2).zzl = l;
                    ((zzhn)zzgg2).zzm = n;
                    ((zze)zzgg2).zzx.zzy().zzj(bl);
                    if (bl2) {
                        zzgg2 = ((zze)zzgg2).zzx;
                        zzgg2 = ((zzfl)zzgg2).zzy();
                        atomicReference = new AtomicReference<String>();
                        ((zzjb)zzgg2).zzv(atomicReference);
                        return;
                    }
                    return;
                }
            }
            ((zzge)zzgg2).zzx.zzat().zzi().zzb("Lower precedence consent source ignored, proposed source", n);
            return;
        }
        ((zzge)zzgg2).zzx.zzat().zzi().zzb("Dropped out-of-date consent setting, proposed settings", atomicReference);
    }

    static /* synthetic */ void zzX(zzhn zzhn2) {
        zzhn2.zzZ();
    }
}

