/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzlz;
import com.google.android.gms.internal.measurement.zznv;
import com.google.android.gms.internal.measurement.zzw;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzeq;
import com.google.android.gms.measurement.internal.zzeu;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzgv;
import com.google.android.gms.measurement.internal.zzgx;
import com.google.android.gms.measurement.internal.zzku;
import com.google.android.gms.measurement.internal.zzky;
import com.google.android.gms.measurement.internal.zzz;
import java.io.ByteArrayInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.x500.X500Principal;

public final class zzkv
extends zzgq {
    private static final String[] zza = new String[]{"firebase_", "google_", "ga_"};
    private static final String[] zzb = new String[]{"_err"};
    private SecureRandom zzc;
    private final AtomicLong zzd = new AtomicLong(0L);
    private int zze;
    private Integer zzf = null;

    zzkv(zzfu zzfu2) {
        super(zzfu2);
    }

    @Override
    protected final boolean zzd() {
        return true;
    }

    @Override
    @WorkerThread
    protected final void g_() {
        ((zzgr)this).zzc();
        SecureRandom secureRandom = new SecureRandom();
        long l = secureRandom.nextLong();
        if (l == 0L && (l = secureRandom.nextLong()) == 0L) {
            ((zzgr)this).zzq().zzh().zza("Utils falling back to Random for random id");
        }
        this.zzd.set(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long zzf() {
        if (this.zzd.get() == 0L) {
            AtomicLong atomicLong = this.zzd;
            synchronized (atomicLong) {
                return new Random(System.nanoTime() ^ ((zzgr)this).zzl().currentTimeMillis()).nextLong() + (long)(++this.zze);
            }
        }
        AtomicLong atomicLong = this.zzd;
        synchronized (atomicLong) {
            this.zzd.compareAndSet(-1L, 1L);
            return this.zzd.getAndIncrement();
        }
    }

    @WorkerThread
    final SecureRandom zzg() {
        ((zzgr)this).zzc();
        if (this.zzc == null) {
            this.zzc = new SecureRandom();
        }
        return this.zzc;
    }

    static boolean zza(String string) {
        Preconditions.checkNotEmpty((String)string);
        return string.charAt(0) != '_' || string.equals("_ep");
    }

    final Bundle zza(@NonNull Uri uri) {
        if (uri == null) {
            return null;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            if (uri.isHierarchical()) {
                string = uri.getQueryParameter("utm_campaign");
                string2 = uri.getQueryParameter("utm_source");
                string3 = uri.getQueryParameter("utm_medium");
                string4 = uri.getQueryParameter("gclid");
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            ((zzgr)this).zzq().zzh().zza("Install referrer url isn't a hierarchical URI", unsupportedOperationException);
            return null;
        }
        if (!(TextUtils.isEmpty(string) && TextUtils.isEmpty(string2) && TextUtils.isEmpty(string3) && TextUtils.isEmpty(string4))) {
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            Bundle bundle = new Bundle();
            if (!TextUtils.isEmpty((CharSequence)string)) {
                bundle.putString("campaign", string);
            }
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                bundle.putString("source", string2);
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                bundle.putString("medium", string3);
            }
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                bundle.putString("gclid", string4);
            }
            if (!TextUtils.isEmpty((CharSequence)(string9 = uri.getQueryParameter("utm_term")))) {
                bundle.putString("term", string9);
            }
            if (!TextUtils.isEmpty((CharSequence)(string8 = uri.getQueryParameter("utm_content")))) {
                bundle.putString("content", string8);
            }
            if (!TextUtils.isEmpty((CharSequence)(string7 = uri.getQueryParameter("aclid")))) {
                bundle.putString("aclid", string7);
            }
            if (!TextUtils.isEmpty((CharSequence)(string6 = uri.getQueryParameter("cp1")))) {
                bundle.putString("cp1", string6);
            }
            if (!TextUtils.isEmpty((CharSequence)(string5 = uri.getQueryParameter("anid")))) {
                bundle.putString("anid", string5);
            }
            return bundle;
        }
        return null;
    }

    static boolean zza(Intent intent) {
        String string = intent.getStringExtra("android.intent.extra.REFERRER_NAME");
        return "android-app://com.google.android.googlequicksearchbox/https/www.google.com".equals(string) || "https://www.google.com".equals(string) || "android-app://com.google.appcrawler".equals(string);
    }

    final boolean zza(String string, String string2) {
        int n;
        if (string2 == null) {
            ((zzgr)this).zzq().zzg().zza("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            ((zzgr)this).zzq().zzg().zza("Name is required and can't be empty. Type", string);
            return false;
        }
        int n2 = string2.codePointAt(0);
        if (!Character.isLetter(n2)) {
            ((zzgr)this).zzq().zzg().zza("Name must start with a letter. Type, name", string, string2);
            return false;
        }
        int n3 = string2.length();
        for (int i = Character.charCount(n2); i < n3; i += Character.charCount(n)) {
            n = string2.codePointAt(i);
            if (n == 95 || Character.isLetterOrDigit(n)) continue;
            ((zzgr)this).zzq().zzg().zza("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    final boolean zzb(String string, String string2) {
        int n;
        if (string2 == null) {
            ((zzgr)this).zzq().zzg().zza("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            ((zzgr)this).zzq().zzg().zza("Name is required and can't be empty. Type", string);
            return false;
        }
        int n2 = string2.codePointAt(0);
        if (!Character.isLetter(n2) && n2 != 95) {
            ((zzgr)this).zzq().zzg().zza("Name must start with a letter or _ (underscore). Type, name", string, string2);
            return false;
        }
        int n3 = string2.length();
        for (int i = Character.charCount(n2); i < n3; i += Character.charCount(n)) {
            n = string2.codePointAt(i);
            if (n == 95 || Character.isLetterOrDigit(n)) continue;
            ((zzgr)this).zzq().zzg().zza("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    final boolean zza(String string, String[] stringArray, String[] stringArray2, String string2) {
        boolean bl;
        block4: {
            if (string2 == null) {
                ((zzgr)this).zzq().zzg().zza("Name is required and can't be null. Type", string);
                return false;
            }
            String string3 = string2;
            Preconditions.checkNotNull((Object)string3);
            String[] stringArray3 = zza;
            int n = zza.length;
            for (int i = 0; i < n; ++i) {
                String string4 = stringArray3[i];
                if (!string3.startsWith(string4)) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        if (bl) {
            ((zzgr)this).zzq().zzg().zza("Name starts with reserved prefix. Type, name", string, string2);
            return false;
        }
        if (stringArray != null && zzkv.zza(string2, stringArray) && (stringArray2 == null || !zzkv.zza(string2, stringArray2))) {
            ((zzgr)this).zzq().zzg().zza("Name is reserved. Type, name", string, string2);
            return false;
        }
        return true;
    }

    final boolean zza(String string, String[] stringArray, String string2) {
        return this.zza(string, stringArray, null, string2);
    }

    final boolean zza(String string, int n, String string2) {
        if (string2 == null) {
            ((zzgr)this).zzq().zzg().zza("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.codePointCount(0, string2.length()) > n) {
            ((zzgr)this).zzq().zzg().zza("Name is too long. Type, maximum supported length, name", string, n, string2);
            return false;
        }
        return true;
    }

    final int zza(String string, boolean bl) {
        if (!this.zzb("event", string)) {
            return 2;
        }
        if (bl ? !this.zza("event", zzgv.zza, zzgv.zzb, string) : !this.zza("event", zzgv.zza, string)) {
            return 13;
        }
        if (!this.zza("event", 40, string)) {
            return 2;
        }
        return 0;
    }

    final int zzb(String string) {
        if (!this.zzb("user property", string)) {
            return 6;
        }
        if (!this.zza("user property", zzgx.zza, string)) {
            return 15;
        }
        if (!this.zza("user property", 24, string)) {
            return 6;
        }
        return 0;
    }

    private final int zzg(String string) {
        if (!this.zza("event param", string)) {
            return 3;
        }
        if (!this.zza("event param", (String[])null, string)) {
            return 14;
        }
        if (!this.zza("event param", 40, string)) {
            return 3;
        }
        return 0;
    }

    private final int zzh(String string) {
        if (!this.zzb("event param", string)) {
            return 3;
        }
        if (!this.zza("event param", (String[])null, string)) {
            return 14;
        }
        if (!this.zza("event param", 40, string)) {
            return 3;
        }
        return 0;
    }

    static boolean zza(Object object) {
        return object instanceof Parcelable[] || object instanceof ArrayList || object instanceof Bundle;
    }

    final boolean zza(String string, String string2, int n, Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Long || object instanceof Float || object instanceof Integer || object instanceof Byte || object instanceof Short || object instanceof Boolean || object instanceof Double) {
            return true;
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            String string3 = String.valueOf(object);
            if (string3.codePointCount(0, string3.length()) > n) {
                ((zzgr)this).zzq().zzj().zza("Value is too long; discarded. Value kind, name, value length", string, string2, string3.length());
                return false;
            }
            return true;
        }
        return false;
    }

    static boolean zza(Bundle bundle, int n) {
        if (bundle.size() <= n) {
            return false;
        }
        TreeSet treeSet = new TreeSet(bundle.keySet());
        int n2 = 0;
        for (String string : treeSet) {
            if (++n2 <= n) continue;
            bundle.remove(string);
        }
        return true;
    }

    private final void zza(String string, String string2, String string3, Bundle bundle, @Nullable List<String> list, boolean bl) {
        if (bundle == null) {
            return;
        }
        int n = 0;
        for (String string4 : new TreeSet(bundle.keySet())) {
            int n2 = 0;
            if (list == null || !list.contains(string4)) {
                if (bl) {
                    n2 = this.zzg(string4);
                }
                if (n2 == 0) {
                    n2 = this.zzh(string4);
                }
            }
            if (n2 != 0) {
                zzkv.zza(bundle, n2, string4, string4, n2 == 3 ? string4 : null);
                bundle.remove(string4);
                continue;
            }
            if (zzkv.zza(bundle.get(string4))) {
                ((zzgr)this).zzq().zzj().zza("Nested Bundle parameters are not allowed; discarded. event name, param name, child param name", string2, string3, string4);
                n2 = 22;
            } else {
                n2 = this.zza(string, string2, string4, bundle.get(string4), bundle, list, bl, false);
            }
            if (n2 != 0 && !"_ev".equals(string4)) {
                zzkv.zza(bundle, n2, string4, string4, bundle.get(string4));
                bundle.remove(string4);
                continue;
            }
            if (!zzkv.zza(string4) || zzkv.zza(string4, zzgu.zzd) || ++n <= 0) continue;
            ((zzgr)this).zzq().zzg().zza("Item cannot contain custom parameters", ((zzgr)this).zzn().zza(string2), ((zzgr)this).zzn().zza(bundle));
            zzkv.zzb(bundle, 23);
            bundle.remove(string4);
        }
    }

    final boolean zza(String string, String string2, String string3) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (!zzkv.zzi(string)) {
                if (this.zzy.zzk()) {
                    ((zzgr)this).zzq().zzg().zza("Invalid google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI. provided id", zzeq.zza(string));
                }
                return false;
            }
        } else if (!zznv.zzb() || !((zzgr)this).zzs().zza(zzas.zzbi) || TextUtils.isEmpty((CharSequence)string3)) {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                if (!zzkv.zzi(string2)) {
                    ((zzgr)this).zzq().zzg().zza("Invalid admob_app_id. Analytics disabled.", zzeq.zza(string2));
                    return false;
                }
            } else {
                if (this.zzy.zzk()) {
                    ((zzgr)this).zzq().zzg().zza("Missing google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI");
                }
                return false;
            }
        }
        return true;
    }

    static boolean zza(String string, String string2, String string3, String string4) {
        boolean bl = TextUtils.isEmpty((CharSequence)string);
        boolean bl2 = TextUtils.isEmpty((CharSequence)string2);
        if (!bl && !bl2) {
            return !string.equals(string2);
        }
        if (bl && bl2) {
            if (!TextUtils.isEmpty((CharSequence)string3) && !TextUtils.isEmpty((CharSequence)string4)) {
                return !string3.equals(string4);
            }
            return !TextUtils.isEmpty((CharSequence)string4);
        }
        if (!bl && bl2) {
            if (TextUtils.isEmpty((CharSequence)string4)) {
                return false;
            }
            return TextUtils.isEmpty((CharSequence)string3) || !string3.equals(string4);
        }
        return TextUtils.isEmpty((CharSequence)string3) || !string3.equals(string4);
    }

    @VisibleForTesting
    private static boolean zzi(String string) {
        Preconditions.checkNotNull((Object)string);
        String string2 = "^(1:\\d+:android:[a-f0-9]+|ca-app-pub-.*)$";
        return string.matches(string2);
    }

    private final Object zza(int n, Object object, boolean bl, boolean bl2) {
        if (object == null) {
            return null;
        }
        if (object instanceof Long || object instanceof Double) {
            return object;
        }
        if (object instanceof Integer) {
            return (long)((Integer)object).intValue();
        }
        if (object instanceof Byte) {
            return (long)((Byte)object).byteValue();
        }
        if (object instanceof Short) {
            return (long)((Short)object).shortValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1L : 0L;
        }
        if (object instanceof Float) {
            return ((Float)object).doubleValue();
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            return zzkv.zza(String.valueOf(object), n, bl);
        }
        if (bl2 && (object instanceof Bundle[] || object instanceof Parcelable[])) {
            ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
            for (Parcelable parcelable : (Parcelable[])object) {
                Bundle bundle;
                if (!(parcelable instanceof Bundle) || (bundle = this.zza((Bundle)parcelable)) == null || bundle.isEmpty()) continue;
                arrayList.add(bundle);
            }
            return arrayList.toArray(new Bundle[arrayList.size()]);
        }
        return null;
    }

    public static String zza(String string, int n, boolean bl) {
        if (string == null) {
            return null;
        }
        if (string.codePointCount(0, string.length()) > n) {
            if (bl) {
                return String.valueOf(string.substring(0, string.offsetByCodePoints(0, n))).concat("...");
            }
            return null;
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    @WorkerThread
    private final int zza(String var1_1, String var2_2, String var3_3, Object var4_4, Bundle var5_5, @Nullable List<String> var6_6, boolean var7_7, boolean var8_8) {
        block25: {
            block26: {
                block27: {
                    this.zzc();
                    var9_9 = 0;
                    if (!zzkv.zza(var4_4)) break block25;
                    if (!var8_8) break block26;
                    if (!zzkv.zza(var3_3, zzgu.zzc)) {
                        return 20;
                    }
                    if (!this.zzy.zzv().zzah()) {
                        return 25;
                    }
                    var15_10 = var4_4;
                    var13_11 = var3_3;
                    var12_12 = "param";
                    var11_13 = this;
                    if (!(var15_10 instanceof Parcelable[])) break block27;
                    var16_14 = ((Parcelable[])var15_10).length;
                    ** GOTO lbl21
                }
                if (!(var15_10 instanceof ArrayList)) {
                    v0 = true;
                } else {
                    var16_14 = ((ArrayList)var15_10).size();
lbl21:
                    // 2 sources

                    if (var16_14 > 200) {
                        var11_13.zzq().zzj().zza("Parameter array is too long; discarded. Value kind, name, array length", var12_12, var13_11, var16_14);
                        v0 = false;
                    } else {
                        v0 = true;
                    }
                }
                if (!v0) {
                    var9_9 = 17;
                    var14_17 = var4_4;
                    var12_12 = var3_3;
                    var11_13 = var5_5;
                    if (var14_17 instanceof Parcelable[]) {
                        if (((Parcelable[])var14_17).length > 200) {
                            var11_13.putParcelableArray(var12_12, Arrays.copyOf((Parcelable[])var14_17, 200));
                        }
                    } else if (var14_17 instanceof ArrayList && (var16_15 = (ArrayList)var14_17).size() > 200) {
                        var11_13.putParcelableArrayList(var12_12, new ArrayList<E>(var16_15.subList(0, 200)));
                    }
                }
                break block25;
            }
            return 21;
        }
        if (this.zza("param", var3_3, var10_18 = this.zzs().zze(var1_1, zzas.zzaq) != false && zzkv.zzd(var2_2) != false || zzkv.zzd(var3_3) != false ? 256 : 100, var4_4)) {
            return var9_9;
        }
        if (var8_8) {
            var17_19 = var7_7;
            var16_16 = var6_6;
            var15_10 = var4_4;
            var14_17 = var3_3;
            var13_11 = var2_2;
            var12_12 = var1_1;
            var11_13 = this;
            if (var15_10 instanceof Bundle) {
                var11_13.zza(var12_12, var13_11, (String)var14_17, (Bundle)var15_10, var16_16, var17_19);
                v1 = true;
            } else if (var15_10 instanceof Parcelable[]) {
                for (Parcelable var21_24 : (Parcelable[])var15_10) {
                    if (!(var21_24 instanceof Bundle)) {
                        var11_13.zzq().zzj().zza("All Parcelable[] elements must be of type Bundle. Value type, name", var21_24.getClass(), var14_17);
                        ** break block24
                    }
                    var11_13.zza(var12_12, var13_11, (String)var14_17, (Bundle)var21_24, var16_16, var17_19);
                }
                v1 = true;
            } else if (var15_10 instanceof ArrayList) {
                var22_25 = (ArrayList)var15_10;
                var23_26 = var22_25.size();
                for (var24_27 = 0; var24_27 < var23_26; ++var24_27) {
                    v2 = var22_25.get(var24_27);
                    var19_22 = v2;
                    if (!(v2 instanceof Bundle)) {
                        var11_13.zzq().zzj().zza("All ArrayList elements must be of type Bundle. Value type, name", var19_22.getClass(), var14_17);
                        ** break block24
                    }
                    var11_13.zza(var12_12, var13_11, (String)var14_17, (Bundle)var19_22, var16_16, var17_19);
                }
                v1 = true;
            } else lbl-1000:
            // 3 sources

            {
                v1 = false;
            }
            if (v1) {
                return var9_9;
            }
        }
        return 4;
    }

    final Object zza(String string, Object object) {
        if ("_ev".equals(string)) {
            return this.zza(256, object, true, true);
        }
        return this.zza(zzkv.zzd(string) ? 256 : 100, object, false, true);
    }

    static Bundle[] zzb(Object object) {
        if (object instanceof Bundle) {
            return new Bundle[]{(Bundle)object};
        }
        if (object instanceof Parcelable[]) {
            return (Bundle[])Arrays.copyOf((Parcelable[])object, ((Parcelable[])object).length, Bundle[].class);
        }
        if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            return arrayList.toArray(new Bundle[arrayList.size()]);
        }
        return null;
    }

    final Bundle zza(String string, String string2, Bundle bundle, @Nullable List<String> list, boolean bl, boolean bl2) {
        boolean bl3 = zzkv.zza(string2, zzgv.zzd);
        Bundle bundle2 = null;
        if (bundle != null) {
            bundle2 = new Bundle(bundle);
            int n = 0;
            int n2 = ((zzgr)this).zzs().zzd();
            TreeSet treeSet = ((zzgr)this).zzs().zze(string, zzas.zzay) ? new TreeSet(bundle.keySet()) : bundle.keySet();
            for (String string3 : treeSet) {
                String string4;
                int n3 = 0;
                if (list == null || !list.contains(string3)) {
                    if (bl) {
                        n3 = this.zzg(string3);
                    }
                    if (n3 == 0) {
                        n3 = this.zzh(string3);
                    }
                }
                if (n3 != 0) {
                    zzkv.zza(bundle2, n3, string3, string3, n3 == 3 ? string3 : null);
                    bundle2.remove(string3);
                    continue;
                }
                n3 = this.zza(string, string2, string3, bundle.get(string3), bundle2, list, bl, bl3);
                if (n3 == 17) {
                    zzkv.zza(bundle2, n3, string3, string3, false);
                } else if (n3 != 0 && !"_ev".equals(string3)) {
                    string4 = n3 == 21 ? string2 : string3;
                    zzkv.zza(bundle2, n3, string4, string3, bundle.get(string3));
                    bundle2.remove(string3);
                    continue;
                }
                if (!zzkv.zza(string3) || ++n <= n2) continue;
                string4 = new StringBuilder(48).append("Event can't contain more than ").append(n2).append(" params").toString();
                ((zzgr)this).zzq().zzg().zza(string4, ((zzgr)this).zzn().zza(string2), ((zzgr)this).zzn().zza(bundle));
                zzkv.zzb(bundle2, 5);
                bundle2.remove(string3);
            }
        }
        return bundle2;
    }

    final void zza(zzeu zzeu2, int n) {
        int n2 = 0;
        for (String string : new TreeSet(zzeu2.zzb.keySet())) {
            if (!zzkv.zza(string) || ++n2 <= n) continue;
            String string2 = new StringBuilder(48).append("Event can't contain more than ").append(n).append(" params").toString();
            ((zzgr)this).zzq().zzg().zza(string2, ((zzgr)this).zzn().zza(zzeu2.zza), ((zzgr)this).zzn().zza(zzeu2.zzb));
            zzkv.zzb(zzeu2.zzb, 5);
            zzeu2.zzb.remove(string);
        }
    }

    final void zza(Bundle bundle, Bundle bundle2) {
        if (bundle2 == null) {
            return;
        }
        for (String string : bundle2.keySet()) {
            if (bundle.containsKey(string)) continue;
            ((zzgr)this).zzo().zza(bundle, string, bundle2.get(string));
        }
    }

    private static void zza(Bundle bundle, int n, String string, String string2, Object object) {
        if (zzkv.zzb(bundle, n)) {
            String string3 = zzkv.zza(string, 40, true);
            bundle.putString("_ev", string3);
            if (object != null) {
                Object object2 = object;
                Bundle bundle2 = bundle;
                Preconditions.checkNotNull((Object)bundle2);
                if (object2 != null && (object2 instanceof String || object2 instanceof CharSequence)) {
                    String string4 = String.valueOf(object2);
                    bundle2.putLong("_el", (long)string4.length());
                }
            }
        }
    }

    private static boolean zzb(Bundle bundle, int n) {
        if (bundle == null) {
            return false;
        }
        if (bundle.getLong("_err") == 0L) {
            bundle.putLong("_err", (long)n);
            return true;
        }
        return false;
    }

    private final int zzj(String string) {
        if ("_ldl".equals(string)) {
            return 2048;
        }
        if ("_id".equals(string)) {
            return 256;
        }
        if (((zzgr)this).zzs().zza(zzas.zzbg) && "_lgclid".equals(string)) {
            return 100;
        }
        return 36;
    }

    final int zzb(String string, Object object) {
        boolean bl = "_ldl".equals(string) ? this.zza("user property referrer", string, this.zzj(string), object) : this.zza("user property", string, this.zzj(string), object);
        if (bl) {
            return 0;
        }
        return 7;
    }

    final Object zzc(String string, Object object) {
        if ("_ldl".equals(string)) {
            return this.zza(this.zzj(string), object, true, false);
        }
        return this.zza(this.zzj(string), object, false, false);
    }

    final void zza(Bundle bundle, String string, Object object) {
        if (bundle == null) {
            return;
        }
        if (object instanceof Long) {
            bundle.putLong(string, ((Long)object).longValue());
            return;
        }
        if (object instanceof String) {
            String string2 = String.valueOf(object);
            bundle.putString(string, string2);
            return;
        }
        if (object instanceof Double) {
            bundle.putDouble(string, ((Double)object).doubleValue());
            return;
        }
        if (object instanceof Bundle[]) {
            bundle.putParcelableArray(string, (Parcelable[])((Bundle[])object));
            return;
        }
        if (string != null) {
            String string3 = object != null ? object.getClass().getSimpleName() : null;
            ((zzgr)this).zzq().zzj().zza("Not putting event parameter. Invalid value type. name, type", ((zzgr)this).zzn().zzb(string), string3);
        }
    }

    public final void zza(zzky zzky2, int n, String string, String string2, int n2) {
        this.zza(zzky2, null, n, string, string2, n2);
    }

    final void zza(zzky zzky2, String string, int n, String string2, String string3, int n2) {
        Bundle bundle = new Bundle();
        zzkv.zzb(bundle, n);
        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3)) {
            bundle.putString(string2, string3);
        }
        if (n == 6 || n == 7 || n == 2) {
            bundle.putLong("_el", (long)n2);
        }
        if (zzlz.zzb() && ((zzgr)this).zzs().zza(zzas.zzcn)) {
            zzky2.zza(string, bundle);
            return;
        }
        this.zzy.zzg().zza("auto", "_err", bundle);
    }

    static MessageDigest zzh() {
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                if (messageDigest == null) continue;
                return messageDigest;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        return null;
    }

    @VisibleForTesting
    static long zza(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        Preconditions.checkState((byArray.length > 0 ? 1 : 0) != 0);
        long l = 0L;
        int n = 0;
        for (int i = byArray.length - 1; i >= 0 && i >= byArray.length - 8; --i) {
            l += ((long)byArray[i] & 0xFFL) << n;
            n += 8;
        }
        return l;
    }

    static boolean zza(Context context, boolean bl) {
        Preconditions.checkNotNull((Object)context);
        if (Build.VERSION.SDK_INT >= 24) {
            return zzkv.zzb(context, "com.google.android.gms.measurement.AppMeasurementJobService");
        }
        return zzkv.zzb(context, "com.google.android.gms.measurement.AppMeasurementService");
    }

    private static boolean zzb(Context context, String string) {
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ServiceInfo serviceInfo = packageManager.getServiceInfo(new ComponentName(context, string), 0);
            if (serviceInfo != null && serviceInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    @WorkerThread
    final boolean zzc(String string) {
        ((zzgr)this).zzc();
        if (Wrappers.packageManager((Context)((zzgr)this).zzm()).checkCallingOrSelfPermission(string) == 0) {
            return true;
        }
        ((zzgr)this).zzq().zzv().zza("Permission not granted", string);
        return false;
    }

    static boolean zzd(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && string.startsWith("_");
    }

    static boolean zzc(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return string.equals(string2);
    }

    static boolean zza(Boolean bl, Boolean bl2) {
        if (bl == null && bl2 == null) {
            return true;
        }
        if (bl == null) {
            return false;
        }
        return bl.equals(bl2);
    }

    static boolean zza(@Nullable List<String> list, @Nullable List<String> list2) {
        if (list == null && list2 == null) {
            return true;
        }
        if (list == null) {
            return false;
        }
        return list.equals(list2);
    }

    final boolean zze(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        String string2 = ((zzgr)this).zzs().zzw();
        return string2.equals(string);
    }

    final Bundle zza(Bundle bundle) {
        Bundle bundle2 = new Bundle();
        if (bundle != null) {
            for (String string : bundle.keySet()) {
                Object object = this.zza(string, bundle.get(string));
                if (object == null) {
                    ((zzgr)this).zzq().zzj().zza("Param value can't be null", ((zzgr)this).zzn().zzb(string));
                    continue;
                }
                this.zza(bundle2, string, object);
            }
        }
        return bundle2;
    }

    final zzaq zza(String string, String string2, Bundle bundle, String string3, long l, boolean bl, boolean bl2, boolean bl3) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        if (this.zza(string2, bl3) != 0) {
            ((zzgr)this).zzq().zze().zza("Invalid conditional property event name", ((zzgr)this).zzn().zzc(string2));
            throw new IllegalArgumentException();
        }
        bundle = bundle != null ? new Bundle(bundle) : new Bundle();
        bundle.putString("_o", string3);
        List list = CollectionUtils.listOf((Object)"_o");
        Bundle bundle2 = this.zza(string, string2, bundle, list, false, false);
        Bundle bundle3 = bl ? this.zza(bundle2) : bundle2;
        return new zzaq(string2, new zzap(bundle3), string3, l);
    }

    @WorkerThread
    final long zza(Context context, String string) {
        ((zzgr)this).zzc();
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotEmpty((String)string);
        long l = 0L;
        PackageManager packageManager = context.getPackageManager();
        MessageDigest messageDigest = zzkv.zzh();
        if (messageDigest == null) {
            ((zzgr)this).zzq().zze().zza("Could not get MD5 instance");
            l = -1L;
        } else if (packageManager != null) {
            try {
                if (!this.zzc(context, string)) {
                    PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(((zzgr)this).zzm().getPackageName(), 64);
                    if (packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                        l = zzkv.zza(messageDigest.digest(packageInfo.signatures[0].toByteArray()));
                    } else {
                        ((zzgr)this).zzq().zzh().zza("Could not get signatures");
                        l = -1L;
                    }
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                ((zzgr)this).zzq().zze().zza("Package name not found", (Object)nameNotFoundException);
            }
        }
        return l;
    }

    @VisibleForTesting
    private final boolean zzc(Context context, String string) {
        X500Principal x500Principal = new X500Principal("CN=Android Debug,O=Android,C=US");
        try {
            PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(string, 64);
            if (packageInfo != null && packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                Signature signature = packageInfo.signatures[0];
                return ((X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(signature.toByteArray()))).getSubjectX500Principal().equals(x500Principal);
            }
        }
        catch (CertificateException certificateException) {
            ((zzgr)this).zzq().zze().zza("Error obtaining certificate", certificateException);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzgr)this).zzq().zze().zza("Package name not found", (Object)nameNotFoundException);
        }
        return true;
    }

    static byte[] zza(Parcelable parcelable) {
        if (parcelable == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcelable.writeToParcel(parcel, 0);
            byte[] byArray = parcel.marshall();
            return byArray;
        }
        finally {
            parcel.recycle();
        }
    }

    public static Bundle zzb(Bundle bundle) {
        if (bundle == null) {
            return new Bundle();
        }
        Bundle bundle2 = new Bundle(bundle);
        for (String string : bundle2.keySet()) {
            int n;
            Object object;
            Object object2 = bundle2.get(string);
            if (object2 instanceof Bundle) {
                bundle2.putBundle(string, new Bundle((Bundle)object2));
                continue;
            }
            if (object2 instanceof Parcelable[]) {
                object = (Parcelable[])object2;
                for (n = 0; n < ((Parcelable[])object).length; ++n) {
                    if (!(object[n] instanceof Bundle)) continue;
                    object[n] = new Bundle((Bundle)object[n]);
                }
                continue;
            }
            if (!(object2 instanceof List)) continue;
            object = (List)object2;
            for (n = 0; n < object.size(); ++n) {
                Object e = object.get(n);
                if (!(e instanceof Bundle)) continue;
                object.set(n, new Bundle((Bundle)e));
            }
        }
        return bundle2;
    }

    private static boolean zza(String string, String[] stringArray) {
        Preconditions.checkNotNull((Object)stringArray);
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray2[i];
            if (!zzkv.zzc(string, string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean zzf(String string) {
        String[] stringArray = zzb;
        int n = zzb.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return false;
        }
        return true;
    }

    public final int zzi() {
        if (this.zzf == null) {
            this.zzf = GoogleApiAvailabilityLight.getInstance().getApkVersion(((zzgr)this).zzm()) / 1000;
        }
        return this.zzf;
    }

    public final int zza(int n) {
        return GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(((zzgr)this).zzm(), 12451000);
    }

    public static long zza(long l, long l2) {
        return (l + l2 * 60000L) / 86400000L;
    }

    @WorkerThread
    final void zza(Bundle bundle, long l) {
        long l2 = bundle.getLong("_et");
        if (l2 != 0L) {
            ((zzgr)this).zzq().zzh().zza("Params already contained engagement", l2);
        }
        bundle.putLong("_et", l + l2);
    }

    public final void zza(zzw zzw2, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("r", string);
        try {
            zzw2.zza(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzy.zzq().zzh().zza("Error returning string value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zza(zzw zzw2, long l) {
        Bundle bundle = new Bundle();
        bundle.putLong("r", l);
        try {
            zzw2.zza(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzy.zzq().zzh().zza("Error returning long value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zza(zzw zzw2, int n) {
        Bundle bundle = new Bundle();
        bundle.putInt("r", n);
        try {
            zzw2.zza(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzy.zzq().zzh().zza("Error returning int value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zza(zzw zzw2, byte[] byArray) {
        Bundle bundle = new Bundle();
        bundle.putByteArray("r", byArray);
        try {
            zzw2.zza(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzy.zzq().zzh().zza("Error returning byte array to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zza(zzw zzw2, boolean bl) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("r", bl);
        try {
            zzw2.zza(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzy.zzq().zzh().zza("Error returning boolean value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zza(zzw zzw2, Bundle bundle) {
        try {
            zzw2.zza(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzy.zzq().zzh().zza("Error returning bundle value to wrapper", (Object)remoteException);
            return;
        }
    }

    public static Bundle zza(List<zzku> list) {
        Bundle bundle = new Bundle();
        if (list == null) {
            return bundle;
        }
        for (zzku zzku2 : list) {
            if (zzku2.zzd != null) {
                bundle.putString(zzku2.zza, zzku2.zzd);
                continue;
            }
            if (zzku2.zzc != null) {
                bundle.putLong(zzku2.zza, zzku2.zzc.longValue());
                continue;
            }
            if (zzku2.zzf == null) continue;
            bundle.putDouble(zzku2.zza, zzku2.zzf.doubleValue());
        }
        return bundle;
    }

    public final void zza(zzw zzw2, ArrayList<Bundle> arrayList) {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList("r", arrayList);
        try {
            zzw2.zza(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzy.zzq().zzh().zza("Error returning bundle list to wrapper", (Object)remoteException);
            return;
        }
    }

    public static ArrayList<Bundle> zzb(List<zzz> list) {
        if (list == null) {
            return new ArrayList<Bundle>(0);
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>(list.size());
        for (zzz zzz2 : list) {
            Bundle bundle = new Bundle();
            bundle.putString("app_id", zzz2.zza);
            bundle.putString("origin", zzz2.zzb);
            bundle.putLong("creation_timestamp", zzz2.zzd);
            bundle.putString("name", zzz2.zzc.zza);
            zzgs.zza((Bundle)bundle, (Object)zzz2.zzc.zza());
            bundle.putBoolean("active", zzz2.zze);
            if (zzz2.zzf != null) {
                bundle.putString("trigger_event_name", zzz2.zzf);
            }
            if (zzz2.zzg != null) {
                bundle.putString("timed_out_event_name", zzz2.zzg.zza);
                if (zzz2.zzg.zzb != null) {
                    bundle.putBundle("timed_out_event_params", zzz2.zzg.zzb.zzb());
                }
            }
            bundle.putLong("trigger_timeout", zzz2.zzh);
            if (zzz2.zzi != null) {
                bundle.putString("triggered_event_name", zzz2.zzi.zza);
                if (zzz2.zzi.zzb != null) {
                    bundle.putBundle("triggered_event_params", zzz2.zzi.zzb.zzb());
                }
            }
            bundle.putLong("triggered_timestamp", zzz2.zzc.zzb);
            bundle.putLong("time_to_live", zzz2.zzj);
            if (zzz2.zzk != null) {
                bundle.putString("expired_event_name", zzz2.zzk.zza);
                if (zzz2.zzk.zzb != null) {
                    bundle.putBundle("expired_event_params", zzz2.zzk.zzb.zzb());
                }
            }
            arrayList.add(bundle);
        }
        return arrayList;
    }

    public final URL zza(long l, @NonNull String string, @NonNull String string2, long l2) {
        try {
            Preconditions.checkNotEmpty((String)string2);
            Preconditions.checkNotEmpty((String)string);
            String string3 = String.format("https://www.googleadservices.com/pagead/conversion/app/deeplink?id_type=adid&sdk_version=%s&rdid=%s&bundleid=%s&retry=%s", String.format("v%s.%s", l, this.zzi()), string2, string, l2);
            if (string.equals(((zzgr)this).zzs().zzx())) {
                string3 = string3.concat("&ddl_test=1");
            }
            return new URL(string3);
        }
        catch (IllegalArgumentException | MalformedURLException exception) {
            ((zzgr)this).zzq().zze().zza("Failed to create BOW URL for Deferred Deep Link. exception", exception.getMessage());
            return null;
        }
    }

    @SuppressLint(value={"ApplySharedPref"})
    final boolean zza(String string, double d) {
        try {
            SharedPreferences.Editor editor = ((zzgr)this).zzm().getSharedPreferences("google.analytics.deferred.deeplink.prefs", 0).edit();
            editor.putString("deeplink", string);
            editor.putLong("timestamp", Double.doubleToRawLongBits(d));
            return editor.commit();
        }
        catch (Exception exception) {
            ((zzgr)this).zzq().zze().zza("Failed to persist Deferred Deep Link. exception", exception);
            return false;
        }
    }

    public final boolean zzj() {
        try {
            ((zzgr)this).zzm().getClassLoader().loadClass("com.google.firebase.remoteconfig.FirebaseRemoteConfig");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static long zza(zzap zzap2) {
        if (zzap2 == null) {
            return 0L;
        }
        long l = 0L;
        for (String string : zzap2) {
            Object object = zzap2.zza(string);
            if (!(object instanceof Parcelable[])) continue;
            l += (long)((Parcelable[])object).length;
        }
        return l;
    }
}

