/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzae;
import com.google.android.gms.internal.measurement.zzdh;
import com.google.android.gms.internal.measurement.zzml;
import com.google.android.gms.internal.measurement.zzms;
import com.google.android.gms.internal.measurement.zznw;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzeg;
import com.google.android.gms.measurement.internal.zzem;
import com.google.android.gms.measurement.internal.zzen;
import com.google.android.gms.measurement.internal.zzeo;
import com.google.android.gms.measurement.internal.zzeq;
import com.google.android.gms.measurement.internal.zzes;
import com.google.android.gms.measurement.internal.zzfc;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzfm;
import com.google.android.gms.measurement.internal.zzfr;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzgy;
import com.google.android.gms.measurement.internal.zzhb;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzid;
import com.google.android.gms.measurement.internal.zzif;
import com.google.android.gms.measurement.internal.zzii;
import com.google.android.gms.measurement.internal.zzir;
import com.google.android.gms.measurement.internal.zzjx;
import com.google.android.gms.measurement.internal.zzkv;
import com.google.android.gms.measurement.internal.zzw;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONException;
import org.json.JSONObject;

public class zzfu
implements zzgt {
    private static volatile zzfu zzb;
    private final Context zzc;
    private final String zzd;
    private final String zze;
    private final String zzf;
    private final boolean zzg;
    private final zzw zzh;
    private final zzab zzi;
    private final zzfc zzj;
    private final zzeq zzk;
    private final zzfr zzl;
    private final zzjx zzm;
    private final zzkv zzn;
    private final zzeo zzo;
    private final Clock zzp;
    private final zzii zzq;
    private final zzhb zzr;
    private final zza zzs;
    private final zzid zzt;
    private zzem zzu;
    private zzir zzv;
    private zzak zzw;
    private zzen zzx;
    private zzfl zzy;
    private boolean zzz = false;
    private Boolean zzaa;
    private long zzab;
    private volatile Boolean zzac;
    @VisibleForTesting
    private Boolean zzad;
    @VisibleForTesting
    private Boolean zzae;
    private volatile boolean zzaf;
    private int zzag;
    private AtomicInteger zzah = new AtomicInteger(0);
    @VisibleForTesting
    final long zza;

    private zzfu(zzgy zzgy2) {
        Object object;
        Preconditions.checkNotNull((Object)zzgy2);
        Object object2 = zzgy2.zza;
        zzeg.zza = this.zzh = new zzw((Context)object2);
        this.zzc = zzgy2.zza;
        this.zzd = zzgy2.zzb;
        this.zze = zzgy2.zzc;
        this.zzf = zzgy2.zzd;
        this.zzg = zzgy2.zzh;
        this.zzac = zzgy2.zze;
        this.zzaf = true;
        zzae zzae2 = zzgy2.zzg;
        if (zzae2 != null && zzae2.zzg != null) {
            object = zzae2.zzg.get("measurementEnabled");
            if (object instanceof Boolean) {
                this.zzad = (Boolean)object;
            }
            if ((object = zzae2.zzg.get("measurementDeactivated")) instanceof Boolean) {
                this.zzae = (Boolean)object;
            }
        }
        zzdh.zza(this.zzc);
        this.zzp = DefaultClock.getInstance();
        this.zza = zzgy2.zzi != null ? zzgy2.zzi.longValue() : this.zzp.currentTimeMillis();
        object2 = this;
        this.zzi = new zzab((zzfu)object2);
        object2 = this;
        object = new zzfc((zzfu)object2);
        ((zzgq)object).zzac();
        this.zzj = object;
        object2 = this;
        zzeq zzeq2 = new zzeq((zzfu)object2);
        zzeq2.zzac();
        this.zzk = zzeq2;
        object2 = this;
        zzkv zzkv2 = new zzkv((zzfu)object2);
        zzkv2.zzac();
        this.zzn = zzkv2;
        object2 = this;
        zzeo zzeo2 = new zzeo((zzfu)object2);
        zzeo2.zzac();
        this.zzo = zzeo2;
        object2 = this;
        this.zzs = new zza((zzfu)object2);
        object2 = this;
        zzii zzii2 = new zzii((zzfu)object2);
        zzii2.zzw();
        this.zzq = zzii2;
        object2 = this;
        zzhb zzhb2 = new zzhb((zzfu)object2);
        zzhb2.zzw();
        this.zzr = zzhb2;
        object2 = this;
        zzjx zzjx2 = new zzjx((zzfu)object2);
        zzjx2.zzw();
        this.zzm = zzjx2;
        object2 = this;
        zzid zzid2 = new zzid((zzfu)object2);
        zzid2.zzac();
        this.zzt = zzid2;
        object2 = this;
        zzfr zzfr2 = new zzfr((zzfu)object2);
        zzfr2.zzac();
        this.zzl = zzfr2;
        boolean bl = zzgy2.zzg != null && zzgy2.zzg.zzb != 0L;
        boolean bl2 = !bl;
        object2 = this;
        if (((zzfu)object2).zzc.getApplicationContext() instanceof Application) {
            boolean bl3 = bl2;
            zzhb zzhb3 = ((zzfu)object2).zzg();
            if (((zzgr)zzhb3).zzm().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzgr)zzhb3).zzm().getApplicationContext();
                if (zzhb3.zza == null) {
                    zzhb3.zza = new zzhy(zzhb3, null);
                }
                if (bl3) {
                    application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzhb3.zza);
                    application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzhb3.zza);
                    ((zzgr)zzhb3).zzq().zzw().zza("Registered activity lifecycle callback");
                }
            }
        } else {
            ((zzfu)object2).zzq().zzh().zza("Application context is not an Application");
        }
        this.zzl.zza(new zzfw(this, zzgy2));
    }

    @WorkerThread
    private final void zza(zzgy zzgy2) {
        ((zzgr)this.zzp()).zzc();
        Object object = this;
        zzak zzak2 = new zzak((zzfu)object);
        zzak2.zzac();
        this.zzw = zzak2;
        zzfu zzfu2 = this;
        object = zzgy2;
        zzen zzen2 = new zzen(zzfu2, ((zzgy)object).zzf);
        zzen2.zzw();
        this.zzx = zzen2;
        object = this;
        zzem zzem2 = new zzem((zzfu)object);
        zzem2.zzw();
        this.zzu = zzem2;
        object = this;
        zzir zzir2 = new zzir((zzfu)object);
        zzir2.zzw();
        this.zzv = zzir2;
        this.zzn.zzad();
        this.zzj.zzad();
        object = this;
        this.zzy = new zzfl((zzfu)object);
        this.zzx.zzx();
        this.zzq().zzu().zza("App measurement initialized, version", 33025L);
        this.zzq().zzu().zza("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        String string = zzen2.zzaa();
        if (TextUtils.isEmpty((CharSequence)this.zzd)) {
            String string2;
            zzes zzes2;
            if (this.zzh().zze(string)) {
                zzes2 = this.zzq().zzu();
                string2 = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
            } else {
                zzes2 = this.zzq().zzu();
                String string3 = String.valueOf(string);
                string2 = string3.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string3) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
            }
            zzes2.zza(string2);
        }
        this.zzq().zzv().zza("Debug-level message logging enabled");
        if (this.zzag != this.zzah.get()) {
            this.zzq().zze().zza("Not all components initialized", this.zzag, this.zzah.get());
        }
        this.zzz = true;
    }

    @WorkerThread
    protected final void zza(zzae zzae2) {
        int n;
        ((zzgr)this.zzp()).zzc();
        if (zzml.zzb() && this.zzi.zza(zzas.zzcg)) {
            zzac zzac2;
            zzac zzac3 = this.zzb().zzx();
            n = this.zzb().zzw();
            if (this.zzi.zza(zzas.zzch)) {
                zzac zzac4;
                zzac zzac5 = null;
                int n2 = 0;
                Boolean bl = this.zzi.zzi();
                Boolean bl2 = this.zzi.zzj();
                if ((bl != null || bl2 != null) && this.zzb().zza(20)) {
                    zzac5 = new zzac(bl, bl2);
                    n2 = 20;
                } else if (!(TextUtils.isEmpty((CharSequence)this.zzx().zzab()) || n != 30 && n != 40)) {
                    this.zzg().zza(com.google.android.gms.measurement.internal.zzac.zza, 20, this.zza);
                } else if (zzae2 != null && zzae2.zzg != null && this.zzb().zza(40) && !(zzac4 = com.google.android.gms.measurement.internal.zzac.zzb(zzae2.zzg)).equals(com.google.android.gms.measurement.internal.zzac.zza)) {
                    zzac5 = zzac4;
                    n2 = 40;
                }
                if (zzac5 != null) {
                    zzac3 = zzac5;
                    this.zzg().zza(zzac3, n2, this.zza);
                }
            } else if (zzae2 != null && zzae2.zzg != null && this.zzb().zza(40) && !(zzac2 = com.google.android.gms.measurement.internal.zzac.zzb(zzae2.zzg)).equals(com.google.android.gms.measurement.internal.zzac.zza)) {
                zzac3 = zzac2;
                this.zzg().zza(zzac3, 40, this.zza);
            }
            this.zzg().zza(zzac3);
        }
        if (this.zzb().zzc.zza() == 0L) {
            this.zzb().zzc.zza(this.zzp.currentTimeMillis());
        }
        if (Long.valueOf(this.zzb().zzh.zza()) == 0L) {
            this.zzq().zzw().zza("Persisting first open", this.zza);
            this.zzb().zzh.zza(this.zza);
        }
        if (this.zzi.zza(zzas.zzcc)) {
            this.zzg().zzb.zzb();
        }
        if (!this.zzaf()) {
            if (this.zzaa()) {
                if (!this.zzh().zzc("android.permission.INTERNET")) {
                    this.zzq().zze().zza("App is missing INTERNET permission");
                }
                if (!this.zzh().zzc("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzq().zze().zza("App is missing ACCESS_NETWORK_STATE permission");
                }
                if (!Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() && !this.zzi.zzy()) {
                    if (!zzfm.zza(this.zzc)) {
                        this.zzq().zze().zza("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzkv.zza(this.zzc, false)) {
                        this.zzq().zze().zza("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzq().zze().zza("Uploading is not possible. App measurement disabled");
            }
        } else {
            if (!TextUtils.isEmpty((CharSequence)this.zzx().zzab()) || !TextUtils.isEmpty((CharSequence)this.zzx().zzac())) {
                this.zzh();
                if (zzkv.zza(this.zzx().zzab(), this.zzb().zzg(), this.zzx().zzac(), this.zzb().zzh())) {
                    this.zzq().zzu().zza("Rechecking which service to use due to a GMP App Id change");
                    this.zzb().zzj();
                    this.zzj().zzaa();
                    this.zzv.zzag();
                    this.zzv.zzae();
                    this.zzb().zzh.zza(this.zza);
                    this.zzb().zzj.zza(null);
                }
                this.zzb().zzb(this.zzx().zzab());
                this.zzb().zzc(this.zzx().zzac());
            }
            if (zzml.zzb() && this.zzi.zza(zzas.zzcg) && !this.zzb().zzx().zze()) {
                this.zzb().zzj.zza(null);
            }
            this.zzg().zza(this.zzb().zzj.zza());
            if (zzms.zzb() && this.zzi.zza(zzas.zzbo) && !this.zzh().zzj() && !TextUtils.isEmpty((CharSequence)this.zzb().zzu.zza())) {
                this.zzq().zzh().zza("Remote config removed with active feature rollouts");
                this.zzb().zzu.zza(null);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzx().zzab()) || !TextUtils.isEmpty((CharSequence)this.zzx().zzac())) {
                n = this.zzaa() ? 1 : 0;
                if (!this.zzb().zzz() && !this.zzi.zzf()) {
                    this.zzb().zzb(n == 0);
                }
                if (n != 0) {
                    this.zzg().zzah();
                }
                this.zzd().zza.zza();
                this.zzv().zza(new AtomicReference<String>());
                if (zznw.zzb() && this.zzi.zza(zzas.zzby)) {
                    this.zzv().zza(this.zzb().zzx.zza());
                }
            }
        }
        this.zzb().zzo.zza(this.zzi.zza(zzas.zzax));
    }

    @Override
    public final zzw zzt() {
        return this.zzh;
    }

    public final zzab zza() {
        return this.zzi;
    }

    public final zzfc zzb() {
        zzfu.zza(this.zzj);
        return this.zzj;
    }

    @Override
    public final zzeq zzq() {
        zzfu.zzb(this.zzk);
        return this.zzk;
    }

    public final zzeq zzc() {
        if (this.zzk != null && this.zzk.zzaa()) {
            return this.zzk;
        }
        return null;
    }

    @Override
    public final zzfr zzp() {
        zzfu.zzb(this.zzl);
        return this.zzl;
    }

    public final zzjx zzd() {
        zzfu.zzb(this.zzm);
        return this.zzm;
    }

    public final zzfl zze() {
        return this.zzy;
    }

    final zzfr zzf() {
        return this.zzl;
    }

    public final zzhb zzg() {
        zzfu.zzb(this.zzr);
        return this.zzr;
    }

    public final zzkv zzh() {
        zzfu.zza(this.zzn);
        return this.zzn;
    }

    public final zzeo zzi() {
        zzfu.zza(this.zzo);
        return this.zzo;
    }

    public final zzem zzj() {
        zzfu.zzb(this.zzu);
        return this.zzu;
    }

    private final zzid zzah() {
        zzfu.zzb(this.zzt);
        return this.zzt;
    }

    @Override
    public final Context zzm() {
        return this.zzc;
    }

    public final boolean zzk() {
        return TextUtils.isEmpty((CharSequence)this.zzd);
    }

    public final String zzn() {
        return this.zzd;
    }

    public final String zzo() {
        return this.zze;
    }

    public final String zzr() {
        return this.zzf;
    }

    public final boolean zzs() {
        return this.zzg;
    }

    @Override
    public final Clock zzl() {
        return this.zzp;
    }

    public final zzii zzu() {
        zzfu.zzb(this.zzq);
        return this.zzq;
    }

    public final zzir zzv() {
        zzfu.zzb(this.zzv);
        return this.zzv;
    }

    public final zzak zzw() {
        zzfu.zzb(this.zzw);
        return this.zzw;
    }

    public final zzen zzx() {
        zzfu.zzb(this.zzx);
        return this.zzx;
    }

    public final zza zzy() {
        if (this.zzs == null) {
            throw new IllegalStateException("Component not created");
        }
        return this.zzs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzfu zza(Context context, zzae zzae2, Long l) {
        if (zzae2 != null && (zzae2.zze == null || zzae2.zzf == null)) {
            zzae2 = new zzae(zzae2.zza, zzae2.zzb, zzae2.zzc, zzae2.zzd, null, null, zzae2.zzg);
        }
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzb == null) {
            Class<zzfu> clazz = zzfu.class;
            synchronized (zzfu.class) {
                if (zzb == null) {
                    zzgy zzgy2 = new zzgy(context, zzae2, l);
                    zzb = new zzfu(zzgy2);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else if (zzae2 != null && zzae2.zzg != null && zzae2.zzg.containsKey("dataCollectionDefaultEnabled")) {
            zzb.zza(zzae2.zzg.getBoolean("dataCollectionDefaultEnabled"));
        }
        return zzb;
    }

    private static void zzb(zzgq zzgq2) {
        if (zzgq2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzgq2.zzaa()) {
            String string = String.valueOf(zzgq2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zzb(zzg zzg2) {
        if (zzg2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzg2.zzu()) {
            String string = String.valueOf(zzg2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzgr zzgr2) {
        if (zzgr2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzac = bl;
    }

    @WorkerThread
    public final boolean zzz() {
        return this.zzac != null && this.zzac != false;
    }

    @WorkerThread
    public final boolean zzaa() {
        return this.zzab() == 0;
    }

    @WorkerThread
    public final int zzab() {
        ((zzgr)this.zzp()).zzc();
        if (this.zzi.zzf()) {
            return 1;
        }
        if (this.zzae != null && this.zzae.booleanValue()) {
            return 2;
        }
        if (zzml.zzb() && this.zzi.zza(zzas.zzcg) && !this.zzac()) {
            return 8;
        }
        Boolean bl = this.zzb().zzu();
        if (bl != null) {
            if (bl.booleanValue()) {
                return 0;
            }
            return 3;
        }
        zzab zzab2 = this.zzi;
        Boolean bl2 = zzab2.zzf("firebase_analytics_collection_enabled");
        if (bl2 != null) {
            if (bl2.booleanValue()) {
                return 0;
            }
            return 4;
        }
        if (this.zzad != null) {
            if (this.zzad.booleanValue()) {
                return 0;
            }
            return 5;
        }
        if (GoogleServices.isMeasurementExplicitlyDisabled()) {
            return 6;
        }
        if (this.zzi.zza(zzas.zzar) && this.zzac != null) {
            if (this.zzac.booleanValue()) {
                return 0;
            }
            return 7;
        }
        return 0;
    }

    @WorkerThread
    public final void zzb(boolean bl) {
        ((zzgr)this.zzp()).zzc();
        this.zzaf = bl;
    }

    @WorkerThread
    public final boolean zzac() {
        ((zzgr)this.zzp()).zzc();
        return this.zzaf;
    }

    final void zzad() {
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zza(zzgq zzgq2) {
        ++this.zzag;
    }

    final void zza(zzg zzg2) {
        ++this.zzag;
    }

    final void zzae() {
        this.zzah.incrementAndGet();
    }

    @WorkerThread
    protected final boolean zzaf() {
        if (!this.zzz) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
        ((zzgr)this.zzp()).zzc();
        if (this.zzaa == null || this.zzab == 0L || this.zzaa != null && !this.zzaa.booleanValue() && Math.abs(this.zzp.elapsedRealtime() - this.zzab) > 1000L) {
            this.zzab = this.zzp.elapsedRealtime();
            this.zzaa = this.zzh().zzc("android.permission.INTERNET") && this.zzh().zzc("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() || this.zzi.zzy() || zzfm.zza(this.zzc) && zzkv.zza(this.zzc, false));
            if (this.zzaa.booleanValue()) {
                this.zzaa = this.zzh().zza(this.zzx().zzab(), this.zzx().zzac(), this.zzx().zzad()) || !TextUtils.isEmpty((CharSequence)this.zzx().zzac());
            }
        }
        return this.zzaa;
    }

    @WorkerThread
    public final void zzag() {
        ((zzgr)this.zzp()).zzc();
        zzfu.zzb(this.zzah());
        String string = this.zzx().zzaa();
        Pair<String, Boolean> pair = this.zzb().zza(string);
        if (!this.zzi.zzg().booleanValue() || ((Boolean)pair.second).booleanValue() || TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            this.zzq().zzv().zza("ADID unavailable to retrieve Deferred Deep Link. Skipping");
            return;
        }
        if (!this.zzah().zzf()) {
            this.zzq().zzh().zza("Network is not available for Deferred Deep Link request. Skipping");
            return;
        }
        zzkv zzkv2 = this.zzh();
        this.zzx();
        URL uRL = zzkv2.zza(33025L, string, (String)pair.first, this.zzb().zzt.zza() - 1L);
        zzfx zzfx2 = new zzfx(this);
        URL uRL2 = uRL;
        String string2 = string;
        zzid zzid2 = this.zzah();
        ((zzgr)zzid2).zzc();
        zzid2.zzab();
        Preconditions.checkNotNull((Object)uRL2);
        Preconditions.checkNotNull((Object)zzfx2);
        ((zzgr)zzid2).zzp().zzc(new zzif(zzid2, string2, uRL2, null, null, zzfx2));
    }

    final /* synthetic */ void zza(String string, int n, Throwable throwable, byte[] byArray, Map map) {
        Throwable throwable2 = throwable;
        byte[] byArray2 = byArray;
        int n2 = n;
        zzfu zzfu2 = this;
        if (!((n2 == 200 || n2 == 204 || n2 == 304) && throwable2 == null)) {
            zzfu2.zzq().zzh().zza("Network Request for Deferred Deep Link failed. response, exception", n2, throwable2);
            return;
        }
        zzfu2.zzb().zzs.zza(true);
        if (byArray2.length == 0) {
            zzfu2.zzq().zzv().zza("Deferred Deep Link response empty.");
            return;
        }
        String string2 = new String(byArray2);
        try {
            List list;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("deeplink", "");
            String string4 = jSONObject.optString("gclid", "");
            double d = jSONObject.optDouble("timestamp", 0.0);
            if (TextUtils.isEmpty((CharSequence)string3)) {
                zzfu2.zzq().zzv().zza("Deferred Deep Link is empty.");
                return;
            }
            String string5 = string3;
            zzkv zzkv2 = zzfu2.zzh();
            if (!(!TextUtils.isEmpty((CharSequence)string5) && (list = ((zzgr)zzkv2).zzm().getPackageManager().queryIntentActivities(new Intent("android.intent.action.VIEW", Uri.parse((String)string5)), 0)) != null && !list.isEmpty())) {
                zzfu2.zzq().zzh().zza("Deferred Deep Link validation failed. gclid, deep link", string4, string3);
                return;
            }
            Bundle bundle = new Bundle();
            bundle.putString("gclid", string4);
            bundle.putString("_cis", "ddp");
            zzfu2.zzr.zza("auto", "_cmp", bundle);
            string5 = string3;
            zzkv2 = zzfu2.zzh();
            if (!TextUtils.isEmpty((CharSequence)string5) && zzkv2.zza(string5, d)) {
                Intent intent = new Intent("android.google.analytics.action.DEEPLINK_ACTION");
                ((zzgr)zzkv2).zzm().sendBroadcast(intent);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzfu2.zzq().zze().zza("Failed to parse the Deferred Deep Link response. exception", (Object)jSONException);
            return;
        }
    }

    static /* synthetic */ void zza(zzfu zzfu2, zzgy zzgy2) {
        zzfu2.zza(zzgy2);
    }
}

