/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzfi;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgj;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzfg
extends zzgi {
    private zzfk zza;
    private zzfk zzb;
    private final PriorityBlockingQueue<zzfl<?>> zzc;
    private final BlockingQueue<zzfl<?>> zzd;
    private final Thread.UncaughtExceptionHandler zze;
    private final Thread.UncaughtExceptionHandler zzf;
    private final Object zzg = new Object();
    private final Semaphore zzh = new Semaphore(2);
    private volatile boolean zzi;
    private static final AtomicLong zzj = new AtomicLong(Long.MIN_VALUE);

    zzfg(zzfn zzfn2) {
        super(zzfn2);
        this.zzc = new PriorityBlockingQueue();
        this.zzd = new LinkedBlockingQueue();
        this.zze = new zzfi(this, "Thread death: Uncaught exception on worker thread");
        this.zzf = new zzfi(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final boolean zze() {
        return false;
    }

    @Override
    public final void zzd() {
        if (Thread.currentThread() != this.zza) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzc() {
        if (Thread.currentThread() != this.zzb) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public final boolean zzg() {
        return Thread.currentThread() == this.zza;
    }

    public final <V> Future<V> zza(Callable<V> callable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull(callable);
        zzfl zzfl2 = new zzfl(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zza) {
            if (!this.zzc.isEmpty()) {
                ((zzgj)this).zzr().zzi().zza("Callable skipped the worker queue.");
            }
            zzfl2.run();
        } else {
            this.zza(zzfl2);
        }
        return zzfl2;
    }

    public final <V> Future<V> zzb(Callable<V> callable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull(callable);
        zzfl zzfl2 = new zzfl(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zza) {
            zzfl2.run();
        } else {
            this.zza(zzfl2);
        }
        return zzfl2;
    }

    public final void zza(Runnable runnable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull((Object)runnable);
        this.zza(new zzfl(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> T zza(AtomicReference<T> atomicReference, long l, String string, Runnable runnable) {
        AtomicReference<T> atomicReference2 = atomicReference;
        synchronized (atomicReference2) {
            ((zzgj)this).zzq().zza(runnable);
            try {
                atomicReference.wait(15000L);
            }
            catch (InterruptedException interruptedException) {
                String string2 = String.valueOf(string);
                ((zzgj)this).zzr().zzi().zza(string2.length() != 0 ? "Interrupted waiting for ".concat(string2) : new String("Interrupted waiting for "));
                return null;
            }
        }
        atomicReference2 = atomicReference.get();
        if (atomicReference2 == null) {
            String string3 = String.valueOf(string);
            ((zzgj)this).zzr().zzi().zza(string3.length() != 0 ? "Timed out waiting for ".concat(string3) : new String("Timed out waiting for "));
        }
        return (T)atomicReference2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzfl<?> zzfl2) {
        Object object = this.zzg;
        synchronized (object) {
            this.zzc.add(zzfl2);
            if (this.zza == null) {
                this.zza = new zzfk(this, "Measurement Worker", this.zzc);
                this.zza.setUncaughtExceptionHandler(this.zze);
                this.zza.start();
            } else {
                this.zza.zza();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(Runnable runnable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull((Object)runnable);
        zzfl zzfl2 = new zzfl(this, runnable, false, "Task exception on network thread");
        zzfg zzfg2 = this;
        Object object = zzfg2.zzg;
        synchronized (object) {
            zzfg2.zzd.add(zzfl2);
            if (zzfg2.zzb == null) {
                zzfg2.zzb = new zzfk(zzfg2, "Measurement Network", zzfg2.zzd);
                zzfg2.zzb.setUncaughtExceptionHandler(zzfg2.zzf);
                zzfg2.zzb.start();
            } else {
                zzfg2.zzb.zza();
            }
            return;
        }
    }

    static /* synthetic */ Semaphore zza(zzfg zzfg2) {
        return zzfg2.zzh;
    }

    static /* synthetic */ boolean zzb(zzfg zzfg2) {
        return zzfg2.zzi;
    }

    static /* synthetic */ Object zzc(zzfg zzfg2) {
        return zzfg2.zzg;
    }

    static /* synthetic */ zzfk zzd(zzfg zzfg2) {
        return zzfg2.zza;
    }

    static /* synthetic */ zzfk zza(zzfg zzfg2, zzfk zzfk2) {
        zzfg2.zza = null;
        return null;
    }

    static /* synthetic */ zzfk zze(zzfg zzfg2) {
        return zzfg2.zzb;
    }

    static /* synthetic */ zzfk zzb(zzfg zzfg2, zzfk zzfk2) {
        zzfg2.zzb = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzh() {
        return zzj;
    }
}

