/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzdu;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzr;
import com.google.android.gms.measurement.internal.zzu;
import com.google.android.gms.measurement.internal.zzv;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;

public final class zzs
extends zzgf {
    private Boolean zzeb;
    @NonNull
    private zzu zzec = zzv.zzee;
    private Boolean zzed;

    zzs(zzfj zzfj2) {
        super(zzfj2);
        zzak.zza(zzfj2);
    }

    final void zza(@NonNull zzu zzu2) {
        this.zzec = zzu2;
    }

    static String zzbm() {
        return zzak.zzgf.get(null);
    }

    @WorkerThread
    public final int zzi(@Size(min=1L) String string) {
        return this.zzb(string, zzak.zzgt);
    }

    public final long zzao() {
        zzr zzr2 = ((zzgf)this).zzae();
        return 16250L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzbn() {
        if (this.zzed == null) {
            zzs zzs2 = this;
            synchronized (zzs2) {
                if (this.zzed == null) {
                    ApplicationInfo applicationInfo = ((zzgf)this).getContext().getApplicationInfo();
                    String string = ProcessUtils.getMyProcessName();
                    if (applicationInfo != null) {
                        String string2 = applicationInfo.processName;
                        this.zzed = string2 != null && string2.equals(string);
                    }
                    if (this.zzed == null) {
                        this.zzed = Boolean.TRUE;
                        ((zzgf)this).zzab().zzgk().zzao("My process not in the list of running processes");
                    }
                }
            }
        }
        return this.zzed;
    }

    @WorkerThread
    public final long zza(String string, @NonNull zzdu<Long> zzdu2) {
        if (string == null) {
            return zzdu2.get(null);
        }
        String string2 = this.zzec.zzb(string, zzdu2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzdu2.get(null);
        }
        try {
            long l = Long.parseLong(string2);
            return zzdu2.get(l);
        }
        catch (NumberFormatException numberFormatException) {
            return zzdu2.get(null);
        }
    }

    @WorkerThread
    public final int zzb(String string, @NonNull zzdu<Integer> zzdu2) {
        if (string == null) {
            return zzdu2.get(null);
        }
        String string2 = this.zzec.zzb(string, zzdu2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzdu2.get(null);
        }
        try {
            int n = Integer.parseInt(string2);
            return zzdu2.get(n);
        }
        catch (NumberFormatException numberFormatException) {
            return zzdu2.get(null);
        }
    }

    @WorkerThread
    public final double zzc(String string, @NonNull zzdu<Double> zzdu2) {
        if (string == null) {
            return zzdu2.get(null);
        }
        String string2 = this.zzec.zzb(string, zzdu2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzdu2.get(null);
        }
        try {
            double d = Double.parseDouble(string2);
            return zzdu2.get(d);
        }
        catch (NumberFormatException numberFormatException) {
            return zzdu2.get(null);
        }
    }

    @WorkerThread
    public final boolean zzd(String string, @NonNull zzdu<Boolean> zzdu2) {
        if (string == null) {
            return zzdu2.get(null);
        }
        String string2 = this.zzec.zzb(string, zzdu2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzdu2.get(null);
        }
        boolean bl = Boolean.parseBoolean(string2);
        return zzdu2.get(bl);
    }

    public final boolean zze(String string, zzdu<Boolean> zzdu2) {
        return this.zzd(string, zzdu2);
    }

    public final boolean zza(zzdu<Boolean> zzdu2) {
        zzdu<Boolean> zzdu3 = zzdu2;
        return this.zzd(null, zzdu3);
    }

    @Nullable
    @VisibleForTesting
    private final Bundle zzbo() {
        try {
            if (((zzgf)this).getContext().getPackageManager() == null) {
                ((zzgf)this).zzab().zzgk().zzao("Failed to load metadata: PackageManager is null");
                return null;
            }
            ApplicationInfo applicationInfo = Wrappers.packageManager((Context)((zzgf)this).getContext()).getApplicationInfo(((zzgf)this).getContext().getPackageName(), 128);
            if (applicationInfo == null) {
                ((zzgf)this).zzab().zzgk().zzao("Failed to load metadata: ApplicationInfo is null");
                return null;
            }
            return applicationInfo.metaData;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzgf)this).zzab().zzgk().zza("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
            return null;
        }
    }

    @Nullable
    @VisibleForTesting
    final Boolean zzj(@Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        Bundle bundle = this.zzbo();
        if (bundle == null) {
            ((zzgf)this).zzab().zzgk().zzao("Failed to load metadata: Metadata bundle is null");
            return null;
        }
        if (!bundle.containsKey(string)) {
            return null;
        }
        return bundle.getBoolean(string);
    }

    @Nullable
    @VisibleForTesting
    final List<String> zzk(@Size(min=1L) String string) {
        Integer n;
        Integer n2;
        String string2 = string;
        zzs zzs2 = this;
        Preconditions.checkNotEmpty((String)string2);
        Bundle bundle = zzs2.zzbo();
        if (bundle == null) {
            ((zzgf)zzs2).zzab().zzgk().zzao("Failed to load metadata: Metadata bundle is null");
            n2 = null;
        } else {
            n2 = n = !bundle.containsKey(string2) ? null : Integer.valueOf(bundle.getInt(string2));
        }
        if (n2 == null) {
            return null;
        }
        try {
            String[] stringArray = ((zzgf)this).getContext().getResources().getStringArray(n.intValue());
            if (stringArray == null) {
                return null;
            }
            return Arrays.asList(stringArray);
        }
        catch (Resources.NotFoundException notFoundException) {
            ((zzgf)this).zzab().zzgk().zza("Failed to load string array from metadata: resource not found", (Object)notFoundException);
            return null;
        }
    }

    public final boolean zzbp() {
        zzr zzr2 = ((zzgf)this).zzae();
        Boolean bl = this.zzj("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public final Boolean zzbq() {
        zzr zzr2 = ((zzgf)this).zzae();
        return this.zzj("firebase_analytics_collection_enabled");
    }

    public final Boolean zzbr() {
        ((zzgf)this).zzm();
        Boolean bl = this.zzj("google_analytics_adid_collection_enabled");
        return bl == null || bl != false;
    }

    public static long zzbs() {
        return zzak.zzhi.get(null);
    }

    public static long zzbt() {
        return zzak.zzgi.get(null);
    }

    public final String zzbu() {
        try {
            return (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, "debug.firebase.analytics.app", "");
        }
        catch (ClassNotFoundException classNotFoundException) {
            ((zzgf)this).zzab().zzgk().zza("Could not find SystemProperties class", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ((zzgf)this).zzab().zzgk().zza("Could not find SystemProperties.get() method", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ((zzgf)this).zzab().zzgk().zza("Could not access SystemProperties.get()", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ((zzgf)this).zzab().zzgk().zza("SystemProperties.get() threw an exception", invocationTargetException);
        }
        return "";
    }

    public static boolean zzbv() {
        return zzak.zzge.get(null);
    }

    public final boolean zzl(String string) {
        return "1".equals(this.zzec.zzb(string, "gaia_collection_enabled"));
    }

    public final boolean zzm(String string) {
        return "1".equals(this.zzec.zzb(string, "measurement.event_sampling_enabled"));
    }

    @WorkerThread
    final boolean zzn(String string) {
        return this.zzd(string, zzak.zzhs);
    }

    @WorkerThread
    final boolean zzo(String string) {
        return this.zzd(string, zzak.zzhm);
    }

    @WorkerThread
    final String zzp(String string) {
        zzdu<String> zzdu2 = zzak.zzhn;
        String string2 = string;
        zzs zzs2 = this;
        if (string2 == null) {
            return zzdu2.get(null);
        }
        return zzdu2.get(zzs2.zzec.zzb(string2, zzdu2.getKey()));
    }

    final boolean zzq(String string) {
        return this.zzd(string, zzak.zzht);
    }

    @WorkerThread
    final boolean zzr(String string) {
        return this.zzd(string, zzak.zzhu);
    }

    @WorkerThread
    final boolean zzs(String string) {
        return this.zzd(string, zzak.zzhv);
    }

    @WorkerThread
    final boolean zzt(String string) {
        return this.zzd(string, zzak.zzhx);
    }

    @WorkerThread
    final boolean zzbw() {
        if (this.zzeb == null) {
            this.zzeb = this.zzj("app_measurement_lite");
            if (this.zzeb == null) {
                this.zzeb = false;
            }
        }
        return this.zzeb != false || !this.zzj.zzia();
    }

    @WorkerThread
    final boolean zzu(String string) {
        return this.zzd(string, zzak.zzhw);
    }

    @WorkerThread
    static boolean zzbx() {
        return zzak.zzhy.get(null);
    }

    @WorkerThread
    final boolean zzv(String string) {
        return this.zzd(string, zzak.zzhz);
    }

    @WorkerThread
    final boolean zzw(String string) {
        return this.zzd(string, zzak.zzia);
    }

    @WorkerThread
    final boolean zzx(String string) {
        return this.zzd(string, zzak.zzib);
    }

    @WorkerThread
    final boolean zzy(String string) {
        return this.zzd(string, zzak.zzic);
    }

    @WorkerThread
    final boolean zzz(String string) {
        return this.zzd(string, zzak.zzih);
    }
}

