/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzgv;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzgx;
import com.google.android.gms.measurement.internal.zzgy;
import com.google.android.gms.measurement.internal.zzgz;
import com.google.android.gms.measurement.internal.zzha;
import com.google.android.gms.measurement.internal.zzhb;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzhe;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzhg;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzhq;
import com.google.android.gms.measurement.internal.zzhr;
import com.google.android.gms.measurement.internal.zzjn;
import com.google.android.gms.measurement.internal.zzjs;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;

public final class zzgp
extends zzg {
    @VisibleForTesting
    protected zzhj zzpu;
    private zzgk zzpv;
    private final Set<zzgn> zzpw = new CopyOnWriteArraySet<zzgn>();
    private boolean zzpx;
    private final AtomicReference<String> zzpy = new AtomicReference();
    @VisibleForTesting
    protected boolean zzpz = true;

    protected zzgp(zzfj zzfj2) {
        super(zzfj2);
    }

    @Override
    protected final boolean zzbk() {
        return false;
    }

    public final void zzif() {
        if (((zzgf)this).getContext().getApplicationContext() instanceof Application) {
            zzhj zzhj2 = this.zzpu;
            ((Application)((zzgf)this).getContext().getApplicationContext()).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzhj2);
        }
    }

    public final Boolean zzig() {
        AtomicReference atomicReference = new AtomicReference();
        return (Boolean)((zzgf)this).zzaa().zza(atomicReference, 15000L, "boolean test flag value", new zzgo(this, atomicReference));
    }

    public final String zzih() {
        AtomicReference atomicReference = new AtomicReference();
        return (String)((zzgf)this).zzaa().zza(atomicReference, 15000L, "String test flag value", new zzgy(this, atomicReference));
    }

    public final Long zzii() {
        AtomicReference atomicReference = new AtomicReference();
        return (Long)((zzgf)this).zzaa().zza(atomicReference, 15000L, "long test flag value", new zzha(this, atomicReference));
    }

    public final Integer zzij() {
        AtomicReference atomicReference = new AtomicReference();
        return (Integer)((zzgf)this).zzaa().zza(atomicReference, 15000L, "int test flag value", new zzhd(this, atomicReference));
    }

    public final Double zzik() {
        AtomicReference atomicReference = new AtomicReference();
        return (Double)((zzgf)this).zzaa().zza(atomicReference, 15000L, "double test flag value", new zzhc(this, atomicReference));
    }

    public final void setMeasurementEnabled(boolean bl) {
        this.zzbi();
        ((zzgf)this).zzm();
        ((zzgf)this).zzaa().zza(new zzhf(this, bl));
    }

    public final void zza(boolean bl) {
        this.zzbi();
        ((zzgf)this).zzm();
        ((zzgf)this).zzaa().zza(new zzhe(this, bl));
    }

    @WorkerThread
    private final void zzg(boolean bl) {
        ((zzgf)this).zzo();
        ((zzgf)this).zzm();
        this.zzbi();
        ((zzgf)this).zzab().zzgr().zza("Setting app measurement enabled (FE)", bl);
        ((zzgf)this).zzac().setMeasurementEnabled(bl);
        this.zzil();
    }

    @WorkerThread
    private final void zzil() {
        if (((zzgf)this).zzad().zze(((zzd)this).zzr().zzag(), zzak.zzik)) {
            zzgp zzgp2 = this;
            ((zzgf)zzgp2).zzo();
            String string = ((zzgf)zzgp2).zzac().zzlx.zzho();
            if (string != null) {
                if ("unset".equals(string)) {
                    zzgp2.zza("app", "_npa", null, ((zzgf)zzgp2).zzx().currentTimeMillis());
                } else {
                    zzgp2.zza("app", "_npa", (Object)("true".equals(string) ? 1L : 0L), ((zzgf)zzgp2).zzx().currentTimeMillis());
                }
            }
        }
        if (this.zzj.isEnabled() && this.zzpz) {
            ((zzgf)this).zzab().zzgr().zzao("Recording app launch after enabling measurement for the first time (FE)");
            this.zzim();
            return;
        }
        ((zzgf)this).zzab().zzgr().zzao("Updating Scion state (FE)");
        ((zzd)this).zzs().zzip();
    }

    public final void setMinimumSessionDuration(long l) {
        ((zzgf)this).zzm();
        ((zzgf)this).zzaa().zza(new zzhh(this, l));
    }

    public final void setSessionTimeoutDuration(long l) {
        ((zzgf)this).zzm();
        ((zzgf)this).zzaa().zza(new zzhg(this, l));
    }

    public final void zza(String string, String string2, Bundle bundle, boolean bl) {
        this.logEvent(string, string2, bundle, false, true, ((zzgf)this).zzx().currentTimeMillis());
    }

    public final void logEvent(String string, String string2, Bundle bundle) {
        this.logEvent(string, string2, bundle, true, true, ((zzgf)this).zzx().currentTimeMillis());
    }

    @WorkerThread
    final void zza(String string, String string2, Bundle bundle) {
        ((zzgf)this).zzm();
        ((zzgf)this).zzo();
        this.zza(string, string2, ((zzgf)this).zzx().currentTimeMillis(), bundle);
    }

    @WorkerThread
    final void zza(String string, String string2, long l, Bundle bundle) {
        ((zzgf)this).zzm();
        ((zzgf)this).zzo();
        boolean bl = this.zzpv == null || zzjs.zzbq(string2);
        this.zza(string, string2, l, bundle, true, bl, false, null);
    }

    @WorkerThread
    private final void zza(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Class<?> clazz;
        zzgf zzgf2;
        Object object7;
        Preconditions.checkNotEmpty((String)string);
        if (!((zzgf)this).zzad().zze(string3, zzak.zzip)) {
            Preconditions.checkNotEmpty((String)string2);
        }
        Preconditions.checkNotNull((Object)bundle);
        ((zzgf)this).zzo();
        this.zzbi();
        if (!this.zzj.isEnabled()) {
            ((zzgf)this).zzab().zzgr().zzao("Event not sent since app measurement is disabled");
            return;
        }
        if (((zzgf)this).zzad().zze(((zzd)this).zzr().zzag(), zzak.zzix) && (object7 = ((zzd)this).zzr().zzbh()) != null && !object7.contains(string2)) {
            ((zzgf)this).zzab().zzgr().zza("Dropping non-safelisted event. event name, origin", string2, string);
            return;
        }
        if (!this.zzpx) {
            this.zzpx = true;
            zzgf2 = this;
            try {
                clazz = !((zzgp)zzgf2).zzj.zzia() ? Class.forName("com.google.android.gms.tagmanager.TagManagerService", true, zzgf2.getContext().getClassLoader()) : Class.forName("com.google.android.gms.tagmanager.TagManagerService");
                Class<?> clazz2 = clazz;
                object6 = zzgf2;
                try {
                    clazz2.getDeclaredMethod("initialize", Context.class).invoke(null, ((zzgf)object6).getContext());
                }
                catch (Exception exception) {
                    ((zzgf)object6).zzab().zzgn().zza("Failed to invoke Tag Manager's initialize() method", exception);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                zzgf2.zzab().zzgq().zzao("Tag Manager is not found and thus will not be used");
            }
        }
        if (((zzgf)this).zzad().zze(((zzd)this).zzr().zzag(), zzak.zzje) && "_cmp".equals(string2) && bundle.containsKey("gclid")) {
            this.zza("auto", "_lgclid", (Object)bundle.getString("gclid"), ((zzgf)this).zzx().currentTimeMillis());
        }
        if (bl3) {
            object6 = ((zzgf)this).zzae();
            if (!"_iap".equals(string2)) {
                int n;
                clazz = string2;
                zzgf2 = this.zzj.zzz();
                if ((!((zzjs)zzgf2).zzp("event", (String)((Object)clazz)) ? 2 : (!((zzjs)zzgf2).zza("event", zzgj.zzpn, (String)((Object)clazz)) ? 13 : (n = !((zzjs)zzgf2).zza("event", 40, (String)((Object)clazz)) ? 2 : 0))) != 0) {
                    ((zzgf)this).zzab().zzgm().zza("Invalid public event name. Event will not be logged (FE)", ((zzgf)this).zzy().zzaj(string2));
                    this.zzj.zzz();
                    String string4 = zzjs.zza(string2, 40, true);
                    int n2 = string2 != null ? string2.length() : 0;
                    this.zzj.zzz().zza(n, "_ev", string4, n2);
                    return;
                }
            }
        }
        object6 = ((zzgf)this).zzae();
        zzhr zzhr2 = ((zzd)this).zzt().zzin();
        if (zzhr2 != null && !bundle.containsKey("_sc")) {
            zzhr2.zzqx = true;
        }
        object7 = zzhr2;
        zzhq.zza((zzhr)object7, bundle, bl && bl3);
        boolean bl4 = "am".equals(string);
        boolean bl5 = zzjs.zzbq(string2);
        if (bl && this.zzpv != null && !bl5 && !bl4) {
            ((zzgf)this).zzab().zzgr().zza("Passing event to registered event handler (FE)", ((zzgf)this).zzy().zzaj(string2), ((zzgf)this).zzy().zzc(bundle));
            this.zzpv.interceptEvent(string, string2, bundle, l);
            return;
        }
        if (!this.zzj.zzie()) {
            return;
        }
        int n = ((zzgf)this).zzz().zzbl(string2);
        if (n != 0) {
            ((zzgf)this).zzab().zzgm().zza("Invalid event name. Event will not be logged (FE)", ((zzgf)this).zzy().zzaj(string2));
            ((zzgf)this).zzz();
            String string5 = zzjs.zza(string2, 40, true);
            int n3 = string2 != null ? string2.length() : 0;
            this.zzj.zzz().zza(string3, n, "_ev", string5, n3);
            return;
        }
        List list = CollectionUtils.listOf((Object[])new String[]{"_o", "_sn", "_sc", "_si"});
        Bundle bundle3 = ((zzgf)this).zzz().zza(string3, string2, bundle, list, bl3, true);
        zzgf2 = bundle3;
        if (bundle3 == null || !zzgf2.containsKey("_sc") || !zzgf2.containsKey("_si")) {
            object5 = null;
        } else {
            clazz = zzgf2.getString("_sn");
            String string6 = zzgf2.getString("_sc");
            Long l2 = zzgf2.getLong("_si");
            object5 = object4 = new zzhr((String)((Object)clazz), string6, l2);
        }
        if (object5 == null) {
            object4 = object7;
        }
        if (((zzgf)this).zzad().zzz(string3)) {
            long l3;
            object6 = ((zzgf)this).zzae();
            if (((zzd)this).zzt().zzin() != null && "_ae".equals(string2) && (l3 = ((zzd)this).zzv().zzjb()) > 0L) {
                ((zzgf)this).zzz().zzb(bundle3, l3);
            }
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        arrayList.add(bundle3);
        long l4 = ((zzgf)this).zzz().zzjw().nextLong();
        if (((zzgf)this).zzad().zze(((zzd)this).zzr().zzag(), zzak.zzid) && ((zzgf)this).zzac().zzma.get() > 0L && ((zzgf)this).zzac().zzx(l) && ((zzgf)this).zzac().zzmd.get()) {
            ((zzgf)this).zzab().zzgs().zzao("Current session is expired, remove the session number and Id");
            if (((zzgf)this).zzad().zze(((zzd)this).zzr().zzag(), zzak.zzhz)) {
                this.zza("auto", "_sid", null, ((zzgf)this).zzx().currentTimeMillis());
            }
            if (((zzgf)this).zzad().zze(((zzd)this).zzr().zzag(), zzak.zzia)) {
                this.zza("auto", "_sno", null, ((zzgf)this).zzx().currentTimeMillis());
            }
        }
        if (((zzgf)this).zzad().zzy(((zzd)this).zzr().zzag()) && bundle3.getLong("extend_session", 0L) == 1L) {
            ((zzgf)this).zzab().zzgs().zzao("EXTEND_SESSION param attached: initiate a new session or extend the current active session");
            this.zzj.zzv().zza(l, true);
        }
        int n4 = 0;
        Object[] objectArray = bundle3.keySet().toArray(new String[bundle.size()]);
        Arrays.sort(objectArray);
        Object[] objectArray2 = objectArray;
        int n5 = objectArray.length;
        for (int i = 0; i < n5; ++i) {
            object3 = objectArray2[i];
            object2 = bundle3.get((String)object3);
            ((zzgf)this).zzz();
            object = zzjs.zzb(object2);
            if (object == null) continue;
            bundle3.putInt((String)object3, ((Bundle[])object).length);
            for (int j = 0; j < ((Bundle[])object).length; ++j) {
                Bundle bundle4 = object[j];
                zzhq.zza((zzhr)object4, bundle4, true);
                bundle2 = ((zzgf)this).zzz().zza(string3, "_ep", bundle4, list, bl3, false);
                bundle2.putString("_en", string2);
                bundle2.putLong("_eid", l4);
                bundle2.putString("_gn", (String)object3);
                bundle2.putInt("_ll", ((Bundle[])object).length);
                bundle2.putInt("_i", j);
                arrayList.add(bundle2);
            }
            n4 += ((Bundle[])object).length;
        }
        if (n4 != 0) {
            bundle3.putLong("_eid", l4);
            bundle3.putInt("_epc", n4);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Bundle bundle5 = (Bundle)arrayList.get(i);
            object3 = i != 0 ? "_ep" : string2;
            bundle5.putString("_o", string);
            object2 = bl2 ? ((zzgf)this).zzz().zzg(bundle5) : bundle5;
            ((zzgf)this).zzab().zzgr().zza("Logging event (FE)", ((zzgf)this).zzy().zzaj(string2), ((zzgf)this).zzy().zzc((Bundle)object2));
            object = new zzai((String)object3, new zzah((Bundle)object2), string, l);
            ((zzd)this).zzs().zzc((zzai)((Object)object), string3);
            if (bl4) continue;
            for (zzgn zzgn2 : this.zzpw) {
                bundle2 = new Bundle((Bundle)object2);
                zzgn2.onEvent(string, string2, bundle2, l);
            }
        }
        object6 = ((zzgf)this).zzae();
        if (((zzd)this).zzt().zzin() != null && "_ae".equals(string2)) {
            ((zzd)this).zzv().zza(true, true);
        }
    }

    public final void logEvent(String string, String string2, Bundle bundle, boolean bl, boolean bl2, long l) {
        ((zzgf)this).zzm();
        if (string == null) {
            string = "app";
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        boolean bl3 = !bl2 || this.zzpv == null || zzjs.zzbq(string2);
        this.zzb(string, string2, l, bundle, bl2, bl3, !bl, null);
    }

    private final void zzb(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2 = zzjs.zzh(bundle);
        ((zzgf)this).zzaa().zza(new zzgr(this, string, string2, l, bundle2, bl, bl2, bl3, string3));
    }

    public final void zzb(String string, String string2, Object object, boolean bl) {
        this.zza(string, string2, object, bl, ((zzgf)this).zzx().currentTimeMillis());
    }

    public final void zza(String string, String string2, Object object, boolean bl, long l) {
        int n;
        int n2;
        if (string == null) {
            string = "app";
        }
        if (bl) {
            n2 = ((zzgf)this).zzz().zzbm(string2);
        } else {
            String string3 = string2;
            zzjs zzjs2 = ((zzgf)this).zzz();
            n2 = !zzjs2.zzp("user property", string3) ? 6 : (!zzjs2.zza("user property", zzgl.zzpp, string3) ? 15 : (n = !zzjs2.zza("user property", 24, string3) ? 6 : 0));
        }
        if (n2 != 0) {
            ((zzgf)this).zzz();
            String string4 = zzjs.zza(string2, 24, true);
            int n3 = string2 != null ? string2.length() : 0;
            this.zzj.zzz().zza(n, "_ev", string4, n3);
            return;
        }
        if (object != null) {
            n = ((zzgf)this).zzz().zzc(string2, object);
            if (n != 0) {
                ((zzgf)this).zzz();
                String string5 = zzjs.zza(string2, 24, true);
                int n4 = 0;
                if (object instanceof String || object instanceof CharSequence) {
                    n4 = String.valueOf(object).length();
                }
                this.zzj.zzz().zza(n, "_ev", string5, n4);
                return;
            }
            Object object2 = ((zzgf)this).zzz().zzd(string2, object);
            if (object2 != null) {
                this.zza(string, string2, l, object2);
            }
            return;
        }
        this.zza(string, string2, l, (Object)null);
    }

    private final void zza(String string, String string2, long l, Object object) {
        ((zzgf)this).zzaa().zza(new zzgq(this, string, string2, object, l));
    }

    @WorkerThread
    final void zza(String string, String string2, Object object, long l) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ((zzgf)this).zzo();
        ((zzgf)this).zzm();
        this.zzbi();
        if (((zzgf)this).zzad().zze(((zzd)this).zzr().zzag(), zzak.zzik) && "allow_personalized_ads".equals(string2)) {
            if (object instanceof String && !TextUtils.isEmpty((CharSequence)((String)object))) {
                object = "false".equals(((String)object).toLowerCase(Locale.ENGLISH)) ? 1L : 0L;
                string2 = "_npa";
                ((zzgf)this).zzac().zzlx.zzau((Long)object == 1L ? "true" : "false");
            } else if (object == null) {
                string2 = "_npa";
                ((zzgf)this).zzac().zzlx.zzau("unset");
            }
        }
        if (!this.zzj.isEnabled()) {
            ((zzgf)this).zzab().zzgr().zzao("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzj.zzie()) {
            return;
        }
        ((zzgf)this).zzab().zzgr().zza("Setting user property (FE)", ((zzgf)this).zzy().zzaj(string2), object);
        zzjn zzjn2 = new zzjn(string2, l, object, string);
        ((zzd)this).zzs().zzb(zzjn2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<zzjn> zzh(boolean bl) {
        ((zzgf)this).zzm();
        this.zzbi();
        ((zzgf)this).zzab().zzgr().zzao("Fetching user attributes (FE)");
        if (((zzgf)this).zzaa().zzhp()) {
            ((zzgf)this).zzab().zzgk().zzao("Cannot get all user properties from analytics worker thread");
            return Collections.emptyList();
        }
        if (zzr.isMainThread()) {
            ((zzgf)this).zzab().zzgk().zzao("Cannot get all user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzj.zzaa().zza(new zzgt(this, atomicReference, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzgf)this).zzab().zzgn().zza("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzgf)this).zzab().zzgn().zzao("Timed out waiting for get user properties");
                return Collections.emptyList();
            }
            return object;
        }
    }

    @Nullable
    public final String zzi() {
        ((zzgf)this).zzm();
        return this.zzpy.get();
    }

    @Nullable
    public final String zzy(long l) {
        if (((zzgf)this).zzaa().zzhp()) {
            ((zzgf)this).zzab().zzgk().zzao("Cannot retrieve app instance id from analytics worker thread");
            return null;
        }
        if (zzr.isMainThread()) {
            ((zzgf)this).zzab().zzgk().zzao("Cannot retrieve app instance id from main thread");
            return null;
        }
        long l2 = ((zzgf)this).zzx().elapsedRealtime();
        String string = this.zzz(120000L);
        long l3 = ((zzgf)this).zzx().elapsedRealtime() - l2;
        if (string == null && l3 < 120000L) {
            string = this.zzz(120000L - l3);
        }
        return string;
    }

    final void zzbg(@Nullable String string) {
        this.zzpy.set(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private final String zzz(long l) {
        AtomicReference atomicReference;
        AtomicReference atomicReference2 = atomicReference = new AtomicReference();
        synchronized (atomicReference) {
            ((zzgf)this).zzaa().zza(new zzgs(this, atomicReference));
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                ((zzgf)this).zzab().zzgn().zzao("Interrupted waiting for app instance id");
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return null;
            }
            return (String)atomicReference.get();
        }
    }

    public final void resetAnalyticsData(long l) {
        this.zzbg(null);
        ((zzgf)this).zzaa().zza(new zzgv(this, l));
    }

    @WorkerThread
    public final void zzim() {
        ((zzgf)this).zzo();
        ((zzgf)this).zzm();
        this.zzbi();
        if (!this.zzj.zzie()) {
            return;
        }
        ((zzd)this).zzs().zzim();
        this.zzpz = false;
        String string = ((zzgf)this).zzac().zzhh();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            ((zzgf)this).zzw().zzbi();
            if (!string.equals(Build.VERSION.RELEASE)) {
                Bundle bundle = new Bundle();
                bundle.putString("_po", string);
                this.logEvent("auto", "_ou", bundle);
            }
        }
    }

    @WorkerThread
    public final void zza(zzgk zzgk2) {
        ((zzgf)this).zzo();
        ((zzgf)this).zzm();
        this.zzbi();
        if (zzgk2 != null && zzgk2 != this.zzpv) {
            Preconditions.checkState((this.zzpv == null ? 1 : 0) != 0, (Object)"EventInterceptor already set.");
        }
        this.zzpv = zzgk2;
    }

    public final void zza(zzgn zzgn2) {
        ((zzgf)this).zzm();
        this.zzbi();
        Preconditions.checkNotNull((Object)zzgn2);
        if (!this.zzpw.add(zzgn2)) {
            ((zzgf)this).zzab().zzgn().zzao("OnEventListener already registered");
        }
    }

    public final void zzb(zzgn zzgn2) {
        ((zzgf)this).zzm();
        this.zzbi();
        Preconditions.checkNotNull((Object)zzgn2);
        if (!this.zzpw.remove(zzgn2)) {
            ((zzgf)this).zzab().zzgn().zzao("OnEventListener had not been registered");
        }
    }

    public final void setConditionalUserProperty(Bundle bundle) {
        this.setConditionalUserProperty(bundle, ((zzgf)this).zzx().currentTimeMillis());
    }

    public final void setConditionalUserProperty(Bundle bundle, long l) {
        Preconditions.checkNotNull((Object)bundle);
        ((zzgf)this).zzm();
        Bundle bundle2 = new Bundle(bundle);
        if (!TextUtils.isEmpty((CharSequence)bundle2.getString("app_id"))) {
            ((zzgf)this).zzab().zzgn().zzao("Package name should be null when calling setConditionalUserProperty");
        }
        bundle2.remove("app_id");
        this.zza(bundle2, l);
    }

    public final void zzd(Bundle bundle) {
        Preconditions.checkNotNull((Object)bundle);
        Preconditions.checkNotEmpty((String)bundle.getString("app_id"));
        ((zzgf)this).zzl();
        this.zza(new Bundle(bundle), ((zzgf)this).zzx().currentTimeMillis());
    }

    private final void zza(Bundle bundle, long l) {
        Preconditions.checkNotNull((Object)bundle);
        Bundle bundle2 = bundle;
        zzgg.zza((Bundle)bundle2, (String)"app_id", String.class, null);
        zzgg.zza((Bundle)bundle2, (String)"origin", String.class, null);
        zzgg.zza((Bundle)bundle2, (String)"name", String.class, null);
        zzgg.zza((Bundle)bundle2, (String)"value", Object.class, null);
        zzgg.zza((Bundle)bundle2, (String)"trigger_event_name", String.class, null);
        zzgg.zza((Bundle)bundle2, (String)"trigger_timeout", Long.class, (Object)0L);
        zzgg.zza((Bundle)bundle2, (String)"timed_out_event_name", String.class, null);
        zzgg.zza((Bundle)bundle2, (String)"timed_out_event_params", Bundle.class, null);
        zzgg.zza((Bundle)bundle2, (String)"triggered_event_name", String.class, null);
        zzgg.zza((Bundle)bundle2, (String)"triggered_event_params", Bundle.class, null);
        zzgg.zza((Bundle)bundle2, (String)"time_to_live", Long.class, (Object)0L);
        zzgg.zza((Bundle)bundle2, (String)"expired_event_name", String.class, null);
        zzgg.zza((Bundle)bundle2, (String)"expired_event_params", Bundle.class, null);
        Preconditions.checkNotEmpty((String)bundle.getString("name"));
        Preconditions.checkNotEmpty((String)bundle.getString("origin"));
        Preconditions.checkNotNull((Object)bundle.get("value"));
        bundle.putLong("creation_timestamp", l);
        String string = bundle.getString("name");
        Object object = bundle.get("value");
        if (((zzgf)this).zzz().zzbm(string) != 0) {
            ((zzgf)this).zzab().zzgk().zza("Invalid conditional user property name", ((zzgf)this).zzy().zzal(string));
            return;
        }
        if (((zzgf)this).zzz().zzc(string, object) != 0) {
            ((zzgf)this).zzab().zzgk().zza("Invalid conditional user property value", ((zzgf)this).zzy().zzal(string), object);
            return;
        }
        Object object2 = ((zzgf)this).zzz().zzd(string, object);
        if (object2 == null) {
            ((zzgf)this).zzab().zzgk().zza("Unable to normalize conditional user property value", ((zzgf)this).zzy().zzal(string), object);
            return;
        }
        zzgg.zza((Bundle)bundle, (Object)object2);
        long l2 = bundle.getLong("trigger_timeout");
        if (!(TextUtils.isEmpty((CharSequence)bundle.getString("trigger_event_name")) || l2 <= 15552000000L && l2 >= 1L)) {
            ((zzgf)this).zzab().zzgk().zza("Invalid conditional user property timeout", ((zzgf)this).zzy().zzal(string), l2);
            return;
        }
        long l3 = bundle.getLong("time_to_live");
        if (l3 > 15552000000L || l3 < 1L) {
            ((zzgf)this).zzab().zzgk().zza("Invalid conditional user property time to live", ((zzgf)this).zzy().zzal(string), l3);
            return;
        }
        ((zzgf)this).zzaa().zza(new zzgx(this, bundle));
    }

    public final void clearConditionalUserProperty(String string, String string2, Bundle bundle) {
        ((zzgf)this).zzm();
        this.zza(null, string, string2, bundle);
    }

    public final void clearConditionalUserPropertyAs(String string, String string2, String string3, Bundle bundle) {
        Preconditions.checkNotEmpty((String)string);
        ((zzgf)this).zzl();
        this.zza(string, string2, string3, bundle);
    }

    private final void zza(String string, String string2, String string3, Bundle bundle) {
        long l = ((zzgf)this).zzx().currentTimeMillis();
        Preconditions.checkNotEmpty((String)string2);
        Bundle bundle2 = new Bundle();
        if (string != null) {
            bundle2.putString("app_id", string);
        }
        bundle2.putString("name", string2);
        bundle2.putLong("creation_timestamp", l);
        if (string3 != null) {
            bundle2.putString("expired_event_name", string3);
            bundle2.putBundle("expired_event_params", bundle);
        }
        ((zzgf)this).zzaa().zza(new zzgw(this, bundle2));
    }

    @WorkerThread
    private final void zze(Bundle bundle) {
        zzai zzai2;
        zzai zzai3;
        zzai zzai4;
        ((zzgf)this).zzo();
        this.zzbi();
        Preconditions.checkNotNull((Object)bundle);
        Preconditions.checkNotEmpty((String)bundle.getString("name"));
        Preconditions.checkNotEmpty((String)bundle.getString("origin"));
        Preconditions.checkNotNull((Object)bundle.get("value"));
        if (!this.zzj.isEnabled()) {
            ((zzgf)this).zzab().zzgr().zzao("Conditional property not sent since collection is disabled");
            return;
        }
        zzjn zzjn2 = new zzjn(bundle.getString("name"), bundle.getLong("triggered_timestamp"), bundle.get("value"), bundle.getString("origin"));
        try {
            zzai4 = ((zzgf)this).zzz().zza(bundle.getString("app_id"), bundle.getString("triggered_event_name"), bundle.getBundle("triggered_event_params"), bundle.getString("origin"), 0L, true, false);
            zzai3 = ((zzgf)this).zzz().zza(bundle.getString("app_id"), bundle.getString("timed_out_event_name"), bundle.getBundle("timed_out_event_params"), bundle.getString("origin"), 0L, true, false);
            zzai2 = ((zzgf)this).zzz().zza(bundle.getString("app_id"), bundle.getString("expired_event_name"), bundle.getBundle("expired_event_params"), bundle.getString("origin"), 0L, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzq zzq2 = new zzq(bundle.getString("app_id"), bundle.getString("origin"), zzjn2, bundle.getLong("creation_timestamp"), false, bundle.getString("trigger_event_name"), zzai3, bundle.getLong("trigger_timeout"), zzai4, bundle.getLong("time_to_live"), zzai2);
        ((zzd)this).zzs().zzd(zzq2);
    }

    @WorkerThread
    private final void zzf(Bundle bundle) {
        zzai zzai2;
        ((zzgf)this).zzo();
        this.zzbi();
        Preconditions.checkNotNull((Object)bundle);
        Preconditions.checkNotEmpty((String)bundle.getString("name"));
        if (!this.zzj.isEnabled()) {
            ((zzgf)this).zzab().zzgr().zzao("Conditional property not cleared since collection is disabled");
            return;
        }
        zzjn zzjn2 = new zzjn(bundle.getString("name"), 0L, null, null);
        try {
            zzai2 = ((zzgf)this).zzz().zza(bundle.getString("app_id"), bundle.getString("expired_event_name"), bundle.getBundle("expired_event_params"), bundle.getString("origin"), bundle.getLong("creation_timestamp"), true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzq zzq2 = new zzq(bundle.getString("app_id"), bundle.getString("origin"), zzjn2, bundle.getLong("creation_timestamp"), bundle.getBoolean("active"), bundle.getString("trigger_event_name"), null, bundle.getLong("trigger_timeout"), null, bundle.getLong("time_to_live"), zzai2);
        ((zzd)this).zzs().zzd(zzq2);
    }

    public final ArrayList<Bundle> zzn(String string, String string2) {
        ((zzgf)this).zzm();
        return this.zze(null, string, string2);
    }

    public final ArrayList<Bundle> zzd(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        ((zzgf)this).zzl();
        return this.zze(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final ArrayList<Bundle> zze(String string, String string2, String string3) {
        if (((zzgf)this).zzaa().zzhp()) {
            ((zzgf)this).zzab().zzgk().zzao("Cannot get conditional user properties from analytics worker thread");
            return new ArrayList<Bundle>(0);
        }
        if (zzr.isMainThread()) {
            ((zzgf)this).zzab().zzgk().zzao("Cannot get conditional user properties from main thread");
            return new ArrayList<Bundle>(0);
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzj.zzaa().zza(new zzgz(this, atomicReference, string, string2, string3));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzgf)this).zzab().zzgn().zza("Interrupted waiting for get conditional user properties", string, interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzgf)this).zzab().zzgn().zza("Timed out waiting for get conditional user properties", string);
                return new ArrayList<Bundle>();
            }
            return zzjs.zzd((List<zzq>)object);
        }
    }

    public final Map<String, Object> getUserProperties(String string, String string2, boolean bl) {
        ((zzgf)this).zzm();
        return this.zzb(null, string, string2, bl);
    }

    public final Map<String, Object> getUserPropertiesAs(String string, String string2, String string3, boolean bl) {
        Preconditions.checkNotEmpty((String)string);
        ((zzgf)this).zzl();
        return this.zzb(string, string2, string3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final Map<String, Object> zzb(String string, String string2, String string3, boolean bl) {
        if (((zzgf)this).zzaa().zzhp()) {
            ((zzgf)this).zzab().zzgk().zzao("Cannot get user properties from analytics worker thread");
            return Collections.emptyMap();
        }
        if (zzr.isMainThread()) {
            ((zzgf)this).zzab().zzgk().zzao("Cannot get user properties from main thread");
            return Collections.emptyMap();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzj.zzaa().zza(new zzhb(this, atomicReference, string, string2, string3, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzgf)this).zzab().zzgn().zza("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzgf)this).zzab().zzgn().zzao("Timed out waiting for get user properties");
                return Collections.emptyMap();
            }
            ArrayMap arrayMap = new ArrayMap(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzjn zzjn2 = (zzjn)((Object)iterator.next());
                arrayMap.put(zzjn2.name, zzjn2.getValue());
            }
            return arrayMap;
        }
    }

    @Nullable
    public final String getCurrentScreenName() {
        zzhr zzhr2 = this.zzj.zzt().zzio();
        if (zzhr2 != null) {
            return zzhr2.zzqu;
        }
        return null;
    }

    @Nullable
    public final String getCurrentScreenClass() {
        zzhr zzhr2 = this.zzj.zzt().zzio();
        if (zzhr2 != null) {
            return zzhr2.zzqv;
        }
        return null;
    }

    @Nullable
    public final String getGmpAppId() {
        if (this.zzj.zzhx() != null) {
            return this.zzj.zzhx();
        }
        try {
            return GoogleServices.getGoogleAppId();
        }
        catch (IllegalStateException illegalStateException) {
            this.zzj.zzab().zzgk().zza("getGoogleAppId failed with exception", illegalStateException);
            return null;
        }
    }

    static /* synthetic */ void zza(zzgp zzgp2, boolean bl) {
        zzgp2.zzg(bl);
    }

    static /* synthetic */ void zza(zzgp zzgp2) {
        zzgp2.zzil();
    }

    static /* synthetic */ void zza(zzgp zzgp2, String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        zzgp2.zza(string, string2, l, bundle, bl, bl2, bl3, string3);
    }

    static /* synthetic */ void zza(zzgp zzgp2, Bundle bundle) {
        zzgp2.zze(bundle);
    }

    static /* synthetic */ void zzb(zzgp zzgp2, Bundle bundle) {
        zzgp2.zzf(bundle);
    }
}

