/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzdj;
import com.google.android.gms.internal.measurement.zzez;
import com.google.android.gms.internal.measurement.zzff;
import com.google.android.gms.internal.measurement.zzfg;
import com.google.android.gms.internal.measurement.zzgu;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzfw
extends zzdj<Long>
implements zzfg,
zzgu,
RandomAccess {
    private static final zzfw zzajy = new zzfw(new long[0], 0);
    private long[] zzajz;
    private int size;

    public static zzfw zzvk() {
        return zzajy;
    }

    zzfw() {
        this(new long[10], 0);
    }

    private zzfw(long[] lArray, int n) {
        this.zzajz = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzrz();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzajz, n2, this.zzajz, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzfw)) {
            return super.equals(object);
        }
        zzfw zzfw2 = (zzfw)object;
        if (this.size != zzfw2.size) {
            return false;
        }
        long[] lArray = zzfw2.zzajz;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzajz[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzez.zzbx(this.zzajz[i]);
        }
        return n;
    }

    @Override
    public final zzfg zzbv(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException();
        }
        return new zzfw(Arrays.copyOf(this.zzajz, n), this.size);
    }

    @Override
    public final long getLong(int n) {
        this.zzan(n);
        return this.zzajz[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final void zzby(long l) {
        this.zzk(this.size, l);
    }

    private final void zzk(int n, long l) {
        this.zzrz();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzao(n));
        }
        if (this.size < this.zzajz.length) {
            System.arraycopy(this.zzajz, n, this.zzajz, n + 1, this.size - n);
        } else {
            long[] lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzajz, 0, lArray, 0, n);
            System.arraycopy(this.zzajz, n, lArray, n + 1, this.size - n);
            this.zzajz = lArray;
        }
        this.zzajz[n] = l;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzrz();
        zzez.checkNotNull(collection);
        if (!(collection instanceof zzfw)) {
            return super.addAll(collection);
        }
        zzfw zzfw2 = (zzfw)collection;
        if (zzfw2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzfw2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzfw2.size;
        if (n > this.zzajz.length) {
            this.zzajz = Arrays.copyOf(this.zzajz, n);
        }
        System.arraycopy(zzfw2.zzajz, 0, this.zzajz, this.size, zzfw2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzrz();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzajz[i])) continue;
            System.arraycopy(this.zzajz, i + 1, this.zzajz, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzan(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzao(n));
        }
    }

    private final String zzao(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzfw zzfw2 = this;
        zzfw2.zzrz();
        zzfw2.zzan(n);
        long l3 = zzfw2.zzajz[n];
        zzfw2.zzajz[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzfw zzfw2 = this;
        zzfw2.zzrz();
        zzfw2.zzan(n);
        long l = zzfw2.zzajz[n];
        if (n < zzfw2.size - 1) {
            System.arraycopy(zzfw2.zzajz, n + 1, zzfw2.zzajz, n, zzfw2.size - n - 1);
        }
        --zzfw2.size;
        ++zzfw2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        this.zzk(n, l);
    }

    @Override
    public final /* synthetic */ zzff zzap(int n) {
        return this.zzbv(n);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzajy.zzry();
    }
}

