/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.os.Bundle;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zzby;
import com.google.android.gms.measurement.internal.zzc;
import com.google.android.gms.measurement.internal.zzct;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzec;
import com.google.android.gms.measurement.internal.zzed;
import java.util.Map;

public final class zza
extends zze {
    private final Map<String, Long> zzby;
    private final Map<String, Integer> zzbz = new ArrayMap();
    private long zzca;

    public zza(zzby zzby2) {
        super(zzby2);
        this.zzby = new ArrayMap();
    }

    public final void beginAdUnitExposure(String string, long l) {
        if (string == null || string.length() == 0) {
            ((zzct)this).zzad().zzda().zzaq("Ad unit id must be a non-empty string");
            return;
        }
        ((zzct)this).zzac().zza(new zzb(this, string, l));
    }

    @WorkerThread
    private final void zza(String string, long l) {
        Integer n;
        ((zzct)this).zzo();
        ((zzct)this).zzq();
        Preconditions.checkNotEmpty((String)string);
        if (this.zzbz.isEmpty()) {
            this.zzca = l;
        }
        if ((n = this.zzbz.get(string)) != null) {
            this.zzbz.put(string, n + 1);
            return;
        }
        if (this.zzbz.size() >= 100) {
            ((zzct)this).zzad().zzdd().zzaq("Too many ads visible");
            return;
        }
        this.zzbz.put(string, 1);
        this.zzby.put(string, l);
    }

    public final void endAdUnitExposure(String string, long l) {
        if (string == null || string.length() == 0) {
            ((zzct)this).zzad().zzda().zzaq("Ad unit id must be a non-empty string");
            return;
        }
        ((zzct)this).zzac().zza(new zzc(this, string, l));
    }

    @WorkerThread
    private final void zzb(String string, long l) {
        ((zzct)this).zzo();
        ((zzct)this).zzq();
        Preconditions.checkNotEmpty((String)string);
        Integer n = this.zzbz.get(string);
        if (n != null) {
            zzec zzec2 = ((zze)this).zzv().zzfc();
            int n2 = n - 1;
            if (n2 == 0) {
                this.zzbz.remove(string);
                Long l2 = this.zzby.get(string);
                if (l2 == null) {
                    ((zzct)this).zzad().zzda().zzaq("First ad unit exposure time was never set");
                } else {
                    long l3 = l - l2;
                    this.zzby.remove(string);
                    this.zza(string, l3, zzec2);
                }
                if (this.zzbz.isEmpty()) {
                    if (this.zzca == 0L) {
                        ((zzct)this).zzad().zzda().zzaq("First ad exposure time was never set");
                        return;
                    }
                    this.zza(l - this.zzca, zzec2);
                    this.zzca = 0L;
                }
                return;
            }
            this.zzbz.put(string, n2);
            return;
        }
        ((zzct)this).zzad().zzda().zza("Call to endAdUnitExposure for unknown ad unit id", string);
    }

    @WorkerThread
    private final void zza(long l, zzec zzec2) {
        if (zzec2 == null) {
            ((zzct)this).zzad().zzdi().zzaq("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzct)this).zzad().zzdi().zza("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zzed.zza(zzec2, bundle, true);
        ((zze)this).zzs().logEvent("am", "_xa", bundle);
    }

    @WorkerThread
    private final void zza(String string, long l, zzec zzec2) {
        if (zzec2 == null) {
            ((zzct)this).zzad().zzdi().zzaq("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzct)this).zzad().zzdi().zza("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zzed.zza(zzec2, bundle, true);
        ((zze)this).zzs().logEvent("am", "_xu", bundle);
    }

    @WorkerThread
    public final void zzc(long l) {
        zzec zzec2 = ((zze)this).zzv().zzfc();
        for (String string : this.zzby.keySet()) {
            long l2 = this.zzby.get(string);
            this.zza(string, l - l2, zzec2);
        }
        if (!this.zzby.isEmpty()) {
            this.zza(l - this.zzca, zzec2);
        }
        this.zzd(l);
    }

    @WorkerThread
    private final void zzd(long l) {
        for (String string : this.zzby.keySet()) {
            this.zzby.put(string, l);
        }
        if (!this.zzby.isEmpty()) {
            this.zzca = l;
        }
    }

    static /* synthetic */ void zza(zza zza2, String string, long l) {
        zza2.zza(string, l);
    }

    static /* synthetic */ void zzb(zza zza2, String string, long l) {
        zza2.zzb(string, l);
    }

    static /* synthetic */ void zza(zza zza2, long l) {
        zza2.zzd(l);
    }
}

