/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzby;
import com.google.android.gms.measurement.internal.zzcw;
import com.google.android.gms.measurement.internal.zzcx;
import com.google.android.gms.measurement.internal.zzcy;
import com.google.android.gms.measurement.internal.zzcz;
import com.google.android.gms.measurement.internal.zzda;
import com.google.android.gms.measurement.internal.zzdb;
import com.google.android.gms.measurement.internal.zzdy;
import com.google.android.gms.measurement.internal.zzeb;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.zza;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Deprecated
@ShowFirstParty
public class AppMeasurement {
    @ShowFirstParty
    @KeepForSdk
    public static final String CRASH_ORIGIN = "crash";
    @ShowFirstParty
    @KeepForSdk
    public static final String FCM_ORIGIN = "fcm";
    @ShowFirstParty
    @KeepForSdk
    public static final String FIAM_ORIGIN = "fiam";
    private static volatile AppMeasurement zzk;
    private final zzby zzl;
    private final zzdy zzm;
    private final boolean zzn;

    @Deprecated
    @ShowFirstParty
    @Keep
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    public static AppMeasurement getInstance(Context context) {
        return AppMeasurement.zza(context, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    private static AppMeasurement zza(Context context, String string, String string2) {
        if (zzk != null) return zzk;
        Class<AppMeasurement> clazz = AppMeasurement.class;
        synchronized (AppMeasurement.class) {
            if (zzk != null) return zzk;
            zzdy zzdy2 = AppMeasurement.zzb(context, null);
            if (zzdy2 != null) {
                zzk = new AppMeasurement(zzdy2);
            } else {
                zzby zzby2 = zzby.zza(context, null, null, null);
                zzk = new AppMeasurement(zzby2);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return zzk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AppMeasurement zza(Context context, Bundle bundle) {
        if (zzk != null) return zzk;
        Class<AppMeasurement> clazz = AppMeasurement.class;
        synchronized (AppMeasurement.class) {
            if (zzk != null) return zzk;
            zzdy zzdy2 = AppMeasurement.zzb(context, bundle);
            if (zzdy2 != null) {
                zzk = new AppMeasurement(zzdy2);
            } else {
                zzby zzby2 = zzby.zza(context, null, null, bundle);
                zzk = new AppMeasurement(zzby2);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return zzk;
        }
    }

    private static zzdy zzb(Context context, Bundle bundle) {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.google.firebase.analytics.FirebaseAnalytics");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        try {
            return (zzdy)clazz.getDeclaredMethod("getScionFrontendApiImplementation", Context.class, Bundle.class).invoke(null, context, bundle);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Deprecated
    @KeepForSdk
    public void setMeasurementEnabled(boolean bl) {
        if (this.zzn) {
            this.zzm.setMeasurementEnabled(bl);
            return;
        }
        this.zzl.zzs().setMeasurementEnabled(bl);
    }

    public final void zza(boolean bl) {
        if (this.zzn) {
            this.zzm.setDataCollectionEnabled(bl);
            return;
        }
        this.zzl.zzs().zza(bl);
    }

    private AppMeasurement(zzby zzby2) {
        Preconditions.checkNotNull((Object)zzby2);
        this.zzl = zzby2;
        this.zzm = null;
        this.zzn = false;
    }

    private AppMeasurement(zzdy zzdy2) {
        Preconditions.checkNotNull((Object)zzdy2);
        this.zzm = zzdy2;
        this.zzl = null;
        this.zzn = true;
    }

    @ShowFirstParty
    @Keep
    public void logEventInternal(String string, String string2, Bundle bundle) {
        if (this.zzn) {
            this.zzm.logEventInternal(string, string2, bundle);
            return;
        }
        this.zzl.zzs().logEvent(string, string2, bundle);
    }

    @ShowFirstParty
    @KeepForSdk
    public void logEventInternalNoInterceptor(String string, String string2, Bundle bundle, long l) {
        if (this.zzn) {
            this.zzm.logEventInternalNoInterceptor(string, string2, bundle, l);
            return;
        }
        Bundle bundle2 = bundle;
        String string3 = string2;
        String string4 = string;
        this.zzl.zzs().logEvent(string4, string3, bundle2, true, false, l);
    }

    @ShowFirstParty
    @KeepForSdk
    public void setUserPropertyInternal(String string, String string2, Object object) {
        Preconditions.checkNotEmpty((String)string);
        if (this.zzn) {
            this.zzm.setUserPropertyInternal(string, string2, object);
            return;
        }
        this.zzl.zzs().zzb(string, string2, object, true);
    }

    @WorkerThread
    @ShowFirstParty
    @KeepForSdk
    public Map<String, Object> getUserProperties(boolean bl) {
        if (this.zzn) {
            return this.zzm.getUserProperties(null, null, bl);
        }
        List<zzga> list = this.zzl.zzs().zzh(bl);
        ArrayMap arrayMap = new ArrayMap(list.size());
        for (zzga zzga2 : list) {
            arrayMap.put(zzga2.name, zzga2.getValue());
        }
        return arrayMap;
    }

    @WorkerThread
    @ShowFirstParty
    @KeepForSdk
    public void setEventInterceptor(EventInterceptor eventInterceptor) {
        if (this.zzn) {
            this.zzm.zza(eventInterceptor);
            return;
        }
        this.zzl.zzs().zza(eventInterceptor);
    }

    @ShowFirstParty
    @KeepForSdk
    public void registerOnMeasurementEventListener(OnEventListener onEventListener) {
        if (this.zzn) {
            this.zzm.zza(onEventListener);
            return;
        }
        this.zzl.zzs().zza(onEventListener);
    }

    @ShowFirstParty
    @KeepForSdk
    public void unregisterOnMeasurementEventListener(OnEventListener onEventListener) {
        if (this.zzn) {
            this.zzm.zzb(onEventListener);
            return;
        }
        this.zzl.zzs().zzb(onEventListener);
    }

    @Nullable
    @Keep
    public String getCurrentScreenName() {
        if (this.zzn) {
            return this.zzm.getCurrentScreenName();
        }
        return this.zzl.zzs().getCurrentScreenName();
    }

    @Nullable
    @Keep
    public String getCurrentScreenClass() {
        if (this.zzn) {
            return this.zzm.getCurrentScreenClass();
        }
        return this.zzl.zzs().getCurrentScreenClass();
    }

    @Nullable
    @Keep
    public String getAppInstanceId() {
        if (this.zzn) {
            return this.zzm.zzj();
        }
        return this.zzl.zzs().zzj();
    }

    @Nullable
    @Keep
    public String getGmpAppId() {
        if (this.zzn) {
            return this.zzm.getGmpAppId();
        }
        return this.zzl.zzs().getGmpAppId();
    }

    @Keep
    public long generateEventId() {
        if (this.zzn) {
            return this.zzm.generateEventId();
        }
        return this.zzl.zzab().zzgk();
    }

    @Keep
    public void beginAdUnitExposure(@NonNull @Size(min=1L) String string) {
        if (this.zzn) {
            this.zzm.beginAdUnitExposure(string);
            return;
        }
        this.zzl.zzr().beginAdUnitExposure(string, this.zzl.zzz().elapsedRealtime());
    }

    @Keep
    public void endAdUnitExposure(@NonNull @Size(min=1L) String string) {
        if (this.zzn) {
            this.zzm.endAdUnitExposure(string);
            return;
        }
        this.zzl.zzr().endAdUnitExposure(string, this.zzl.zzz().elapsedRealtime());
    }

    @Keep
    @ShowFirstParty
    @KeepForSdk
    public void setConditionalUserProperty(@NonNull ConditionalUserProperty conditionalUserProperty) {
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        if (this.zzn) {
            this.zzm.setConditionalUserProperty(conditionalUserProperty.zzf());
            return;
        }
        this.zzl.zzs().setConditionalUserProperty(conditionalUserProperty.zzf());
    }

    @Keep
    @VisibleForTesting
    protected void setConditionalUserPropertyAs(@NonNull ConditionalUserProperty conditionalUserProperty) {
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        if (this.zzn) {
            throw new IllegalStateException("Unexpected call on client side");
        }
        this.zzl.zzs().zzd(conditionalUserProperty.zzf());
    }

    @Keep
    @ShowFirstParty
    @KeepForSdk
    public void clearConditionalUserProperty(@NonNull @Size(min=1L, max=24L) String string, @Nullable String string2, @Nullable Bundle bundle) {
        if (this.zzn) {
            this.zzm.clearConditionalUserProperty(string, string2, bundle);
            return;
        }
        this.zzl.zzs().clearConditionalUserProperty(string, string2, bundle);
    }

    @Keep
    @VisibleForTesting
    protected void clearConditionalUserPropertyAs(@NonNull @Size(min=1L) String string, @NonNull @Size(min=1L, max=24L) String string2, @Nullable String string3, @Nullable Bundle bundle) {
        if (this.zzn) {
            throw new IllegalStateException("Unexpected call on client side");
        }
        this.zzl.zzs().clearConditionalUserPropertyAs(string, string2, string3, bundle);
    }

    @WorkerThread
    @Keep
    @VisibleForTesting
    protected Map<String, Object> getUserProperties(@Nullable String string, @Nullable @Size(min=1L, max=24L) String string2, boolean bl) {
        if (this.zzn) {
            return this.zzm.getUserProperties(string, string2, bl);
        }
        return this.zzl.zzs().getUserProperties(string, string2, bl);
    }

    @WorkerThread
    @Keep
    @VisibleForTesting
    protected Map<String, Object> getUserPropertiesAs(@NonNull @Size(min=1L) String string, @Nullable String string2, @Nullable @Size(min=1L, max=23L) String string3, boolean bl) {
        if (this.zzn) {
            throw new IllegalStateException("Unexpected call on client side");
        }
        return this.zzl.zzs().getUserPropertiesAs(string, string2, string3, bl);
    }

    @WorkerThread
    @Keep
    @ShowFirstParty
    @KeepForSdk
    public List<ConditionalUserProperty> getConditionalUserProperties(@Nullable String string, @Nullable @Size(min=1L, max=23L) String string2) {
        List<Bundle> list = this.zzn ? this.zzm.getConditionalUserProperties(string, string2) : this.zzl.zzs().zzn(string, string2);
        ArrayList<ConditionalUserProperty> arrayList = new ArrayList<ConditionalUserProperty>(list == null ? 0 : list.size());
        for (Bundle bundle : list) {
            arrayList.add(new ConditionalUserProperty(bundle, null));
        }
        return arrayList;
    }

    @WorkerThread
    @Keep
    @VisibleForTesting
    protected List<ConditionalUserProperty> getConditionalUserPropertiesAs(@NonNull @Size(min=1L) String string, @Nullable String string2, @Nullable @Size(min=1L, max=23L) String string3) {
        if (this.zzn) {
            throw new IllegalStateException("Unexpected call on client side");
        }
        ArrayList<Bundle> arrayList = this.zzl.zzs().zze(string, string2, string3);
        ArrayList<ConditionalUserProperty> arrayList2 = new ArrayList<ConditionalUserProperty>(arrayList == null ? 0 : arrayList.size());
        ArrayList<Bundle> arrayList3 = arrayList;
        int n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            Bundle bundle = arrayList3.get(i);
            Bundle bundle2 = bundle;
            arrayList2.add(new ConditionalUserProperty(bundle2, null));
        }
        return arrayList2;
    }

    @WorkerThread
    @Keep
    @ShowFirstParty
    @KeepForSdk
    public int getMaxUserProperties(@NonNull @Size(min=1L) String string) {
        if (this.zzn) {
            return this.zzm.getMaxUserProperties(string);
        }
        this.zzl.zzs();
        String string2 = string;
        Preconditions.checkNotEmpty((String)string2);
        return 25;
    }

    @KeepForSdk
    public Boolean getBoolean() {
        if (this.zzn) {
            return (Boolean)this.zzm.zzb(4);
        }
        return this.zzl.zzs().zzev();
    }

    @KeepForSdk
    public String getString() {
        if (this.zzn) {
            return (String)this.zzm.zzb(0);
        }
        return this.zzl.zzs().zzew();
    }

    @KeepForSdk
    public Long getLong() {
        if (this.zzn) {
            return (Long)this.zzm.zzb(1);
        }
        return this.zzl.zzs().zzex();
    }

    @KeepForSdk
    public Integer getInteger() {
        if (this.zzn) {
            return (Integer)this.zzm.zzb(3);
        }
        return this.zzl.zzs().zzey();
    }

    @KeepForSdk
    public Double getDouble() {
        if (this.zzn) {
            return (Double)this.zzm.zzb(2);
        }
        return this.zzl.zzs().zzez();
    }

    @ShowFirstParty
    @KeepForSdk
    public static class ConditionalUserProperty {
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public String mAppId;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public String mOrigin;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public String mName;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public Object mValue;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public String mTriggerEventName;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mTriggerTimeout;
        @Keep
        public String mTimedOutEventName;
        @Keep
        public Bundle mTimedOutEventParams;
        @Keep
        public String mTriggeredEventName;
        @Keep
        public Bundle mTriggeredEventParams;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mTimeToLive;
        @Keep
        public String mExpiredEventName;
        @Keep
        public Bundle mExpiredEventParams;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mCreationTimestamp;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public boolean mActive;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mTriggeredTimestamp;

        @KeepForSdk
        public ConditionalUserProperty() {
        }

        @KeepForSdk
        public ConditionalUserProperty(ConditionalUserProperty conditionalUserProperty) {
            Preconditions.checkNotNull((Object)conditionalUserProperty);
            this.mAppId = conditionalUserProperty.mAppId;
            this.mOrigin = conditionalUserProperty.mOrigin;
            this.mCreationTimestamp = conditionalUserProperty.mCreationTimestamp;
            this.mName = conditionalUserProperty.mName;
            if (conditionalUserProperty.mValue != null) {
                this.mValue = zzeb.zza((Object)conditionalUserProperty.mValue);
                if (this.mValue == null) {
                    this.mValue = conditionalUserProperty.mValue;
                }
            }
            this.mActive = conditionalUserProperty.mActive;
            this.mTriggerEventName = conditionalUserProperty.mTriggerEventName;
            this.mTriggerTimeout = conditionalUserProperty.mTriggerTimeout;
            this.mTimedOutEventName = conditionalUserProperty.mTimedOutEventName;
            if (conditionalUserProperty.mTimedOutEventParams != null) {
                this.mTimedOutEventParams = new Bundle(conditionalUserProperty.mTimedOutEventParams);
            }
            this.mTriggeredEventName = conditionalUserProperty.mTriggeredEventName;
            if (conditionalUserProperty.mTriggeredEventParams != null) {
                this.mTriggeredEventParams = new Bundle(conditionalUserProperty.mTriggeredEventParams);
            }
            this.mTriggeredTimestamp = conditionalUserProperty.mTriggeredTimestamp;
            this.mTimeToLive = conditionalUserProperty.mTimeToLive;
            this.mExpiredEventName = conditionalUserProperty.mExpiredEventName;
            if (conditionalUserProperty.mExpiredEventParams != null) {
                this.mExpiredEventParams = new Bundle(conditionalUserProperty.mExpiredEventParams);
            }
        }

        private ConditionalUserProperty(@NonNull Bundle bundle) {
            Preconditions.checkNotNull((Object)bundle);
            this.mAppId = (String)zzcw.zza((Bundle)bundle, (String)"app_id", String.class, null);
            this.mOrigin = (String)zzcw.zza((Bundle)bundle, (String)"origin", String.class, null);
            this.mName = (String)zzcw.zza((Bundle)bundle, (String)"name", String.class, null);
            this.mValue = zzcw.zza((Bundle)bundle, (String)"value", Object.class, null);
            this.mTriggerEventName = (String)zzcw.zza((Bundle)bundle, (String)"trigger_event_name", String.class, null);
            this.mTriggerTimeout = (Long)zzcw.zza((Bundle)bundle, (String)"trigger_timeout", Long.class, (Object)0L);
            this.mTimedOutEventName = (String)zzcw.zza((Bundle)bundle, (String)"timed_out_event_name", String.class, null);
            this.mTimedOutEventParams = (Bundle)zzcw.zza((Bundle)bundle, (String)"timed_out_event_params", Bundle.class, null);
            this.mTriggeredEventName = (String)zzcw.zza((Bundle)bundle, (String)"triggered_event_name", String.class, null);
            this.mTriggeredEventParams = (Bundle)zzcw.zza((Bundle)bundle, (String)"triggered_event_params", Bundle.class, null);
            this.mTimeToLive = (Long)zzcw.zza((Bundle)bundle, (String)"time_to_live", Long.class, (Object)0L);
            this.mExpiredEventName = (String)zzcw.zza((Bundle)bundle, (String)"expired_event_name", String.class, null);
            this.mExpiredEventParams = (Bundle)zzcw.zza((Bundle)bundle, (String)"expired_event_params", Bundle.class, null);
        }

        private final Bundle zzf() {
            Bundle bundle = new Bundle();
            if (this.mAppId != null) {
                bundle.putString("app_id", this.mAppId);
            }
            if (this.mOrigin != null) {
                bundle.putString("origin", this.mOrigin);
            }
            if (this.mName != null) {
                bundle.putString("name", this.mName);
            }
            if (this.mValue != null) {
                zzcw.zza((Bundle)bundle, (Object)this.mValue);
            }
            if (this.mTriggerEventName != null) {
                bundle.putString("trigger_event_name", this.mTriggerEventName);
            }
            bundle.putLong("trigger_timeout", this.mTriggerTimeout);
            if (this.mTimedOutEventName != null) {
                bundle.putString("timed_out_event_name", this.mTimedOutEventName);
            }
            if (this.mTimedOutEventParams != null) {
                bundle.putBundle("timed_out_event_params", this.mTimedOutEventParams);
            }
            if (this.mTriggeredEventName != null) {
                bundle.putString("triggered_event_name", this.mTriggeredEventName);
            }
            if (this.mTriggeredEventParams != null) {
                bundle.putBundle("triggered_event_params", this.mTriggeredEventParams);
            }
            bundle.putLong("time_to_live", this.mTimeToLive);
            if (this.mExpiredEventName != null) {
                bundle.putString("expired_event_name", this.mExpiredEventName);
            }
            if (this.mExpiredEventParams != null) {
                bundle.putBundle("expired_event_params", this.mExpiredEventParams);
            }
            bundle.putLong("creation_timestamp", this.mCreationTimestamp);
            bundle.putBoolean("active", this.mActive);
            bundle.putLong("triggered_timestamp", this.mTriggeredTimestamp);
            return bundle;
        }

        /* synthetic */ ConditionalUserProperty(Bundle bundle, zza zza2) {
            this(bundle);
        }
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface OnEventListener
    extends zzdb {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void onEvent(String var1, String var2, Bundle var3, long var4);
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface EventInterceptor
    extends zzda {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void interceptEvent(String var1, String var2, Bundle var3, long var4);
    }

    @ShowFirstParty
    @KeepForSdk
    public static final class UserProperty
    extends zzcz {
        @ShowFirstParty
        @KeepForSdk
        public static final String FIREBASE_LAST_NOTIFICATION = "_ln";

        private UserProperty() {
        }
    }

    @ShowFirstParty
    @KeepForSdk
    public static final class Param
    extends zzcy {
        @ShowFirstParty
        @KeepForSdk
        public static final String FATAL = "fatal";
        @ShowFirstParty
        @KeepForSdk
        public static final String TIMESTAMP = "timestamp";
        @ShowFirstParty
        @KeepForSdk
        public static final String TYPE = "type";

        private Param() {
        }
    }

    @ShowFirstParty
    @KeepForSdk
    public static final class Event
    extends zzcx {
        @ShowFirstParty
        @KeepForSdk
        public static final String APP_EXCEPTION = "_ae";
        @ShowFirstParty
        @KeepForSdk
        public static final String AD_REWARD = "_ar";

        private Event() {
        }
    }
}

