/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzdg;
import com.google.android.gms.internal.measurement.zzdo;
import com.google.android.gms.internal.measurement.zzdp;
import com.google.android.gms.internal.measurement.zzeh;
import com.google.android.gms.internal.measurement.zzei;
import com.google.android.gms.internal.measurement.zzfb;
import com.google.android.gms.internal.measurement.zzfo;
import com.google.android.gms.internal.measurement.zzgh;
import com.google.android.gms.internal.measurement.zzgy;
import com.google.android.gms.internal.measurement.zzhw;
import com.google.android.gms.internal.measurement.zzhy;
import com.google.android.gms.internal.measurement.zzic;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class zzeg
extends zzdo {
    private static final Logger logger = Logger.getLogger(zzeg.class.getName());
    private static final boolean zzacv = zzhw.zzou();
    zzei zzacw;

    public static zzeg zzh(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        return new zza(byArray2, 0, n);
    }

    public static zzeg zza(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            return new zzb(byteBuffer);
        }
        if (byteBuffer.isDirect() && !byteBuffer.isReadOnly()) {
            if (zzhw.zzov()) {
                ByteBuffer byteBuffer2 = byteBuffer;
                return new zze(byteBuffer2);
            }
            ByteBuffer byteBuffer3 = byteBuffer;
            return new zzd(byteBuffer3);
        }
        throw new IllegalArgumentException("ByteBuffer is read-only");
    }

    private zzeg() {
    }

    public abstract void zzb(int var1, int var2) throws IOException;

    public abstract void zzc(int var1, int var2) throws IOException;

    public abstract void zzd(int var1, int var2) throws IOException;

    public final void zze(int n, int n2) throws IOException {
        this.zzd(n, zzeg.zzaq(n2));
    }

    public abstract void zzf(int var1, int var2) throws IOException;

    public abstract void zza(int var1, long var2) throws IOException;

    public final void zzb(int n, long l) throws IOException {
        this.zza(n, zzeg.zzay(l));
    }

    public abstract void zzc(int var1, long var2) throws IOException;

    public final void zza(int n, float f) throws IOException {
        this.zzf(n, Float.floatToRawIntBits(f));
    }

    public final void zza(int n, double d) throws IOException {
        this.zzc(n, Double.doubleToRawLongBits(d));
    }

    public abstract void zzb(int var1, boolean var2) throws IOException;

    public abstract void zzb(int var1, String var2) throws IOException;

    public abstract void zza(int var1, zzdp var2) throws IOException;

    public abstract void zza(int var1, zzgh var2) throws IOException;

    abstract void zza(int var1, zzgh var2, zzgy var3) throws IOException;

    public abstract void zzb(int var1, zzgh var2) throws IOException;

    public abstract void zzb(int var1, zzdp var2) throws IOException;

    public abstract void zzaf(int var1) throws IOException;

    public abstract void zzag(int var1) throws IOException;

    public final void zzah(int n) throws IOException {
        this.zzag(zzeg.zzaq(n));
    }

    public abstract void zzai(int var1) throws IOException;

    public abstract void zzaq(long var1) throws IOException;

    public final void zzar(long l) throws IOException {
        this.zzaq(zzeg.zzay(l));
    }

    public abstract void zzas(long var1) throws IOException;

    public final void zza(float f) throws IOException {
        this.zzai(Float.floatToRawIntBits(f));
    }

    public final void zzd(double d) throws IOException {
        this.zzas(Double.doubleToRawLongBits(d));
    }

    public final void zzm(boolean bl) throws IOException {
        this.zzc((byte)(bl ? 1 : 0));
    }

    public abstract void zzco(String var1) throws IOException;

    public abstract void zza(zzdp var1) throws IOException;

    public abstract void zzb(zzgh var1) throws IOException;

    abstract void zza(zzgh var1, zzgy var2) throws IOException;

    public abstract void zzc(byte var1) throws IOException;

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public static int zzg(int n, int n2) {
        return zzeg.zzaj(n) + zzeg.zzak(n2);
    }

    public static int zzh(int n, int n2) {
        return zzeg.zzaj(n) + zzeg.zzal(n2);
    }

    public static int zzi(int n, int n2) {
        return zzeg.zzaj(n) + zzeg.zzal(zzeg.zzaq(n2));
    }

    public static int zzj(int n, int n2) {
        return zzeg.zzaj(n) + 4;
    }

    public static int zzk(int n, int n2) {
        return zzeg.zzaj(n) + 4;
    }

    public static int zzd(int n, long l) {
        return zzeg.zzaj(n) + zzeg.zzau(l);
    }

    public static int zze(int n, long l) {
        return zzeg.zzaj(n) + zzeg.zzau(l);
    }

    public static int zzf(int n, long l) {
        return zzeg.zzaj(n) + zzeg.zzau(zzeg.zzay(l));
    }

    public static int zzg(int n, long l) {
        return zzeg.zzaj(n) + 8;
    }

    public static int zzh(int n, long l) {
        return zzeg.zzaj(n) + 8;
    }

    public static int zzb(int n, float f) {
        return zzeg.zzaj(n) + 4;
    }

    public static int zzb(int n, double d) {
        return zzeg.zzaj(n) + 8;
    }

    public static int zzc(int n, boolean bl) {
        return zzeg.zzaj(n) + 1;
    }

    public static int zzl(int n, int n2) {
        return zzeg.zzaj(n) + zzeg.zzak(n2);
    }

    public static int zzc(int n, String string) {
        return zzeg.zzaj(n) + zzeg.zzcp(string);
    }

    public static int zzc(int n, zzdp zzdp2) {
        int n2 = zzdp2.size();
        return zzeg.zzaj(n) + (zzeg.zzal(n2) + n2);
    }

    public static int zza(int n, zzfo zzfo2) {
        int n2 = zzfo2.zzly();
        return zzeg.zzaj(n) + (zzeg.zzal(n2) + n2);
    }

    public static int zzc(int n, zzgh zzgh2) {
        return zzeg.zzaj(n) + zzeg.zzc(zzgh2);
    }

    static int zzb(int n, zzgh zzgh2, zzgy zzgy2) {
        return zzeg.zzaj(n) + zzeg.zzb(zzgh2, zzgy2);
    }

    public static int zzd(int n, zzgh zzgh2) {
        return (zzeg.zzaj(1) << 1) + zzeg.zzh(2, n) + zzeg.zzc(3, zzgh2);
    }

    public static int zzd(int n, zzdp zzdp2) {
        return (zzeg.zzaj(1) << 1) + zzeg.zzh(2, n) + zzeg.zzc(3, zzdp2);
    }

    public static int zzb(int n, zzfo zzfo2) {
        return (zzeg.zzaj(1) << 1) + zzeg.zzh(2, n) + zzeg.zza(3, zzfo2);
    }

    public static int zzaj(int n) {
        return zzeg.zzal(n << 3);
    }

    public static int zzak(int n) {
        if (n >= 0) {
            return zzeg.zzal(n);
        }
        return 10;
    }

    public static int zzal(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int zzam(int n) {
        return zzeg.zzal(zzeg.zzaq(n));
    }

    public static int zzan(int n) {
        return 4;
    }

    public static int zzao(int n) {
        return 4;
    }

    public static int zzat(long l) {
        return zzeg.zzau(l);
    }

    public static int zzau(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (l < 0L) {
            return 10;
        }
        int n = 2;
        if ((l & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            l >>>= 28;
        }
        if ((l & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            l >>>= 14;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    public static int zzav(long l) {
        return zzeg.zzau(zzeg.zzay(l));
    }

    public static int zzaw(long l) {
        return 8;
    }

    public static int zzax(long l) {
        return 8;
    }

    public static int zzb(float f) {
        return 4;
    }

    public static int zze(double d) {
        return 8;
    }

    public static int zzn(boolean bl) {
        return 1;
    }

    public static int zzap(int n) {
        return zzeg.zzak(n);
    }

    public static int zzcp(String string) {
        int n;
        try {
            n = zzhy.zza(string);
        }
        catch (zzic zzic2) {
            n = string.getBytes(zzfb.UTF_8).length;
        }
        int n2 = n;
        return zzeg.zzal(n2) + n2;
    }

    public static int zza(zzfo zzfo2) {
        int n = zzfo2.zzly();
        return zzeg.zzal(n) + n;
    }

    public static int zzb(zzdp zzdp2) {
        int n = zzdp2.size();
        return zzeg.zzal(n) + n;
    }

    public static int zzi(byte[] byArray) {
        int n = byArray.length;
        return zzeg.zzal(n) + n;
    }

    public static int zzc(zzgh zzgh2) {
        int n = zzgh2.zzly();
        return zzeg.zzal(n) + n;
    }

    static int zzb(zzgh zzgh2, zzgy zzgy2) {
        zzgy zzgy3 = zzgy2;
        zzdg zzdg2 = (zzdg)zzgh2;
        int n = zzdg2.zzjw();
        if (n == -1) {
            n = zzgy3.zzs(zzdg2);
            zzdg2.zzn(n);
        }
        int n2 = n;
        return zzeg.zzal(n2) + n2;
    }

    private static int zzaq(int n) {
        return n << 1 ^ n >> 31;
    }

    private static long zzay(long l) {
        return l << 1 ^ l >> 63;
    }

    public abstract void flush() throws IOException;

    public abstract int zzlj();

    public final void zzlk() {
        if (this.zzlj() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    abstract void zze(byte[] var1, int var2, int var3) throws IOException;

    final void zza(String string, zzic zzic2) throws IOException {
        logger.logp(Level.WARNING, "com.google.protobuf.CodedOutputStream", "inefficientWriteStringNoTag", "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", zzic2);
        byte[] byArray = string.getBytes(zzfb.UTF_8);
        try {
            this.zzag(byArray.length);
            this.zza(byArray, 0, byArray.length);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new zzc(indexOutOfBoundsException);
        }
        catch (zzc zzc2) {
            throw zzc2;
        }
    }

    @Deprecated
    static int zzc(int n, zzgh zzgh2, zzgy zzgy2) {
        zzgy zzgy3;
        int n2 = zzeg.zzaj(n) << 1;
        zzgy zzgy4 = zzgy3 = zzgy2;
        zzdg zzdg2 = (zzdg)zzgh2;
        int n3 = zzdg2.zzjw();
        if (n3 == -1) {
            n3 = zzgy4.zzs(zzdg2);
            zzdg2.zzn(n3);
        }
        return n2 + n3;
    }

    @Deprecated
    public static int zzd(zzgh zzgh2) {
        return zzgh2.zzly();
    }

    @Deprecated
    public static int zzar(int n) {
        return zzeg.zzal(n);
    }

    /* synthetic */ zzeg(zzeh zzeh2) {
        this();
    }

    static final class zze
    extends zzeg {
        private final ByteBuffer zzacz;
        private final ByteBuffer zzada;
        private final long zzadb;
        private final long zzadc;
        private final long zzadd;
        private final long zzade;
        private long zzadf;

        zze(ByteBuffer byteBuffer) {
            super(null);
            this.zzacz = byteBuffer;
            this.zzada = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzadb = zzhw.zzb(byteBuffer);
            this.zzadc = this.zzadb + (long)byteBuffer.position();
            this.zzadd = this.zzadb + (long)byteBuffer.limit();
            this.zzade = this.zzadd - 10L;
            this.zzadf = this.zzadc;
        }

        @Override
        public final void zzb(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzeg)this).zzag(n << 3 | n3);
        }

        @Override
        public final void zzc(int n, int n2) throws IOException {
            ((zzeg)this).zzb(n, 0);
            ((zzeg)this).zzaf(n2);
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            ((zzeg)this).zzb(n, 0);
            ((zzeg)this).zzag(n2);
        }

        @Override
        public final void zzf(int n, int n2) throws IOException {
            ((zzeg)this).zzb(n, 5);
            ((zzeg)this).zzai(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzeg)this).zzb(n, 0);
            ((zzeg)this).zzaq(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzeg)this).zzb(n, 1);
            ((zzeg)this).zzas(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzeg)this).zzb(n, 0);
            ((zzeg)this).zzc((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzb(int n, String string) throws IOException {
            ((zzeg)this).zzb(n, 2);
            ((zzeg)this).zzco(string);
        }

        @Override
        public final void zza(int n, zzdp zzdp2) throws IOException {
            ((zzeg)this).zzb(n, 2);
            ((zzeg)this).zza(zzdp2);
        }

        @Override
        public final void zza(int n, zzgh zzgh2) throws IOException {
            ((zzeg)this).zzb(n, 2);
            ((zzeg)this).zzb(zzgh2);
        }

        @Override
        final void zza(int n, zzgh zzgh2, zzgy zzgy2) throws IOException {
            ((zzeg)this).zzb(n, 2);
            ((zzeg)this).zza(zzgh2, zzgy2);
        }

        @Override
        public final void zzb(int n, zzgh zzgh2) throws IOException {
            ((zzeg)this).zzb(1, 3);
            ((zzeg)this).zzd(2, n);
            ((zzeg)this).zza(3, zzgh2);
            ((zzeg)this).zzb(1, 4);
        }

        @Override
        public final void zzb(int n, zzdp zzdp2) throws IOException {
            ((zzeg)this).zzb(1, 3);
            ((zzeg)this).zzd(2, n);
            ((zzeg)this).zza(3, zzdp2);
            ((zzeg)this).zzb(1, 4);
        }

        @Override
        public final void zzb(zzgh zzgh2) throws IOException {
            ((zzeg)this).zzag(zzgh2.zzly());
            zzgh2.zzb(this);
        }

        @Override
        final void zza(zzgh zzgh2, zzgy zzgy2) throws IOException {
            zzgy zzgy3 = zzgy2;
            zzdg zzdg2 = (zzdg)zzgh2;
            int n = zzdg2.zzjw();
            if (n == -1) {
                n = zzgy3.zzs(zzdg2);
                zzdg2.zzn(n);
            }
            ((zzeg)this).zzag(n);
            zzgy2.zza(zzgh2, this.zzacw);
        }

        @Override
        public final void zzc(byte by) throws IOException {
            if (this.zzadf >= this.zzadd) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzadf, this.zzadd, 1));
            }
            zzhw.zza(this.zzadf++, by);
        }

        @Override
        public final void zza(zzdp zzdp2) throws IOException {
            ((zzeg)this).zzag(zzdp2.size());
            zzdp2.zza(this);
        }

        @Override
        public final void zze(byte[] byArray, int n, int n2) throws IOException {
            ((zzeg)this).zzag(n2);
            ((zzeg)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzaf(int n) throws IOException {
            if (n >= 0) {
                ((zzeg)this).zzag(n);
                return;
            }
            ((zzeg)this).zzaq(n);
        }

        @Override
        public final void zzag(int n) throws IOException {
            if (this.zzadf <= this.zzade) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzhw.zza(this.zzadf++, (byte)n);
                        return;
                    }
                    zzhw.zza(this.zzadf++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            while (this.zzadf < this.zzadd) {
                if ((n & 0xFFFFFF80) == 0) {
                    zzhw.zza(this.zzadf++, (byte)n);
                    return;
                }
                zzhw.zza(this.zzadf++, (byte)(n & 0x7F | 0x80));
                n >>>= 7;
            }
            throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzadf, this.zzadd, 1));
        }

        @Override
        public final void zzai(int n) throws IOException {
            long l = this.zzadf;
            zze zze2 = this;
            this.zzada.putInt((int)(l - zze2.zzadb), n);
            this.zzadf += 4L;
        }

        @Override
        public final void zzaq(long l) throws IOException {
            if (this.zzadf <= this.zzade) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzhw.zza(this.zzadf++, (byte)l);
                        return;
                    }
                    zzhw.zza(this.zzadf++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            while (this.zzadf < this.zzadd) {
                if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    zzhw.zza(this.zzadf++, (byte)l);
                    return;
                }
                zzhw.zza(this.zzadf++, (byte)((int)l & 0x7F | 0x80));
                l >>>= 7;
            }
            throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzadf, this.zzadd, 1));
        }

        @Override
        public final void zzas(long l) throws IOException {
            long l2 = this.zzadf;
            zze zze2 = this;
            this.zzada.putLong((int)(l2 - zze2.zzadb), l);
            this.zzadf += 8L;
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null || n < 0 || n2 < 0 || byArray.length - n2 < n || this.zzadd - (long)n2 < this.zzadf) {
                if (byArray == null) {
                    throw new NullPointerException("value");
                }
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzadf, this.zzadd, n2));
            }
            zzhw.zza(byArray, n, this.zzadf, n2);
            this.zzadf += (long)n2;
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzeg)this).write(byArray, n, n2);
        }

        @Override
        public final void zzco(String string) throws IOException {
            long l = this.zzadf;
            try {
                int n = zze.zzal(string.length() * 3);
                int n2 = zze.zzal(string.length());
                if (n2 == n) {
                    long l2 = this.zzadf;
                    zze zze2 = this;
                    int n3 = (int)(l2 - zze2.zzadb) + n2;
                    this.zzada.position(n3);
                    zzhy.zza(string, this.zzada);
                    int n4 = this.zzada.position() - n3;
                    ((zzeg)this).zzag(n4);
                    this.zzadf += (long)n4;
                    return;
                }
                int n5 = zzhy.zza(string);
                ((zzeg)this).zzag(n5);
                this.zzaz(this.zzadf);
                zzhy.zza(string, this.zzada);
                this.zzadf += (long)n5;
                return;
            }
            catch (zzic zzic2) {
                this.zzadf = l;
                this.zzaz(this.zzadf);
                this.zza(string, zzic2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzc(illegalArgumentException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }

        @Override
        public final void flush() {
            long l = this.zzadf;
            zze zze2 = this;
            this.zzacz.position((int)(l - zze2.zzadb));
        }

        @Override
        public final int zzlj() {
            return (int)(this.zzadd - this.zzadf);
        }

        private final void zzaz(long l) {
            long l2 = l;
            zze zze2 = this;
            this.zzada.position((int)(l2 - zze2.zzadb));
        }
    }

    static final class zzd
    extends zzeg {
        private final ByteBuffer zzacz;
        private final ByteBuffer zzada;
        private final int zzacy;

        zzd(ByteBuffer byteBuffer) {
            super(null);
            this.zzacz = byteBuffer;
            this.zzada = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzacy = byteBuffer.position();
        }

        @Override
        public final void zzb(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzeg)this).zzag(n << 3 | n3);
        }

        @Override
        public final void zzc(int n, int n2) throws IOException {
            ((zzeg)this).zzb(n, 0);
            ((zzeg)this).zzaf(n2);
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            ((zzeg)this).zzb(n, 0);
            ((zzeg)this).zzag(n2);
        }

        @Override
        public final void zzf(int n, int n2) throws IOException {
            ((zzeg)this).zzb(n, 5);
            ((zzeg)this).zzai(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzeg)this).zzb(n, 0);
            ((zzeg)this).zzaq(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzeg)this).zzb(n, 1);
            ((zzeg)this).zzas(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzeg)this).zzb(n, 0);
            ((zzeg)this).zzc((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzb(int n, String string) throws IOException {
            ((zzeg)this).zzb(n, 2);
            ((zzeg)this).zzco(string);
        }

        @Override
        public final void zza(int n, zzdp zzdp2) throws IOException {
            ((zzeg)this).zzb(n, 2);
            ((zzeg)this).zza(zzdp2);
        }

        @Override
        public final void zza(int n, zzgh zzgh2) throws IOException {
            ((zzeg)this).zzb(n, 2);
            ((zzeg)this).zzb(zzgh2);
        }

        @Override
        final void zza(int n, zzgh zzgh2, zzgy zzgy2) throws IOException {
            ((zzeg)this).zzb(n, 2);
            ((zzeg)this).zza(zzgh2, zzgy2);
        }

        @Override
        public final void zzb(int n, zzgh zzgh2) throws IOException {
            ((zzeg)this).zzb(1, 3);
            ((zzeg)this).zzd(2, n);
            ((zzeg)this).zza(3, zzgh2);
            ((zzeg)this).zzb(1, 4);
        }

        @Override
        public final void zzb(int n, zzdp zzdp2) throws IOException {
            ((zzeg)this).zzb(1, 3);
            ((zzeg)this).zzd(2, n);
            ((zzeg)this).zza(3, zzdp2);
            ((zzeg)this).zzb(1, 4);
        }

        @Override
        public final void zzb(zzgh zzgh2) throws IOException {
            ((zzeg)this).zzag(zzgh2.zzly());
            zzgh2.zzb(this);
        }

        @Override
        final void zza(zzgh zzgh2, zzgy zzgy2) throws IOException {
            zzgy zzgy3 = zzgy2;
            zzdg zzdg2 = (zzdg)zzgh2;
            int n = zzdg2.zzjw();
            if (n == -1) {
                n = zzgy3.zzs(zzdg2);
                zzdg2.zzn(n);
            }
            ((zzeg)this).zzag(n);
            zzgy2.zza(zzgh2, this.zzacw);
        }

        @Override
        public final void zzc(byte by) throws IOException {
            try {
                this.zzada.put(by);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zza(zzdp zzdp2) throws IOException {
            ((zzeg)this).zzag(zzdp2.size());
            zzdp2.zza(this);
        }

        @Override
        public final void zze(byte[] byArray, int n, int n2) throws IOException {
            ((zzeg)this).zzag(n2);
            ((zzeg)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzaf(int n) throws IOException {
            if (n >= 0) {
                ((zzeg)this).zzag(n);
                return;
            }
            ((zzeg)this).zzaq(n);
        }

        @Override
        public final void zzag(int n) throws IOException {
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.zzada.put((byte)n);
                        return;
                    }
                    this.zzada.put((byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzai(int n) throws IOException {
            try {
                this.zzada.putInt(n);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzaq(long l) throws IOException {
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.zzada.put((byte)l);
                        return;
                    }
                    this.zzada.put((byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzas(long l) throws IOException {
            try {
                this.zzada.putLong(l);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.zzada.put(byArray, n, n2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzeg)this).write(byArray, n, n2);
        }

        @Override
        public final void zzco(String string) throws IOException {
            int n = this.zzada.position();
            try {
                int n2 = zzd.zzal(string.length() * 3);
                int n3 = zzd.zzal(string.length());
                if (n3 == n2) {
                    int n4 = this.zzada.position() + n3;
                    this.zzada.position(n4);
                    this.zzcq(string);
                    int n5 = this.zzada.position();
                    this.zzada.position(n);
                    ((zzeg)this).zzag(n5 - n4);
                    this.zzada.position(n5);
                    return;
                }
                int n6 = zzhy.zza(string);
                ((zzeg)this).zzag(n6);
                this.zzcq(string);
                return;
            }
            catch (zzic zzic2) {
                this.zzada.position(n);
                this.zza(string, zzic2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzc(illegalArgumentException);
            }
        }

        @Override
        public final void flush() {
            this.zzacz.position(this.zzada.position());
        }

        @Override
        public final int zzlj() {
            return this.zzada.remaining();
        }

        private final void zzcq(String string) throws IOException {
            try {
                zzhy.zza(string, this.zzada);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }
    }

    static final class zzb
    extends zza {
        private final ByteBuffer zzacx;
        private int zzacy;

        zzb(ByteBuffer byteBuffer) {
            super(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            this.zzacx = byteBuffer;
            this.zzacy = byteBuffer.position();
        }

        @Override
        public final void flush() {
            this.zzacx.position(this.zzacy + this.zzlm());
        }
    }

    static class zza
    extends zzeg {
        private final byte[] buffer;
        private final int offset;
        private final int limit;
        private int position;

        zza(byte[] byArray, int n, int n2) {
            super(null);
            if (byArray == null) {
                throw new NullPointerException("buffer");
            }
            if ((n | n2 | byArray.length - (n + n2)) < 0) {
                throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", byArray.length, n, n2));
            }
            this.buffer = byArray;
            this.offset = n;
            this.position = n;
            this.limit = n + n2;
        }

        @Override
        public final void zzb(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzeg)this).zzag(n << 3 | n3);
        }

        @Override
        public final void zzc(int n, int n2) throws IOException {
            ((zzeg)this).zzb(n, 0);
            ((zzeg)this).zzaf(n2);
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            ((zzeg)this).zzb(n, 0);
            ((zzeg)this).zzag(n2);
        }

        @Override
        public final void zzf(int n, int n2) throws IOException {
            ((zzeg)this).zzb(n, 5);
            ((zzeg)this).zzai(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzeg)this).zzb(n, 0);
            ((zzeg)this).zzaq(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzeg)this).zzb(n, 1);
            ((zzeg)this).zzas(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzeg)this).zzb(n, 0);
            ((zzeg)this).zzc((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzb(int n, String string) throws IOException {
            ((zzeg)this).zzb(n, 2);
            ((zzeg)this).zzco(string);
        }

        @Override
        public final void zza(int n, zzdp zzdp2) throws IOException {
            ((zzeg)this).zzb(n, 2);
            ((zzeg)this).zza(zzdp2);
        }

        @Override
        public final void zza(zzdp zzdp2) throws IOException {
            ((zzeg)this).zzag(zzdp2.size());
            zzdp2.zza(this);
        }

        @Override
        public final void zze(byte[] byArray, int n, int n2) throws IOException {
            ((zzeg)this).zzag(n2);
            ((zzeg)this).write(byArray, 0, n2);
        }

        @Override
        public final void zza(int n, zzgh zzgh2) throws IOException {
            ((zzeg)this).zzb(n, 2);
            ((zzeg)this).zzb(zzgh2);
        }

        @Override
        final void zza(int n, zzgh zzgh2, zzgy zzgy2) throws IOException {
            ((zzeg)this).zzb(n, 2);
            zzgy zzgy3 = zzgy2;
            zzdg zzdg2 = (zzdg)zzgh2;
            int n2 = zzdg2.zzjw();
            if (n2 == -1) {
                n2 = zzgy3.zzs(zzdg2);
                zzdg2.zzn(n2);
            }
            ((zzeg)this).zzag(n2);
            zzgy2.zza(zzgh2, this.zzacw);
        }

        @Override
        public final void zzb(int n, zzgh zzgh2) throws IOException {
            ((zzeg)this).zzb(1, 3);
            ((zzeg)this).zzd(2, n);
            ((zzeg)this).zza(3, zzgh2);
            ((zzeg)this).zzb(1, 4);
        }

        @Override
        public final void zzb(int n, zzdp zzdp2) throws IOException {
            ((zzeg)this).zzb(1, 3);
            ((zzeg)this).zzd(2, n);
            ((zzeg)this).zza(3, zzdp2);
            ((zzeg)this).zzb(1, 4);
        }

        @Override
        public final void zzb(zzgh zzgh2) throws IOException {
            ((zzeg)this).zzag(zzgh2.zzly());
            zzgh2.zzb(this);
        }

        @Override
        final void zza(zzgh zzgh2, zzgy zzgy2) throws IOException {
            zzgy zzgy3 = zzgy2;
            zzdg zzdg2 = (zzdg)zzgh2;
            int n = zzdg2.zzjw();
            if (n == -1) {
                n = zzgy3.zzs(zzdg2);
                zzdg2.zzn(n);
            }
            ((zzeg)this).zzag(n);
            zzgy2.zza(zzgh2, this.zzacw);
        }

        @Override
        public final void zzc(byte by) throws IOException {
            try {
                this.buffer[this.position++] = by;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzaf(int n) throws IOException {
            if (n >= 0) {
                ((zzeg)this).zzag(n);
                return;
            }
            ((zzeg)this).zzaq(n);
        }

        @Override
        public final void zzag(int n) throws IOException {
            if (zzacv && ((zzeg)this).zzlj() >= 10) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzhw.zza(this.buffer, (long)this.position++, (byte)n);
                        return;
                    }
                    zzhw.zza(this.buffer, (long)this.position++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.buffer[this.position++] = (byte)n;
                        return;
                    }
                    this.buffer[this.position++] = (byte)(n & 0x7F | 0x80);
                    n >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzai(int n) throws IOException {
            try {
                this.buffer[this.position++] = (byte)n;
                this.buffer[this.position++] = (byte)(n >> 8);
                this.buffer[this.position++] = (byte)(n >> 16);
                this.buffer[this.position++] = (byte)(n >>> 24);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzaq(long l) throws IOException {
            if (zzacv && ((zzeg)this).zzlj() >= 10) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzhw.zza(this.buffer, (long)this.position++, (byte)l);
                        return;
                    }
                    zzhw.zza(this.buffer, (long)this.position++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)l;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)l & 0x7F | 0x80);
                    l >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzas(long l) throws IOException {
            try {
                this.buffer[this.position++] = (byte)l;
                this.buffer[this.position++] = (byte)(l >> 8);
                this.buffer[this.position++] = (byte)(l >> 16);
                this.buffer[this.position++] = (byte)(l >> 24);
                this.buffer[this.position++] = (byte)(l >> 32);
                this.buffer[this.position++] = (byte)(l >> 40);
                this.buffer[this.position++] = (byte)(l >> 48);
                this.buffer[this.position++] = (byte)(l >> 56);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                System.arraycopy(byArray, n, this.buffer, this.position, n2);
                this.position += n2;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, n2), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzeg)this).write(byArray, n, n2);
        }

        @Override
        public final void zzco(String string) throws IOException {
            int n = this.position;
            try {
                int n2 = zza.zzal(string.length() * 3);
                int n3 = zza.zzal(string.length());
                if (n3 == n2) {
                    this.position = n + n3;
                    int n4 = zzhy.zza(string, this.buffer, this.position, ((zzeg)this).zzlj());
                    this.position = n;
                    int n5 = n4 - n - n3;
                    ((zzeg)this).zzag(n5);
                    this.position = n4;
                    return;
                }
                int n6 = zzhy.zza(string);
                ((zzeg)this).zzag(n6);
                this.position = zzhy.zza(string, this.buffer, this.position, ((zzeg)this).zzlj());
                return;
            }
            catch (zzic zzic2) {
                this.position = n;
                this.zza(string, zzic2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public final int zzlj() {
            return this.limit - this.position;
        }

        public final int zzlm() {
            return this.position - this.offset;
        }
    }

    public static final class zzc
    extends IOException {
        zzc() {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.");
        }

        zzc(String string) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        }

        zzc(Throwable throwable) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.", throwable);
        }

        zzc(String string, Throwable throwable) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2), throwable);
        }
    }
}

