/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.analytics;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.Keep;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import androidx.annotation.Size;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzdf;
import com.google.android.gms.measurement.internal.zzjz;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.analytics.zza;
import com.google.firebase.analytics.zzb;
import com.google.firebase.analytics.zzc;
import com.google.firebase.analytics.zzd;
import com.google.firebase.installations.FirebaseInstallations;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class FirebaseAnalytics {
    private static volatile @MonotonicNonNull FirebaseAnalytics zza;
    private final zzdf zzb;
    private @MonotonicNonNull ExecutorService zzc;

    static /* bridge */ /* synthetic */ zzdf zza(FirebaseAnalytics firebaseAnalytics) {
        return firebaseAnalytics.zzb;
    }

    @Nullable
    @Keep
    public static zzjz getScionFrontendApiImplementation(Context context, @Nullable Bundle bundle) {
        zzdf zzdf2 = zzdf.zza((Context)context, null, null, null, (Bundle)bundle);
        if (zzdf2 == null) {
            return null;
        }
        zzdf zzdf3 = zzdf2;
        return new zzc(zzdf3);
    }

    @NonNull
    public final Task<@org.checkerframework.checker.nullness.qual.Nullable String> getAppInstanceId() {
        try {
            return Tasks.call((Executor)this.zza(), (Callable)new zza(this));
        }
        catch (RuntimeException runtimeException) {
            this.zzb.zza(5, "Failed to schedule task for getAppInstanceId", null, null, null);
            return Tasks.forException((Exception)runtimeException);
        }
    }

    @NonNull
    public final Task<@org.checkerframework.checker.nullness.qual.Nullable Long> getSessionId() {
        try {
            return Tasks.call((Executor)this.zza(), (Callable)new zzd(this));
        }
        catch (RuntimeException runtimeException) {
            this.zzb.zza(5, "Failed to schedule task for getSessionId", null, null, null);
            return Tasks.forException((Exception)runtimeException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    @Keep
    @NonNull
    public static FirebaseAnalytics getInstance(@NonNull Context context) {
        if (zza != null) return zza;
        Class<FirebaseAnalytics> clazz = FirebaseAnalytics.class;
        synchronized (FirebaseAnalytics.class) {
            if (zza != null) return zza;
            zzdf zzdf2 = zzdf.zza((Context)context);
            zza = new FirebaseAnalytics(zzdf2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zza;
        }
    }

    @Keep
    @NonNull
    public final String getFirebaseInstanceId() {
        try {
            return (String)Tasks.await((Task)FirebaseInstallations.getInstance().getId(), (long)30000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException executionException) {
            throw new IllegalStateException(executionException.getCause());
        }
        catch (TimeoutException timeoutException) {
            throw new IllegalThreadStateException("Firebase Installations getId Task has timed out.");
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException(interruptedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EnsuresNonNull(value={"this.executor"})
    private final ExecutorService zza() {
        Class<FirebaseAnalytics> clazz = FirebaseAnalytics.class;
        synchronized (FirebaseAnalytics.class) {
            if (this.zzc == null) {
                this.zzc = new zzb(this, 0, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue(100));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.zzc;
        }
    }

    private FirebaseAnalytics(zzdf zzdf2) {
        Preconditions.checkNotNull((Object)zzdf2);
        this.zzb = zzdf2;
    }

    public final void logEvent(@NonNull @Size(min=1L, max=40L) String string, @Nullable Bundle bundle) {
        this.zzb.zza(string, bundle);
    }

    public final void resetAnalyticsData() {
        this.zzb.zzj();
    }

    public final void setAnalyticsCollectionEnabled(boolean bl) {
        this.zzb.zza(Boolean.valueOf(bl));
    }

    public final void setConsent(@NonNull Map<ConsentType, ConsentStatus> map) {
        ConsentStatus consentStatus;
        ConsentStatus consentStatus2;
        ConsentStatus consentStatus3;
        Bundle bundle = new Bundle();
        ConsentStatus consentStatus4 = map.get((Object)ConsentType.AD_STORAGE);
        if (consentStatus4 != null) {
            switch (consentStatus4.ordinal()) {
                case 0: {
                    bundle.putString("ad_storage", "granted");
                    break;
                }
                case 1: {
                    bundle.putString("ad_storage", "denied");
                }
            }
        }
        if ((consentStatus3 = map.get((Object)ConsentType.ANALYTICS_STORAGE)) != null) {
            switch (consentStatus3.ordinal()) {
                case 0: {
                    bundle.putString("analytics_storage", "granted");
                    break;
                }
                case 1: {
                    bundle.putString("analytics_storage", "denied");
                }
            }
        }
        if ((consentStatus2 = map.get((Object)ConsentType.AD_USER_DATA)) != null) {
            switch (consentStatus2.ordinal()) {
                case 0: {
                    bundle.putString("ad_user_data", "granted");
                    break;
                }
                case 1: {
                    bundle.putString("ad_user_data", "denied");
                }
            }
        }
        if ((consentStatus = map.get((Object)ConsentType.AD_PERSONALIZATION)) != null) {
            switch (consentStatus.ordinal()) {
                case 0: {
                    bundle.putString("ad_personalization", "granted");
                    break;
                }
                case 1: {
                    bundle.putString("ad_personalization", "denied");
                }
            }
        }
        this.zzb.zzc(bundle);
    }

    @Deprecated
    @MainThread
    @Keep
    public final void setCurrentScreen(@NonNull Activity activity, @Nullable @Size(min=1L, max=36L) String string, @Nullable @Size(min=1L, max=36L) String string2) {
        this.zzb.zza(activity, string, string2);
    }

    public final void setDefaultEventParameters(@Nullable Bundle bundle) {
        this.zzb.zzd(bundle);
    }

    public final void setSessionTimeoutDuration(long l) {
        this.zzb.zza(l);
    }

    public final void setUserId(@Nullable String string) {
        this.zzb.zzd(string);
    }

    public final void setUserProperty(@NonNull @Size(min=1L, max=24L) String string, @Nullable @Size(max=36L) String string2) {
        this.zzb.zzb(string, string2);
    }

    public static enum ConsentType {
        AD_STORAGE,
        ANALYTICS_STORAGE,
        AD_USER_DATA,
        AD_PERSONALIZATION;

    }

    public static enum ConsentStatus {
        GRANTED,
        DENIED;

    }

    public static class UserProperty {
        @NonNull
        public static final String SIGN_UP_METHOD = "sign_up_method";
        @NonNull
        public static final String ALLOW_AD_PERSONALIZATION_SIGNALS = "allow_personalized_ads";

        protected UserProperty() {
        }
    }

    public static class Param {
        @NonNull
        public static final String ACHIEVEMENT_ID = "achievement_id";
        @NonNull
        public static final String AD_FORMAT = "ad_format";
        @NonNull
        public static final String AD_PLATFORM = "ad_platform";
        @NonNull
        public static final String AD_SOURCE = "ad_source";
        @NonNull
        public static final String AD_UNIT_NAME = "ad_unit_name";
        @NonNull
        public static final String CHARACTER = "character";
        @NonNull
        public static final String TRAVEL_CLASS = "travel_class";
        @NonNull
        public static final String CONTENT_TYPE = "content_type";
        @NonNull
        public static final String CURRENCY = "currency";
        @NonNull
        public static final String COUPON = "coupon";
        @NonNull
        public static final String START_DATE = "start_date";
        @NonNull
        public static final String END_DATE = "end_date";
        @NonNull
        public static final String EXTEND_SESSION = "extend_session";
        @NonNull
        public static final String FLIGHT_NUMBER = "flight_number";
        @NonNull
        public static final String GROUP_ID = "group_id";
        @NonNull
        public static final String ITEM_CATEGORY = "item_category";
        @NonNull
        public static final String ITEM_ID = "item_id";
        @NonNull
        public static final String ITEM_NAME = "item_name";
        @NonNull
        public static final String LOCATION = "location";
        @NonNull
        public static final String LEVEL = "level";
        @NonNull
        public static final String LEVEL_NAME = "level_name";
        @NonNull
        public static final String METHOD = "method";
        @NonNull
        public static final String NUMBER_OF_NIGHTS = "number_of_nights";
        @NonNull
        public static final String NUMBER_OF_PASSENGERS = "number_of_passengers";
        @NonNull
        public static final String NUMBER_OF_ROOMS = "number_of_rooms";
        @NonNull
        public static final String DESTINATION = "destination";
        @NonNull
        public static final String ORIGIN = "origin";
        @NonNull
        public static final String PRICE = "price";
        @NonNull
        public static final String QUANTITY = "quantity";
        @NonNull
        public static final String SCORE = "score";
        @NonNull
        public static final String SHIPPING = "shipping";
        @NonNull
        public static final String TRANSACTION_ID = "transaction_id";
        @NonNull
        public static final String SEARCH_TERM = "search_term";
        @NonNull
        public static final String SUCCESS = "success";
        @NonNull
        public static final String TAX = "tax";
        @NonNull
        public static final String VALUE = "value";
        @NonNull
        public static final String VIRTUAL_CURRENCY_NAME = "virtual_currency_name";
        @NonNull
        public static final String CAMPAIGN = "campaign";
        @NonNull
        public static final String SOURCE = "source";
        @NonNull
        public static final String MEDIUM = "medium";
        @NonNull
        public static final String TERM = "term";
        @NonNull
        public static final String CONTENT = "content";
        @NonNull
        public static final String ACLID = "aclid";
        @NonNull
        public static final String CP1 = "cp1";
        @NonNull
        public static final String CAMPAIGN_ID = "campaign_id";
        @NonNull
        public static final String SOURCE_PLATFORM = "source_platform";
        @NonNull
        public static final String CREATIVE_FORMAT = "creative_format";
        @NonNull
        public static final String MARKETING_TACTIC = "marketing_tactic";
        @NonNull
        public static final String ITEM_BRAND = "item_brand";
        @NonNull
        public static final String ITEM_VARIANT = "item_variant";
        @NonNull
        public static final String CREATIVE_NAME = "creative_name";
        @NonNull
        public static final String CREATIVE_SLOT = "creative_slot";
        @NonNull
        public static final String AFFILIATION = "affiliation";
        @NonNull
        public static final String INDEX = "index";
        @NonNull
        public static final String DISCOUNT = "discount";
        @NonNull
        public static final String ITEM_CATEGORY2 = "item_category2";
        @NonNull
        public static final String ITEM_CATEGORY3 = "item_category3";
        @NonNull
        public static final String ITEM_CATEGORY4 = "item_category4";
        @NonNull
        public static final String ITEM_CATEGORY5 = "item_category5";
        @NonNull
        public static final String ITEM_LIST_ID = "item_list_id";
        @NonNull
        public static final String ITEM_LIST_NAME = "item_list_name";
        @NonNull
        public static final String ITEMS = "items";
        @NonNull
        public static final String LOCATION_ID = "location_id";
        @NonNull
        public static final String PAYMENT_TYPE = "payment_type";
        @NonNull
        public static final String PROMOTION_ID = "promotion_id";
        @NonNull
        public static final String PROMOTION_NAME = "promotion_name";
        @NonNull
        public static final String SCREEN_CLASS = "screen_class";
        @NonNull
        public static final String SCREEN_NAME = "screen_name";
        @NonNull
        public static final String SHIPPING_TIER = "shipping_tier";

        protected Param() {
        }
    }

    public static class Event {
        @NonNull
        public static final String AD_IMPRESSION = "ad_impression";
        @NonNull
        public static final String ADD_PAYMENT_INFO = "add_payment_info";
        @NonNull
        public static final String ADD_TO_CART = "add_to_cart";
        @NonNull
        public static final String ADD_TO_WISHLIST = "add_to_wishlist";
        @NonNull
        public static final String APP_OPEN = "app_open";
        @NonNull
        public static final String BEGIN_CHECKOUT = "begin_checkout";
        @NonNull
        public static final String CAMPAIGN_DETAILS = "campaign_details";
        @NonNull
        public static final String GENERATE_LEAD = "generate_lead";
        @NonNull
        public static final String JOIN_GROUP = "join_group";
        @NonNull
        public static final String LEVEL_END = "level_end";
        @NonNull
        public static final String LEVEL_START = "level_start";
        @NonNull
        public static final String LEVEL_UP = "level_up";
        @NonNull
        public static final String LOGIN = "login";
        @NonNull
        public static final String POST_SCORE = "post_score";
        @NonNull
        public static final String SEARCH = "search";
        @NonNull
        public static final String SELECT_CONTENT = "select_content";
        @NonNull
        public static final String SHARE = "share";
        @NonNull
        public static final String SIGN_UP = "sign_up";
        @NonNull
        public static final String SPEND_VIRTUAL_CURRENCY = "spend_virtual_currency";
        @NonNull
        public static final String TUTORIAL_BEGIN = "tutorial_begin";
        @NonNull
        public static final String TUTORIAL_COMPLETE = "tutorial_complete";
        @NonNull
        public static final String UNLOCK_ACHIEVEMENT = "unlock_achievement";
        @NonNull
        public static final String VIEW_ITEM = "view_item";
        @NonNull
        public static final String VIEW_ITEM_LIST = "view_item_list";
        @NonNull
        public static final String VIEW_SEARCH_RESULTS = "view_search_results";
        @NonNull
        public static final String EARN_VIRTUAL_CURRENCY = "earn_virtual_currency";
        @NonNull
        public static final String SCREEN_VIEW = "screen_view";
        @NonNull
        public static final String REMOVE_FROM_CART = "remove_from_cart";
        @NonNull
        public static final String ADD_SHIPPING_INFO = "add_shipping_info";
        @NonNull
        public static final String PURCHASE = "purchase";
        @NonNull
        public static final String REFUND = "refund";
        @NonNull
        public static final String SELECT_ITEM = "select_item";
        @NonNull
        public static final String SELECT_PROMOTION = "select_promotion";
        @NonNull
        public static final String VIEW_CART = "view_cart";
        @NonNull
        public static final String VIEW_PROMOTION = "view_promotion";

        protected Event() {
        }
    }
}

