/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.internal;

import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.maps.internal.zzc;
import com.google.android.gms.maps.model.RuntimeRemoteException;

public class zzai {
    private static Context apz;
    private static zzc apA;

    public static zzc zzdm(Context context) throws GooglePlayServicesNotAvailableException {
        zzaa.zzy((Object)context);
        if (apA != null) {
            return apA;
        }
        zzai.zzdn(context);
        apA = zzai.zzdo(context);
        try {
            apA.zzh(zze.zzac((Object)zzai.getRemoteContext(context).getResources()), GooglePlayServicesUtil.GOOGLE_PLAY_SERVICES_VERSION_CODE);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return apA;
    }

    private static void zzdn(Context context) throws GooglePlayServicesNotAvailableException {
        int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)context);
        switch (n) {
            case 0: {
                return;
            }
        }
        throw new GooglePlayServicesNotAvailableException(n);
    }

    private static zzc zzdo(Context context) {
        Log.i((String)zzai.class.getSimpleName(), (String)"Making Creator dynamically");
        IBinder iBinder = (IBinder)zzai.zza(zzai.getRemoteContext(context).getClassLoader(), "com.google.android.gms.maps.internal.CreatorImpl");
        return zzc.zza.zzhr(iBinder);
    }

    private static Context getRemoteContext(Context context) {
        if (apz == null) {
            apz = GooglePlayServicesUtil.getRemoteContext((Context)context);
        }
        return apz;
    }

    private static <T> T zza(ClassLoader classLoader, String string) {
        try {
            return zzai.zzf(((ClassLoader)zzaa.zzy((Object)classLoader)).loadClass(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string2 = String.valueOf(string);
            throw new IllegalStateException(string2.length() != 0 ? "Unable to find dynamic class ".concat(string2) : new String("Unable to find dynamic class "));
        }
    }

    private static <T> T zzf(Class<?> clazz) {
        try {
            return (T)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            String string = String.valueOf(clazz.getName());
            throw new IllegalStateException(string.length() != 0 ? "Unable to instantiate the dynamic class ".concat(string) : new String("Unable to instantiate the dynamic class "));
        }
        catch (IllegalAccessException illegalAccessException) {
            String string = String.valueOf(clazz.getName());
            throw new IllegalStateException(string.length() != 0 ? "Unable to call the default constructor of ".concat(string) : new String("Unable to call the default constructor of "));
        }
    }
}

