/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.IMapViewDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzai;
import com.google.android.gms.maps.internal.zzt;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.ArrayList;
import java.util.List;

public class MapView
extends FrameLayout {
    private final zzb aoP;

    public MapView(Context context) {
        super(context);
        this.aoP = new zzb((ViewGroup)this, context, null);
        this.zzbsq();
    }

    public MapView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.aoP = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attributeSet));
        this.zzbsq();
    }

    public MapView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.aoP = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attributeSet));
        this.zzbsq();
    }

    public MapView(Context context, GoogleMapOptions googleMapOptions) {
        super(context);
        this.aoP = new zzb((ViewGroup)this, context, googleMapOptions);
        this.zzbsq();
    }

    private void zzbsq() {
        this.setClickable(true);
    }

    public final void onCreate(Bundle bundle) {
        this.aoP.onCreate(bundle);
        if (this.aoP.zzbdo() == null) {
            com.google.android.gms.dynamic.zza.zzb((FrameLayout)this);
        }
    }

    public final void onResume() {
        this.aoP.onResume();
    }

    public final void onPause() {
        this.aoP.onPause();
    }

    public final void onStart() {
        this.aoP.onStart();
    }

    public final void onStop() {
        this.aoP.onStop();
    }

    public final void onDestroy() {
        this.aoP.onDestroy();
    }

    public final void onLowMemory() {
        this.aoP.onLowMemory();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        this.aoP.onSaveInstanceState(bundle);
    }

    public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
        zzaa.zzhs((String)"getMapAsync() must be called on the main thread");
        this.aoP.getMapAsync(onMapReadyCallback);
    }

    public final void onEnterAmbient(Bundle bundle) {
        zzaa.zzhs((String)"onEnterAmbient() must be called on the main thread");
        this.aoP.onEnterAmbient(bundle);
    }

    public final void onExitAmbient() {
        zzaa.zzhs((String)"onExitAmbient() must be called on the main thread");
        this.aoP.onExitAmbient();
    }

    static class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final ViewGroup aoU;
        private final Context mContext;
        protected zzf<zza> aoN;
        private final GoogleMapOptions aoV;
        private final List<OnMapReadyCallback> aoO = new ArrayList<OnMapReadyCallback>();

        zzb(ViewGroup viewGroup, Context context, GoogleMapOptions googleMapOptions) {
            this.aoU = viewGroup;
            this.mContext = context;
            this.aoV = googleMapOptions;
        }

        protected void zza(zzf<zza> zzf2) {
            this.aoN = zzf2;
            this.zzbsp();
        }

        public void zzbsp() {
            if (this.aoN != null && this.zzbdo() == null) {
                try {
                    MapsInitializer.initialize(this.mContext);
                    IMapViewDelegate iMapViewDelegate = zzai.zzdm(this.mContext).zza(zze.zzac((Object)this.mContext), this.aoV);
                    if (iMapViewDelegate == null) {
                        return;
                    }
                    this.aoN.zza((LifecycleDelegate)new zza(this.aoU, iMapViewDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : this.aoO) {
                        ((zza)this.zzbdo()).getMapAsync(onMapReadyCallback);
                    }
                    this.aoO.clear();
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    // empty catch block
                }
            }
        }

        public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            if (this.zzbdo() != null) {
                ((zza)this.zzbdo()).getMapAsync(onMapReadyCallback);
            } else {
                this.aoO.add(onMapReadyCallback);
            }
        }

        public void onEnterAmbient(Bundle bundle) {
            if (this.zzbdo() != null) {
                ((zza)this.zzbdo()).onEnterAmbient(bundle);
            }
        }

        public void onExitAmbient() {
            if (this.zzbdo() != null) {
                ((zza)this.zzbdo()).onExitAmbient();
            }
        }
    }

    static class zza
    implements MapLifecycleDelegate {
        private final ViewGroup aoQ;
        private final IMapViewDelegate aoR;
        private View aoS;

        public zza(ViewGroup viewGroup, IMapViewDelegate iMapViewDelegate) {
            this.aoR = (IMapViewDelegate)zzaa.zzy((Object)iMapViewDelegate);
            this.aoQ = (ViewGroup)zzaa.zzy((Object)viewGroup);
        }

        public void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            throw new UnsupportedOperationException("onInflate not allowed on MapViewDelegate");
        }

        public void onCreate(Bundle bundle) {
            try {
                this.aoR.onCreate(bundle);
                this.aoS = (View)zze.zzae((zzd)this.aoR.getView());
                this.aoQ.removeAllViews();
                this.aoQ.addView(this.aoS);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            throw new UnsupportedOperationException("onCreateView not allowed on MapViewDelegate");
        }

        public void onStart() {
            try {
                this.aoR.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onResume() {
            try {
                this.aoR.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.aoR.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onStop() {
            try {
                this.aoR.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onDestroyView() {
            throw new UnsupportedOperationException("onDestroyView not allowed on MapViewDelegate");
        }

        public void onDestroy() {
            try {
                this.aoR.onDestroy();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onLowMemory() {
            try {
                this.aoR.onLowMemory();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onSaveInstanceState(Bundle bundle) {
            try {
                this.aoR.onSaveInstanceState(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void getMapAsync(final OnMapReadyCallback onMapReadyCallback) {
            try {
                this.aoR.getMapAsync(new zzt.zza(){

                    @Override
                    public void zza(IGoogleMapDelegate iGoogleMapDelegate) throws RemoteException {
                        onMapReadyCallback.onMapReady(new GoogleMap(iGoogleMapDelegate));
                    }
                });
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onEnterAmbient(Bundle bundle) {
            try {
                this.aoR.onEnterAmbient(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onExitAmbient() {
            try {
                this.aoR.onExitAmbient();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

