/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.maps.internal.zza;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLngBounds;

public final class GoogleMapOptions
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final Parcelable.Creator<GoogleMapOptions> CREATOR = new com.google.android.gms.maps.zza();
    private final int mVersionCode;
    private Boolean aot;
    private Boolean aou;
    private int aov = -1;
    private CameraPosition aow;
    private Boolean aox;
    private Boolean aoy;
    private Boolean aoz;
    private Boolean aoA;
    private Boolean aoB;
    private Boolean aoC;
    private Boolean aoD;
    private Boolean aoE;
    private Boolean aoF;
    private Float aoG = null;
    private Float aoH = null;
    private LatLngBounds aoI = null;

    GoogleMapOptions(int n, byte by, byte by2, int n2, CameraPosition cameraPosition, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8, byte by9, byte by10, byte by11, Float f, Float f2, LatLngBounds latLngBounds) {
        this.mVersionCode = n;
        this.aot = zza.zza(by);
        this.aou = zza.zza(by2);
        this.aov = n2;
        this.aow = cameraPosition;
        this.aox = zza.zza(by3);
        this.aoy = zza.zza(by4);
        this.aoz = zza.zza(by5);
        this.aoA = zza.zza(by6);
        this.aoB = zza.zza(by7);
        this.aoC = zza.zza(by8);
        this.aoD = zza.zza(by9);
        this.aoE = zza.zza(by10);
        this.aoF = zza.zza(by11);
        this.aoG = f;
        this.aoH = f2;
        this.aoI = latLngBounds;
    }

    public void writeToParcel(Parcel parcel, int n) {
        com.google.android.gms.maps.zza.zza(this, parcel, n);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    byte zzbse() {
        return zza.zze(this.aot);
    }

    byte zzbsf() {
        return zza.zze(this.aou);
    }

    byte zzbsg() {
        return zza.zze(this.aox);
    }

    byte zzbsh() {
        return zza.zze(this.aoy);
    }

    byte zzbsi() {
        return zza.zze(this.aoz);
    }

    byte zzbsj() {
        return zza.zze(this.aoA);
    }

    byte zzbsk() {
        return zza.zze(this.aoB);
    }

    byte zzbsl() {
        return zza.zze(this.aoC);
    }

    byte zzbsm() {
        return zza.zze(this.aoD);
    }

    byte zzbsn() {
        return zza.zze(this.aoE);
    }

    byte zzbso() {
        return zza.zze(this.aoF);
    }

    public GoogleMapOptions() {
        this.mVersionCode = 1;
    }

    public GoogleMapOptions zOrderOnTop(boolean bl) {
        this.aot = bl;
        return this;
    }

    public GoogleMapOptions useViewLifecycleInFragment(boolean bl) {
        this.aou = bl;
        return this;
    }

    public GoogleMapOptions mapType(int n) {
        this.aov = n;
        return this;
    }

    public GoogleMapOptions camera(CameraPosition cameraPosition) {
        this.aow = cameraPosition;
        return this;
    }

    public GoogleMapOptions zoomControlsEnabled(boolean bl) {
        this.aox = bl;
        return this;
    }

    public GoogleMapOptions compassEnabled(boolean bl) {
        this.aoy = bl;
        return this;
    }

    public GoogleMapOptions scrollGesturesEnabled(boolean bl) {
        this.aoz = bl;
        return this;
    }

    public GoogleMapOptions zoomGesturesEnabled(boolean bl) {
        this.aoA = bl;
        return this;
    }

    public GoogleMapOptions tiltGesturesEnabled(boolean bl) {
        this.aoB = bl;
        return this;
    }

    public GoogleMapOptions rotateGesturesEnabled(boolean bl) {
        this.aoC = bl;
        return this;
    }

    public GoogleMapOptions liteMode(boolean bl) {
        this.aoD = bl;
        return this;
    }

    public GoogleMapOptions mapToolbarEnabled(boolean bl) {
        this.aoE = bl;
        return this;
    }

    public GoogleMapOptions ambientEnabled(boolean bl) {
        this.aoF = bl;
        return this;
    }

    public GoogleMapOptions minZoomPreference(float f) {
        this.aoG = Float.valueOf(f);
        return this;
    }

    public GoogleMapOptions maxZoomPreference(float f) {
        this.aoH = Float.valueOf(f);
        return this;
    }

    public GoogleMapOptions latLngBoundsForCameraTarget(LatLngBounds latLngBounds) {
        this.aoI = latLngBounds;
        return this;
    }

    public Boolean getZOrderOnTop() {
        return this.aot;
    }

    public Boolean getUseViewLifecycleInFragment() {
        return this.aou;
    }

    public int getMapType() {
        return this.aov;
    }

    public CameraPosition getCamera() {
        return this.aow;
    }

    public Boolean getZoomControlsEnabled() {
        return this.aox;
    }

    public Boolean getCompassEnabled() {
        return this.aoy;
    }

    public Boolean getScrollGesturesEnabled() {
        return this.aoz;
    }

    public Boolean getZoomGesturesEnabled() {
        return this.aoA;
    }

    public Boolean getTiltGesturesEnabled() {
        return this.aoB;
    }

    public Boolean getRotateGesturesEnabled() {
        return this.aoC;
    }

    public Boolean getLiteMode() {
        return this.aoD;
    }

    public Boolean getMapToolbarEnabled() {
        return this.aoE;
    }

    public Boolean getAmbientEnabled() {
        return this.aoF;
    }

    public Float getMinZoomPreference() {
        return this.aoG;
    }

    public Float getMaxZoomPreference() {
        return this.aoH;
    }

    public LatLngBounds getLatLngBoundsForCameraTarget() {
        return this.aoI;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(R.styleable.MapAttrs_mapType)) {
            googleMapOptions.mapType(typedArray.getInt(R.styleable.MapAttrs_mapType, -1));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_zOrderOnTop)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(R.styleable.MapAttrs_zOrderOnTop, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_useViewLifecycle)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(R.styleable.MapAttrs_useViewLifecycle, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiCompass)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiCompass, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiRotateGestures)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiRotateGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGestures)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiTiltGestures)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiTiltGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomGestures)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomControls)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomControls, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_liteMode)) {
            googleMapOptions.liteMode(typedArray.getBoolean(R.styleable.MapAttrs_liteMode, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiMapToolbar)) {
            googleMapOptions.mapToolbarEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiMapToolbar, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_ambientEnabled)) {
            googleMapOptions.ambientEnabled(typedArray.getBoolean(R.styleable.MapAttrs_ambientEnabled, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.minZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMinZoomPreference, Float.NEGATIVE_INFINITY));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.maxZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMaxZoomPreference, Float.POSITIVE_INFINITY));
        }
        LatLngBounds latLngBounds = LatLngBounds.createFromAttributes(context, attributeSet);
        googleMapOptions.latLngBoundsForCameraTarget(latLngBounds);
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attributeSet);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }
}

