/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.IMapFragmentDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzah;
import com.google.android.gms.maps.internal.zzai;
import com.google.android.gms.maps.internal.zzt;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=11)
public class MapFragment
extends Fragment {
    private final zzb alC = new zzb(this);

    public static MapFragment newInstance() {
        return new MapFragment();
    }

    public static MapFragment newInstance(GoogleMapOptions googleMapOptions) {
        MapFragment mapFragment = new MapFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)googleMapOptions);
        mapFragment.setArguments(bundle);
        return mapFragment;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.alC.setActivity(activity);
    }

    @SuppressLint(value={"NewApi"})
    public void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        this.alC.setActivity(activity);
        GoogleMapOptions googleMapOptions = GoogleMapOptions.createFromAttributes((Context)activity, attributeSet);
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("MapOptions", (Parcelable)googleMapOptions);
        this.alC.onInflate(activity, bundle2, bundle);
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.alC.onCreate(bundle);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = this.alC.onCreateView(layoutInflater, viewGroup, bundle);
        view.setClickable(true);
        return view;
    }

    public void onResume() {
        super.onResume();
        this.alC.onResume();
    }

    public void onPause() {
        this.alC.onPause();
        super.onPause();
    }

    public void onStart() {
        super.onStart();
        this.alC.onStart();
    }

    public void onStop() {
        this.alC.onStop();
        super.onStop();
    }

    public void onDestroyView() {
        this.alC.onDestroyView();
        super.onDestroyView();
    }

    public void onDestroy() {
        this.alC.onDestroy();
        super.onDestroy();
    }

    public void onLowMemory() {
        this.alC.onLowMemory();
        super.onLowMemory();
    }

    public void onActivityCreated(Bundle bundle) {
        if (bundle != null) {
            bundle.setClassLoader(MapFragment.class.getClassLoader());
        }
        super.onActivityCreated(bundle);
    }

    public void onSaveInstanceState(Bundle bundle) {
        if (bundle != null) {
            bundle.setClassLoader(MapFragment.class.getClassLoader());
        }
        super.onSaveInstanceState(bundle);
        this.alC.onSaveInstanceState(bundle);
    }

    public final void onEnterAmbient(Bundle bundle) {
        zzac.zzhq((String)"onEnterAmbient must be called on the main thread.");
        this.alC.onEnterAmbient(bundle);
    }

    public final void onExitAmbient() {
        zzac.zzhq((String)"onExitAmbient must be called on the main thread.");
        this.alC.onExitAmbient();
    }

    public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
        zzac.zzhq((String)"getMapAsync must be called on the main thread.");
        this.alC.getMapAsync(onMapReadyCallback);
    }

    public void setArguments(Bundle bundle) {
        super.setArguments(bundle);
    }

    static class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final Fragment Os;
        protected zzf<zza> alG;
        private Activity mActivity;
        private final List<OnMapReadyCallback> alH = new ArrayList<OnMapReadyCallback>();

        zzb(Fragment fragment) {
            this.Os = fragment;
        }

        protected void zza(zzf<zza> zzf2) {
            this.alG = zzf2;
            this.zzbru();
        }

        public void zzbru() {
            if (this.mActivity != null && this.alG != null && this.zzbdt() == null) {
                try {
                    MapsInitializer.initialize((Context)this.mActivity);
                    IMapFragmentDelegate iMapFragmentDelegate = zzai.zzdp((Context)this.mActivity).zzah(zze.zzac((Object)this.mActivity));
                    if (iMapFragmentDelegate == null) {
                        return;
                    }
                    this.alG.zza((LifecycleDelegate)new zza(this.Os, iMapFragmentDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : this.alH) {
                        ((zza)this.zzbdt()).getMapAsync(onMapReadyCallback);
                    }
                    this.alH.clear();
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    // empty catch block
                }
            }
        }

        private void setActivity(Activity activity) {
            this.mActivity = activity;
            this.zzbru();
        }

        public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            if (this.zzbdt() != null) {
                ((zza)this.zzbdt()).getMapAsync(onMapReadyCallback);
            } else {
                this.alH.add(onMapReadyCallback);
            }
        }

        public void onEnterAmbient(Bundle bundle) {
            if (this.zzbdt() != null) {
                ((zza)this.zzbdt()).onEnterAmbient(bundle);
            }
        }

        public void onExitAmbient() {
            if (this.zzbdt() != null) {
                ((zza)this.zzbdt()).onExitAmbient();
            }
        }
    }

    static class zza
    implements MapLifecycleDelegate {
        private final Fragment Os;
        private final IMapFragmentDelegate alD;

        public zza(Fragment fragment, IMapFragmentDelegate iMapFragmentDelegate) {
            this.alD = (IMapFragmentDelegate)zzac.zzy((Object)iMapFragmentDelegate);
            this.Os = (Fragment)zzac.zzy((Object)fragment);
        }

        public void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            GoogleMapOptions googleMapOptions = (GoogleMapOptions)bundle.getParcelable("MapOptions");
            try {
                this.alD.onInflate(zze.zzac((Object)activity), googleMapOptions, bundle2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onCreate(Bundle bundle) {
            try {
                Bundle bundle2;
                if (bundle == null) {
                    bundle = new Bundle();
                }
                if ((bundle2 = this.Os.getArguments()) != null && bundle2.containsKey("MapOptions")) {
                    zzah.zza(bundle, "MapOptions", bundle2.getParcelable("MapOptions"));
                }
                this.alD.onCreate(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            zzd zzd2;
            try {
                zzd2 = this.alD.onCreateView(zze.zzac((Object)layoutInflater), zze.zzac((Object)viewGroup), bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
            return (View)zze.zzae((zzd)zzd2);
        }

        public void onStart() {
            try {
                this.alD.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onResume() {
            try {
                this.alD.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.alD.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onStop() {
            try {
                this.alD.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onDestroyView() {
            try {
                this.alD.onDestroyView();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onDestroy() {
            try {
                this.alD.onDestroy();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onLowMemory() {
            try {
                this.alD.onLowMemory();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onSaveInstanceState(Bundle bundle) {
            try {
                this.alD.onSaveInstanceState(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void getMapAsync(final OnMapReadyCallback onMapReadyCallback) {
            try {
                this.alD.getMapAsync(new zzt.zza(){

                    @Override
                    public void zza(IGoogleMapDelegate iGoogleMapDelegate) throws RemoteException {
                        onMapReadyCallback.onMapReady(new GoogleMap(iGoogleMapDelegate));
                    }
                });
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onEnterAmbient(Bundle bundle) {
            try {
                this.alD.onEnterAmbient(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onExitAmbient() {
            try {
                this.alD.onExitAmbient();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

