/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.maps.internal.zza;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLngBounds;

public final class GoogleMapOptions
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final com.google.android.gms.maps.zza CREATOR = new com.google.android.gms.maps.zza();
    private final int mVersionCode;
    private Boolean alm;
    private Boolean aln;
    private int alo = -1;
    private CameraPosition alp;
    private Boolean alq;
    private Boolean alr;
    private Boolean als;
    private Boolean alt;
    private Boolean alu;
    private Boolean alv;
    private Boolean alw;
    private Boolean alx;
    private Boolean aly;
    private Float alz = null;
    private Float alA = null;
    private LatLngBounds alB = null;

    GoogleMapOptions(int n, byte by, byte by2, int n2, CameraPosition cameraPosition, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8, byte by9, byte by10, byte by11, Float f, Float f2, LatLngBounds latLngBounds) {
        this.mVersionCode = n;
        this.alm = zza.zza(by);
        this.aln = zza.zza(by2);
        this.alo = n2;
        this.alp = cameraPosition;
        this.alq = zza.zza(by3);
        this.alr = zza.zza(by4);
        this.als = zza.zza(by5);
        this.alt = zza.zza(by6);
        this.alu = zza.zza(by7);
        this.alv = zza.zza(by8);
        this.alw = zza.zza(by9);
        this.alx = zza.zza(by10);
        this.aly = zza.zza(by11);
        this.alz = f;
        this.alA = f2;
        this.alB = latLngBounds;
    }

    public void writeToParcel(Parcel parcel, int n) {
        com.google.android.gms.maps.zza.zza(this, parcel, n);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    byte zzbrj() {
        return zza.zze(this.alm);
    }

    byte zzbrk() {
        return zza.zze(this.aln);
    }

    byte zzbrl() {
        return zza.zze(this.alq);
    }

    byte zzbrm() {
        return zza.zze(this.alr);
    }

    byte zzbrn() {
        return zza.zze(this.als);
    }

    byte zzbro() {
        return zza.zze(this.alt);
    }

    byte zzbrp() {
        return zza.zze(this.alu);
    }

    byte zzbrq() {
        return zza.zze(this.alv);
    }

    byte zzbrr() {
        return zza.zze(this.alw);
    }

    byte zzbrs() {
        return zza.zze(this.alx);
    }

    byte zzbrt() {
        return zza.zze(this.aly);
    }

    public GoogleMapOptions() {
        this.mVersionCode = 1;
    }

    public GoogleMapOptions zOrderOnTop(boolean bl) {
        this.alm = bl;
        return this;
    }

    public GoogleMapOptions useViewLifecycleInFragment(boolean bl) {
        this.aln = bl;
        return this;
    }

    public GoogleMapOptions mapType(int n) {
        this.alo = n;
        return this;
    }

    public GoogleMapOptions camera(CameraPosition cameraPosition) {
        this.alp = cameraPosition;
        return this;
    }

    public GoogleMapOptions zoomControlsEnabled(boolean bl) {
        this.alq = bl;
        return this;
    }

    public GoogleMapOptions compassEnabled(boolean bl) {
        this.alr = bl;
        return this;
    }

    public GoogleMapOptions scrollGesturesEnabled(boolean bl) {
        this.als = bl;
        return this;
    }

    public GoogleMapOptions zoomGesturesEnabled(boolean bl) {
        this.alt = bl;
        return this;
    }

    public GoogleMapOptions tiltGesturesEnabled(boolean bl) {
        this.alu = bl;
        return this;
    }

    public GoogleMapOptions rotateGesturesEnabled(boolean bl) {
        this.alv = bl;
        return this;
    }

    public GoogleMapOptions liteMode(boolean bl) {
        this.alw = bl;
        return this;
    }

    public GoogleMapOptions mapToolbarEnabled(boolean bl) {
        this.alx = bl;
        return this;
    }

    public GoogleMapOptions ambientEnabled(boolean bl) {
        this.aly = bl;
        return this;
    }

    public GoogleMapOptions minZoomPreference(float f) {
        this.alz = Float.valueOf(f);
        return this;
    }

    public GoogleMapOptions maxZoomPreference(float f) {
        this.alA = Float.valueOf(f);
        return this;
    }

    public GoogleMapOptions latLngBoundsForCameraTarget(LatLngBounds latLngBounds) {
        this.alB = latLngBounds;
        return this;
    }

    public Boolean getZOrderOnTop() {
        return this.alm;
    }

    public Boolean getUseViewLifecycleInFragment() {
        return this.aln;
    }

    public int getMapType() {
        return this.alo;
    }

    public CameraPosition getCamera() {
        return this.alp;
    }

    public Boolean getZoomControlsEnabled() {
        return this.alq;
    }

    public Boolean getCompassEnabled() {
        return this.alr;
    }

    public Boolean getScrollGesturesEnabled() {
        return this.als;
    }

    public Boolean getZoomGesturesEnabled() {
        return this.alt;
    }

    public Boolean getTiltGesturesEnabled() {
        return this.alu;
    }

    public Boolean getRotateGesturesEnabled() {
        return this.alv;
    }

    public Boolean getLiteMode() {
        return this.alw;
    }

    public Boolean getMapToolbarEnabled() {
        return this.alx;
    }

    public Boolean getAmbientEnabled() {
        return this.aly;
    }

    public Float getMinZoomPreference() {
        return this.alz;
    }

    public Float getMaxZoomPreference() {
        return this.alA;
    }

    public LatLngBounds getLatLngBoundsForCameraTarget() {
        return this.alB;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(R.styleable.MapAttrs_mapType)) {
            googleMapOptions.mapType(typedArray.getInt(R.styleable.MapAttrs_mapType, -1));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_zOrderOnTop)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(R.styleable.MapAttrs_zOrderOnTop, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_useViewLifecycle)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(R.styleable.MapAttrs_useViewLifecycle, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiCompass)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiCompass, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiRotateGestures)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiRotateGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGestures)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiTiltGestures)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiTiltGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomGestures)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomControls)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomControls, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_liteMode)) {
            googleMapOptions.liteMode(typedArray.getBoolean(R.styleable.MapAttrs_liteMode, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiMapToolbar)) {
            googleMapOptions.mapToolbarEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiMapToolbar, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_ambientEnabled)) {
            googleMapOptions.ambientEnabled(typedArray.getBoolean(R.styleable.MapAttrs_ambientEnabled, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.minZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMinZoomPreference, Float.NEGATIVE_INFINITY));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.maxZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMaxZoomPreference, Float.POSITIVE_INFINITY));
        }
        LatLngBounds latLngBounds = LatLngBounds.createFromAttributes(context, attributeSet);
        googleMapOptions.latLngBoundsForCameraTarget(latLngBounds);
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attributeSet);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }
}

