/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.zzh;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolygonOptions
extends AbstractSafeParcelable {
    public static final zzh CREATOR = new zzh();
    private final int mVersionCode;
    private final List<LatLng> ahr;
    private final List<List<LatLng>> ahs;
    private float mStrokeWidth = 10.0f;
    private int mStrokeColor = -16777216;
    private int mFillColor = 0;
    private float agP = 0.0f;
    private boolean agQ = true;
    private boolean aht = false;
    private boolean agR = false;

    public PolygonOptions() {
        this.mVersionCode = 1;
        this.ahr = new ArrayList<LatLng>();
        this.ahs = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(int n, List<LatLng> list, List list2, float f, int n2, int n3, float f2, boolean bl, boolean bl2, boolean bl3) {
        this.mVersionCode = n;
        this.ahr = list;
        this.ahs = list2;
        this.mStrokeWidth = f;
        this.mStrokeColor = n2;
        this.mFillColor = n3;
        this.agP = f2;
        this.agQ = bl;
        this.aht = bl2;
        this.agR = bl3;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    List zzbpl() {
        return this.ahs;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzh.zza(this, parcel, n);
    }

    public PolygonOptions add(LatLng latLng) {
        this.ahr.add(latLng);
        return this;
    }

    public PolygonOptions add(LatLng ... latLngArray) {
        this.ahr.addAll(Arrays.asList(latLngArray));
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> iterable) {
        for (LatLng latLng : iterable) {
            this.ahr.add(latLng);
        }
        return this;
    }

    public PolygonOptions addHole(Iterable<LatLng> iterable) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : iterable) {
            arrayList.add(latLng);
        }
        this.ahs.add(arrayList);
        return this;
    }

    public PolygonOptions strokeWidth(float f) {
        this.mStrokeWidth = f;
        return this;
    }

    public PolygonOptions strokeColor(int n) {
        this.mStrokeColor = n;
        return this;
    }

    public PolygonOptions fillColor(int n) {
        this.mFillColor = n;
        return this;
    }

    public PolygonOptions zIndex(float f) {
        this.agP = f;
        return this;
    }

    public PolygonOptions visible(boolean bl) {
        this.agQ = bl;
        return this;
    }

    public PolygonOptions geodesic(boolean bl) {
        this.aht = bl;
        return this;
    }

    public PolygonOptions clickable(boolean bl) {
        this.agR = bl;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.ahr;
    }

    public List<List<LatLng>> getHoles() {
        return this.ahs;
    }

    public float getStrokeWidth() {
        return this.mStrokeWidth;
    }

    public int getStrokeColor() {
        return this.mStrokeColor;
    }

    public int getFillColor() {
        return this.mFillColor;
    }

    public float getZIndex() {
        return this.agP;
    }

    public boolean isVisible() {
        return this.agQ;
    }

    public boolean isGeodesic() {
        return this.aht;
    }

    public boolean isClickable() {
        return this.agR;
    }
}

