/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.zzc;

public final class GroundOverlayOptions
extends AbstractSafeParcelable {
    public static final zzc CREATOR = new zzc();
    public static final float NO_DIMENSION = -1.0f;
    private final int mVersionCode;
    private BitmapDescriptor agT;
    private LatLng agU;
    private float agV;
    private float agW;
    private LatLngBounds aeO;
    private float agL;
    private float agP;
    private boolean agQ = true;
    private float agX = 0.0f;
    private float agY = 0.5f;
    private float agZ = 0.5f;
    private boolean agR = false;

    GroundOverlayOptions(int n, IBinder iBinder, LatLng latLng, float f, float f2, LatLngBounds latLngBounds, float f3, float f4, boolean bl, float f5, float f6, float f7, boolean bl2) {
        this.mVersionCode = n;
        this.agT = new BitmapDescriptor(zzd.zza.zzfc((IBinder)iBinder));
        this.agU = latLng;
        this.agV = f;
        this.agW = f2;
        this.aeO = latLngBounds;
        this.agL = f3;
        this.agP = f4;
        this.agQ = bl;
        this.agX = f5;
        this.agY = f6;
        this.agZ = f7;
        this.agR = bl2;
    }

    public GroundOverlayOptions() {
        this.mVersionCode = 1;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzc.zza(this, parcel, n);
    }

    IBinder zzbpj() {
        return this.agT.zzboj().asBinder();
    }

    public GroundOverlayOptions image(BitmapDescriptor bitmapDescriptor) {
        this.agT = bitmapDescriptor;
        return this;
    }

    public GroundOverlayOptions anchor(float f, float f2) {
        this.agY = f;
        this.agZ = f2;
        return this;
    }

    public GroundOverlayOptions position(LatLng latLng, float f) {
        zzab.zza((this.aeO == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzab.zzb((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzab.zzb((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        return this.zza(latLng, f, -1.0f);
    }

    public GroundOverlayOptions position(LatLng latLng, float f, float f2) {
        zzab.zza((this.aeO == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzab.zzb((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzab.zzb((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        zzab.zzb((f2 >= 0.0f ? 1 : 0) != 0, (Object)"Height must be non-negative");
        return this.zza(latLng, f, f2);
    }

    private GroundOverlayOptions zza(LatLng latLng, float f, float f2) {
        this.agU = latLng;
        this.agV = f;
        this.agW = f2;
        return this;
    }

    public GroundOverlayOptions positionFromBounds(LatLngBounds latLngBounds) {
        String string = String.valueOf((Object)this.agU);
        zzab.zza((this.agU == null ? 1 : 0) != 0, (Object)new StringBuilder(46 + String.valueOf(string).length()).append("Position has already been set using position: ").append(string).toString());
        this.aeO = latLngBounds;
        return this;
    }

    public GroundOverlayOptions bearing(float f) {
        this.agL = (f % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public GroundOverlayOptions zIndex(float f) {
        this.agP = f;
        return this;
    }

    public GroundOverlayOptions visible(boolean bl) {
        this.agQ = bl;
        return this;
    }

    public GroundOverlayOptions transparency(float f) {
        zzab.zzb((f >= 0.0f && f <= 1.0f ? 1 : 0) != 0, (Object)"Transparency must be in the range [0..1]");
        this.agX = f;
        return this;
    }

    public GroundOverlayOptions clickable(boolean bl) {
        this.agR = bl;
        return this;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public BitmapDescriptor getImage() {
        return this.agT;
    }

    public LatLng getLocation() {
        return this.agU;
    }

    public float getWidth() {
        return this.agV;
    }

    public float getHeight() {
        return this.agW;
    }

    public LatLngBounds getBounds() {
        return this.aeO;
    }

    public float getBearing() {
        return this.agL;
    }

    public float getZIndex() {
        return this.agP;
    }

    public float getTransparency() {
        return this.agX;
    }

    public float getAnchorU() {
        return this.agY;
    }

    public float getAnchorV() {
        return this.agZ;
    }

    public boolean isVisible() {
        return this.agQ;
    }

    public boolean isClickable() {
        return this.agR;
    }
}

