/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.IMapViewDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzai;
import com.google.android.gms.maps.internal.zzt;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.ArrayList;
import java.util.List;

public class MapView
extends FrameLayout {
    private final zzb afU;

    public MapView(Context context) {
        super(context);
        this.afU = new zzb((ViewGroup)this, context, null);
        this.zzbox();
    }

    public MapView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.afU = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attributeSet));
        this.zzbox();
    }

    public MapView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.afU = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attributeSet));
        this.zzbox();
    }

    public MapView(Context context, GoogleMapOptions googleMapOptions) {
        super(context);
        this.afU = new zzb((ViewGroup)this, context, googleMapOptions);
        this.zzbox();
    }

    private void zzbox() {
        this.setClickable(true);
    }

    public final void onCreate(Bundle bundle) {
        this.afU.onCreate(bundle);
        if (this.afU.zzbbt() == null) {
            com.google.android.gms.dynamic.zza.zzb((FrameLayout)this);
        }
    }

    public final void onResume() {
        this.afU.onResume();
    }

    public final void onPause() {
        this.afU.onPause();
    }

    public final void onDestroy() {
        this.afU.onDestroy();
    }

    public final void onLowMemory() {
        this.afU.onLowMemory();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        this.afU.onSaveInstanceState(bundle);
    }

    public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
        zzab.zzhi((String)"getMapAsync() must be called on the main thread");
        this.afU.getMapAsync(onMapReadyCallback);
    }

    public final void onEnterAmbient(Bundle bundle) {
        zzab.zzhi((String)"onEnterAmbient() must be called on the main thread");
        this.afU.onEnterAmbient(bundle);
    }

    public final void onExitAmbient() {
        zzab.zzhi((String)"onExitAmbient() must be called on the main thread");
        this.afU.onExitAmbient();
    }

    static class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final ViewGroup afZ;
        private final Context mContext;
        protected zzf<zza> afS;
        private final GoogleMapOptions aga;
        private final List<OnMapReadyCallback> afT = new ArrayList<OnMapReadyCallback>();

        zzb(ViewGroup viewGroup, Context context, GoogleMapOptions googleMapOptions) {
            this.afZ = viewGroup;
            this.mContext = context;
            this.aga = googleMapOptions;
        }

        protected void zza(zzf<zza> zzf2) {
            this.afS = zzf2;
            this.zzbow();
        }

        public void zzbow() {
            if (this.afS != null && this.zzbbt() == null) {
                try {
                    MapsInitializer.initialize(this.mContext);
                    IMapViewDelegate iMapViewDelegate = zzai.zzdk(this.mContext).zza(zze.zzac((Object)this.mContext), this.aga);
                    if (iMapViewDelegate == null) {
                        return;
                    }
                    this.afS.zza((LifecycleDelegate)new zza(this.afZ, iMapViewDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : this.afT) {
                        ((zza)this.zzbbt()).getMapAsync(onMapReadyCallback);
                    }
                    this.afT.clear();
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    // empty catch block
                }
            }
        }

        public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            if (this.zzbbt() != null) {
                ((zza)this.zzbbt()).getMapAsync(onMapReadyCallback);
            } else {
                this.afT.add(onMapReadyCallback);
            }
        }

        public void onEnterAmbient(Bundle bundle) {
            if (this.zzbbt() != null) {
                ((zza)this.zzbbt()).onEnterAmbient(bundle);
            }
        }

        public void onExitAmbient() {
            if (this.zzbbt() != null) {
                ((zza)this.zzbbt()).onExitAmbient();
            }
        }
    }

    static class zza
    implements MapLifecycleDelegate {
        private final ViewGroup afV;
        private final IMapViewDelegate afW;
        private View afX;

        public zza(ViewGroup viewGroup, IMapViewDelegate iMapViewDelegate) {
            this.afW = (IMapViewDelegate)zzab.zzy((Object)iMapViewDelegate);
            this.afV = (ViewGroup)zzab.zzy((Object)viewGroup);
        }

        public void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            throw new UnsupportedOperationException("onInflate not allowed on MapViewDelegate");
        }

        public void onCreate(Bundle bundle) {
            try {
                this.afW.onCreate(bundle);
                this.afX = (View)zze.zzad((zzd)this.afW.getView());
                this.afV.removeAllViews();
                this.afV.addView(this.afX);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            throw new UnsupportedOperationException("onCreateView not allowed on MapViewDelegate");
        }

        public void onStart() {
        }

        public void onResume() {
            try {
                this.afW.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.afW.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onStop() {
        }

        public void onDestroyView() {
            throw new UnsupportedOperationException("onDestroyView not allowed on MapViewDelegate");
        }

        public void onDestroy() {
            try {
                this.afW.onDestroy();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onLowMemory() {
            try {
                this.afW.onLowMemory();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onSaveInstanceState(Bundle bundle) {
            try {
                this.afW.onSaveInstanceState(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void getMapAsync(final OnMapReadyCallback onMapReadyCallback) {
            try {
                this.afW.getMapAsync(new zzt.zza(){

                    @Override
                    public void zza(IGoogleMapDelegate iGoogleMapDelegate) throws RemoteException {
                        onMapReadyCallback.onMapReady(new GoogleMap(iGoogleMapDelegate));
                    }
                });
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onEnterAmbient(Bundle bundle) {
            try {
                this.afW.onEnterAmbient(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onExitAmbient() {
            try {
                this.afW.onExitAmbient();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

