/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.maps.internal.zza;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLngBounds;

public final class GoogleMapOptions
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final com.google.android.gms.maps.zza CREATOR = new com.google.android.gms.maps.zza();
    private final int mVersionCode;
    private Boolean afy;
    private Boolean afz;
    private int afA = -1;
    private CameraPosition afB;
    private Boolean afC;
    private Boolean afD;
    private Boolean afE;
    private Boolean afF;
    private Boolean afG;
    private Boolean afH;
    private Boolean afI;
    private Boolean afJ;
    private Boolean afK;
    private Float afL = null;
    private Float afM = null;
    private LatLngBounds afN = null;

    GoogleMapOptions(int n, byte by, byte by2, int n2, CameraPosition cameraPosition, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8, byte by9, byte by10, byte by11, Float f, Float f2, LatLngBounds latLngBounds) {
        this.mVersionCode = n;
        this.afy = zza.zza(by);
        this.afz = zza.zza(by2);
        this.afA = n2;
        this.afB = cameraPosition;
        this.afC = zza.zza(by3);
        this.afD = zza.zza(by4);
        this.afE = zza.zza(by5);
        this.afF = zza.zza(by6);
        this.afG = zza.zza(by7);
        this.afH = zza.zza(by8);
        this.afI = zza.zza(by9);
        this.afJ = zza.zza(by10);
        this.afK = zza.zza(by11);
        this.afL = f;
        this.afM = f2;
        this.afN = latLngBounds;
    }

    public void writeToParcel(Parcel parcel, int n) {
        com.google.android.gms.maps.zza.zza(this, parcel, n);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    byte zzbol() {
        return zza.zze(this.afy);
    }

    byte zzbom() {
        return zza.zze(this.afz);
    }

    byte zzbon() {
        return zza.zze(this.afC);
    }

    byte zzboo() {
        return zza.zze(this.afD);
    }

    byte zzbop() {
        return zza.zze(this.afE);
    }

    byte zzboq() {
        return zza.zze(this.afF);
    }

    byte zzbor() {
        return zza.zze(this.afG);
    }

    byte zzbos() {
        return zza.zze(this.afH);
    }

    byte zzbot() {
        return zza.zze(this.afI);
    }

    byte zzbou() {
        return zza.zze(this.afJ);
    }

    byte zzbov() {
        return zza.zze(this.afK);
    }

    public GoogleMapOptions() {
        this.mVersionCode = 1;
    }

    public GoogleMapOptions zOrderOnTop(boolean bl) {
        this.afy = bl;
        return this;
    }

    public GoogleMapOptions useViewLifecycleInFragment(boolean bl) {
        this.afz = bl;
        return this;
    }

    public GoogleMapOptions mapType(int n) {
        this.afA = n;
        return this;
    }

    public GoogleMapOptions camera(CameraPosition cameraPosition) {
        this.afB = cameraPosition;
        return this;
    }

    public GoogleMapOptions zoomControlsEnabled(boolean bl) {
        this.afC = bl;
        return this;
    }

    public GoogleMapOptions compassEnabled(boolean bl) {
        this.afD = bl;
        return this;
    }

    public GoogleMapOptions scrollGesturesEnabled(boolean bl) {
        this.afE = bl;
        return this;
    }

    public GoogleMapOptions zoomGesturesEnabled(boolean bl) {
        this.afF = bl;
        return this;
    }

    public GoogleMapOptions tiltGesturesEnabled(boolean bl) {
        this.afG = bl;
        return this;
    }

    public GoogleMapOptions rotateGesturesEnabled(boolean bl) {
        this.afH = bl;
        return this;
    }

    public GoogleMapOptions liteMode(boolean bl) {
        this.afI = bl;
        return this;
    }

    public GoogleMapOptions mapToolbarEnabled(boolean bl) {
        this.afJ = bl;
        return this;
    }

    public GoogleMapOptions ambientEnabled(boolean bl) {
        this.afK = bl;
        return this;
    }

    public GoogleMapOptions minZoomPreference(float f) {
        this.afL = Float.valueOf(f);
        return this;
    }

    public GoogleMapOptions maxZoomPreference(float f) {
        this.afM = Float.valueOf(f);
        return this;
    }

    public GoogleMapOptions latLngBoundsForCameraTarget(LatLngBounds latLngBounds) {
        this.afN = latLngBounds;
        return this;
    }

    public Boolean getZOrderOnTop() {
        return this.afy;
    }

    public Boolean getUseViewLifecycleInFragment() {
        return this.afz;
    }

    public int getMapType() {
        return this.afA;
    }

    public CameraPosition getCamera() {
        return this.afB;
    }

    public Boolean getZoomControlsEnabled() {
        return this.afC;
    }

    public Boolean getCompassEnabled() {
        return this.afD;
    }

    public Boolean getScrollGesturesEnabled() {
        return this.afE;
    }

    public Boolean getZoomGesturesEnabled() {
        return this.afF;
    }

    public Boolean getTiltGesturesEnabled() {
        return this.afG;
    }

    public Boolean getRotateGesturesEnabled() {
        return this.afH;
    }

    public Boolean getLiteMode() {
        return this.afI;
    }

    public Boolean getMapToolbarEnabled() {
        return this.afJ;
    }

    public Boolean getAmbientEnabled() {
        return this.afK;
    }

    public Float getMinZoomPreference() {
        return this.afL;
    }

    public Float getMaxZoomPreference() {
        return this.afM;
    }

    public LatLngBounds getLatLngBoundsForCameraTarget() {
        return this.afN;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(R.styleable.MapAttrs_mapType)) {
            googleMapOptions.mapType(typedArray.getInt(R.styleable.MapAttrs_mapType, -1));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_zOrderOnTop)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(R.styleable.MapAttrs_zOrderOnTop, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_useViewLifecycle)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(R.styleable.MapAttrs_useViewLifecycle, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiCompass)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiCompass, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiRotateGestures)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiRotateGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGestures)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiTiltGestures)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiTiltGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomGestures)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomControls)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomControls, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_liteMode)) {
            googleMapOptions.liteMode(typedArray.getBoolean(R.styleable.MapAttrs_liteMode, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiMapToolbar)) {
            googleMapOptions.mapToolbarEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiMapToolbar, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_ambientEnabled)) {
            googleMapOptions.ambientEnabled(typedArray.getBoolean(R.styleable.MapAttrs_ambientEnabled, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.minZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMinZoomPreference, Float.NEGATIVE_INFINITY));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.maxZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMaxZoomPreference, Float.POSITIVE_INFINITY));
        }
        LatLngBounds latLngBounds = LatLngBounds.createFromAttributes(context, attributeSet);
        googleMapOptions.latLngBoundsForCameraTarget(latLngBounds);
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attributeSet);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }
}

