/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.zzd;

public final class LatLngBounds
implements SafeParcelable {
    public static final zzd CREATOR = new zzd();
    private final int mVersionCode;
    public final LatLng southwest;
    public final LatLng northeast;

    LatLngBounds(int n, LatLng latLng, LatLng latLng2) {
        zzab.zzb((Object)latLng, (Object)"null southwest");
        zzab.zzb((Object)latLng2, (Object)"null northeast");
        zzab.zzb((latLng2.latitude >= latLng.latitude ? 1 : 0) != 0, (String)"southern latitude exceeds northern latitude (%s > %s)", (Object[])new Object[]{latLng.latitude, latLng2.latitude});
        this.mVersionCode = n;
        this.southwest = latLng;
        this.northeast = latLng2;
    }

    public LatLngBounds(LatLng latLng, LatLng latLng2) {
        this(1, latLng, latLng2);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzd.zza(this, parcel, n);
    }

    public int describeContents() {
        return 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean contains(LatLng latLng) {
        LatLng latLng2 = latLng;
        return this.zzh(latLng2.latitude) && this.zzi(latLng2.longitude);
    }

    public LatLngBounds including(LatLng latLng) {
        LatLng latLng2 = latLng;
        double d = Math.min(this.southwest.latitude, latLng2.latitude);
        double d2 = Math.max(this.northeast.latitude, latLng2.latitude);
        double d3 = this.northeast.longitude;
        double d4 = this.southwest.longitude;
        double d5 = latLng2.longitude;
        if (!this.zzi(d5)) {
            if (LatLngBounds.zzb(d4, d5) < LatLngBounds.zzc(d3, d5)) {
                d4 = d5;
            } else {
                d3 = d5;
            }
        }
        return new LatLngBounds(new LatLng(d, d4), new LatLng(d2, d3));
    }

    public LatLng getCenter() {
        double d = (this.southwest.latitude + this.northeast.latitude) / 2.0;
        double d2 = this.southwest.longitude;
        double d3 = this.northeast.longitude;
        double d4 = d2 <= d3 ? (d3 + d2) / 2.0 : (d3 + 360.0 + d2) / 2.0;
        return new LatLng(d, d4);
    }

    private static double zzb(double d, double d2) {
        return (d - d2 + 360.0) % 360.0;
    }

    private static double zzc(double d, double d2) {
        return (d2 - d + 360.0) % 360.0;
    }

    private boolean zzh(double d) {
        return this.southwest.latitude <= d && d <= this.northeast.latitude;
    }

    private boolean zzi(double d) {
        if (this.southwest.longitude <= this.northeast.longitude) {
            return this.southwest.longitude <= d && d <= this.northeast.longitude;
        }
        return this.southwest.longitude <= d || d <= this.northeast.longitude;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.southwest, this.northeast});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LatLngBounds)) {
            return false;
        }
        LatLngBounds latLngBounds = (LatLngBounds)object;
        return this.southwest.equals(latLngBounds.southwest) && this.northeast.equals(latLngBounds.northeast);
    }

    public String toString() {
        return zzaa.zzz((Object)this).zzg("southwest", (Object)this.southwest).zzg("northeast", (Object)this.northeast).toString();
    }

    public static final class Builder {
        private double aiz = Double.POSITIVE_INFINITY;
        private double aiA = Double.NEGATIVE_INFINITY;
        private double aiB = Double.NaN;
        private double aiC = Double.NaN;

        public Builder include(LatLng latLng) {
            this.aiz = Math.min(this.aiz, latLng.latitude);
            this.aiA = Math.max(this.aiA, latLng.latitude);
            double d = latLng.longitude;
            if (Double.isNaN(this.aiB)) {
                this.aiB = d;
                this.aiC = d;
            } else if (!this.zzi(d)) {
                if (LatLngBounds.zzb(this.aiB, d) < LatLngBounds.zzc(this.aiC, d)) {
                    this.aiB = d;
                } else {
                    this.aiC = d;
                }
            }
            return this;
        }

        private boolean zzi(double d) {
            if (this.aiB <= this.aiC) {
                return this.aiB <= d && d <= this.aiC;
            }
            return this.aiB <= d || d <= this.aiC;
        }

        public LatLngBounds build() {
            zzab.zza((!Double.isNaN(this.aiB) ? 1 : 0) != 0, (Object)"no included points");
            return new LatLngBounds(new LatLng(this.aiz, this.aiB), new LatLng(this.aiA, this.aiC));
        }
    }
}

