/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.IMapViewDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzae;
import com.google.android.gms.maps.internal.zzp;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.ArrayList;
import java.util.List;

public class MapView
extends FrameLayout {
    private final zzb aho;

    public MapView(Context context) {
        super(context);
        this.aho = new zzb((ViewGroup)this, context, null);
        this.zzbpu();
    }

    public MapView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.aho = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attributeSet));
        this.zzbpu();
    }

    public MapView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.aho = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attributeSet));
        this.zzbpu();
    }

    public MapView(Context context, GoogleMapOptions googleMapOptions) {
        super(context);
        this.aho = new zzb((ViewGroup)this, context, googleMapOptions);
        this.zzbpu();
    }

    private void zzbpu() {
        this.setClickable(true);
    }

    public final void onCreate(Bundle bundle) {
        this.aho.onCreate(bundle);
        if (this.aho.zzbcr() == null) {
            com.google.android.gms.dynamic.zza.zzb((FrameLayout)this);
        }
    }

    public final void onResume() {
        this.aho.onResume();
    }

    public final void onPause() {
        this.aho.onPause();
    }

    public final void onDestroy() {
        this.aho.onDestroy();
    }

    public final void onLowMemory() {
        this.aho.onLowMemory();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        this.aho.onSaveInstanceState(bundle);
    }

    public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
        zzab.zzhj((String)"getMapAsync() must be called on the main thread");
        this.aho.getMapAsync(onMapReadyCallback);
    }

    public final void onEnterAmbient(Bundle bundle) {
        zzab.zzhj((String)"onEnterAmbient() must be called on the main thread");
        this.aho.onEnterAmbient(bundle);
    }

    public final void onExitAmbient() {
        zzab.zzhj((String)"onExitAmbient() must be called on the main thread");
        this.aho.onExitAmbient();
    }

    static class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final ViewGroup aht;
        private final Context mContext;
        protected zzf<zza> ahm;
        private final GoogleMapOptions ahu;
        private final List<OnMapReadyCallback> ahn = new ArrayList<OnMapReadyCallback>();

        zzb(ViewGroup viewGroup, Context context, GoogleMapOptions googleMapOptions) {
            this.aht = viewGroup;
            this.mContext = context;
            this.ahu = googleMapOptions;
        }

        protected void zza(zzf<zza> zzf2) {
            this.ahm = zzf2;
            this.zzbpt();
        }

        public void zzbpt() {
            if (this.ahm != null && this.zzbcr() == null) {
                try {
                    MapsInitializer.initialize(this.mContext);
                    IMapViewDelegate iMapViewDelegate = zzae.zzdk(this.mContext).zza(zze.zzae((Object)this.mContext), this.ahu);
                    if (iMapViewDelegate == null) {
                        return;
                    }
                    this.ahm.zza((LifecycleDelegate)new zza(this.aht, iMapViewDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : this.ahn) {
                        ((zza)this.zzbcr()).getMapAsync(onMapReadyCallback);
                    }
                    this.ahn.clear();
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    // empty catch block
                }
            }
        }

        public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            if (this.zzbcr() != null) {
                ((zza)this.zzbcr()).getMapAsync(onMapReadyCallback);
            } else {
                this.ahn.add(onMapReadyCallback);
            }
        }

        public void onEnterAmbient(Bundle bundle) {
            if (this.zzbcr() != null) {
                ((zza)this.zzbcr()).onEnterAmbient(bundle);
            }
        }

        public void onExitAmbient() {
            if (this.zzbcr() != null) {
                ((zza)this.zzbcr()).onExitAmbient();
            }
        }
    }

    static class zza
    implements MapLifecycleDelegate {
        private final ViewGroup ahp;
        private final IMapViewDelegate ahq;
        private View ahr;

        public zza(ViewGroup viewGroup, IMapViewDelegate iMapViewDelegate) {
            this.ahq = (IMapViewDelegate)zzab.zzaa((Object)iMapViewDelegate);
            this.ahp = (ViewGroup)zzab.zzaa((Object)viewGroup);
        }

        public void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            throw new UnsupportedOperationException("onInflate not allowed on MapViewDelegate");
        }

        public void onCreate(Bundle bundle) {
            try {
                this.ahq.onCreate(bundle);
                this.ahr = (View)zze.zzad((zzd)this.ahq.getView());
                this.ahp.removeAllViews();
                this.ahp.addView(this.ahr);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            throw new UnsupportedOperationException("onCreateView not allowed on MapViewDelegate");
        }

        public void onStart() {
        }

        public void onResume() {
            try {
                this.ahq.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.ahq.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onStop() {
        }

        public void onDestroyView() {
            throw new UnsupportedOperationException("onDestroyView not allowed on MapViewDelegate");
        }

        public void onDestroy() {
            try {
                this.ahq.onDestroy();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onLowMemory() {
            try {
                this.ahq.onLowMemory();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onSaveInstanceState(Bundle bundle) {
            try {
                this.ahq.onSaveInstanceState(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void getMapAsync(final OnMapReadyCallback onMapReadyCallback) {
            try {
                this.ahq.getMapAsync(new zzp.zza(){

                    @Override
                    public void zza(IGoogleMapDelegate iGoogleMapDelegate) throws RemoteException {
                        onMapReadyCallback.onMapReady(new GoogleMap(iGoogleMapDelegate));
                    }
                });
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onEnterAmbient(Bundle bundle) {
            try {
                this.ahq.onEnterAmbient(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onExitAmbient() {
            try {
                this.ahq.onExitAmbient();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

