/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.zza;

public final class GoogleMapOptions
implements SafeParcelable {
    public static final zza CREATOR = new zza();
    private final int mVersionCode;
    private Boolean agV;
    private Boolean agW;
    private int agX = -1;
    private CameraPosition agY;
    private Boolean agZ;
    private Boolean aha;
    private Boolean ahb;
    private Boolean ahc;
    private Boolean ahd;
    private Boolean ahe;
    private Boolean ahf;
    private Boolean ahg;
    private Boolean ahh;

    GoogleMapOptions(int n, byte by, byte by2, int n2, CameraPosition cameraPosition, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8, byte by9, byte by10, byte by11) {
        this.mVersionCode = n;
        this.agV = com.google.android.gms.maps.internal.zza.zza(by);
        this.agW = com.google.android.gms.maps.internal.zza.zza(by2);
        this.agX = n2;
        this.agY = cameraPosition;
        this.agZ = com.google.android.gms.maps.internal.zza.zza(by3);
        this.aha = com.google.android.gms.maps.internal.zza.zza(by4);
        this.ahb = com.google.android.gms.maps.internal.zza.zza(by5);
        this.ahc = com.google.android.gms.maps.internal.zza.zza(by6);
        this.ahd = com.google.android.gms.maps.internal.zza.zza(by7);
        this.ahe = com.google.android.gms.maps.internal.zza.zza(by8);
        this.ahf = com.google.android.gms.maps.internal.zza.zza(by9);
        this.ahg = com.google.android.gms.maps.internal.zza.zza(by10);
        this.ahh = com.google.android.gms.maps.internal.zza.zza(by11);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zza.zza(this, parcel, n);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    byte zzbpi() {
        return com.google.android.gms.maps.internal.zza.zze(this.agV);
    }

    byte zzbpj() {
        return com.google.android.gms.maps.internal.zza.zze(this.agW);
    }

    byte zzbpk() {
        return com.google.android.gms.maps.internal.zza.zze(this.agZ);
    }

    byte zzbpl() {
        return com.google.android.gms.maps.internal.zza.zze(this.aha);
    }

    byte zzbpm() {
        return com.google.android.gms.maps.internal.zza.zze(this.ahb);
    }

    byte zzbpn() {
        return com.google.android.gms.maps.internal.zza.zze(this.ahc);
    }

    byte zzbpo() {
        return com.google.android.gms.maps.internal.zza.zze(this.ahd);
    }

    byte zzbpp() {
        return com.google.android.gms.maps.internal.zza.zze(this.ahe);
    }

    byte zzbpq() {
        return com.google.android.gms.maps.internal.zza.zze(this.ahf);
    }

    byte zzbpr() {
        return com.google.android.gms.maps.internal.zza.zze(this.ahg);
    }

    byte zzbps() {
        return com.google.android.gms.maps.internal.zza.zze(this.ahh);
    }

    public GoogleMapOptions() {
        this.mVersionCode = 1;
    }

    public GoogleMapOptions zOrderOnTop(boolean bl) {
        this.agV = bl;
        return this;
    }

    public GoogleMapOptions useViewLifecycleInFragment(boolean bl) {
        this.agW = bl;
        return this;
    }

    public GoogleMapOptions mapType(int n) {
        this.agX = n;
        return this;
    }

    public GoogleMapOptions camera(CameraPosition cameraPosition) {
        this.agY = cameraPosition;
        return this;
    }

    public GoogleMapOptions zoomControlsEnabled(boolean bl) {
        this.agZ = bl;
        return this;
    }

    public GoogleMapOptions compassEnabled(boolean bl) {
        this.aha = bl;
        return this;
    }

    public GoogleMapOptions scrollGesturesEnabled(boolean bl) {
        this.ahb = bl;
        return this;
    }

    public GoogleMapOptions zoomGesturesEnabled(boolean bl) {
        this.ahc = bl;
        return this;
    }

    public GoogleMapOptions tiltGesturesEnabled(boolean bl) {
        this.ahd = bl;
        return this;
    }

    public GoogleMapOptions rotateGesturesEnabled(boolean bl) {
        this.ahe = bl;
        return this;
    }

    public GoogleMapOptions liteMode(boolean bl) {
        this.ahf = bl;
        return this;
    }

    public GoogleMapOptions mapToolbarEnabled(boolean bl) {
        this.ahg = bl;
        return this;
    }

    public GoogleMapOptions ambientEnabled(boolean bl) {
        this.ahh = bl;
        return this;
    }

    public Boolean getZOrderOnTop() {
        return this.agV;
    }

    public Boolean getUseViewLifecycleInFragment() {
        return this.agW;
    }

    public int getMapType() {
        return this.agX;
    }

    public CameraPosition getCamera() {
        return this.agY;
    }

    public Boolean getZoomControlsEnabled() {
        return this.agZ;
    }

    public Boolean getCompassEnabled() {
        return this.aha;
    }

    public Boolean getScrollGesturesEnabled() {
        return this.ahb;
    }

    public Boolean getZoomGesturesEnabled() {
        return this.ahc;
    }

    public Boolean getTiltGesturesEnabled() {
        return this.ahd;
    }

    public Boolean getRotateGesturesEnabled() {
        return this.ahe;
    }

    public Boolean getLiteMode() {
        return this.ahf;
    }

    public Boolean getMapToolbarEnabled() {
        return this.ahg;
    }

    public Boolean getAmbientEnabled() {
        return this.ahh;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(R.styleable.MapAttrs_mapType)) {
            googleMapOptions.mapType(typedArray.getInt(R.styleable.MapAttrs_mapType, -1));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_zOrderOnTop)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(R.styleable.MapAttrs_zOrderOnTop, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_useViewLifecycle)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(R.styleable.MapAttrs_useViewLifecycle, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiCompass)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiCompass, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiRotateGestures)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiRotateGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGestures)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiTiltGestures)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiTiltGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomGestures)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomControls)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomControls, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_liteMode)) {
            googleMapOptions.liteMode(typedArray.getBoolean(R.styleable.MapAttrs_liteMode, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiMapToolbar)) {
            googleMapOptions.mapToolbarEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiMapToolbar, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_ambientEnabled)) {
            googleMapOptions.ambientEnabled(typedArray.getBoolean(R.styleable.MapAttrs_ambientEnabled, false));
        }
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attributeSet);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }
}

