/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.maps.model.zzm;

public class StreetViewPanoramaOrientation
implements SafeParcelable {
    public static final zzm CREATOR = new zzm();
    private final int mVersionCode;
    public final float tilt;
    public final float bearing;

    StreetViewPanoramaOrientation(int n, float f, float f2) {
        zzaa.zzb((-90.0f <= f && f <= 90.0f ? 1 : 0) != 0, (Object)"Tilt needs to be between -90 and 90 inclusive");
        this.mVersionCode = n;
        this.tilt = f + 0.0f;
        this.bearing = ((double)f2 <= 0.0 ? f2 % 360.0f + 360.0f : f2) % 360.0f;
    }

    public StreetViewPanoramaOrientation(float f, float f2) {
        this(1, f, f2);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzm.zza(this, parcel, n);
    }

    public int describeContents() {
        return 0;
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{Float.valueOf(this.tilt), Float.valueOf(this.bearing)});
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(StreetViewPanoramaOrientation streetViewPanoramaOrientation) {
        return new Builder(streetViewPanoramaOrientation);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StreetViewPanoramaOrientation)) {
            return false;
        }
        StreetViewPanoramaOrientation streetViewPanoramaOrientation = (StreetViewPanoramaOrientation)object;
        return Float.floatToIntBits(this.tilt) == Float.floatToIntBits(streetViewPanoramaOrientation.tilt) && Float.floatToIntBits(this.bearing) == Float.floatToIntBits(streetViewPanoramaOrientation.bearing);
    }

    public String toString() {
        return zzz.zzy((Object)this).zzg("tilt", (Object)Float.valueOf(this.tilt)).zzg("bearing", (Object)Float.valueOf(this.bearing)).toString();
    }

    public static final class Builder {
        public float bearing;
        public float tilt;

        public Builder() {
        }

        public Builder(StreetViewPanoramaOrientation streetViewPanoramaOrientation) {
            StreetViewPanoramaOrientation streetViewPanoramaOrientation2 = streetViewPanoramaOrientation;
            this.bearing = streetViewPanoramaOrientation2.bearing;
            this.tilt = streetViewPanoramaOrientation2.tilt;
        }

        public Builder tilt(float f) {
            this.tilt = f;
            return this;
        }

        public Builder bearing(float f) {
            this.bearing = f;
            return this;
        }

        public StreetViewPanoramaOrientation build() {
            return new StreetViewPanoramaOrientation(this.tilt, this.bearing);
        }
    }
}

