/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.zzh;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolygonOptions
implements SafeParcelable {
    public static final zzh CREATOR = new zzh();
    private final int mVersionCode;
    private final List<LatLng> zzaTJ;
    private final List<List<LatLng>> zzaTK;
    private float zzaTe = 10.0f;
    private int zzaTf = -16777216;
    private int zzaTg = 0;
    private float zzaTh = 0.0f;
    private boolean zzaTi = true;
    private boolean zzaTL = false;
    private boolean zzaTr = false;

    public PolygonOptions() {
        this.mVersionCode = 1;
        this.zzaTJ = new ArrayList<LatLng>();
        this.zzaTK = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(int versionCode, List<LatLng> points, List holes, float strokeWidth, int strokeColor, int fillColor, float zIndex, boolean visible, boolean geodesic, boolean clickable) {
        this.mVersionCode = versionCode;
        this.zzaTJ = points;
        this.zzaTK = holes;
        this.zzaTe = strokeWidth;
        this.zzaTf = strokeColor;
        this.zzaTg = fillColor;
        this.zzaTh = zIndex;
        this.zzaTi = visible;
        this.zzaTL = geodesic;
        this.zzaTr = clickable;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    List zzAl() {
        return this.zzaTK;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzh.zza(this, out, flags);
    }

    public int describeContents() {
        return 0;
    }

    public PolygonOptions add(LatLng point) {
        this.zzaTJ.add(point);
        return this;
    }

    public PolygonOptions add(LatLng ... points) {
        this.zzaTJ.addAll(Arrays.asList(points));
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> points) {
        for (LatLng latLng : points) {
            this.zzaTJ.add(latLng);
        }
        return this;
    }

    public PolygonOptions addHole(Iterable<LatLng> points) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : points) {
            arrayList.add(latLng);
        }
        this.zzaTK.add(arrayList);
        return this;
    }

    public PolygonOptions strokeWidth(float width) {
        this.zzaTe = width;
        return this;
    }

    public PolygonOptions strokeColor(int color) {
        this.zzaTf = color;
        return this;
    }

    public PolygonOptions fillColor(int color) {
        this.zzaTg = color;
        return this;
    }

    public PolygonOptions zIndex(float zIndex) {
        this.zzaTh = zIndex;
        return this;
    }

    public PolygonOptions visible(boolean visible) {
        this.zzaTi = visible;
        return this;
    }

    public PolygonOptions geodesic(boolean geodesic) {
        this.zzaTL = geodesic;
        return this;
    }

    public PolygonOptions clickable(boolean clickable) {
        this.zzaTr = clickable;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.zzaTJ;
    }

    public List<List<LatLng>> getHoles() {
        return this.zzaTK;
    }

    public float getStrokeWidth() {
        return this.zzaTe;
    }

    public int getStrokeColor() {
        return this.zzaTf;
    }

    public int getFillColor() {
        return this.zzaTg;
    }

    public float getZIndex() {
        return this.zzaTh;
    }

    public boolean isVisible() {
        return this.zzaTi;
    }

    public boolean isGeodesic() {
        return this.zzaTL;
    }

    public boolean isClickable() {
        return this.zzaTr;
    }
}

