/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.zza;

public final class GoogleMapOptions
implements SafeParcelable {
    public static final zza CREATOR = new zza();
    private final int zzzH;
    private Boolean zzatL;
    private Boolean zzatM;
    private int zzatN = -1;
    private CameraPosition zzatO;
    private Boolean zzatP;
    private Boolean zzatQ;
    private Boolean zzatR;
    private Boolean zzatS;
    private Boolean zzatT;
    private Boolean zzatU;
    private Boolean zzatV;
    private Boolean zzatW;

    GoogleMapOptions(int versionCode, byte zOrderOnTop, byte useViewLifecycleInFragment, int mapType, CameraPosition camera, byte zoomControlsEnabled, byte compassEnabled, byte scrollGesturesEnabled, byte zoomGesturesEnabled, byte tiltGesturesEnabled, byte rotateGesturesEnabled, byte liteMode, byte mapToolbarEnabled) {
        this.zzzH = versionCode;
        this.zzatL = com.google.android.gms.maps.internal.zza.zza(zOrderOnTop);
        this.zzatM = com.google.android.gms.maps.internal.zza.zza(useViewLifecycleInFragment);
        this.zzatN = mapType;
        this.zzatO = camera;
        this.zzatP = com.google.android.gms.maps.internal.zza.zza(zoomControlsEnabled);
        this.zzatQ = com.google.android.gms.maps.internal.zza.zza(compassEnabled);
        this.zzatR = com.google.android.gms.maps.internal.zza.zza(scrollGesturesEnabled);
        this.zzatS = com.google.android.gms.maps.internal.zza.zza(zoomGesturesEnabled);
        this.zzatT = com.google.android.gms.maps.internal.zza.zza(tiltGesturesEnabled);
        this.zzatU = com.google.android.gms.maps.internal.zza.zza(rotateGesturesEnabled);
        this.zzatV = com.google.android.gms.maps.internal.zza.zza(liteMode);
        this.zzatW = com.google.android.gms.maps.internal.zza.zza(mapToolbarEnabled);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zza.zza(this, out, flags);
    }

    int getVersionCode() {
        return this.zzzH;
    }

    byte zzts() {
        return com.google.android.gms.maps.internal.zza.zzd(this.zzatL);
    }

    byte zztt() {
        return com.google.android.gms.maps.internal.zza.zzd(this.zzatM);
    }

    byte zztu() {
        return com.google.android.gms.maps.internal.zza.zzd(this.zzatP);
    }

    byte zztv() {
        return com.google.android.gms.maps.internal.zza.zzd(this.zzatQ);
    }

    byte zztw() {
        return com.google.android.gms.maps.internal.zza.zzd(this.zzatR);
    }

    byte zztx() {
        return com.google.android.gms.maps.internal.zza.zzd(this.zzatS);
    }

    byte zzty() {
        return com.google.android.gms.maps.internal.zza.zzd(this.zzatT);
    }

    byte zztz() {
        return com.google.android.gms.maps.internal.zza.zzd(this.zzatU);
    }

    byte zztA() {
        return com.google.android.gms.maps.internal.zza.zzd(this.zzatV);
    }

    byte zztB() {
        return com.google.android.gms.maps.internal.zza.zzd(this.zzatW);
    }

    public GoogleMapOptions() {
        this.zzzH = 1;
    }

    public GoogleMapOptions zOrderOnTop(boolean zOrderOnTop) {
        this.zzatL = zOrderOnTop;
        return this;
    }

    public GoogleMapOptions useViewLifecycleInFragment(boolean useViewLifecycleInFragment) {
        this.zzatM = useViewLifecycleInFragment;
        return this;
    }

    public GoogleMapOptions mapType(int mapType) {
        this.zzatN = mapType;
        return this;
    }

    public GoogleMapOptions camera(CameraPosition camera) {
        this.zzatO = camera;
        return this;
    }

    public GoogleMapOptions zoomControlsEnabled(boolean enabled) {
        this.zzatP = enabled;
        return this;
    }

    public GoogleMapOptions compassEnabled(boolean enabled) {
        this.zzatQ = enabled;
        return this;
    }

    public GoogleMapOptions scrollGesturesEnabled(boolean enabled) {
        this.zzatR = enabled;
        return this;
    }

    public GoogleMapOptions zoomGesturesEnabled(boolean enabled) {
        this.zzatS = enabled;
        return this;
    }

    public GoogleMapOptions tiltGesturesEnabled(boolean enabled) {
        this.zzatT = enabled;
        return this;
    }

    public GoogleMapOptions rotateGesturesEnabled(boolean enabled) {
        this.zzatU = enabled;
        return this;
    }

    public GoogleMapOptions liteMode(boolean enabled) {
        this.zzatV = enabled;
        return this;
    }

    public GoogleMapOptions mapToolbarEnabled(boolean enabled) {
        this.zzatW = enabled;
        return this;
    }

    public Boolean getZOrderOnTop() {
        return this.zzatL;
    }

    public Boolean getUseViewLifecycleInFragment() {
        return this.zzatM;
    }

    public int getMapType() {
        return this.zzatN;
    }

    public CameraPosition getCamera() {
        return this.zzatO;
    }

    public Boolean getZoomControlsEnabled() {
        return this.zzatP;
    }

    public Boolean getCompassEnabled() {
        return this.zzatQ;
    }

    public Boolean getScrollGesturesEnabled() {
        return this.zzatR;
    }

    public Boolean getZoomGesturesEnabled() {
        return this.zzatS;
    }

    public Boolean getTiltGesturesEnabled() {
        return this.zzatT;
    }

    public Boolean getRotateGesturesEnabled() {
        return this.zzatU;
    }

    public Boolean getLiteMode() {
        return this.zzatV;
    }

    public Boolean getMapToolbarEnabled() {
        return this.zzatW;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(R.styleable.MapAttrs_mapType)) {
            googleMapOptions.mapType(typedArray.getInt(R.styleable.MapAttrs_mapType, -1));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_zOrderOnTop)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(R.styleable.MapAttrs_zOrderOnTop, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_useViewLifecycle)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(R.styleable.MapAttrs_useViewLifecycle, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiCompass)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiCompass, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiRotateGestures)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiRotateGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGestures)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiTiltGestures)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiTiltGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomGestures)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomControls)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomControls, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_liteMode)) {
            googleMapOptions.liteMode(typedArray.getBoolean(R.styleable.MapAttrs_liteMode, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiMapToolbar)) {
            googleMapOptions.mapToolbarEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiMapToolbar, true));
        }
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attrs);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }
}

