/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.internal;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.maps.internal.zzy;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.VisibleRegion;

public interface IProjectionDelegate
extends IInterface {
    public LatLng fromScreenLocation(zzd var1) throws RemoteException;

    public zzd toScreenLocation(LatLng var1) throws RemoteException;

    public VisibleRegion getVisibleRegion() throws RemoteException;

    public LatLng fromScreenLocation2(zzy var1) throws RemoteException;

    public zzy toScreenLocation2(LatLng var1) throws RemoteException;

    public static abstract class com.google.android.gms.maps.internal.IProjectionDelegate$zza
    extends Binder
    implements IProjectionDelegate {
        public static IProjectionDelegate zzbQ(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface("com.google.android.gms.maps.internal.IProjectionDelegate");
            if (iInterface != null && iInterface instanceof IProjectionDelegate) {
                return (IProjectionDelegate)iInterface;
            }
            return new zza(iBinder);
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString("com.google.android.gms.maps.internal.IProjectionDelegate");
                    return true;
                }
                case 1: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IProjectionDelegate");
                    zzd zzd2 = zzd.zza.zzau((IBinder)data.readStrongBinder());
                    LatLng latLng = this.fromScreenLocation(zzd2);
                    reply.writeNoException();
                    if (latLng != null) {
                        reply.writeInt(1);
                        latLng.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 2: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IProjectionDelegate");
                    LatLng latLng = 0 != data.readInt() ? LatLng.CREATOR.zzdW(data) : null;
                    zzd zzd3 = this.toScreenLocation(latLng);
                    reply.writeNoException();
                    reply.writeStrongBinder(zzd3 != null ? zzd3.asBinder() : null);
                    return true;
                }
                case 3: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IProjectionDelegate");
                    VisibleRegion visibleRegion = this.getVisibleRegion();
                    reply.writeNoException();
                    if (visibleRegion != null) {
                        reply.writeInt(1);
                        visibleRegion.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 4: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IProjectionDelegate");
                    zzy zzy2 = 0 != data.readInt() ? zzy.CREATOR.zzdR(data) : null;
                    LatLng latLng = this.fromScreenLocation2(zzy2);
                    reply.writeNoException();
                    if (latLng != null) {
                        reply.writeInt(1);
                        latLng.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 5: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IProjectionDelegate");
                    LatLng latLng = 0 != data.readInt() ? LatLng.CREATOR.zzdW(data) : null;
                    zzy zzy3 = this.toScreenLocation2(latLng);
                    reply.writeNoException();
                    if (zzy3 != null) {
                        reply.writeInt(1);
                        zzy3.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class zza
        implements IProjectionDelegate {
            private IBinder zzle;

            zza(IBinder iBinder) {
                this.zzle = iBinder;
            }

            public IBinder asBinder() {
                return this.zzle;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public LatLng fromScreenLocation(zzd point) throws RemoteException {
                LatLng latLng;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IProjectionDelegate");
                    parcel.writeStrongBinder(point != null ? point.asBinder() : null);
                    this.zzle.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    latLng = 0 != parcel2.readInt() ? LatLng.CREATOR.zzdW(parcel2) : null;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return latLng;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public zzd toScreenLocation(LatLng location) throws RemoteException {
                zzd zzd2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IProjectionDelegate");
                    if (location != null) {
                        parcel.writeInt(1);
                        location.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.zzle.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    zzd2 = zzd.zza.zzau((IBinder)parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return zzd2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VisibleRegion getVisibleRegion() throws RemoteException {
                VisibleRegion visibleRegion;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IProjectionDelegate");
                    this.zzle.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    visibleRegion = 0 != parcel2.readInt() ? VisibleRegion.CREATOR.zzeg(parcel2) : null;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return visibleRegion;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public LatLng fromScreenLocation2(zzy point) throws RemoteException {
                LatLng latLng;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IProjectionDelegate");
                    if (point != null) {
                        parcel.writeInt(1);
                        point.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.zzle.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    latLng = 0 != parcel2.readInt() ? LatLng.CREATOR.zzdW(parcel2) : null;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return latLng;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public zzy toScreenLocation2(LatLng location) throws RemoteException {
                zzy zzy2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IProjectionDelegate");
                    if (location != null) {
                        parcel.writeInt(1);
                        location.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.zzle.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    zzy2 = 0 != parcel2.readInt() ? zzy.CREATOR.zzdR(parcel2) : null;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return zzy2;
            }
        }
    }
}

