/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.StreetViewPanoramaOrientation;
import com.google.android.gms.maps.model.zzx;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="StreetViewPanoramaCameraCreator")
public class StreetViewPanoramaCamera
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @NonNull
    public static final Parcelable.Creator<StreetViewPanoramaCamera> CREATOR = new zzx();
    @SafeParcelable.Field(id=2)
    public final float zoom;
    @SafeParcelable.Field(id=3)
    public final float tilt;
    @SafeParcelable.Field(id=4)
    public final float bearing;
    private final StreetViewPanoramaOrientation zza;

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Float.valueOf(this.zoom), Float.valueOf(this.tilt), Float.valueOf(this.bearing)});
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public static Builder builder(@NonNull StreetViewPanoramaCamera camera) {
        StreetViewPanoramaCamera streetViewPanoramaCamera;
        return new Builder(streetViewPanoramaCamera);
    }

    @NonNull
    public StreetViewPanoramaOrientation getOrientation() {
        return this.zza;
    }

    @NonNull
    public String toString() {
        float f = this.zoom;
        Objects.ToStringHelper toStringHelper = Objects.toStringHelper((Object)((Object)this)).add("zoom", (Object)Float.valueOf(f));
        f = this.tilt;
        float f2 = this.bearing;
        return toStringHelper.add("tilt", (Object)Float.valueOf(f)).add("bearing", (Object)Float.valueOf(f2)).toString();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    public StreetViewPanoramaCamera(@SafeParcelable.Param(id=2) float zoom, @SafeParcelable.Param(id=3) float tilt, @SafeParcelable.Param(id=4) float bearing) {
        void var3_3;
        float f;
        void var2_2;
        boolean bl = !(var2_2 < -90.0f) ? var2_2 <= 90.0f : false;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Tilt needs to be between -90 and 90 inclusive: ");
        stringBuilder.append((float)var2_2);
        Preconditions.checkArgument((boolean)bl, (Object)stringBuilder.toString());
        if ((double)f <= 0.0) {
            f = 0.0f;
        }
        this.zoom = f;
        this.tilt = var2_2 + 0.0f;
        f = (double)var3_3 <= 0.0 ? var3_3 % 360.0f + 360.0f : var3_3;
        this.bearing = f % 360.0f;
        StreetViewPanoramaOrientation.Builder builder = new StreetViewPanoramaOrientation.Builder();
        builder.tilt((float)var2_2);
        builder.bearing((float)var3_3);
        this.zza = builder.build();
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int n) {
        void var1_1;
        float f = this.zoom;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)2, (float)f);
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)3, (float)this.tilt);
        void v1 = var1_1;
        SafeParcelWriter.writeFloat((Parcel)v1, (int)4, (float)this.bearing);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    public boolean equals(@Nullable Object o) {
        StreetViewPanoramaCamera streetViewPanoramaCamera;
        if (this == streetViewPanoramaCamera) {
            return true;
        }
        if (!(streetViewPanoramaCamera instanceof StreetViewPanoramaCamera)) {
            return false;
        }
        streetViewPanoramaCamera = streetViewPanoramaCamera;
        return Float.floatToIntBits(this.zoom) == Float.floatToIntBits(streetViewPanoramaCamera.zoom) && Float.floatToIntBits(this.tilt) == Float.floatToIntBits(streetViewPanoramaCamera.tilt) && Float.floatToIntBits(this.bearing) == Float.floatToIntBits(streetViewPanoramaCamera.bearing);
    }

    public static final class Builder {
        public float bearing;
        public float tilt;
        public float zoom;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder bearing(float bearing) {
            void var1_1;
            this.bearing = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder orientation(@NonNull StreetViewPanoramaOrientation orientation) {
            void var1_1;
            Preconditions.checkNotNull((Object)((Object)orientation), (Object)"orientation must not be null.");
            this.tilt = var1_1.tilt;
            this.bearing = var1_1.bearing;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder tilt(float tilt) {
            void var1_1;
            this.tilt = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder zoom(float zoom) {
            void var1_1;
            this.zoom = var1_1;
            return this;
        }

        @NonNull
        public StreetViewPanoramaCamera build() {
            return new StreetViewPanoramaCamera(this.zoom, this.tilt, this.bearing);
        }

        public Builder() {
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull StreetViewPanoramaCamera previous) {
            void var1_1;
            Preconditions.checkNotNull((Object)var1_1, (Object)"StreetViewPanoramaCamera must not be null.");
            this.zoom = var1_1.zoom;
            this.bearing = var1_1.bearing;
            this.tilt = var1_1.tilt;
        }
    }
}

