/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.maps.model.AdvancedMarkerOptions;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.zzl;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="MarkerOptionsCreator")
public class MarkerOptions
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<MarkerOptions> CREATOR = new zzl();
    @SafeParcelable.Field(id=2, getter="getPosition")
    private LatLng zza;
    @SafeParcelable.Field(id=3, getter="getTitle")
    @Nullable
    private String zzb;
    @SafeParcelable.Field(id=4, getter="getSnippet")
    @Nullable
    private String zzc;
    @SafeParcelable.Field(id=5, getter="getWrappedIconDescriptorImplBinder", type="android.os.IBinder")
    @Nullable
    private BitmapDescriptor zzd;
    @SafeParcelable.Field(id=6, getter="getAnchorU")
    private float zze = 0.5f;
    @SafeParcelable.Field(id=7, getter="getAnchorV")
    private float zzf = 1.0f;
    @SafeParcelable.Field(id=8, getter="isDraggable")
    private boolean zzg;
    @SafeParcelable.Field(id=9, getter="isVisible")
    private boolean zzh = true;
    @SafeParcelable.Field(id=10, getter="isFlat")
    private boolean zzi = false;
    @SafeParcelable.Field(id=11, getter="getRotation")
    private float zzj = 0.0f;
    @SafeParcelable.Field(id=12, getter="getInfoWindowAnchorU", defaultValue="0.5f")
    private float zzk = 0.5f;
    @SafeParcelable.Field(id=13, getter="getInfoWindowAnchorV")
    private float zzl = 0.0f;
    @SafeParcelable.Field(id=14, getter="getAlpha", defaultValue="1.0f")
    private float zzm = 1.0f;
    @SafeParcelable.Field(id=15, getter="getZIndex")
    private float zzn;
    @AdvancedMarkerOptions.CollisionBehavior
    @SafeParcelable.Field(id=17, getter="getCollisionBehaviorInternal")
    private int zzo = 0;
    @SafeParcelable.Field(id=18, getter="getIconViewBinder", type="android.os.IBinder")
    @Nullable
    private View zzp;
    @SafeParcelable.Field(id=19, getter="getMarkerType")
    private int zzq;
    @SafeParcelable.Field(id=20, getter="getContentDescription")
    @Nullable
    private String zzr;
    @SafeParcelable.Field(id=21, getter="getAltitudeInternal")
    private float zzs;

    public float getAlpha() {
        return this.zzm;
    }

    public float getAnchorU() {
        return this.zze;
    }

    public float getAnchorV() {
        return this.zzf;
    }

    public float getInfoWindowAnchorU() {
        return this.zzk;
    }

    public float getInfoWindowAnchorV() {
        return this.zzl;
    }

    public float getRotation() {
        return this.zzj;
    }

    public float getZIndex() {
        return this.zzn;
    }

    @Nullable
    public BitmapDescriptor getIcon() {
        return this.zzd;
    }

    @NonNull
    public LatLng getPosition() {
        return this.zza;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public MarkerOptions alpha(float alpha) {
        void var1_1;
        this.zzm = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public MarkerOptions anchor(float u, float v) {
        void var2_2;
        void var1_1;
        this.zze = var1_1;
        this.zzf = var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public MarkerOptions contentDescription(@Nullable String contentDescription) {
        void var1_1;
        this.zzr = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public MarkerOptions draggable(boolean draggable) {
        void var1_1;
        this.zzg = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public MarkerOptions flat(boolean flat) {
        void var1_1;
        this.zzi = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public MarkerOptions icon(@Nullable BitmapDescriptor iconDescriptor) {
        void var1_1;
        this.zzd = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public MarkerOptions infoWindowAnchor(float u, float v) {
        void var2_2;
        void var1_1;
        this.zzk = var1_1;
        this.zzl = var2_2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public MarkerOptions position(@NonNull LatLng latlng) {
        void var1_1;
        if (latlng == null) {
            throw new IllegalArgumentException("latlng cannot be null - a position is required.");
        }
        this.zza = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public MarkerOptions rotation(float rotation) {
        void var1_1;
        this.zzj = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public MarkerOptions snippet(@Nullable String snippet) {
        void var1_1;
        this.zzc = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public MarkerOptions title(@Nullable String title) {
        void var1_1;
        this.zzb = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public MarkerOptions visible(boolean visible) {
        void var1_1;
        this.zzh = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public MarkerOptions zIndex(float zIndex) {
        void var1_1;
        this.zzn = var1_1;
        return this;
    }

    @Nullable
    public String getSnippet() {
        return this.zzc;
    }

    @Nullable
    public String getTitle() {
        return this.zzb;
    }

    public MarkerOptions() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    MarkerOptions(@SafeParcelable.Param(id=2) LatLng latLng, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) String string2, @SafeParcelable.Param(id=5) @Nullable IBinder iBinder, @SafeParcelable.Param(id=6) float f, @SafeParcelable.Param(id=7) float f2, @SafeParcelable.Param(id=8) boolean bl, @SafeParcelable.Param(id=9) boolean bl2, @SafeParcelable.Param(id=10) boolean bl3, @SafeParcelable.Param(id=11) float f3, @SafeParcelable.Param(id=12) float f4, @SafeParcelable.Param(id=13) float f5, @SafeParcelable.Param(id=14) float f6, @SafeParcelable.Param(id=15) float f7, @SafeParcelable.Param(id=17) int n, @SafeParcelable.Param(id=18) IBinder iBinder2, @SafeParcelable.Param(id=19) int n2, @SafeParcelable.Param(id=20) String string3, @SafeParcelable.Param(id=21) float f8) {
        this.zza = latLng;
        this.zzb = string;
        this.zzc = string2;
        this.zzd = iBinder == null ? null : new BitmapDescriptor(IObjectWrapper.Stub.asInterface((IBinder)iBinder));
        this.zze = f;
        this.zzf = f2;
        this.zzg = bl;
        this.zzh = bl2;
        this.zzi = bl3;
        this.zzj = f3;
        this.zzk = f4;
        this.zzl = f5;
        this.zzm = f6;
        this.zzn = f7;
        this.zzq = n2;
        this.zzo = n;
        latLng = IObjectWrapper.Stub.asInterface((IBinder)iBinder2);
        latLng = latLng == null ? null : (View)ObjectWrapper.unwrap((IObjectWrapper)latLng);
        this.zzp = latLng;
        this.zzr = string3;
        this.zzs = f8;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)2, (Parcelable)this.getPosition(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.getTitle(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)4, (String)this.getSnippet(), (boolean)false);
        BitmapDescriptor bitmapDescriptor = this.zzd;
        bitmapDescriptor = bitmapDescriptor == null ? null : bitmapDescriptor.zza().asBinder();
        SafeParcelWriter.writeIBinder((Parcel)var1_1, (int)5, (IBinder)bitmapDescriptor, (boolean)false);
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)6, (float)this.getAnchorU());
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)7, (float)this.getAnchorV());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)8, (boolean)this.isDraggable());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)9, (boolean)this.isVisible());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)10, (boolean)this.isFlat());
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)11, (float)this.getRotation());
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)12, (float)this.getInfoWindowAnchorU());
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)13, (float)this.getInfoWindowAnchorV());
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)14, (float)this.getAlpha());
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)15, (float)this.getZIndex());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)17, (int)this.zzo);
        SafeParcelWriter.writeIBinder((Parcel)var1_1, (int)18, (IBinder)ObjectWrapper.wrap((Object)this.zzp).asBinder(), (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)19, (int)this.zzq);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)20, (String)this.zzr, (boolean)false);
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)21, (float)this.zzs);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean isDraggable() {
        return this.zzg;
    }

    public boolean isFlat() {
        return this.zzi;
    }

    public boolean isVisible() {
        return this.zzh;
    }

    public final int zza() {
        return this.zzo;
    }

    public final int zzb() {
        return this.zzq;
    }

    @Nullable
    public final View zzc() {
        return this.zzp;
    }

    @NonNull
    public final MarkerOptions zzd(@AdvancedMarkerOptions.CollisionBehavior int n) {
        this.zzo = n;
        return this;
    }

    @NonNull
    public final MarkerOptions zze(@Nullable View view) {
        this.zzp = view;
        return this;
    }

    @NonNull
    public final MarkerOptions zzf(int n) {
        this.zzq = 1;
        return this;
    }
}

