/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.content.Context;
import android.content.res.Resources;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.IOUtils;
import com.google.android.gms.maps.model.zzh;
import java.io.IOException;
import java.io.InputStream;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="MapStyleOptionsCreator")
public final class MapStyleOptions
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<MapStyleOptions> CREATOR;
    private static final String zza;
    @SafeParcelable.Field(id=2, getter="getJson")
    private String zzb;

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static MapStyleOptions loadRawResourceStyle(@NonNull Context clientContext, int resourceId) throws Resources.NotFoundException {
        void var1_3;
        Object object = clientContext.getResources().openRawResource((int)var1_3);
        try {
            object = IOUtils.readInputStreamFully((InputStream)object);
            String string = new String((byte[])object, "UTF-8");
            object = new MapStyleOptions(string);
        }
        catch (IOException iOException) {
            String string = ((Object)iOException).toString();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Failed to read resource ");
            stringBuilder.append((int)var1_3);
            stringBuilder.append(": ");
            stringBuilder.append(string);
            Resources.NotFoundException notFoundException = new Resources.NotFoundException(stringBuilder.toString());
            throw notFoundException;
        }
        return object;
    }

    static {
        zzh zzh2;
        zza = MapStyleOptions.class.getSimpleName();
        CREATOR = zzh2 = new zzh();
    }

    /*
     * WARNING - void declaration
     */
    @SafeParcelable.Constructor
    public MapStyleOptions(@SafeParcelable.Param(id=2) @NonNull String json) {
        void var1_1;
        Preconditions.checkNotNull((Object)var1_1, (Object)"json must not be null");
        this.zzb = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int n) {
        void var1_1;
        n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.zzb, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }
}

