/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.zzf;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="LatLngBoundsCreator")
public final class LatLngBounds
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @KeepForSdk
    @NonNull
    public static final Parcelable.Creator<LatLngBounds> CREATOR;
    @SafeParcelable.Field(id=2)
    @NonNull
    public final LatLng southwest;
    @SafeParcelable.Field(id=3)
    @NonNull
    public final LatLng northeast;

    public int hashCode() {
        Object[] objectArray = new Object[]{this.southwest, this.northeast};
        return Objects.hashCode((Object[])objectArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public LatLng getCenter() {
        double d;
        double d2;
        LatLng latLng = this.southwest;
        double d3 = latLng.latitude;
        LatLng latLng2 = this.northeast;
        double d4 = (d3 + latLng2.latitude) / 2.0;
        double d5 = latLng.longitude;
        double d6 = latLng2.longitude;
        if (d5 <= d6) {
            double d7;
            d2 = d7 = (d6 + d5) / 2.0;
            return new LatLng(d4, d2);
        }
        d2 = d = (d6 + 360.0 + d5) / 2.0;
        return new LatLng(d4, d2);
    }

    @NonNull
    public static Builder builder() {
        Builder builder = new Builder();
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static LatLngBounds createFromAttributes(@Nullable Context context, @Nullable AttributeSet attrs) {
        void var1_1;
        return GoogleMapOptions.zzb(context, (AttributeSet)var1_1);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public LatLngBounds including(@NonNull LatLng point) {
        double d;
        double d2;
        LatLng latLng = (LatLng)((Object)Preconditions.checkNotNull((Object)((Object)point), (Object)"point must not be null."));
        double d3 = Math.min(this.southwest.latitude, latLng.latitude);
        double d4 = Math.max(this.northeast.latitude, latLng.latitude);
        double d5 = this.northeast.longitude;
        double d6 = this.southwest.longitude;
        double d7 = latLng.longitude;
        if (!this.zza(d7)) {
            if ((d6 - d7 + 360.0) % 360.0 < (d7 - d5 + 360.0) % 360.0) {
                d2 = d7;
                d = d5;
            } else {
                d2 = d6;
                d = d7;
            }
        } else {
            d2 = d6;
            d = d5;
        }
        latLng = new LatLng(d3, d2);
        LatLng latLng2 = new LatLng(d4, d);
        return new LatLngBounds(latLng, latLng2);
    }

    @NonNull
    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("southwest", (Object)this.southwest).add("northeast", (Object)this.northeast).toString();
    }

    static {
        zzf zzf2;
        CREATOR = zzf2 = new zzf();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    public LatLngBounds(@SafeParcelable.Param(id=2) @NonNull LatLng southwest, @SafeParcelable.Param(id=3) @NonNull LatLng northeast) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull((Object)var1_1, (Object)"southwest must not be null.");
        Preconditions.checkNotNull((Object)var2_2, (Object)"northeast must not be null.");
        double d = var2_2.latitude;
        double d2 = var1_1.latitude;
        boolean bl = d >= d2;
        Object[] objectArray = new Object[]{d2, var2_2.latitude};
        Preconditions.checkArgument((boolean)bl, (String)"southern latitude exceeds northern latitude (%s > %s)", (Object[])objectArray);
        this.southwest = var1_1;
        this.northeast = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)2, (Parcelable)this.southwest, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)3, (Parcelable)this.northeast, (int)var2_2, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean contains(@NonNull LatLng point) {
        LatLng latLng = (LatLng)((Object)Preconditions.checkNotNull((Object)((Object)point), (Object)"point must not be null."));
        double d = latLng.latitude;
        return this.southwest.latitude <= d && d <= this.northeast.latitude && this.zza(latLng.longitude);
    }

    public boolean equals(@Nullable Object o) {
        LatLngBounds latLngBounds;
        if (this == latLngBounds) {
            return true;
        }
        if (!(latLngBounds instanceof LatLngBounds)) {
            return false;
        }
        latLngBounds = latLngBounds;
        return this.southwest.equals((Object)latLngBounds.southwest) && this.northeast.equals((Object)latLngBounds.northeast);
    }

    private final boolean zza(double d) {
        double d2 = this.southwest.longitude;
        double d3 = this.northeast.longitude;
        if (d2 <= d3) {
            return d2 <= d && d <= d3;
        }
        return d2 <= d || d <= d3;
    }

    public static final class Builder {
        private double zza = Double.POSITIVE_INFINITY;
        private double zzb = Double.NEGATIVE_INFINITY;
        private double zzc = Double.NaN;
        private double zzd = Double.NaN;

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder include(@NonNull LatLng point) {
            void var1_1;
            Preconditions.checkNotNull((Object)((Object)point), (Object)"point must not be null");
            this.zza = Math.min(this.zza, var1_1.latitude);
            this.zzb = Math.max(this.zzb, var1_1.latitude);
            double d = var1_1.longitude;
            if (Double.isNaN(this.zzc)) {
                this.zzc = d;
                this.zzd = d;
                return this;
            }
            double d2 = this.zzc;
            double d3 = this.zzd;
            if (d2 <= d3) {
                if (d2 <= d) {
                    if (d <= d3) return this;
                }
            } else {
                if (d2 <= d) return this;
                if (d <= d3) {
                    return this;
                }
            }
            if ((d2 - d + 360.0) % 360.0 < (d - this.zzd + 360.0) % 360.0) {
                this.zzc = d;
                return this;
            }
            this.zzd = d;
            return this;
        }

        @NonNull
        public LatLngBounds build() {
            Preconditions.checkState((boolean)(Double.isNaN(this.zzc) ^ true), (Object)"no included points");
            LatLng latLng = new LatLng(this.zza, this.zzc);
            LatLng latLng2 = new LatLng(this.zzb, this.zzd);
            LatLngBounds latLngBounds = new LatLngBounds(latLng, latLng2);
            return latLngBounds;
        }
    }
}

