/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.maps.zzai;
import com.google.android.gms.internal.maps.zzaj;
import com.google.android.gms.maps.model.TileProvider;
import com.google.android.gms.maps.model.zzt;
import com.google.android.gms.maps.model.zzu;
import com.google.android.gms.maps.model.zzv;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="TileOverlayOptionsCreator")
public final class TileOverlayOptions
extends AbstractSafeParcelable {
    @RecentlyNonNull
    public static final Parcelable.Creator<TileOverlayOptions> CREATOR;
    @Nullable
    @SafeParcelable.Field(id=2, getter="getTileProviderDelegate", type="android.os.IBinder")
    private zzaj zza;
    @Nullable
    private TileProvider zzb;
    @SafeParcelable.Field(id=3, getter="isVisible")
    private boolean zzc = true;
    @SafeParcelable.Field(id=4, getter="getZIndex")
    private float zzd;
    @SafeParcelable.Field(id=5, getter="getFadeIn", defaultValue="true")
    private boolean zze = true;
    @SafeParcelable.Field(id=6, getter="getTransparency")
    private float zzf = 0.0f;

    public TileOverlayOptions() {
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    TileOverlayOptions(@SafeParcelable.Param(id=2) IBinder object, @SafeParcelable.Param(id=3) boolean bl, @SafeParcelable.Param(id=4) float f, @SafeParcelable.Param(id=5) boolean bl2, @SafeParcelable.Param(id=6) float f2) {
        void var5_8;
        void var4_7;
        void var3_6;
        void var2_5;
        void var1_3;
        this.zza = zzai.zzc(object);
        if (this.zza == null) {
            Object var1_2 = null;
        } else {
            zzt zzt2 = new zzt(this);
        }
        this.zzb = var1_3;
        this.zzc = var2_5;
        this.zzd = var3_6;
        this.zze = var4_7;
        this.zzf = var5_8;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void writeToParcel(@RecentlyNonNull Parcel out, int n) {
        void var1_1;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)out);
        zzaj zzaj2 = this.zza;
        zzaj2 = zzaj2 == null ? null : zzaj2.asBinder();
        SafeParcelWriter.writeIBinder((Parcel)var1_1, (int)2, (IBinder)zzaj2, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)3, (boolean)this.isVisible());
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)4, (float)this.getZIndex());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)5, (boolean)this.getFadeIn());
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)6, (float)this.getTransparency());
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n2);
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public TileOverlayOptions tileProvider(@RecentlyNonNull TileProvider tileProvider) {
        void var1_1;
        this.zzb = (TileProvider)Preconditions.checkNotNull((Object)var1_1, (Object)"tileProvider must not be null.");
        zzu zzu2 = new zzu(this, (TileProvider)var1_1);
        this.zza = zzu2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public TileOverlayOptions zIndex(float zIndex) {
        void var1_1;
        this.zzd = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public TileOverlayOptions visible(boolean visible) {
        void var1_1;
        this.zzc = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public TileOverlayOptions fadeIn(boolean fadeIn) {
        void var1_1;
        this.zze = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @RecentlyNonNull
    public TileOverlayOptions transparency(float transparency) {
        void var1_1;
        boolean bl = transparency >= 0.0f ? var1_1 <= 1.0f : false;
        Preconditions.checkArgument((boolean)bl, (Object)"Transparency must be in the range [0..1]");
        this.zzf = var1_1;
        return this;
    }

    @RecentlyNullable
    public TileProvider getTileProvider() {
        return this.zzb;
    }

    public float getZIndex() {
        return this.zzd;
    }

    public boolean isVisible() {
        return this.zzc;
    }

    public boolean getFadeIn() {
        return this.zze;
    }

    public float getTransparency() {
        return this.zzf;
    }

    static {
        zzv zzv2;
        CREATOR = zzv2 = new zzv();
    }

    static /* synthetic */ zzaj zza(TileOverlayOptions tileOverlayOptions) {
        return tileOverlayOptions.zza;
    }
}

