/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.Dash;
import com.google.android.gms.maps.model.Dot;
import com.google.android.gms.maps.model.Gap;
import com.google.android.gms.maps.model.zzi;
import java.util.ArrayList;
import java.util.List;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="PatternItemCreator")
public class PatternItem
extends AbstractSafeParcelable {
    private static final String TAG = PatternItem.class.getSimpleName();
    public static final Parcelable.Creator<PatternItem> CREATOR = new zzi();
    @SafeParcelable.Field(id=2, getter="getType")
    private final int type;
    @SafeParcelable.Field(id=3, getter="getLength")
    @Nullable
    private final Float zzdv;

    @SafeParcelable.Constructor
    public PatternItem(@SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) @Nullable Float f) {
        String string = String.valueOf(f);
        Preconditions.checkArgument((n == 1 || f != null && f.floatValue() >= 0.0f ? 1 : 0) != 0, (Object)new StringBuilder(45 + String.valueOf(string).length()).append("Invalid PatternItem: type=").append(n).append(" length=").append(string).toString());
        this.type = n;
        this.zzdv = f;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PatternItem patternItem = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)2, (int)patternItem.type);
        SafeParcelWriter.writeFloatObject((Parcel)parcel2, (int)3, (Float)patternItem.zzdv, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.zzdv});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PatternItem)) {
            return false;
        }
        PatternItem patternItem = (PatternItem)((Object)object);
        return this.type == patternItem.type && Objects.equal((Object)this.zzdv, (Object)patternItem.zzdv);
    }

    public String toString() {
        int n = this.type;
        String string = String.valueOf(this.zzdv);
        return new StringBuilder(39 + String.valueOf(string).length()).append("[PatternItem: type=").append(n).append(" length=").append(string).append("]").toString();
    }

    @Nullable
    static List<PatternItem> zza(@Nullable List<PatternItem> list) {
        if (list == null) {
            return null;
        }
        ArrayList<PatternItem> arrayList = new ArrayList<PatternItem>(list.size());
        for (PatternItem patternItem : list) {
            PatternItem patternItem2;
            if (patternItem == null) {
                patternItem2 = null;
            } else {
                PatternItem patternItem3 = patternItem;
                switch (patternItem3.type) {
                    case 0: {
                        patternItem2 = new Dash(patternItem3.zzdv.floatValue());
                        break;
                    }
                    case 1: {
                        patternItem2 = new Dot();
                        break;
                    }
                    case 2: {
                        patternItem2 = new Gap(patternItem3.zzdv.floatValue());
                        break;
                    }
                    default: {
                        int n = patternItem3.type;
                        Log.w((String)TAG, (String)new StringBuilder(37).append("Unknown PatternItem type: ").append(n).toString());
                        patternItem2 = patternItem3;
                    }
                }
            }
            arrayList.add(patternItem2);
        }
        return arrayList;
    }
}

