/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.maps.zzaf;
import com.google.android.gms.internal.maps.zzag;
import com.google.android.gms.maps.model.TileProvider;
import com.google.android.gms.maps.model.zzs;
import com.google.android.gms.maps.model.zzt;
import com.google.android.gms.maps.model.zzu;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="TileOverlayOptionsCreator")
public final class TileOverlayOptions
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<TileOverlayOptions> CREATOR = new zzu();
    @SafeParcelable.Field(id=2, getter="getTileProviderDelegate", type="android.os.IBinder")
    private zzaf zzeh;
    private TileProvider zzei;
    @SafeParcelable.Field(id=3, getter="isVisible")
    private boolean zzcs = true;
    @SafeParcelable.Field(id=4, getter="getZIndex")
    private float zzcr;
    @SafeParcelable.Field(id=5, getter="getFadeIn", defaultValue="true")
    private boolean zzej = true;
    @SafeParcelable.Field(id=6, getter="getTransparency")
    private float zzcz = 0.0f;

    public TileOverlayOptions() {
    }

    @SafeParcelable.Constructor
    TileOverlayOptions(@SafeParcelable.Param(id=2) IBinder iBinder, @SafeParcelable.Param(id=3) boolean bl, @SafeParcelable.Param(id=4) float f, @SafeParcelable.Param(id=5) boolean bl2, @SafeParcelable.Param(id=6) float f2) {
        this.zzeh = zzag.zzk(iBinder);
        this.zzei = this.zzeh == null ? null : new zzs(this);
        this.zzcs = bl;
        this.zzcr = f;
        this.zzej = bl2;
        this.zzcz = f2;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        TileOverlayOptions tileOverlayOptions = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeIBinder((Parcel)parcel2, (int)2, (IBinder)tileOverlayOptions.zzeh.asBinder(), (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)3, (boolean)tileOverlayOptions.isVisible());
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)4, (float)tileOverlayOptions.getZIndex());
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)5, (boolean)tileOverlayOptions.getFadeIn());
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)6, (float)tileOverlayOptions.getTransparency());
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final TileOverlayOptions tileProvider(TileProvider tileProvider) {
        this.zzei = tileProvider;
        this.zzeh = this.zzei == null ? null : new zzt(this, tileProvider);
        return this;
    }

    public final TileOverlayOptions zIndex(float f) {
        this.zzcr = f;
        return this;
    }

    public final TileOverlayOptions visible(boolean bl) {
        this.zzcs = bl;
        return this;
    }

    public final TileOverlayOptions fadeIn(boolean bl) {
        this.zzej = bl;
        return this;
    }

    public final TileOverlayOptions transparency(float f) {
        Preconditions.checkArgument((f >= 0.0f && f <= 1.0f ? 1 : 0) != 0, (Object)"Transparency must be in the range [0..1]");
        this.zzcz = f;
        return this;
    }

    public final TileProvider getTileProvider() {
        return this.zzei;
    }

    public final float getZIndex() {
        return this.zzcr;
    }

    public final boolean isVisible() {
        return this.zzcs;
    }

    public final boolean getFadeIn() {
        return this.zzej;
    }

    public final float getTransparency() {
        return this.zzcz;
    }

    static /* synthetic */ zzaf zza(TileOverlayOptions tileOverlayOptions) {
        return tileOverlayOptions.zzeh;
    }
}

