/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.maps.zzz;
import com.google.android.gms.maps.model.Cap;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.List;

public final class Polyline {
    private final zzz zzea;

    public Polyline(zzz zzz2) {
        this.zzea = (zzz)Preconditions.checkNotNull((Object)zzz2);
    }

    public final void remove() {
        try {
            this.zzea.remove();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final String getId() {
        try {
            return this.zzea.getId();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setPoints(List<LatLng> list) {
        try {
            this.zzea.setPoints(list);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final List<LatLng> getPoints() {
        try {
            return this.zzea.getPoints();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setWidth(float f) {
        try {
            this.zzea.setWidth(f);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final float getWidth() {
        try {
            return this.zzea.getWidth();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setColor(int n) {
        try {
            this.zzea.setColor(n);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final int getColor() {
        try {
            return this.zzea.getColor();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setStartCap(@NonNull Cap cap) {
        Preconditions.checkNotNull((Object)((Object)cap), (Object)"startCap must not be null");
        try {
            this.zzea.setStartCap(cap);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    @NonNull
    public final Cap getStartCap() {
        try {
            return this.zzea.getStartCap().zzg();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setEndCap(@NonNull Cap cap) {
        Preconditions.checkNotNull((Object)((Object)cap), (Object)"endCap must not be null");
        try {
            this.zzea.setEndCap(cap);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    @NonNull
    public final Cap getEndCap() {
        try {
            return this.zzea.getEndCap().zzg();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setJointType(int n) {
        try {
            this.zzea.setJointType(n);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final int getJointType() {
        try {
            return this.zzea.getJointType();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setPattern(@Nullable List<PatternItem> list) {
        try {
            this.zzea.setPattern(list);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    @Nullable
    public final List<PatternItem> getPattern() {
        try {
            return PatternItem.zza(this.zzea.getPattern());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setZIndex(float f) {
        try {
            this.zzea.setZIndex(f);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final float getZIndex() {
        try {
            return this.zzea.getZIndex();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setVisible(boolean bl) {
        try {
            this.zzea.setVisible(bl);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isVisible() {
        try {
            return this.zzea.isVisible();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setGeodesic(boolean bl) {
        try {
            this.zzea.setGeodesic(bl);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isGeodesic() {
        try {
            return this.zzea.isGeodesic();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setClickable(boolean bl) {
        try {
            this.zzea.setClickable(bl);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isClickable() {
        try {
            return this.zzea.isClickable();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setTag(@Nullable Object object) {
        try {
            this.zzea.zze(ObjectWrapper.wrap((Object)object));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    @Nullable
    public final Object getTag() {
        try {
            return ObjectWrapper.unwrap((IObjectWrapper)this.zzea.zzj());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Polyline)) {
            return false;
        }
        try {
            return this.zzea.zzb(((Polyline)object).zzea);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final int hashCode() {
        try {
            return this.zzea.zzi();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }
}

