/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.StrictMode;
import android.support.v4.app.Fragment;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamic.zzo;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IMapFragmentDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzby;
import com.google.android.gms.maps.internal.zzbz;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.zzak;
import java.util.ArrayList;
import java.util.List;

public class SupportMapFragment
extends Fragment {
    @Hide
    private final zzb zzjcp = new zzb(this);

    public static SupportMapFragment newInstance() {
        return new SupportMapFragment();
    }

    public static SupportMapFragment newInstance(GoogleMapOptions googleMapOptions) {
        SupportMapFragment supportMapFragment = new SupportMapFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)googleMapOptions);
        supportMapFragment.setArguments(bundle);
        return supportMapFragment;
    }

    public SupportMapFragment() {
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.zzjcp.setActivity(activity);
    }

    public void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.getThreadPolicy();
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder(threadPolicy).permitAll().build());
        try {
            super.onInflate(activity, attributeSet, bundle);
            this.zzjcp.setActivity(activity);
            GoogleMapOptions googleMapOptions = GoogleMapOptions.createFromAttributes((Context)activity, attributeSet);
            Bundle bundle2 = new Bundle();
            bundle2.putParcelable("MapOptions", (Parcelable)googleMapOptions);
            this.zzjcp.onInflate(activity, bundle2, bundle);
            return;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.zzjcp.onCreate(bundle);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = this.zzjcp.onCreateView(layoutInflater, viewGroup, bundle);
        view.setClickable(true);
        return view;
    }

    public void onResume() {
        super.onResume();
        this.zzjcp.onResume();
    }

    public void onPause() {
        this.zzjcp.onPause();
        super.onPause();
    }

    public void onStart() {
        super.onStart();
        this.zzjcp.onStart();
    }

    public void onStop() {
        this.zzjcp.onStop();
        super.onStop();
    }

    public void onDestroyView() {
        this.zzjcp.onDestroyView();
        super.onDestroyView();
    }

    public void onDestroy() {
        this.zzjcp.onDestroy();
        super.onDestroy();
    }

    public void onLowMemory() {
        this.zzjcp.onLowMemory();
        super.onLowMemory();
    }

    public void onActivityCreated(Bundle bundle) {
        if (bundle != null) {
            bundle.setClassLoader(SupportMapFragment.class.getClassLoader());
        }
        super.onActivityCreated(bundle);
    }

    public void onSaveInstanceState(Bundle bundle) {
        if (bundle != null) {
            bundle.setClassLoader(SupportMapFragment.class.getClassLoader());
        }
        super.onSaveInstanceState(bundle);
        this.zzjcp.onSaveInstanceState(bundle);
    }

    public final void onEnterAmbient(Bundle bundle) {
        zzbq.zzgn((String)"onEnterAmbient must be called on the main thread.");
        Bundle bundle2 = bundle;
        zzb zzb2 = this.zzjcp;
        if (zzb2.zzarg() != null) {
            ((zza)zzb2.zzarg()).onEnterAmbient(bundle2);
        }
    }

    public final void onExitAmbient() {
        zzbq.zzgn((String)"onExitAmbient must be called on the main thread.");
        zzb zzb2 = this.zzjcp;
        if (zzb2.zzarg() != null) {
            ((zza)zzb2.zzarg()).onExitAmbient();
        }
    }

    public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
        zzbq.zzgn((String)"getMapAsync must be called on the main thread.");
        this.zzjcp.getMapAsync(onMapReadyCallback);
    }

    public void setArguments(Bundle bundle) {
        super.setArguments(bundle);
    }

    static final class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final Fragment fragment;
        private zzo<zza> zzjbn;
        private Activity zzakg;
        private final List<OnMapReadyCallback> zzjbo = new ArrayList<OnMapReadyCallback>();

        zzb(Fragment fragment) {
            this.fragment = fragment;
        }

        protected final void zza(zzo<zza> zzo2) {
            this.zzjbn = zzo2;
            this.zzaxs();
        }

        private final void zzaxs() {
            if (this.zzakg != null && this.zzjbn != null && this.zzarg() == null) {
                try {
                    MapsInitializer.initialize((Context)this.zzakg);
                    IMapFragmentDelegate iMapFragmentDelegate = zzbz.zzdz((Context)this.zzakg).zzab(zzn.zzz((Object)this.zzakg));
                    if (iMapFragmentDelegate == null) {
                        return;
                    }
                    this.zzjbn.zza((LifecycleDelegate)new zza(this.fragment, iMapFragmentDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : this.zzjbo) {
                        ((zza)this.zzarg()).getMapAsync(onMapReadyCallback);
                    }
                    this.zzjbo.clear();
                    return;
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {}
            }
        }

        private final void setActivity(Activity activity) {
            this.zzakg = activity;
            this.zzaxs();
        }

        public final void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            if (this.zzarg() != null) {
                ((zza)this.zzarg()).getMapAsync(onMapReadyCallback);
                return;
            }
            this.zzjbo.add(onMapReadyCallback);
        }
    }

    @Hide
    static final class zza
    implements MapLifecycleDelegate {
        private final Fragment fragment;
        private final IMapFragmentDelegate zzjbl;

        public zza(Fragment fragment, IMapFragmentDelegate iMapFragmentDelegate) {
            this.zzjbl = (IMapFragmentDelegate)zzbq.checkNotNull((Object)iMapFragmentDelegate);
            this.fragment = (Fragment)zzbq.checkNotNull((Object)fragment);
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            GoogleMapOptions googleMapOptions = (GoogleMapOptions)bundle.getParcelable("MapOptions");
            try {
                Bundle bundle3 = new Bundle();
                zzby.zzd(bundle2, bundle3);
                this.zzjbl.onInflate(zzn.zzz((Object)activity), googleMapOptions, bundle3);
                zzby.zzd(bundle3, bundle2);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onCreate(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zzd(bundle, bundle2);
                Bundle bundle3 = this.fragment.getArguments();
                if (bundle3 != null && bundle3.containsKey("MapOptions")) {
                    zzby.zza(bundle2, "MapOptions", bundle3.getParcelable("MapOptions"));
                }
                this.zzjbl.onCreate(bundle2);
                zzby.zzd(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            IObjectWrapper iObjectWrapper;
            try {
                Bundle bundle2 = new Bundle();
                zzby.zzd(bundle, bundle2);
                iObjectWrapper = this.zzjbl.onCreateView(zzn.zzz((Object)layoutInflater), zzn.zzz((Object)viewGroup), bundle2);
                zzby.zzd(bundle2, bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
            return (View)zzn.zzy((IObjectWrapper)iObjectWrapper);
        }

        public final void onStart() {
            try {
                this.zzjbl.onStart();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onResume() {
            try {
                this.zzjbl.onResume();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zzjbl.onPause();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onStop() {
            try {
                this.zzjbl.onStop();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onDestroyView() {
            try {
                this.zzjbl.onDestroyView();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onDestroy() {
            try {
                this.zzjbl.onDestroy();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onLowMemory() {
            try {
                this.zzjbl.onLowMemory();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zzd(bundle, bundle2);
                this.zzjbl.onSaveInstanceState(bundle2);
                zzby.zzd(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public final void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            try {
                this.zzjbl.getMapAsync(new zzak(this, onMapReadyCallback));
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onEnterAmbient(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zzd(bundle, bundle2);
                this.zzjbl.onEnterAmbient(bundle2);
                zzby.zzd(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onExitAmbient() {
            try {
                this.zzjbl.onExitAmbient();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

