/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.StrictMode;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamic.zzo;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnStreetViewPanoramaReadyCallback;
import com.google.android.gms.maps.StreetViewPanoramaOptions;
import com.google.android.gms.maps.internal.IStreetViewPanoramaViewDelegate;
import com.google.android.gms.maps.internal.StreetViewLifecycleDelegate;
import com.google.android.gms.maps.internal.zzby;
import com.google.android.gms.maps.internal.zzbz;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.zzaj;
import java.util.ArrayList;
import java.util.List;

public class StreetViewPanoramaView
extends FrameLayout {
    private final zzb zzjcl;

    public StreetViewPanoramaView(Context context) {
        super(context);
        this.zzjcl = new zzb((ViewGroup)this, context, null);
    }

    public StreetViewPanoramaView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zzjcl = new zzb((ViewGroup)this, context, null);
    }

    public StreetViewPanoramaView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zzjcl = new zzb((ViewGroup)this, context, null);
    }

    public StreetViewPanoramaView(Context context, StreetViewPanoramaOptions streetViewPanoramaOptions) {
        super(context);
        this.zzjcl = new zzb((ViewGroup)this, context, streetViewPanoramaOptions);
    }

    public final void onCreate(Bundle bundle) {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.getThreadPolicy();
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder(threadPolicy).permitAll().build());
        try {
            this.zzjcl.onCreate(bundle);
            if (this.zzjcl.zzarg() == null) {
                com.google.android.gms.dynamic.zza.zzb((FrameLayout)this);
            }
            return;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    public final void onResume() {
        this.zzjcl.onResume();
    }

    public final void onPause() {
        this.zzjcl.onPause();
    }

    public final void onDestroy() {
        this.zzjcl.onDestroy();
    }

    public final void onLowMemory() {
        this.zzjcl.onLowMemory();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        this.zzjcl.onSaveInstanceState(bundle);
    }

    public void getStreetViewPanoramaAsync(OnStreetViewPanoramaReadyCallback onStreetViewPanoramaReadyCallback) {
        zzbq.zzgn((String)"getStreetViewPanoramaAsync() must be called on the main thread");
        this.zzjcl.getStreetViewPanoramaAsync(onStreetViewPanoramaReadyCallback);
    }

    static final class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final ViewGroup zzjbs;
        private final Context zzjbt;
        private zzo<zza> zzjbn;
        private final StreetViewPanoramaOptions zzjco;
        private final List<OnStreetViewPanoramaReadyCallback> zzjce = new ArrayList<OnStreetViewPanoramaReadyCallback>();

        zzb(ViewGroup viewGroup, Context context, StreetViewPanoramaOptions streetViewPanoramaOptions) {
            this.zzjbs = viewGroup;
            this.zzjbt = context;
            this.zzjco = streetViewPanoramaOptions;
        }

        protected final void zza(zzo<zza> zzo2) {
            this.zzjbn = zzo2;
            zzb zzb2 = this;
            if (zzb2.zzjbn != null && zzb2.zzarg() == null) {
                try {
                    MapsInitializer.initialize(zzb2.zzjbt);
                    IStreetViewPanoramaViewDelegate iStreetViewPanoramaViewDelegate = zzbz.zzdz(zzb2.zzjbt).zza(zzn.zzz((Object)zzb2.zzjbt), zzb2.zzjco);
                    zzb2.zzjbn.zza((LifecycleDelegate)new zza(zzb2.zzjbs, iStreetViewPanoramaViewDelegate));
                    for (OnStreetViewPanoramaReadyCallback onStreetViewPanoramaReadyCallback : zzb2.zzjce) {
                        ((zza)zzb2.zzarg()).getStreetViewPanoramaAsync(onStreetViewPanoramaReadyCallback);
                    }
                    zzb2.zzjce.clear();
                    return;
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {}
            }
        }

        public final void getStreetViewPanoramaAsync(OnStreetViewPanoramaReadyCallback onStreetViewPanoramaReadyCallback) {
            if (this.zzarg() != null) {
                ((zza)this.zzarg()).getStreetViewPanoramaAsync(onStreetViewPanoramaReadyCallback);
                return;
            }
            this.zzjce.add(onStreetViewPanoramaReadyCallback);
        }
    }

    @Hide
    static final class zza
    implements StreetViewLifecycleDelegate {
        private final ViewGroup parent;
        private final IStreetViewPanoramaViewDelegate zzjcm;
        private View zzjcn;

        public zza(ViewGroup viewGroup, IStreetViewPanoramaViewDelegate iStreetViewPanoramaViewDelegate) {
            this.zzjcm = (IStreetViewPanoramaViewDelegate)zzbq.checkNotNull((Object)iStreetViewPanoramaViewDelegate);
            this.parent = (ViewGroup)zzbq.checkNotNull((Object)viewGroup);
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            throw new UnsupportedOperationException("onInflate not allowed on StreetViewPanoramaViewDelegate");
        }

        public final void onCreate(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zzd(bundle, bundle2);
                this.zzjcm.onCreate(bundle2);
                zzby.zzd(bundle2, bundle);
                this.zzjcn = (View)zzn.zzy((IObjectWrapper)this.zzjcm.getView());
                this.parent.removeAllViews();
                this.parent.addView(this.zzjcn);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            throw new UnsupportedOperationException("onCreateView not allowed on StreetViewPanoramaViewDelegate");
        }

        public final void onStart() {
        }

        public final void onResume() {
            try {
                this.zzjcm.onResume();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zzjcm.onPause();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onStop() {
        }

        public final void onDestroyView() {
            throw new UnsupportedOperationException("onDestroyView not allowed on StreetViewPanoramaViewDelegate");
        }

        public final void onDestroy() {
            try {
                this.zzjcm.onDestroy();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onLowMemory() {
            try {
                this.zzjcm.onLowMemory();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zzd(bundle, bundle2);
                this.zzjcm.onSaveInstanceState(bundle2);
                zzby.zzd(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public final void getStreetViewPanoramaAsync(OnStreetViewPanoramaReadyCallback onStreetViewPanoramaReadyCallback) {
            try {
                this.zzjcm.getStreetViewPanoramaAsync(new zzaj(this, onStreetViewPanoramaReadyCallback));
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

