/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.graphics.Bitmap;
import android.location.Location;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import android.view.View;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.maps.CameraUpdate;
import com.google.android.gms.maps.LocationSource;
import com.google.android.gms.maps.Projection;
import com.google.android.gms.maps.UiSettings;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.Circle;
import com.google.android.gms.maps.model.CircleOptions;
import com.google.android.gms.maps.model.GroundOverlay;
import com.google.android.gms.maps.model.GroundOverlayOptions;
import com.google.android.gms.maps.model.IndoorBuilding;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.MapStyleOptions;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.android.gms.maps.model.PointOfInterest;
import com.google.android.gms.maps.model.Polygon;
import com.google.android.gms.maps.model.PolygonOptions;
import com.google.android.gms.maps.model.Polyline;
import com.google.android.gms.maps.model.PolylineOptions;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.model.TileOverlay;
import com.google.android.gms.maps.model.TileOverlayOptions;
import com.google.android.gms.maps.model.internal.zzg;
import com.google.android.gms.maps.model.internal.zzj;
import com.google.android.gms.maps.model.internal.zzw;
import com.google.android.gms.maps.zzb;
import com.google.android.gms.maps.zzc;
import com.google.android.gms.maps.zzd;
import com.google.android.gms.maps.zze;
import com.google.android.gms.maps.zzf;
import com.google.android.gms.maps.zzh;
import com.google.android.gms.maps.zzi;
import com.google.android.gms.maps.zzk;
import com.google.android.gms.maps.zzl;
import com.google.android.gms.maps.zzn;
import com.google.android.gms.maps.zzo;
import com.google.android.gms.maps.zzp;
import com.google.android.gms.maps.zzq;
import com.google.android.gms.maps.zzr;
import com.google.android.gms.maps.zzs;
import com.google.android.gms.maps.zzt;
import com.google.android.gms.maps.zzu;
import com.google.android.gms.maps.zzv;
import com.google.android.gms.maps.zzx;
import com.google.android.gms.maps.zzy;
import com.google.android.gms.maps.zzz;

public final class GoogleMap {
    public static final int MAP_TYPE_NONE = 0;
    public static final int MAP_TYPE_NORMAL = 1;
    public static final int MAP_TYPE_SATELLITE = 2;
    public static final int MAP_TYPE_TERRAIN = 3;
    public static final int MAP_TYPE_HYBRID = 4;
    private final IGoogleMapDelegate zzizr;
    private UiSettings zzizs;

    @Hide
    public GoogleMap(IGoogleMapDelegate iGoogleMapDelegate) {
        this.zzizr = (IGoogleMapDelegate)zzbq.checkNotNull((Object)iGoogleMapDelegate);
    }

    public final CameraPosition getCameraPosition() {
        try {
            return this.zzizr.getCameraPosition();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final float getMaxZoomLevel() {
        try {
            return this.zzizr.getMaxZoomLevel();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final float getMinZoomLevel() {
        try {
            return this.zzizr.getMinZoomLevel();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void moveCamera(CameraUpdate cameraUpdate) {
        try {
            this.zzizr.moveCamera(cameraUpdate.zzaxq());
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void animateCamera(CameraUpdate cameraUpdate) {
        try {
            this.zzizr.animateCamera(cameraUpdate.zzaxq());
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void animateCamera(CameraUpdate cameraUpdate, CancelableCallback cancelableCallback) {
        try {
            this.zzizr.animateCameraWithCallback(cameraUpdate.zzaxq(), cancelableCallback == null ? null : new zza(cancelableCallback));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void animateCamera(CameraUpdate cameraUpdate, int n, CancelableCallback cancelableCallback) {
        try {
            this.zzizr.animateCameraWithDurationAndCallback(cameraUpdate.zzaxq(), n, cancelableCallback == null ? null : new zza(cancelableCallback));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void stopAnimation() {
        try {
            this.zzizr.stopAnimation();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final Polyline addPolyline(PolylineOptions polylineOptions) {
        try {
            return new Polyline(this.zzizr.addPolyline(polylineOptions));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final Polygon addPolygon(PolygonOptions polygonOptions) {
        try {
            return new Polygon(this.zzizr.addPolygon(polygonOptions));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final Circle addCircle(CircleOptions circleOptions) {
        try {
            return new Circle(this.zzizr.addCircle(circleOptions));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final Marker addMarker(MarkerOptions markerOptions) {
        try {
            com.google.android.gms.maps.model.internal.zzp zzp2 = this.zzizr.addMarker(markerOptions);
            if (zzp2 != null) {
                return new Marker(zzp2);
            }
            return null;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final GroundOverlay addGroundOverlay(GroundOverlayOptions groundOverlayOptions) {
        try {
            zzg zzg2 = this.zzizr.addGroundOverlay(groundOverlayOptions);
            if (zzg2 != null) {
                return new GroundOverlay(zzg2);
            }
            return null;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final TileOverlay addTileOverlay(TileOverlayOptions tileOverlayOptions) {
        try {
            zzw zzw2 = this.zzizr.addTileOverlay(tileOverlayOptions);
            if (zzw2 != null) {
                return new TileOverlay(zzw2);
            }
            return null;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void clear() {
        try {
            this.zzizr.clear();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final IndoorBuilding getFocusedBuilding() {
        try {
            zzj zzj2 = this.zzizr.getFocusedBuilding();
            if (zzj2 != null) {
                return new IndoorBuilding(zzj2);
            }
            return null;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnIndoorStateChangeListener(OnIndoorStateChangeListener onIndoorStateChangeListener) {
        try {
            if (onIndoorStateChangeListener == null) {
                this.zzizr.setOnIndoorStateChangeListener(null);
                return;
            }
            this.zzizr.setOnIndoorStateChangeListener(new com.google.android.gms.maps.zza(this, onIndoorStateChangeListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final int getMapType() {
        try {
            return this.zzizr.getMapType();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setMapType(int n) {
        try {
            this.zzizr.setMapType(n);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isTrafficEnabled() {
        try {
            return this.zzizr.isTrafficEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setTrafficEnabled(boolean bl) {
        try {
            this.zzizr.setTrafficEnabled(bl);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isIndoorEnabled() {
        try {
            return this.zzizr.isIndoorEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean setIndoorEnabled(boolean bl) {
        try {
            return this.zzizr.setIndoorEnabled(bl);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isBuildingsEnabled() {
        try {
            return this.zzizr.isBuildingsEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setBuildingsEnabled(boolean bl) {
        try {
            this.zzizr.setBuildingsEnabled(bl);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isMyLocationEnabled() {
        try {
            return this.zzizr.isMyLocationEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public final void setMyLocationEnabled(boolean bl) {
        try {
            this.zzizr.setMyLocationEnabled(bl);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    @Deprecated
    public final Location getMyLocation() {
        try {
            return this.zzizr.getMyLocation();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setLocationSource(LocationSource locationSource) {
        try {
            if (locationSource == null) {
                this.zzizr.setLocationSource(null);
                return;
            }
            this.zzizr.setLocationSource(new zzl(this, locationSource));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final UiSettings getUiSettings() {
        try {
            if (this.zzizs == null) {
                this.zzizs = new UiSettings(this.zzizr.getUiSettings());
            }
            return this.zzizs;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final Projection getProjection() {
        try {
            return new Projection(this.zzizr.getProjection());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    @Deprecated
    public final void setOnCameraChangeListener(@Nullable OnCameraChangeListener onCameraChangeListener) {
        try {
            if (onCameraChangeListener == null) {
                this.zzizr.setOnCameraChangeListener(null);
                return;
            }
            this.zzizr.setOnCameraChangeListener(new zzt(this, onCameraChangeListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnCameraMoveStartedListener(@Nullable OnCameraMoveStartedListener onCameraMoveStartedListener) {
        try {
            if (onCameraMoveStartedListener == null) {
                this.zzizr.setOnCameraMoveStartedListener(null);
                return;
            }
            this.zzizr.setOnCameraMoveStartedListener(new zzu(this, onCameraMoveStartedListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnCameraMoveListener(@Nullable OnCameraMoveListener onCameraMoveListener) {
        try {
            if (onCameraMoveListener == null) {
                this.zzizr.setOnCameraMoveListener(null);
                return;
            }
            this.zzizr.setOnCameraMoveListener(new zzv(this, onCameraMoveListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnCameraMoveCanceledListener(@Nullable OnCameraMoveCanceledListener onCameraMoveCanceledListener) {
        try {
            if (onCameraMoveCanceledListener == null) {
                this.zzizr.setOnCameraMoveCanceledListener(null);
                return;
            }
            this.zzizr.setOnCameraMoveCanceledListener(new com.google.android.gms.maps.zzw(this, onCameraMoveCanceledListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnCameraIdleListener(@Nullable OnCameraIdleListener onCameraIdleListener) {
        try {
            if (onCameraIdleListener == null) {
                this.zzizr.setOnCameraIdleListener(null);
                return;
            }
            this.zzizr.setOnCameraIdleListener(new zzx(this, onCameraIdleListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMapClickListener(@Nullable OnMapClickListener onMapClickListener) {
        try {
            if (onMapClickListener == null) {
                this.zzizr.setOnMapClickListener(null);
                return;
            }
            this.zzizr.setOnMapClickListener(new zzy(this, onMapClickListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMapLongClickListener(@Nullable OnMapLongClickListener onMapLongClickListener) {
        try {
            if (onMapLongClickListener == null) {
                this.zzizr.setOnMapLongClickListener(null);
                return;
            }
            this.zzizr.setOnMapLongClickListener(new zzz(this, onMapLongClickListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMarkerClickListener(@Nullable OnMarkerClickListener onMarkerClickListener) {
        try {
            if (onMarkerClickListener == null) {
                this.zzizr.setOnMarkerClickListener(null);
                return;
            }
            this.zzizr.setOnMarkerClickListener(new zzb(this, onMarkerClickListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMarkerDragListener(@Nullable OnMarkerDragListener onMarkerDragListener) {
        try {
            if (onMarkerDragListener == null) {
                this.zzizr.setOnMarkerDragListener(null);
                return;
            }
            this.zzizr.setOnMarkerDragListener(new zzc(this, onMarkerDragListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnInfoWindowClickListener(@Nullable OnInfoWindowClickListener onInfoWindowClickListener) {
        try {
            if (onInfoWindowClickListener == null) {
                this.zzizr.setOnInfoWindowClickListener(null);
                return;
            }
            this.zzizr.setOnInfoWindowClickListener(new zzd(this, onInfoWindowClickListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnInfoWindowLongClickListener(@Nullable OnInfoWindowLongClickListener onInfoWindowLongClickListener) {
        try {
            if (onInfoWindowLongClickListener == null) {
                this.zzizr.setOnInfoWindowLongClickListener(null);
                return;
            }
            this.zzizr.setOnInfoWindowLongClickListener(new zze(this, onInfoWindowLongClickListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnInfoWindowCloseListener(@Nullable OnInfoWindowCloseListener onInfoWindowCloseListener) {
        try {
            if (onInfoWindowCloseListener == null) {
                this.zzizr.setOnInfoWindowCloseListener(null);
                return;
            }
            this.zzizr.setOnInfoWindowCloseListener(new zzf(this, onInfoWindowCloseListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setInfoWindowAdapter(InfoWindowAdapter infoWindowAdapter) {
        try {
            if (infoWindowAdapter == null) {
                this.zzizr.setInfoWindowAdapter(null);
                return;
            }
            this.zzizr.setInfoWindowAdapter(new com.google.android.gms.maps.zzg(this, infoWindowAdapter));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    @Deprecated
    public final void setOnMyLocationChangeListener(@Nullable OnMyLocationChangeListener onMyLocationChangeListener) {
        try {
            if (onMyLocationChangeListener == null) {
                this.zzizr.setOnMyLocationChangeListener(null);
                return;
            }
            this.zzizr.setOnMyLocationChangeListener(new zzh(this, onMyLocationChangeListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMyLocationButtonClickListener(@Nullable OnMyLocationButtonClickListener onMyLocationButtonClickListener) {
        try {
            if (onMyLocationButtonClickListener == null) {
                this.zzizr.setOnMyLocationButtonClickListener(null);
                return;
            }
            this.zzizr.setOnMyLocationButtonClickListener(new zzi(this, onMyLocationButtonClickListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMyLocationClickListener(@Nullable OnMyLocationClickListener onMyLocationClickListener) {
        try {
            if (onMyLocationClickListener == null) {
                this.zzizr.setOnMyLocationClickListener(null);
                return;
            }
            this.zzizr.setOnMyLocationClickListener(new com.google.android.gms.maps.zzj(this, onMyLocationClickListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMapLoadedCallback(OnMapLoadedCallback onMapLoadedCallback) {
        try {
            if (onMapLoadedCallback == null) {
                this.zzizr.setOnMapLoadedCallback(null);
                return;
            }
            this.zzizr.setOnMapLoadedCallback(new zzk(this, onMapLoadedCallback));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnGroundOverlayClickListener(OnGroundOverlayClickListener onGroundOverlayClickListener) {
        try {
            if (onGroundOverlayClickListener == null) {
                this.zzizr.setOnGroundOverlayClickListener(null);
                return;
            }
            this.zzizr.setOnGroundOverlayClickListener(new zzn(this, onGroundOverlayClickListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnCircleClickListener(OnCircleClickListener onCircleClickListener) {
        try {
            if (onCircleClickListener == null) {
                this.zzizr.setOnCircleClickListener(null);
                return;
            }
            this.zzizr.setOnCircleClickListener(new zzo(this, onCircleClickListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnPolygonClickListener(OnPolygonClickListener onPolygonClickListener) {
        try {
            if (onPolygonClickListener == null) {
                this.zzizr.setOnPolygonClickListener(null);
                return;
            }
            this.zzizr.setOnPolygonClickListener(new zzp(this, onPolygonClickListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnPolylineClickListener(OnPolylineClickListener onPolylineClickListener) {
        try {
            if (onPolylineClickListener == null) {
                this.zzizr.setOnPolylineClickListener(null);
                return;
            }
            this.zzizr.setOnPolylineClickListener(new zzq(this, onPolylineClickListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void snapshot(SnapshotReadyCallback snapshotReadyCallback) {
        this.snapshot(snapshotReadyCallback, null);
    }

    public final void snapshot(SnapshotReadyCallback snapshotReadyCallback, Bitmap bitmap) {
        com.google.android.gms.dynamic.zzn zzn2 = (com.google.android.gms.dynamic.zzn)(bitmap != null ? com.google.android.gms.dynamic.zzn.zzz((Object)bitmap) : null);
        try {
            this.zzizr.snapshot(new zzr(this, snapshotReadyCallback), (IObjectWrapper)zzn2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setPadding(int n, int n2, int n3, int n4) {
        try {
            this.zzizr.setPadding(n, n2, n3, n4);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setContentDescription(String string) {
        try {
            this.zzizr.setContentDescription(string);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnPoiClickListener(OnPoiClickListener onPoiClickListener) {
        try {
            if (onPoiClickListener == null) {
                this.zzizr.setOnPoiClickListener(null);
                return;
            }
            this.zzizr.setOnPoiClickListener(new zzs(this, onPoiClickListener));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean setMapStyle(@Nullable MapStyleOptions mapStyleOptions) {
        try {
            return this.zzizr.setMapStyle(mapStyleOptions);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setMinZoomPreference(float f) {
        try {
            this.zzizr.setMinZoomPreference(f);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setMaxZoomPreference(float f) {
        try {
            this.zzizr.setMaxZoomPreference(f);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void resetMinMaxZoomPreference() {
        try {
            this.zzizr.resetMinMaxZoomPreference();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setLatLngBoundsForCameraTarget(LatLngBounds latLngBounds) {
        try {
            this.zzizr.setLatLngBoundsForCameraTarget(latLngBounds);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public static interface OnPoiClickListener {
        public void onPoiClick(PointOfInterest var1);
    }

    static final class zza
    extends com.google.android.gms.maps.internal.zzd {
        private final CancelableCallback zzjat;

        zza(CancelableCallback cancelableCallback) {
            this.zzjat = cancelableCallback;
        }

        @Override
        public final void onFinish() {
            this.zzjat.onFinish();
        }

        @Override
        public final void onCancel() {
            this.zzjat.onCancel();
        }
    }

    public static interface OnGroundOverlayClickListener {
        public void onGroundOverlayClick(GroundOverlay var1);
    }

    public static interface OnMapLoadedCallback {
        public void onMapLoaded();
    }

    public static interface OnMyLocationClickListener {
        public void onMyLocationClick(@NonNull Location var1);
    }

    public static interface OnMyLocationButtonClickListener {
        public boolean onMyLocationButtonClick();
    }

    @Deprecated
    public static interface OnMyLocationChangeListener {
        public void onMyLocationChange(Location var1);
    }

    public static interface InfoWindowAdapter {
        public View getInfoWindow(Marker var1);

        public View getInfoContents(Marker var1);
    }

    public static interface SnapshotReadyCallback {
        public void onSnapshotReady(Bitmap var1);
    }

    public static interface CancelableCallback {
        public void onFinish();

        public void onCancel();
    }

    public static interface OnInfoWindowCloseListener {
        public void onInfoWindowClose(Marker var1);
    }

    public static interface OnInfoWindowLongClickListener {
        public void onInfoWindowLongClick(Marker var1);
    }

    public static interface OnInfoWindowClickListener {
        public void onInfoWindowClick(Marker var1);
    }

    public static interface OnMarkerDragListener {
        public void onMarkerDragStart(Marker var1);

        public void onMarkerDrag(Marker var1);

        public void onMarkerDragEnd(Marker var1);
    }

    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(Marker var1);
    }

    public static interface OnPolylineClickListener {
        public void onPolylineClick(Polyline var1);
    }

    public static interface OnPolygonClickListener {
        public void onPolygonClick(Polygon var1);
    }

    public static interface OnCircleClickListener {
        public void onCircleClick(Circle var1);
    }

    @Deprecated
    public static interface OnCameraChangeListener {
        public void onCameraChange(CameraPosition var1);
    }

    public static interface OnCameraIdleListener {
        public void onCameraIdle();
    }

    public static interface OnCameraMoveCanceledListener {
        public void onCameraMoveCanceled();
    }

    public static interface OnCameraMoveListener {
        public void onCameraMove();
    }

    public static interface OnCameraMoveStartedListener {
        public static final int REASON_GESTURE = 1;
        public static final int REASON_API_ANIMATION = 2;
        public static final int REASON_DEVELOPER_ANIMATION = 3;

        public void onCameraMoveStarted(int var1);
    }

    public static interface OnMapLongClickListener {
        public void onMapLongClick(LatLng var1);
    }

    public static interface OnMapClickListener {
        public void onMapClick(LatLng var1);
    }

    public static interface OnIndoorStateChangeListener {
        public void onIndoorBuildingFocused();

        public void onIndoorLevelActivated(IndoorBuilding var1);
    }
}

