/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.StrictMode;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamic.zzo;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IMapViewDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzby;
import com.google.android.gms.maps.internal.zzbz;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.zzac;
import java.util.ArrayList;
import java.util.List;

public class MapView
extends FrameLayout {
    private final zzb zza;

    public MapView(Context context) {
        super(context);
        this.zza = new zzb((ViewGroup)this, context, null);
        this.setClickable(true);
    }

    public MapView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zza = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attributeSet));
        this.setClickable(true);
    }

    public MapView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zza = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attributeSet));
        this.setClickable(true);
    }

    public MapView(Context context, GoogleMapOptions googleMapOptions) {
        super(context);
        this.zza = new zzb((ViewGroup)this, context, googleMapOptions);
        this.setClickable(true);
    }

    public final void onCreate(Bundle bundle) {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.getThreadPolicy();
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder(threadPolicy).permitAll().build());
        try {
            this.zza.zza(bundle);
            if (this.zza.zza() == null) {
                com.google.android.gms.dynamic.zza.zzb((FrameLayout)this);
            }
            return;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    public final void onResume() {
        this.zza.zzc();
    }

    public final void onPause() {
        this.zza.zzd();
    }

    public final void onStart() {
        this.zza.zzb();
    }

    public final void onStop() {
        this.zza.zze();
    }

    public final void onDestroy() {
        this.zza.zzg();
    }

    public final void onLowMemory() {
        this.zza.zzh();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        this.zza.zzb(bundle);
    }

    public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
        zzbq.zzb((String)"getMapAsync() must be called on the main thread");
        this.zza.zza(onMapReadyCallback);
    }

    public final void onEnterAmbient(Bundle bundle) {
        zzbq.zzb((String)"onEnterAmbient() must be called on the main thread");
        Bundle bundle2 = bundle;
        zzb zzb2 = this.zza;
        if (zzb2.zza() != null) {
            ((zza)zzb2.zza()).zza(bundle2);
        }
    }

    public final void onExitAmbient() {
        zzbq.zzb((String)"onExitAmbient() must be called on the main thread");
        zzb zzb2 = this.zza;
        if (zzb2.zza() != null) {
            ((zza)zzb2.zza()).zza();
        }
    }

    static final class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final ViewGroup zza;
        private final Context zzb;
        private zzo<zza> zzc;
        private final GoogleMapOptions zzd;
        private final List<OnMapReadyCallback> zze = new ArrayList<OnMapReadyCallback>();

        zzb(ViewGroup viewGroup, Context context, GoogleMapOptions googleMapOptions) {
            this.zza = viewGroup;
            this.zzb = context;
            this.zzd = googleMapOptions;
        }

        protected final void zza(zzo<zza> zzo2) {
            this.zzc = zzo2;
            zzb zzb2 = this;
            if (zzb2.zzc != null && zzb2.zza() == null) {
                try {
                    MapsInitializer.initialize(zzb2.zzb);
                    IMapViewDelegate iMapViewDelegate = zzbz.zza(zzb2.zzb).zza(zzn.zza((Object)zzb2.zzb), zzb2.zzd);
                    if (iMapViewDelegate == null) {
                        return;
                    }
                    zzb2.zzc.zza((LifecycleDelegate)new zza(zzb2.zza, iMapViewDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : zzb2.zze) {
                        ((zza)zzb2.zza()).getMapAsync(onMapReadyCallback);
                    }
                    zzb2.zze.clear();
                    return;
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {}
            }
        }

        public final void zza(OnMapReadyCallback onMapReadyCallback) {
            if (this.zza() != null) {
                ((zza)this.zza()).getMapAsync(onMapReadyCallback);
                return;
            }
            this.zze.add(onMapReadyCallback);
        }
    }

    @Hide
    static final class zza
    implements MapLifecycleDelegate {
        private final ViewGroup zza;
        private final IMapViewDelegate zzb;
        private View zzc;

        public zza(ViewGroup viewGroup, IMapViewDelegate iMapViewDelegate) {
            this.zzb = (IMapViewDelegate)zzbq.zza((Object)iMapViewDelegate);
            this.zza = (ViewGroup)zzbq.zza((Object)viewGroup);
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            throw new UnsupportedOperationException("onInflate not allowed on MapViewDelegate");
        }

        public final void onCreate(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zza(bundle, bundle2);
                this.zzb.onCreate(bundle2);
                zzby.zza(bundle2, bundle);
                this.zzc = (View)zzn.zza((IObjectWrapper)this.zzb.getView());
                this.zza.removeAllViews();
                this.zza.addView(this.zzc);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            throw new UnsupportedOperationException("onCreateView not allowed on MapViewDelegate");
        }

        public final void onStart() {
            try {
                this.zzb.onStart();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onResume() {
            try {
                this.zzb.onResume();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zzb.onPause();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onStop() {
            try {
                this.zzb.onStop();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onDestroyView() {
            throw new UnsupportedOperationException("onDestroyView not allowed on MapViewDelegate");
        }

        public final void onDestroy() {
            try {
                this.zzb.onDestroy();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onLowMemory() {
            try {
                this.zzb.onLowMemory();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zza(bundle, bundle2);
                this.zzb.onSaveInstanceState(bundle2);
                zzby.zza(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public final void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            try {
                this.zzb.getMapAsync(new zzac(this, onMapReadyCallback));
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void zza(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zza(bundle, bundle2);
                this.zzb.onEnterAmbient(bundle2);
                zzby.zza(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void zza() {
            try {
                this.zzb.onExitAmbient();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

