/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.maps.internal.zza;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.zzaa;

public final class GoogleMapOptions
extends zzbgl
implements ReflectedParcelable {
    @Hide
    public static final Parcelable.Creator<GoogleMapOptions> CREATOR = new zzaa();
    private Boolean zza;
    private Boolean zzb;
    private int zzc = -1;
    private CameraPosition zzd;
    private Boolean zze;
    private Boolean zzf;
    private Boolean zzg;
    private Boolean zzh;
    private Boolean zzi;
    private Boolean zzj;
    private Boolean zzk;
    private Boolean zzl;
    private Boolean zzm;
    private Float zzn = null;
    private Float zzo = null;
    private LatLngBounds zzp = null;

    @Hide
    GoogleMapOptions(byte by, byte by2, int n, CameraPosition cameraPosition, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8, byte by9, byte by10, byte by11, Float f, Float f2, LatLngBounds latLngBounds) {
        this.zza = com.google.android.gms.maps.internal.zza.zza(by);
        this.zzb = com.google.android.gms.maps.internal.zza.zza(by2);
        this.zzc = n;
        this.zzd = cameraPosition;
        this.zze = com.google.android.gms.maps.internal.zza.zza(by3);
        this.zzf = com.google.android.gms.maps.internal.zza.zza(by4);
        this.zzg = com.google.android.gms.maps.internal.zza.zza(by5);
        this.zzh = com.google.android.gms.maps.internal.zza.zza(by6);
        this.zzi = com.google.android.gms.maps.internal.zza.zza(by7);
        this.zzj = com.google.android.gms.maps.internal.zza.zza(by8);
        this.zzk = com.google.android.gms.maps.internal.zza.zza(by9);
        this.zzl = com.google.android.gms.maps.internal.zza.zza(by10);
        this.zzm = com.google.android.gms.maps.internal.zza.zza(by11);
        this.zzn = f;
        this.zzo = f2;
        this.zzp = latLngBounds;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoogleMapOptions googleMapOptions = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (byte)com.google.android.gms.maps.internal.zza.zza(googleMapOptions.zza));
        zzbgo.zza((Parcel)parcel2, (int)3, (byte)com.google.android.gms.maps.internal.zza.zza(googleMapOptions.zzb));
        zzbgo.zza((Parcel)parcel2, (int)4, (int)googleMapOptions.getMapType());
        zzbgo.zza((Parcel)parcel2, (int)5, (Parcelable)googleMapOptions.getCamera(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (byte)com.google.android.gms.maps.internal.zza.zza(googleMapOptions.zze));
        zzbgo.zza((Parcel)parcel2, (int)7, (byte)com.google.android.gms.maps.internal.zza.zza(googleMapOptions.zzf));
        zzbgo.zza((Parcel)parcel2, (int)8, (byte)com.google.android.gms.maps.internal.zza.zza(googleMapOptions.zzg));
        zzbgo.zza((Parcel)parcel2, (int)9, (byte)com.google.android.gms.maps.internal.zza.zza(googleMapOptions.zzh));
        zzbgo.zza((Parcel)parcel2, (int)10, (byte)com.google.android.gms.maps.internal.zza.zza(googleMapOptions.zzi));
        zzbgo.zza((Parcel)parcel2, (int)11, (byte)com.google.android.gms.maps.internal.zza.zza(googleMapOptions.zzj));
        zzbgo.zza((Parcel)parcel2, (int)12, (byte)com.google.android.gms.maps.internal.zza.zza(googleMapOptions.zzk));
        zzbgo.zza((Parcel)parcel2, (int)14, (byte)com.google.android.gms.maps.internal.zza.zza(googleMapOptions.zzl));
        zzbgo.zza((Parcel)parcel2, (int)15, (byte)com.google.android.gms.maps.internal.zza.zza(googleMapOptions.zzm));
        zzbgo.zza((Parcel)parcel2, (int)16, (Float)googleMapOptions.getMinZoomPreference(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)17, (Float)googleMapOptions.getMaxZoomPreference(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)18, (Parcelable)googleMapOptions.getLatLngBoundsForCameraTarget(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public GoogleMapOptions() {
    }

    public final GoogleMapOptions zOrderOnTop(boolean bl) {
        this.zza = bl;
        return this;
    }

    public final GoogleMapOptions useViewLifecycleInFragment(boolean bl) {
        this.zzb = bl;
        return this;
    }

    public final GoogleMapOptions mapType(int n) {
        this.zzc = n;
        return this;
    }

    public final GoogleMapOptions camera(CameraPosition cameraPosition) {
        this.zzd = cameraPosition;
        return this;
    }

    public final GoogleMapOptions zoomControlsEnabled(boolean bl) {
        this.zze = bl;
        return this;
    }

    public final GoogleMapOptions compassEnabled(boolean bl) {
        this.zzf = bl;
        return this;
    }

    public final GoogleMapOptions scrollGesturesEnabled(boolean bl) {
        this.zzg = bl;
        return this;
    }

    public final GoogleMapOptions zoomGesturesEnabled(boolean bl) {
        this.zzh = bl;
        return this;
    }

    public final GoogleMapOptions tiltGesturesEnabled(boolean bl) {
        this.zzi = bl;
        return this;
    }

    public final GoogleMapOptions rotateGesturesEnabled(boolean bl) {
        this.zzj = bl;
        return this;
    }

    public final GoogleMapOptions liteMode(boolean bl) {
        this.zzk = bl;
        return this;
    }

    public final GoogleMapOptions mapToolbarEnabled(boolean bl) {
        this.zzl = bl;
        return this;
    }

    public final GoogleMapOptions ambientEnabled(boolean bl) {
        this.zzm = bl;
        return this;
    }

    public final GoogleMapOptions minZoomPreference(float f) {
        this.zzn = Float.valueOf(f);
        return this;
    }

    public final GoogleMapOptions maxZoomPreference(float f) {
        this.zzo = Float.valueOf(f);
        return this;
    }

    public final GoogleMapOptions latLngBoundsForCameraTarget(LatLngBounds latLngBounds) {
        this.zzp = latLngBounds;
        return this;
    }

    public final Boolean getZOrderOnTop() {
        return this.zza;
    }

    public final Boolean getUseViewLifecycleInFragment() {
        return this.zzb;
    }

    public final int getMapType() {
        return this.zzc;
    }

    public final CameraPosition getCamera() {
        return this.zzd;
    }

    public final Boolean getZoomControlsEnabled() {
        return this.zze;
    }

    public final Boolean getCompassEnabled() {
        return this.zzf;
    }

    public final Boolean getScrollGesturesEnabled() {
        return this.zzg;
    }

    public final Boolean getZoomGesturesEnabled() {
        return this.zzh;
    }

    public final Boolean getTiltGesturesEnabled() {
        return this.zzi;
    }

    public final Boolean getRotateGesturesEnabled() {
        return this.zzj;
    }

    public final Boolean getLiteMode() {
        return this.zzk;
    }

    public final Boolean getMapToolbarEnabled() {
        return this.zzl;
    }

    public final Boolean getAmbientEnabled() {
        return this.zzm;
    }

    public final Float getMinZoomPreference() {
        return this.zzn;
    }

    public final Float getMaxZoomPreference() {
        return this.zzo;
    }

    public final LatLngBounds getLatLngBoundsForCameraTarget() {
        return this.zzp;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(R.styleable.MapAttrs_mapType)) {
            googleMapOptions.mapType(typedArray.getInt(R.styleable.MapAttrs_mapType, -1));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_zOrderOnTop)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(R.styleable.MapAttrs_zOrderOnTop, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_useViewLifecycle)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(R.styleable.MapAttrs_useViewLifecycle, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiCompass)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiCompass, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiRotateGestures)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiRotateGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGestures)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiTiltGestures)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiTiltGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomGestures)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomControls)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomControls, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_liteMode)) {
            googleMapOptions.liteMode(typedArray.getBoolean(R.styleable.MapAttrs_liteMode, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiMapToolbar)) {
            googleMapOptions.mapToolbarEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiMapToolbar, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_ambientEnabled)) {
            googleMapOptions.ambientEnabled(typedArray.getBoolean(R.styleable.MapAttrs_ambientEnabled, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.minZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMinZoomPreference, Float.NEGATIVE_INFINITY));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.maxZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMaxZoomPreference, Float.POSITIVE_INFINITY));
        }
        LatLngBounds latLngBounds = LatLngBounds.createFromAttributes(context, attributeSet);
        googleMapOptions.latLngBoundsForCameraTarget(latLngBounds);
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attributeSet);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }

    public final String toString() {
        return zzbg.zza((Object)((Object)this)).zza("MapType", (Object)this.zzc).zza("LiteMode", (Object)this.zzk).zza("Camera", (Object)this.zzd).zza("CompassEnabled", (Object)this.zzf).zza("ZoomControlsEnabled", (Object)this.zze).zza("ScrollGesturesEnabled", (Object)this.zzg).zza("ZoomGesturesEnabled", (Object)this.zzh).zza("TiltGesturesEnabled", (Object)this.zzi).zza("RotateGesturesEnabled", (Object)this.zzj).zza("MapToolbarEnabled", (Object)this.zzl).zza("AmbientEnabled", (Object)this.zzm).zza("MinZoomPreference", (Object)this.zzn).zza("MaxZoomPreference", (Object)this.zzo).zza("LatLngBoundsForCameraTarget", (Object)this.zzp).zza("ZOrderOnTop", (Object)this.zza).zza("UseViewLifecycleInFragment", (Object)this.zzb).toString();
    }
}

