/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.zzk;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolygonOptions
extends zzbfm {
    public static final Parcelable.Creator<PolygonOptions> CREATOR = new zzk();
    private final List<LatLng> zzivo;
    private final List<List<LatLng>> zzivp;
    private float mStrokeWidth = 10.0f;
    private int mStrokeColor = -16777216;
    private int mFillColor = 0;
    private float zzium = 0.0f;
    private boolean zziun = true;
    private boolean zzivq = false;
    private boolean zziuo = false;
    private int zzivr = 0;
    @Nullable
    private List<PatternItem> zziup = null;

    public PolygonOptions() {
        this.zzivo = new ArrayList<LatLng>();
        this.zzivp = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(List<LatLng> list, List list2, float f, int n, int n2, float f2, boolean bl, boolean bl2, boolean bl3, int n3, @Nullable List<PatternItem> list3) {
        this.zzivo = list;
        this.zzivp = list2;
        this.mStrokeWidth = f;
        this.mStrokeColor = n;
        this.mFillColor = n2;
        this.zzium = f2;
        this.zziun = bl;
        this.zzivq = bl2;
        this.zziuo = bl3;
        this.zzivr = n3;
        this.zziup = list3;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PolygonOptions polygonOptions = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zzc((Parcel)parcel2, (int)2, polygonOptions.getPoints(), (boolean)false);
        zzbfp.zzd((Parcel)parcel2, (int)3, polygonOptions.zzivp, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)4, (float)polygonOptions.getStrokeWidth());
        zzbfp.zzc((Parcel)parcel2, (int)5, (int)polygonOptions.getStrokeColor());
        zzbfp.zzc((Parcel)parcel2, (int)6, (int)polygonOptions.getFillColor());
        zzbfp.zza((Parcel)parcel2, (int)7, (float)polygonOptions.getZIndex());
        zzbfp.zza((Parcel)parcel2, (int)8, (boolean)polygonOptions.isVisible());
        zzbfp.zza((Parcel)parcel2, (int)9, (boolean)polygonOptions.isGeodesic());
        zzbfp.zza((Parcel)parcel2, (int)10, (boolean)polygonOptions.isClickable());
        zzbfp.zzc((Parcel)parcel2, (int)11, (int)polygonOptions.getStrokeJointType());
        zzbfp.zzc((Parcel)parcel2, (int)12, polygonOptions.getStrokePattern(), (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    public final PolygonOptions add(LatLng latLng) {
        this.zzivo.add(latLng);
        return this;
    }

    public final PolygonOptions add(LatLng ... latLngArray) {
        this.zzivo.addAll(Arrays.asList(latLngArray));
        return this;
    }

    public final PolygonOptions addAll(Iterable<LatLng> iterable) {
        for (LatLng latLng : iterable) {
            this.zzivo.add(latLng);
        }
        return this;
    }

    public final PolygonOptions addHole(Iterable<LatLng> iterable) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : iterable) {
            arrayList.add(latLng);
        }
        this.zzivp.add(arrayList);
        return this;
    }

    public final PolygonOptions strokeWidth(float f) {
        this.mStrokeWidth = f;
        return this;
    }

    public final PolygonOptions strokeColor(int n) {
        this.mStrokeColor = n;
        return this;
    }

    public final PolygonOptions strokeJointType(int n) {
        this.zzivr = n;
        return this;
    }

    public final PolygonOptions strokePattern(@Nullable List<PatternItem> list) {
        this.zziup = list;
        return this;
    }

    public final PolygonOptions fillColor(int n) {
        this.mFillColor = n;
        return this;
    }

    public final PolygonOptions zIndex(float f) {
        this.zzium = f;
        return this;
    }

    public final PolygonOptions visible(boolean bl) {
        this.zziun = bl;
        return this;
    }

    public final PolygonOptions geodesic(boolean bl) {
        this.zzivq = bl;
        return this;
    }

    public final PolygonOptions clickable(boolean bl) {
        this.zziuo = bl;
        return this;
    }

    public final List<LatLng> getPoints() {
        return this.zzivo;
    }

    public final List<List<LatLng>> getHoles() {
        return this.zzivp;
    }

    public final float getStrokeWidth() {
        return this.mStrokeWidth;
    }

    public final int getStrokeColor() {
        return this.mStrokeColor;
    }

    public final int getStrokeJointType() {
        return this.zzivr;
    }

    @Nullable
    public final List<PatternItem> getStrokePattern() {
        return this.zziup;
    }

    public final int getFillColor() {
        return this.mFillColor;
    }

    public final float getZIndex() {
        return this.zzium;
    }

    public final boolean isVisible() {
        return this.zziun;
    }

    public final boolean isGeodesic() {
        return this.zzivq;
    }

    public final boolean isClickable() {
        return this.zziuo;
    }
}

