/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.ButtCap;
import com.google.android.gms.maps.model.CustomCap;
import com.google.android.gms.maps.model.RoundCap;
import com.google.android.gms.maps.model.SquareCap;
import com.google.android.gms.maps.model.zzb;
import java.util.Arrays;

public class Cap
extends zzbfm {
    private static final String TAG = Cap.class.getSimpleName();
    public static final Parcelable.Creator<Cap> CREATOR = new zzb();
    private final int type;
    @Nullable
    private final BitmapDescriptor bitmapDescriptor;
    @Nullable
    private final Float zziui;

    private Cap(int n, @Nullable BitmapDescriptor bitmapDescriptor, @Nullable Float f) {
        boolean bl = f != null && f.floatValue() > 0.0f;
        zzbq.checkArgument((n != 3 || bitmapDescriptor != null && bl ? 1 : 0) != 0, (Object)String.format("Invalid Cap: type=%s bitmapDescriptor=%s bitmapRefWidth=%s", n, bitmapDescriptor, f));
        this.type = n;
        this.bitmapDescriptor = bitmapDescriptor;
        this.zziui = f;
    }

    Cap(int n, @Nullable IBinder iBinder, @Nullable Float f) {
        BitmapDescriptor bitmapDescriptor;
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            bitmapDescriptor = null;
        } else {
            IObjectWrapper iObjectWrapper = IObjectWrapper.zza.zzaq((IBinder)iBinder2);
            bitmapDescriptor = new BitmapDescriptor(iObjectWrapper);
        }
        this(n, bitmapDescriptor, f);
    }

    protected Cap(@NonNull BitmapDescriptor bitmapDescriptor, float f) {
        this(3, bitmapDescriptor, Float.valueOf(f));
    }

    protected Cap(int n) {
        this(n, (BitmapDescriptor)null, (Float)null);
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Cap cap = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zzc((Parcel)parcel2, (int)2, (int)cap.type);
        Cap cap2 = cap;
        zzbfp.zza((Parcel)parcel2, (int)3, cap2.bitmapDescriptor == null ? null : cap2.bitmapDescriptor.zzavz().asBinder(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)4, (Float)cap.zziui, (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.type, this.bitmapDescriptor, this.zziui});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Cap)) {
            return false;
        }
        Cap cap = (Cap)((Object)object);
        return this.type == cap.type && zzbg.equal((Object)this.bitmapDescriptor, (Object)cap.bitmapDescriptor) && zzbg.equal((Object)this.zziui, (Object)cap.zziui);
    }

    public String toString() {
        int n = this.type;
        return new StringBuilder(23).append("[Cap: type=").append(n).append("]").toString();
    }

    final Cap zzawf() {
        switch (this.type) {
            case 0: {
                return new ButtCap();
            }
            case 1: {
                return new SquareCap();
            }
            case 2: {
                return new RoundCap();
            }
            case 3: {
                return new CustomCap(this.bitmapDescriptor, this.zziui.floatValue());
            }
        }
        int n = this.type;
        Log.w((String)TAG, (String)new StringBuilder(29).append("Unknown Cap type: ").append(n).toString());
        return this;
    }
}

