/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.StrictMode;
import android.support.v4.app.Fragment;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamic.zzo;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IMapFragmentDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzby;
import com.google.android.gms.maps.internal.zzbz;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.zzak;
import java.util.ArrayList;
import java.util.List;

public class SupportMapFragment
extends Fragment {
    private final zzb zzity = new zzb(this);

    public static SupportMapFragment newInstance() {
        return new SupportMapFragment();
    }

    public static SupportMapFragment newInstance(GoogleMapOptions googleMapOptions) {
        SupportMapFragment supportMapFragment = new SupportMapFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)googleMapOptions);
        supportMapFragment.setArguments(bundle);
        return supportMapFragment;
    }

    public SupportMapFragment() {
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.zzity.setActivity(activity);
    }

    public void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.getThreadPolicy();
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder(threadPolicy).permitAll().build());
        try {
            super.onInflate(activity, attributeSet, bundle);
            this.zzity.setActivity(activity);
            GoogleMapOptions googleMapOptions = GoogleMapOptions.createFromAttributes((Context)activity, attributeSet);
            Bundle bundle2 = new Bundle();
            bundle2.putParcelable("MapOptions", (Parcelable)googleMapOptions);
            this.zzity.onInflate(activity, bundle2, bundle);
            return;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.zzity.onCreate(bundle);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = this.zzity.onCreateView(layoutInflater, viewGroup, bundle);
        view.setClickable(true);
        return view;
    }

    public void onResume() {
        super.onResume();
        this.zzity.onResume();
    }

    public void onPause() {
        this.zzity.onPause();
        super.onPause();
    }

    public void onStart() {
        super.onStart();
        this.zzity.onStart();
    }

    public void onStop() {
        this.zzity.onStop();
        super.onStop();
    }

    public void onDestroyView() {
        this.zzity.onDestroyView();
        super.onDestroyView();
    }

    public void onDestroy() {
        this.zzity.onDestroy();
        super.onDestroy();
    }

    public void onLowMemory() {
        this.zzity.onLowMemory();
        super.onLowMemory();
    }

    public void onActivityCreated(Bundle bundle) {
        if (bundle != null) {
            bundle.setClassLoader(SupportMapFragment.class.getClassLoader());
        }
        super.onActivityCreated(bundle);
    }

    public void onSaveInstanceState(Bundle bundle) {
        if (bundle != null) {
            bundle.setClassLoader(SupportMapFragment.class.getClassLoader());
        }
        super.onSaveInstanceState(bundle);
        this.zzity.onSaveInstanceState(bundle);
    }

    public final void onEnterAmbient(Bundle bundle) {
        zzbq.zzge((String)"onEnterAmbient must be called on the main thread.");
        Bundle bundle2 = bundle;
        zzb zzb2 = this.zzity;
        if (zzb2.zzapw() != null) {
            ((zza)zzb2.zzapw()).onEnterAmbient(bundle2);
        }
    }

    public final void onExitAmbient() {
        zzbq.zzge((String)"onExitAmbient must be called on the main thread.");
        zzb zzb2 = this.zzity;
        if (zzb2.zzapw() != null) {
            ((zza)zzb2.zzapw()).onExitAmbient();
        }
    }

    public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
        zzbq.zzge((String)"getMapAsync must be called on the main thread.");
        this.zzity.getMapAsync(onMapReadyCallback);
    }

    public void setArguments(Bundle bundle) {
        super.setArguments(bundle);
    }

    static final class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final Fragment zzgwp;
        private zzo<zza> zzisu;
        private Activity mActivity;
        private final List<OnMapReadyCallback> zzisv = new ArrayList<OnMapReadyCallback>();

        zzb(Fragment fragment) {
            this.zzgwp = fragment;
        }

        protected final void zza(zzo<zza> zzo2) {
            this.zzisu = zzo2;
            this.zzawb();
        }

        private final void zzawb() {
            if (this.mActivity != null && this.zzisu != null && this.zzapw() == null) {
                try {
                    MapsInitializer.initialize((Context)this.mActivity);
                    IMapFragmentDelegate iMapFragmentDelegate = zzbz.zzdt((Context)this.mActivity).zzaa(zzn.zzz((Object)this.mActivity));
                    if (iMapFragmentDelegate == null) {
                        return;
                    }
                    this.zzisu.zza((LifecycleDelegate)new zza(this.zzgwp, iMapFragmentDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : this.zzisv) {
                        ((zza)this.zzapw()).getMapAsync(onMapReadyCallback);
                    }
                    this.zzisv.clear();
                    return;
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {}
            }
        }

        private final void setActivity(Activity activity) {
            this.mActivity = activity;
            this.zzawb();
        }

        public final void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            if (this.zzapw() != null) {
                ((zza)this.zzapw()).getMapAsync(onMapReadyCallback);
                return;
            }
            this.zzisv.add(onMapReadyCallback);
        }
    }

    static final class zza
    implements MapLifecycleDelegate {
        private final Fragment zzgwp;
        private final IMapFragmentDelegate zziss;

        public zza(Fragment fragment, IMapFragmentDelegate iMapFragmentDelegate) {
            this.zziss = (IMapFragmentDelegate)zzbq.checkNotNull((Object)iMapFragmentDelegate);
            this.zzgwp = (Fragment)zzbq.checkNotNull((Object)fragment);
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            GoogleMapOptions googleMapOptions = (GoogleMapOptions)bundle.getParcelable("MapOptions");
            try {
                Bundle bundle3 = new Bundle();
                zzby.zzd(bundle2, bundle3);
                this.zziss.onInflate(zzn.zzz((Object)activity), googleMapOptions, bundle3);
                zzby.zzd(bundle3, bundle2);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onCreate(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zzd(bundle, bundle2);
                Bundle bundle3 = this.zzgwp.getArguments();
                if (bundle3 != null && bundle3.containsKey("MapOptions")) {
                    zzby.zza(bundle2, "MapOptions", bundle3.getParcelable("MapOptions"));
                }
                this.zziss.onCreate(bundle2);
                zzby.zzd(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            IObjectWrapper iObjectWrapper;
            try {
                Bundle bundle2 = new Bundle();
                zzby.zzd(bundle, bundle2);
                iObjectWrapper = this.zziss.onCreateView(zzn.zzz((Object)layoutInflater), zzn.zzz((Object)viewGroup), bundle2);
                zzby.zzd(bundle2, bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
            return (View)zzn.zzx((IObjectWrapper)iObjectWrapper);
        }

        public final void onStart() {
            try {
                this.zziss.onStart();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onResume() {
            try {
                this.zziss.onResume();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zziss.onPause();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onStop() {
            try {
                this.zziss.onStop();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onDestroyView() {
            try {
                this.zziss.onDestroyView();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onDestroy() {
            try {
                this.zziss.onDestroy();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onLowMemory() {
            try {
                this.zziss.onLowMemory();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zzd(bundle, bundle2);
                this.zziss.onSaveInstanceState(bundle2);
                zzby.zzd(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public final void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            try {
                this.zziss.getMapAsync(new zzak(this, onMapReadyCallback));
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onEnterAmbient(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zzd(bundle, bundle2);
                this.zziss.onEnterAmbient(bundle2);
                zzby.zzd(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onExitAmbient() {
            try {
                this.zziss.onExitAmbient();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

