/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.zzk;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolygonOptions
extends zzbck {
    public static final Parcelable.Creator<PolygonOptions> CREATOR = new zzk();
    private final List<LatLng> zzijr;
    private final List<List<LatLng>> zzijs;
    private float mStrokeWidth = 10.0f;
    private int mStrokeColor = -16777216;
    private int mFillColor = 0;
    private float zziio = 0.0f;
    private boolean zziip = true;
    private boolean zzijt = false;
    private boolean zziiq = false;
    private int zziju = 0;
    @Nullable
    private List<PatternItem> zziir = null;

    public PolygonOptions() {
        this.zzijr = new ArrayList<LatLng>();
        this.zzijs = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(List<LatLng> list, List list2, float f, int n, int n2, float f2, boolean bl, boolean bl2, boolean bl3, int n3, @Nullable List<PatternItem> list3) {
        this.zzijr = list;
        this.zzijs = list2;
        this.mStrokeWidth = f;
        this.mStrokeColor = n;
        this.mFillColor = n2;
        this.zziio = f2;
        this.zziip = bl;
        this.zzijt = bl2;
        this.zziiq = bl3;
        this.zziju = n3;
        this.zziir = list3;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PolygonOptions polygonOptions = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zzc((Parcel)parcel2, (int)2, polygonOptions.getPoints(), (boolean)false);
        zzbcn.zzd((Parcel)parcel2, (int)3, polygonOptions.zzijs, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)4, (float)polygonOptions.getStrokeWidth());
        zzbcn.zzc((Parcel)parcel2, (int)5, (int)polygonOptions.getStrokeColor());
        zzbcn.zzc((Parcel)parcel2, (int)6, (int)polygonOptions.getFillColor());
        zzbcn.zza((Parcel)parcel2, (int)7, (float)polygonOptions.getZIndex());
        zzbcn.zza((Parcel)parcel2, (int)8, (boolean)polygonOptions.isVisible());
        zzbcn.zza((Parcel)parcel2, (int)9, (boolean)polygonOptions.isGeodesic());
        zzbcn.zza((Parcel)parcel2, (int)10, (boolean)polygonOptions.isClickable());
        zzbcn.zzc((Parcel)parcel2, (int)11, (int)polygonOptions.getStrokeJointType());
        zzbcn.zzc((Parcel)parcel2, (int)12, polygonOptions.getStrokePattern(), (boolean)false);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    public final PolygonOptions add(LatLng latLng) {
        this.zzijr.add(latLng);
        return this;
    }

    public final PolygonOptions add(LatLng ... latLngArray) {
        this.zzijr.addAll(Arrays.asList(latLngArray));
        return this;
    }

    public final PolygonOptions addAll(Iterable<LatLng> iterable) {
        for (LatLng latLng : iterable) {
            this.zzijr.add(latLng);
        }
        return this;
    }

    public final PolygonOptions addHole(Iterable<LatLng> iterable) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : iterable) {
            arrayList.add(latLng);
        }
        this.zzijs.add(arrayList);
        return this;
    }

    public final PolygonOptions strokeWidth(float f) {
        this.mStrokeWidth = f;
        return this;
    }

    public final PolygonOptions strokeColor(int n) {
        this.mStrokeColor = n;
        return this;
    }

    public final PolygonOptions strokeJointType(int n) {
        this.zziju = n;
        return this;
    }

    public final PolygonOptions strokePattern(@Nullable List<PatternItem> list) {
        this.zziir = list;
        return this;
    }

    public final PolygonOptions fillColor(int n) {
        this.mFillColor = n;
        return this;
    }

    public final PolygonOptions zIndex(float f) {
        this.zziio = f;
        return this;
    }

    public final PolygonOptions visible(boolean bl) {
        this.zziip = bl;
        return this;
    }

    public final PolygonOptions geodesic(boolean bl) {
        this.zzijt = bl;
        return this;
    }

    public final PolygonOptions clickable(boolean bl) {
        this.zziiq = bl;
        return this;
    }

    public final List<LatLng> getPoints() {
        return this.zzijr;
    }

    public final List<List<LatLng>> getHoles() {
        return this.zzijs;
    }

    public final float getStrokeWidth() {
        return this.mStrokeWidth;
    }

    public final int getStrokeColor() {
        return this.mStrokeColor;
    }

    public final int getStrokeJointType() {
        return this.zziju;
    }

    @Nullable
    public final List<PatternItem> getStrokePattern() {
        return this.zziir;
    }

    public final int getFillColor() {
        return this.mFillColor;
    }

    public final float getZIndex() {
        return this.zziio;
    }

    public final boolean isVisible() {
        return this.zziip;
    }

    public final boolean isGeodesic() {
        return this.zzijt;
    }

    public final boolean isClickable() {
        return this.zziiq;
    }
}

