/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;
import com.google.android.gms.maps.model.Dash;
import com.google.android.gms.maps.model.Dot;
import com.google.android.gms.maps.model.Gap;
import com.google.android.gms.maps.model.zzi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PatternItem
extends zzbck {
    private static final String TAG = PatternItem.class.getSimpleName();
    public static final Parcelable.Creator<PatternItem> CREATOR = new zzi();
    private final int type;
    @Nullable
    private final Float zzijp;

    public PatternItem(int n, @Nullable Float f) {
        String string = String.valueOf(f);
        zzbp.zzb((n == 1 || f != null && f.floatValue() >= 0.0f ? 1 : 0) != 0, (Object)new StringBuilder(45 + String.valueOf(string).length()).append("Invalid PatternItem: type=").append(n).append(" length=").append(string).toString());
        this.type = n;
        this.zzijp = f;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PatternItem patternItem = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zzc((Parcel)parcel2, (int)2, (int)patternItem.type);
        zzbcn.zza((Parcel)parcel2, (int)3, (Float)patternItem.zzijp, (boolean)false);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.type, this.zzijp});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PatternItem)) {
            return false;
        }
        PatternItem patternItem = (PatternItem)((Object)object);
        return this.type == patternItem.type && zzbf.equal((Object)this.zzijp, (Object)patternItem.zzijp);
    }

    public String toString() {
        int n = this.type;
        String string = String.valueOf(this.zzijp);
        return new StringBuilder(39 + String.valueOf(string).length()).append("[PatternItem: type=").append(n).append(" length=").append(string).append("]").toString();
    }

    @Nullable
    static List<PatternItem> zzad(@Nullable List<PatternItem> list) {
        if (list == null) {
            return null;
        }
        ArrayList<PatternItem> arrayList = new ArrayList<PatternItem>(list.size());
        for (PatternItem patternItem : list) {
            PatternItem patternItem2;
            if (patternItem == null) {
                patternItem2 = null;
            } else {
                PatternItem patternItem3 = patternItem;
                switch (patternItem3.type) {
                    case 0: {
                        patternItem2 = new Dash(patternItem3.zzijp.floatValue());
                        break;
                    }
                    case 1: {
                        patternItem2 = new Dot();
                        break;
                    }
                    case 2: {
                        patternItem2 = new Gap(patternItem3.zzijp.floatValue());
                        break;
                    }
                    default: {
                        int n = patternItem3.type;
                        Log.w((String)TAG, (String)new StringBuilder(37).append("Unknown PatternItem type: ").append(n).toString());
                        patternItem2 = patternItem3;
                    }
                }
            }
            arrayList.add(patternItem2);
        }
        return arrayList;
    }
}

