/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.StrictMode;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamic.zzo;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IMapFragmentDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzby;
import com.google.android.gms.maps.internal.zzbz;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.zzab;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=11)
public class MapFragment
extends Fragment {
    private final zzb zzigt = new zzb(this);

    public static MapFragment newInstance() {
        return new MapFragment();
    }

    public static MapFragment newInstance(GoogleMapOptions googleMapOptions) {
        MapFragment mapFragment = new MapFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)googleMapOptions);
        mapFragment.setArguments(bundle);
        return mapFragment;
    }

    public MapFragment() {
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.zzigt.setActivity(activity);
    }

    @SuppressLint(value={"NewApi"})
    public void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.getThreadPolicy();
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder(threadPolicy).permitAll().build());
        try {
            super.onInflate(activity, attributeSet, bundle);
            this.zzigt.setActivity(activity);
            GoogleMapOptions googleMapOptions = GoogleMapOptions.createFromAttributes((Context)activity, attributeSet);
            Bundle bundle2 = new Bundle();
            bundle2.putParcelable("MapOptions", (Parcelable)googleMapOptions);
            this.zzigt.onInflate(activity, bundle2, bundle);
            return;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.zzigt.onCreate(bundle);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = this.zzigt.onCreateView(layoutInflater, viewGroup, bundle);
        view.setClickable(true);
        return view;
    }

    public void onResume() {
        super.onResume();
        this.zzigt.onResume();
    }

    public void onPause() {
        this.zzigt.onPause();
        super.onPause();
    }

    public void onStart() {
        super.onStart();
        this.zzigt.onStart();
    }

    public void onStop() {
        this.zzigt.onStop();
        super.onStop();
    }

    public void onDestroyView() {
        this.zzigt.onDestroyView();
        super.onDestroyView();
    }

    public void onDestroy() {
        this.zzigt.onDestroy();
        super.onDestroy();
    }

    public void onLowMemory() {
        this.zzigt.onLowMemory();
        super.onLowMemory();
    }

    public void onActivityCreated(Bundle bundle) {
        if (bundle != null) {
            bundle.setClassLoader(MapFragment.class.getClassLoader());
        }
        super.onActivityCreated(bundle);
    }

    public void onSaveInstanceState(Bundle bundle) {
        if (bundle != null) {
            bundle.setClassLoader(MapFragment.class.getClassLoader());
        }
        super.onSaveInstanceState(bundle);
        this.zzigt.onSaveInstanceState(bundle);
    }

    public final void onEnterAmbient(Bundle bundle) {
        zzbp.zzfy((String)"onEnterAmbient must be called on the main thread.");
        Bundle bundle2 = bundle;
        zzb zzb2 = this.zzigt;
        if (zzb2.zzaob() != null) {
            ((zza)zzb2.zzaob()).onEnterAmbient(bundle2);
        }
    }

    public final void onExitAmbient() {
        zzbp.zzfy((String)"onExitAmbient must be called on the main thread.");
        zzb zzb2 = this.zzigt;
        if (zzb2.zzaob() != null) {
            ((zza)zzb2.zzaob()).onExitAmbient();
        }
    }

    public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
        zzbp.zzfy((String)"getMapAsync must be called on the main thread.");
        this.zzigt.getMapAsync(onMapReadyCallback);
    }

    public void setArguments(Bundle bundle) {
        super.setArguments(bundle);
    }

    static final class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final Fragment zzgpe;
        private zzo<zza> zzigw;
        private Activity mActivity;
        private final List<OnMapReadyCallback> zzigx = new ArrayList<OnMapReadyCallback>();

        zzb(Fragment fragment) {
            this.zzgpe = fragment;
        }

        protected final void zza(zzo<zza> zzo2) {
            this.zzigw = zzo2;
            this.zzatn();
        }

        private final void zzatn() {
            if (this.mActivity != null && this.zzigw != null && this.zzaob() == null) {
                try {
                    MapsInitializer.initialize((Context)this.mActivity);
                    IMapFragmentDelegate iMapFragmentDelegate = zzbz.zzdj((Context)this.mActivity).zzaa(zzn.zzw((Object)this.mActivity));
                    if (iMapFragmentDelegate == null) {
                        return;
                    }
                    this.zzigw.zza((LifecycleDelegate)new zza(this.zzgpe, iMapFragmentDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : this.zzigx) {
                        ((zza)this.zzaob()).getMapAsync(onMapReadyCallback);
                    }
                    this.zzigx.clear();
                    return;
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {}
            }
        }

        private final void setActivity(Activity activity) {
            this.mActivity = activity;
            this.zzatn();
        }

        public final void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            if (this.zzaob() != null) {
                ((zza)this.zzaob()).getMapAsync(onMapReadyCallback);
                return;
            }
            this.zzigx.add(onMapReadyCallback);
        }
    }

    static final class zza
    implements MapLifecycleDelegate {
        private final Fragment zzgpe;
        private final IMapFragmentDelegate zzigu;

        public zza(Fragment fragment, IMapFragmentDelegate iMapFragmentDelegate) {
            this.zzigu = (IMapFragmentDelegate)zzbp.zzu((Object)iMapFragmentDelegate);
            this.zzgpe = (Fragment)zzbp.zzu((Object)fragment);
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            GoogleMapOptions googleMapOptions = (GoogleMapOptions)bundle.getParcelable("MapOptions");
            try {
                Bundle bundle3 = new Bundle();
                zzby.zzd(bundle2, bundle3);
                this.zzigu.onInflate(zzn.zzw((Object)activity), googleMapOptions, bundle3);
                zzby.zzd(bundle3, bundle2);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onCreate(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zzd(bundle, bundle2);
                Bundle bundle3 = this.zzgpe.getArguments();
                if (bundle3 != null && bundle3.containsKey("MapOptions")) {
                    zzby.zza(bundle2, "MapOptions", bundle3.getParcelable("MapOptions"));
                }
                this.zzigu.onCreate(bundle2);
                zzby.zzd(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            IObjectWrapper iObjectWrapper;
            try {
                Bundle bundle2 = new Bundle();
                zzby.zzd(bundle, bundle2);
                iObjectWrapper = this.zzigu.onCreateView(zzn.zzw((Object)layoutInflater), zzn.zzw((Object)viewGroup), bundle2);
                zzby.zzd(bundle2, bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
            return (View)zzn.zzx((IObjectWrapper)iObjectWrapper);
        }

        public final void onStart() {
            try {
                this.zzigu.onStart();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onResume() {
            try {
                this.zzigu.onResume();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zzigu.onPause();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onStop() {
            try {
                this.zzigu.onStop();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onDestroyView() {
            try {
                this.zzigu.onDestroyView();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onDestroy() {
            try {
                this.zzigu.onDestroy();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onLowMemory() {
            try {
                this.zzigu.onLowMemory();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zzd(bundle, bundle2);
                this.zzigu.onSaveInstanceState(bundle2);
                zzby.zzd(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public final void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            try {
                this.zzigu.getMapAsync(new zzab(this, onMapReadyCallback));
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onEnterAmbient(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zzd(bundle, bundle2);
                this.zzigu.onEnterAmbient(bundle2);
                zzby.zzd(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onExitAmbient() {
            try {
                this.zzigu.onExitAmbient();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

